{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
UNIT Ez3;

INTERFACE

USES  BINED,
      CRT,
      DOS,
      POPSCRN,
      SCRNHEAP,
      PRINTER,
      MENU,
      GETSUB,
      GETFILES,
      GLOBALS,
      EZ0,
      EZ1,
      EZ2;

{$V-}

Procedure GoView(TagOrCurrent: Char);
Procedure FileCopy(Source,Dest: AnyString);
Procedure MoveFile(OldName, NewName: AnyString; var Ecode : integer );
Procedure DateTime(s,d: AnyString);
Procedure GoCopy(TagOrCurrent: Char);
Procedure GoMove(TagOrCurrent: Char);

IMPLEMENTATION

{-------------------------------------------------------------------------}
Procedure GoView(* TagOrCurrent: Char *);
  var
    att,
    att1,
    att2,
    i                : ShortInt;
    ExitCommand      : Integer;
    VFile            : Text;
    s,
    s1               : String[80];
    FirstFile,
    Junk,
    Done             : Boolean;

  label GetNextFile,GetPage, ThisFileDone, AllDone, DoView;
  label JustView;

  Function ExitBinaryEditor(var EdData: EdCB; ExitCommand: Integer): Boolean;
   var
     ExitCode      : Word;
     Dummy         : ShortInt;

    begin
      Case ExitCommand of
         0,
        -1: begin
              if ModifiedFileBinaryEditor(EdData) then begin
               if (SaveFileBinaryEditor(EdData,True)<>0) then begin
                  Dummy:=1;
                end {if Error in Saving File}
                else begin
                  Dummy:=2;
                end;
              end {if File Has Been Modified}
              else
                Dummy:=3;
            end; {^K^D or Alt X}
      end; {Case Exit Command of}
    end; {Exit Binary Editor}


  begin
    if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
      DisplayNoTaggedFiles;
      EscDepressed:=True;
      exit;
    end; {if no files have been tagged}

    FirstFile:=True;
    Case monitor of
      1: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmc',true,true)
           else
             PoPObjLib(@ezd,'hb2fc',true,true);
         end; {1}
      2: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmm',true,true)
           else
             PoPObjLib(@ezd,'hb2fm',true,true);
         end; {2}
    end; {Case monitor of}
    Case monitor of
      1: att2:=47;
      2: att2:=112;
    end;

    SaveScreen(2);
    if TagOrCurrent='C' then begin
      new_dir^.DirTag:=True;
      goto DoView;
    end;

    new_dir:=first_dir;
    repeat
     DoView:
      with new_dir^ do begin
        if DirTag then begin
          if not ExpertMode then begin
            Case monitor of
              1: begin
                   att:=113;
                   att1:=31;
                 end; {1}
              2: begin
                   att:=112;
                   att1:=15;
                 end;
            end; {Case monitor of}
            ClearBox(23,4,58,13,att,2,False);
            if TagOrCurrent='T' then
              PutStr('Are you sure the TAGGED',29,6,att)
            else
              PutStr('Are you sure the Highlighted',26,6,att);

            PutStr('file is an ASCII file?',29,7,att);
            PutStr('FILE:',31,9,att);
            RemBlkR(36,9,50,9,att1,False);
            PutStr(filename,37,9,att1);
            ChooseMenu(41,42,1,att,att1,True,False,0,0,0);
            if EscDepressed then exit;
            if value=42 then begin
              goto GetNextFile;
            end; {if hit Esc or choose NO}
          end; {if not Expert Mode}
          s:=DriveNSub;
          l:=length(s);
          if copy(s,l,1)<>'\' then s:=s+'\';
          s:=s+filename;
          while pos(SPC,s)>0 do begin
            l:=pos(SPC,s);
            delete(s,l,1);
          end; {strip out spaces}
         {---------- See if file is too big for editor ---------------}
          if filesize>65000 then begin
            SaveScreen(1);
              ClearBox(22,9,58,15,ErrAtt,2,False);
              PutStr('File Too Big for Editor',29,11,ErrAtt);
              PutStr('Depress Any Key to View File',27,13,ErrAtt);
              ch1:=ReadKey;
              if ch1=NUL then ch1:=ReadKey;
            RestoreScreen(1);
            goto JustView;
          end; {if file too big for editor}
         {----------- See if not enough ram --------------------------}
          if (MaxAvail)<=65000 then begin
            SaveScreen(1);
              ClearBox(20,9,59,15,ErrAtt,2,False);
              PutStr('Insufficient Memory for Editor',26,11,ErrAtt);
              PutStr('Depress Any Key to View File',27,13,ErrAtt);
              ch1:=ReadKey;
              if ch1=NUL then ch1:=ReadKey;
            RestoreScreen(1);
            goto JustView;
          end; {if not enough ram}

          RemBlkR(1,3,80,24,15,False);
          Box(1,3,80,23,11,2);
          PutStr('Alt X - save file & eXit',3,25,HelpBar);
          PutStr('F10 - Exit File',63,25,HelpBar);
          CursorOn;

         {------------------- Initialize Editor Window ----------------------}
          if (InitBinaryEditor(EdData, MaxFileSize, 2, 4, 79, 22,
              True, EdOptInsert, '', ExitCommands, nil) <> 0) then begin
                 goto JustView;
          end; {If can't initialize editor window}

          if (ReadFileBinaryEditor(EdData, s) > 1) then begin
            ReleaseBinaryEditorHeap(EdData);
            goto JustView;
          end; {Couldn't read file}

          ResetBinaryEditor(EdData);      {Reset for new file}

          CursorOn;
          ExitCommand:=
          UseBinaryEditor(EdData,'');
          Junk:=ExitBinaryEditor(EdData,ExitCommand);
          ReleaseBinaryEditorHeap(EdData);

          if TagOrCurrent='C' then begin
            DirTag:=False;
            EscDepressed:=True;
            CursorOff;
            exit;
          end;
          Goto GetNextFile;
        end; {if DirTag}
       GetNextFile:

        CursorOff;
        new_dir:=next_dir;
      end; {with new_dir do}
    until new_dir=nil;
    goto AllDone;
  {------------------------ Just View Section -------------------------}
   JustView:
    SaveScreen(2);
    bf(0,15);
    ClrScr;
    RemBlkR(1,1,80,1,HelpBar,False);
    RemBlkR(1,25,80,25,HelpBar,False);
    PutStr('FileName: '+s,1,1,HelpBar);
    PutStr('EzDoss',73,1,HelpBar);
    PutStr('F1 - Help ',3,25,HelpBar);
    PutStr('Esc - Finish View This File',51,25,HelpBar);

    Assign(VFile,s);
    Reset(VFile);
   GetPage:
    i:=1;
    repeat
    readln(VFile,s1);
    PutStr(s1,1,i+1,11);
    inc(i);
    until (i=23) or (eof(VFile)); {while not eof}

    if eof(VFile) then begin
      RemBlkR(1,25,80,25,HelpBar,False);
      PutStr('End of File. Depress Any Key',27,25,HelpBar+128);
      ch:=ReadKey;
      if ch=NUL then ch:=ReadKey;
      goto ThisFileDone;
    end;
    Done:=False;
    repeat
      ch:=ReadKey;
      if ch=NUL then begin
        ch:=ReadKey;
        Case ch of
          F1: begin
                SaveScreen(1);
                Case monitor of
                  1: PoPObjLib(@ezd,'vhelpc',true,true);
                  2: PoPObjLib(@ezd,'vhelpm',true,true);
                end; {Case monitor of}
                ch1:=ReadKey;
                if ch1=NUL then ch1:=ReadKey;
                RestoreScreen(1);
              end; {help}
        PGDN: begin
                RemBlkR(1,2,80,24,15,False);
                goto GetPage;
              end;
         F10: goto AllDone;
           else
              write(BELL);
        end; {Case ch of}
      end
      else begin
        Case ch of
          ESC: Done:=True;
           else
               write(BELL);
        end; {Case ch of}
      end; {if ch was NOT a extended key}
    until Done;
   ThisFileDone:
    Close(VFile);

   goto GetNextFile;
   AllDone:

    DisposeFiles;
    GetFile(SourceString,ShortFile);
    GetFileNumber(NumOfFiles);
    TotalFilesTagged:=0;
    TaggedFilesSize:=0;
    Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
  end; {Go View}


{-------------------------------------------------------------------------}
Procedure FileCopy(* Source,Dest: AnyString *);
  Const
    BufSize=8192; {Powers of 2 are good here }
  Var
    SF,DF: File;
    NumRead, NumWritten  : Word;
    Buffer: Array [1..BufSize] Of Char;
    Error: Boolean;

  Begin
    Assign(SF,Source);
    Assign(DF,Dest);
    Reset(SF,1);
    Rewrite(DF,1);
    repeat
      BlockRead(SF,Buffer,SizeOf(Buffer),NumRead);
      BlockWrite(DF,Buffer,NumRead,NumWritten);
    until (NumRead=0) or (NumWritten<>NumRead);
    Close(SF);
    Close(DF);
  End; {File Copy Service}

{------------------------------------------------------------------------}
  Procedure MoveFile(* OldName, NewName  : AnyString;
                       var Ecode : integer *);
                       { Error codes: 0 - successful
                                      2 - file not found
                                      3 - path/file not found
                                      5 - access denied
                                      11h - not same device }
    var
      regs       : Registers;

    begin
      with regs do begin
        OldName := OldName + #0;
        NewName := NewName + #0;
        ds := seg(OldName);
        dx := ofs(OldName) + 1;
        es := seg(NewName);
        di := ofs(NewName) + 1;
        ax := $5600;
        MsDos ( regs );
        if (flags and 1) = 0 then
           Ecode := 0
        else
           Ecode := ax and $00FF;
      end;
    end;   { MoveFile }

{------------------------------------------------------------------------}
Procedure DateTime(* s,d: AnyString *);

  var
    Regs       : Registers;
    date,
    time       : Word;
    handle     : Integer;

  begin

    s[length(s)+1]:=chr(0);
    d[length(d)+1]:=chr(0);
    with Regs do begin
      {----------------- Open Source File & Get Time/Date ----------}
      { Part I - Open File}
      AH:=$3D;
      AL:=0;
      CH:=0;
      CL:=0;
      DS:=Seg(s);
      DX:=Ofs(s)+1;
      MsDos(regs);
      handle:=AX;

      {Part II - Get Source date and time}
      AH:=$57;
      AL:=0;      {0=get, 1=set}
      BX:=handle;
      MsDos(regs);
      time:=CX;
      date:=DX;

      {Part III - Close File}
      AH:=$3E;
      BX:=handle;
      MsDos(regs);

     {---------------- Open Dest. File & write Time/Date ----------------}
     {Part I - Open Dest. File}
      AH:=$3D;
      AL:=0;
      CH:=0;
      CL:=0;
      DS:=Seg(d);
      DX:=Ofs(d)+1;
      MsDos(regs);
      handle:=AX;

      {Part II - Set Dest. date and time}
      AH:=$57;
      AL:=01;      {0=get, 1=set}
      CX:=time;
      DX:=date;
      BX:=handle;
      MsDos(regs);

      {Part III - Close Dest. File}
      AH:=$3E;
      BX:=handle;
      MsDos(regs);
    end; {With registers}
  end; {Date_Time}


{------------------------------------------------------------------------}
Procedure GoCopy(* TagOrCurrent: Char *);
  var
    DestDrive        : Char;
    DestDriveNSub    : String[60];
    xx               : Integer;
    s,
    s1,
    s2,
    DestString       : String[80];
    DirInfo          : SearchRec;
    FleSize,
    DestDiskSpace    : LongInt;
    DoOverWriteAll,
    EnoughRoom       : Boolean;

  label EnterDestDrive, GetDestSubdirectory, GetNextFile, AllDone;
  label DoRoomCheck, RoomCheckDone, DoCopy;

  begin
    if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
      DisplayNoTaggedFiles;
      EscDepressed:=True;
      exit;
    end; {if no files have been tagged}

    SaveScreen(2);
    DoOverwriteAll:=False;
    if monitor=1 then begin
      att:=113;
      att1:=1;
    end
    else begin
      att:=7;
      att1:=7;
    end;
 {------------ This Section Gets Destination Drive & Subdirectory --------}
  EnterDestDrive:
    FillHeap(1,1,1,80,25,#32,15);
    PutHeap(1,'EzDoss',37,1,15);
    FillHeap(1,1,3,80,22,SHADE,att);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Exit Copy',63,25,HelpBar);

    FillHeap(1,28,17,61,21,SHADE1,att1);
    ClearBoxHeap(1,30,16,63,20,att,3);
    PutHeap(1,'Enter the Destination Drive',33,18,att);
    RestoreScreen(1);
    ChooseDrive(DestDrive);
    if EscDepressed then exit;

   GetDestSubdirectory:
    RemBlkR(30,25,55,25,HelpBar,False);
    ClearBox(28,16,65,20,att,3,True);
    PutStr('Enter the Destination Directory',32,18,att);
    PutStr('Esc - Re-enter Drive',58,25,HelpBar);
    ChooseSubdirectory(DestDrive,DestDriveNSub,35,5,SrceMain,SrceHigh,HelpAtt);
    if EscDepressed then goto EnterDestDrive;

    DestString:=DestDriveNSub;
    l:=length(DestString);
    if copy(DestString,l,1)<>'\' then
      DestString:=DestString+'\';

    s1:=DriveNSub;
    l:=length(s1);
    if copy(s1,l,1)<>'\' then
      s1:=s1+'\';

   {----------- Check to see if Trying to Copy to Same Drive & Sub -------}
    if s1=DestString then begin
      RestoreScreen(2);
      ClearBox(20,6,60,13,ErrAtt,3,False);
      PutStr('You CAN NOT Copy Files Onto The',25,8,ErrAtt);
      PutStr('Same Drive and Subdirectory',26,9,ErrAtt);
      PutStr('Depress Any Key to Continue',26,11,ErrAtt);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
      EscDepressed:=True;
      exit;
    end; {if both source & dest are the same}
   {-------------------------- Check To See if Enough Room ---------------}
    i:=ord(DestDrive);
    i:=i-64;
    DestDiskSpace:=DiskFree(i);
    if TagOrCurrent='T' then begin
      if DestDiskSpace>TaggedFilesSize then
        EnoughRoom:=True
      else
        EnoughRoom:=False;
    end
    else begin
      FleSize:=new_dir^.FileSize;
      if DestDiskSpace>new_dir^.FileSize then
        EnoughRoom:=True
      else
        EnoughRoom:=False;
    end;

    if not EnoughRoom then begin
   {------------------------ If not Enough Room check for Duplicates -------}
      if TagOrcurrent='C' then begin
        new_dir^.DirTag:=True;
        goto DoRoomCheck;
      end;
      new_dir:=first_dir;
      repeat
       DoRoomCheck:
        with new_dir^ do begin
          if DirTag then begin
            s:=DestString+filename;
            FindFirst(s,AnyFile,DirInfo);
            if DosError<>18 then begin     {Duplicate so add file size to free}
              DestDiskSpace:=DestDiskSpace+DirInfo.Size;
            end;
          end; {if File is Tagged}
          if TagOrCurrent='C' then goto RoomCheckDone;
          new_dir:=next_dir;
        end; {with new_dir do}
      until new_dir=nil;
     RoomCheckDone:
      RestoreScreen(2);
      Case monitor of
        1: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmc',true,true)
             else
               PoPObjLib(@ezd,'hb2fc',true,true);
           end; {1}
        2: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmm',true,true)
             else
               PoPObjLib(@ezd,'hb2fm',true,true);
           end; {2}
      end; {Case monitor of}
      if TagOrCurrent='T' then  FleSize:=TaggedFilesSize;
      if DestDiskSpace>FleSize then begin
        ClearBox(18,6,62,15,ErrAtt,4,False);
        PutStr('There is NOT Enough Disk Space Unless',21,8,ErrAtt);
        if TagOrCurrent='T' then begin
          PutStr('Files That Are TAGGED and Are On The',21,9,ErrAtt);
          PutStr('DESTINATION Drive Are To Be OVERWRITTEN.',21,10,ErrAtt);
        end
        else begin
          PutStr('the HIGHLIGHTED File On The',25,9,ErrAtt);
          PutStr('DESTINATION Drive Is To Be OVERWRITTEN.',21,10,ErrAtt);
        end;
        PutStr('             OVERWRITE?',21,11,ErrAtt);
        PutStr('F2 - Quick Keys',30,25,HelpBar);
        ChooseMenu(52,53,1,ErrAtt,15,True,False,0,0,0);
        if (EscDepressed) or (value=53) then begin
          EscDepressed:=False;
          goto AllDone;
        end;
        DoOverwriteAll:=True;
      end {if NOW there is ENOUGH room!}
      else begin
        ClearBox(15,7,65,13,ErrAtt,3,False);
        PutStr('There is NOT Enough Disk Space!',25,9,ErrAtt);
        PutStr('Depress Any Key to Re-enter Destination Drive',18,11,ErrAtt);
        ch1:=ReadKey;
        if ch1=NUL then ch1:=ReadKey;
        goto EnterDestDrive;
      end; {Still Not Enough Room}
    end; {if not enough room}
   {--------------------- Start Copying Files -----------------}
    RestoreScreen(2);

    if not ExpertMode then begin
      Case monitor of
        1: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmc',true,true)
             else
               PoPObjLib(@ezd,'hb2fc',true,true);
           end; {1}
        2: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmm',true,true)
             else
               PoPObjLib(@ezd,'hb2fm',true,true);
           end; {2}
      end; {Case monitor of}
      ClearBox(20,6,60,13,VerifyAtt,3,True);
      if TagOrCurrent='T' then begin
        PutStr('Copy Tagged Files',32,7,VerifyTitle);
        str(TotalFilesTagged,string1);
        xx:=1;
        if TotalFilesTagged<100 then xx:=2;
        if TotalFilesTagged<10 then xx:=3;
        string1:='LAST CHANCE! Copy '+string1+' files?';
        PutStr(string1,26+xx,9,VerifyAtt);
      end
      else begin
        PutStr('Copy File',38,7,VerifyTitle);
        PutStr('LAST CHANCE! Copy Highlighted File?',22,9,VerifyAtt);
      end;
      PutStr('F2 - Quick Keys',30,25,HelpBar);
      ChooseMenu(41,42,1,VerifyAtt,VerifyHigh,True,False,0,0,0);
      if (EscDepressed) or (value=42) then begin
        EscDepressed:=False;
        goto AllDone;
      end;
      RestoreScreen(2);
    end; {if not ExpertMode then last chance}

    if TagOrCurrent='C' then begin
      new_dir^.DirTag:=True;
      goto DoCopy;
    end;

    RemBlkR(1,25,80,25,HelpBar,False);
    ClearBox(22,9,57,13,ExeCmdAtt,2,True);
    PutStr('COPY',38,10,ExeCmdAtt);
    str(TotalFilesTagged,string1);
    string1:=string1+' Files Are to Be Copied';
    xx:=1;
    if TotalFilesTagged<100 then xx:=2;
    if TotalFilesTagged<10 then xx:=3;
    PutStr(string1,25+xx,11,ExeCmdAtt);
    SaveScreen(3);

    new_dir:=first_dir;
    repeat
     DoCopy:
      with new_dir^ do begin
        if DirTag then begin
          if TagOrCurrent='C' then begin
            RemBlkR(1,25,80,25,HelpBar,False);
            PutStr('Copying Highlighted File',29,25,HelpBar+128);
          end;
          s2:=s1+filename;
          s:=DestString+filename;
          if DoOverwriteAll then begin
            FileCopy(s2,s);
            DateTime(s2,s);
            if TagOrCurrent='C' then goto AllDone;
            RestoreScreen(3);
            dec(TotalFilesTagged);
            str(TotalFilesTagged,string1);
            xx:=1;
            if TotalFilesTagged<100 then xx:=2;
            if TotalFilesTagged<10 then xx:=3;
            RemBlkR(25,11,55,11,ExeCmdAtt,False);
            string1:=string1+' Files Are to Be Copied';
            PutStr(string1,25+xx,11,ExeCmdAtt);
          end
          else begin
            FindFirst(s,AnyFile,DirInfo);
            if DosError<>18 then begin
              RestoreScreen(2);
              ClearBox(17,7,63,15,ErrAtt,3,False);
              PutStr('Duplicate File Found On Destination Drive!',20,9,ErrAtt);
              PutStr('FileName: ',29,11,ErrAtt);
              RemBlkR(39,11,51,11,ErrAtt,False);
              PutStr(DirInfo.Name,39,11,15);
              RemBlkR(1,25,80,25,HelpBar,False);
              PutStr('F1 - Help',4,25,HelpBar);
              PutStr('F2 - Quick Keys',30,25,HelpBar);
              PutStr('Esc - Exit Copy',63,25,HelpBar);
              ChooseMenu(49,51,1,ErrAtt,15,True,False,0,0,0);
              if EscDepressed then begin
                EscDepressed:=False;
                goto AllDone;
              end;
              if value=51 then goto GetNextFile;
              if value=50 then DoOverWriteAll:=True;

              if TagOrCurrent='T' then
                RestoreScreen(3)
              else begin
                RestoreScreen(2);
                RemBlkR(1,25,80,25,HelpBar,False);
              end;
              FileCopy(s2,s);
              DateTime(s2,s);
              if TagOrCurrent='C' then goto AllDone;
              dec(TotalFilesTagged);
              str(TotalFilesTagged,string1);
              string1:=string1+' Files Are to Be Copied';
              xx:=1;
              if TotalFilesTagged<100 then xx:=2;
              if TotalFilesTagged<10 then xx:=3;
              RemBlkR(25,11,55,11,ExeCmdAtt,False);
              PutStr(string1,25+xx,11,ExeCmdAtt);
            end {if found file}
            else begin
              FileCopy(s2,s);
              DateTime(s2,s);
              if TagOrCurrent='C' then goto AllDone;
              dec(TotalFilesTagged);
              RestoreScreen(3);
              str(TotalFilesTagged,string1);
              string1:=string1+' Files Are to Be Copied';
              xx:=1;
              if TotalFilesTagged<100 then xx:=2;
              if TotalFilesTagged<10 then xx:=3;
              RemBlkR(25,11,55,11,ExeCmdAtt,False);
              PutStr(string1,25+xx,11,ExeCmdAtt);
              SaveScreen(3);
            end; {if file to be copied is not on dest drive}
          end; {see if need to overwrite}
        end; {if file is TAGGED}
       if TagOrCurrent='C' then goto AllDone;
       GetNextFile:
        new_dir:=next_dir;
      end; {with new dir do}
    until new_dir=nil;
   AllDone:
    DisposeFiles;
    GetFile(SourceString,ShortFile);
    GetFileNumber(NumOfFiles);
    TotalFilesTagged:=0;
    TaggedFilesSize:=0;
    Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
    EscDepressed:=False;
  end; {GoCopy - Copy tagged files}

{-------------------------------------------------------------------------}
Procedure GoMove(* TagOrCurrent: Char *);
  var
    DestDrive        : Char;
    DestDriveNSub    : String[60];
    error,
    xx               : Integer;
    FleSize          : LongInt;
    s,
    s1,
    s2,
    DestString       : String[80];
    DirInfo          : SearchRec;
    DestDiskSpace    : LongInt;
    DoOverWriteAll,
    SameDrive,
    EnoughRoom       : Boolean;
    DFile            : Text;

  label EnterDestDrive, GetDestSubdirectory, GetNextFile, AllDone;
  label DoRoomCheck, RoomCheckDone, DoMove;

  begin
    if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
      DisplayNoTaggedFiles;
      EscDepressed:=True;
      exit;
    end; {if no files have been tagged}

    SaveScreen(2);
    DoOverwriteAll:=False;
    SameDrive:=False;
    if monitor=1 then begin
      att:=113;
      att1:=1;
    end
    else begin
      att:=7;
      att1:=7;
    end;
 {------------ This Section Gets Destination Drive & Subdirectory --------}
  EnterDestDrive:
    FillHeap(1,1,1,80,25,#32,15);
    PutHeap(1,'EzDoss',37,1,15);
    FillHeap(1,1,3,80,22,SHADE,att);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Exit Move',63,25,HelpBar);

    FillHeap(1,28,17,61,21,SHADE1,att1);
    ClearBoxHeap(1,30,16,63,20,att,3);
    PutHeap(1,'Enter the Destination Drive',33,18,att);
    RestoreScreen(1);
    ChooseDrive(DestDrive);
    if DestDrive=Drive then SameDrive:=True else SameDrive:=False;
    if EscDepressed then exit;

   GetDestSubdirectory:
    RemBlkR(30,25,55,25,HelpBar,False);
    ClearBox(28,16,65,20,att,3,True);
    PutStr('Enter the Destination Directory',32,18,att);
    PutStr('Esc - Re-enter Drive',58,25,HelpBar);
    ChooseSubdirectory(DestDrive,DestDriveNSub,35,5,SrceMain,SrceHigh,HelpAtt);
    if EscDepressed then goto EnterDestDrive;

    DestString:=DestDriveNSub;
    l:=length(DestString);
    if copy(DestString,l,1)<>'\' then
      DestString:=DestString+'\';

    s1:=DriveNSub;
    l:=length(s1);
    if copy(s1,l,1)<>'\' then
      s1:=s1+'\';

   {----------- Check to see if Trying to Copy to Same Drive & Sub -------}
    if s1=DestString then begin
      RestoreScreen(2);
      ClearBox(20,6,60,13,ErrAtt,3,False);
      PutStr('You CAN NOT Move Files to The',25,8,ErrAtt);
      PutStr('Same Drive and Subdirectory',26,9,ErrAtt);
      PutStr('Depress Any Key to Continue',26,11,ErrAtt);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
      EscDepressed:=True;
      exit;
    end; {if both source & dest are the same}
   {-------------------------- Check To See if Enough Room ---------------}
    i:=ord(DestDrive);
    i:=i-64;
    DestDiskSpace:=DiskFree(i);
    if TagOrCurrent='T' then begin
      if DestDiskSpace>TaggedFilesSize then
        EnoughRoom:=True
      else
        EnoughRoom:=False;
    end
    else begin
      FleSize:=new_dir^.FileSize;
      if DestDiskSpace>new_dir^.FileSize then
        EnoughRoom:=True
      else
        EnoughRoom:=False;
    end;

    if not EnoughRoom then begin
   {------------------------ If not Enough Room check for Duplicates -------}
      if TagOrcurrent='C' then begin
        new_dir^.DirTag:=True;
        goto DoRoomCheck;
      end;
      new_dir:=first_dir;
      repeat
       DoRoomCheck:
        with new_dir^ do begin
          if DirTag then begin
            s:=DestString+filename;
            FindFirst(s,AnyFile,DirInfo);
            if DosError<>18 then begin     {Duplicate so add file size to free}
              DestDiskSpace:=DestDiskSpace+DirInfo.Size;
            end;
          end; {if File is Tagged}
          if TagOrCurrent='C' then goto RoomCheckDone;
          new_dir:=next_dir;
        end; {with new_dir do}
      until new_dir=nil;
     RoomCheckDone:
      RestoreScreen(2);
      Case monitor of
        1: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmc',true,true)
             else
               PoPObjLib(@ezd,'hb2fc',true,true);
           end; {1}
        2: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmm',true,true)
             else
               PoPObjLib(@ezd,'hb2fm',true,true);
           end; {2}
      end; {Case monitor of}
      if TagOrCurrent='T' then  FleSize:=TaggedFilesSize;

      if DestDiskSpace>FleSize then begin
        ClearBox(18,6,62,15,ErrAtt,4,False);
        PutStr('There is NOT Enough Disk Space Unless',21,8,ErrAtt);
        if TagOrCurrent='T' then begin
          PutStr('Files That Are TAGGED and Are On The',21,9,ErrAtt);
          PutStr('DESTINATION Drive Are To Be OVERWRITTEN.',21,10,ErrAtt);
        end
        else begin
          PutStr('the HIGHLIGHTED File On The',25,9,ErrAtt);
          PutStr('DESTINATION Drive Is To Be OVERWRITTEN.',21,10,ErrAtt);
        end;
        PutStr('             OVERWRITE?',21,11,ErrAtt);
        PutStr('F2 - Quick Keys',30,25,HelpBar);
        ChooseMenu(52,53,1,ErrAtt,15,True,False,0,0,0);
        if (EscDepressed) or (value=53) then begin
          EscDepressed:=False;
          goto AllDone;
        end;
        DoOverwriteAll:=True;
      end {if NOW there is ENOUGH room!}
      else begin
        ClearBox(15,7,65,13,ErrAtt,3,False);
        PutStr('There is NOT Enough Disk Space!',25,9,ErrAtt);
        PutStr('Depress Any Key to Re-enter Destination Drive',18,11,ErrAtt);
        ch1:=ReadKey;
        if ch1=NUL then ch1:=ReadKey;
        goto EnterDestDrive;
      end; {Still Not Enough Room}
    end; {if not enough room}
   {--------------------- Start Moving Files -----------------}
    RestoreScreen(2);

    if not ExpertMode then begin
      Case monitor of
        1: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmc',true,true)
             else
               PoPObjLib(@ezd,'hb2fc',true,true);
           end; {1}
        2: begin
             if FromMenu then
               PoPObjLib(@ezd,'hb2mmm',true,true)
             else
               PoPObjLib(@ezd,'hb2fm',true,true);
           end; {2}
      end; {Case monitor of}
      ClearBox(20,6,60,13,VerifyAtt,3,True);
      if TagOrCurrent='T' then begin
        PutStr('Move Tagged Files',32,7,VerifyTitle);
        str(TotalFilesTagged,string1);
        xx:=1;
        if TotalFilesTagged<100 then xx:=2;
        if TotalFilesTagged<10 then xx:=3;
        string1:='LAST CHANCE! Move '+string1+' files?';
        PutStr(string1,26+xx,9,VerifyAtt);
      end
      else begin
        PutStr('Move File',38,7,VerifyTitle);
        PutStr('LAST CHANCE! Move Highlighted File?',22,9,VerifyAtt);
      end;
      PutStr('F2 - Quick Keys',30,25,HelpBar);
      ChooseMenu(41,42,1,VerifyAtt,VerifyHigh,True,False,0,0,0);
      if (EscDepressed) or (value=42) then begin
        EscDepressed:=False;
        goto AllDone;
      end;
      RestoreScreen(2);
    end; {if not ExpertMode then last chance}

    if TagOrCurrent='C' then begin
      new_dir^.DirTag:=True;
      goto DoMove;
    end;

    RemBlkR(1,25,80,25,HelpBar,False);
    ClearBox(22,9,57,13,ExeCmdAtt,2,True);
    PutStr('MOVE',38,10,ExeCmdAtt);
    str(TotalFilesTagged,string1);
    string1:=string1+' Files Are to Be Moved';
    xx:=1;
    if TotalFilesTagged<100 then xx:=2;
    if TotalFilesTagged<10 then xx:=3;
    PutStr(string1,25+xx,11,ExeCmdAtt);
    SaveScreen(3);

    new_dir:=first_dir;
    repeat
     DoMove:
      with new_dir^ do begin
        if DirTag then begin
          if TagOrCurrent='C' then begin
            RemBlkR(1,25,80,25,HelpBar,False);
            PutStr('Moving Highlighted File',29,25,HelpBar+128);
          end; {if ALT M}
          s2:=s1+filename;
          s:=DestString+filename;
          if DoOverwriteAll then begin
            
            if SameDrive then
              MoveFile(s2,s,error)
            else begin
              FileCopy(s2,s);
              DateTime(s2,s);
              Assign(DFile,s2);
              Erase(DFile);
            end;
            if TagOrCurrent='C' then goto AllDone;
            RestoreScreen(3);
            dec(TotalFilesTagged);
            str(TotalFilesTagged,string1);
            xx:=1;
            if TotalFilesTagged<100 then xx:=2;
            if TotalFilesTagged<10 then xx:=3;
            RemBlkR(25,11,55,11,ExeCmdAtt,False);
            string1:=string1+' Files Are to Be Moved';
            PutStr(string1,25+xx,11,ExeCmdAtt);
          end
          else begin
            FindFirst(s,AnyFile,DirInfo);
            if DosError<>18 then begin
              RestoreScreen(2);
              ClearBox(17,7,63,15,ErrAtt,3,False);
              PutStr('Duplicate File Found On Destination Drive!',20,9,ErrAtt);
              PutStr('FileName: ',29,11,ErrAtt);
              RemBlkR(39,11,51,11,ErrAtt,False);
              PutStr(DirInfo.Name,39,11,15);
              RemBlkR(1,25,80,25,HelpBar,False);
              PutStr('F1 - Help',4,25,HelpBar);
              PutStr('F2 - Quick Keys',30,25,HelpBar);
              PutStr('Esc - Exit Copy',63,25,HelpBar);
              ChooseMenu(49,51,1,ErrAtt,15,True,False,0,0,0);
              if EscDepressed then begin
                EscDepressed:=False;
                goto AllDone;
              end;
              if value=51 then goto GetNextFile;
              if value=50 then DoOverWriteAll:=True;

              if TagOrCurrent='T' then
                RestoreScreen(3)
              else begin
                RestoreScreen(2);
                RemBlkR(1,25,80,25,HelpBar,False);
              end;
              if SameDrive then
                MoveFile(s2,s,error)
              else begin
                FileCopy(s2,s);
                DateTime(s2,s);
                Assign(DFile,s2);
                Erase(DFile);
              end;
              if TagOrCurrent='C' then goto AllDone;
              dec(TotalFilesTagged);
              str(TotalFilesTagged,string1);
              string1:=string1+' Files Are to Be Moved';
              xx:=1;
              if TotalFilesTagged<100 then xx:=2;
              if TotalFilesTagged<10 then xx:=3;
              RemBlkR(25,11,55,11,ExeCmdAtt,False);
              PutStr(string1,25+xx,11,ExeCmdAtt);
            end {if found file}
            else begin
              if SameDrive then
                MoveFile(s2,s,error)
              else begin
                FileCopy(s2,s);
                DateTime(s2,s);
                Assign(DFile,s2);
                Erase(DFile);
              end;
              if TagOrCurrent='C' then goto AllDone;
              dec(TotalFilesTagged);
              RestoreScreen(3);
              str(TotalFilesTagged,string1);
              string1:=string1+' Files Are to Be Moved';
              xx:=1;
              if TotalFilesTagged<100 then xx:=2;
              if TotalFilesTagged<10 then xx:=3;
              RemBlkR(25,11,55,11,ExeCmdAtt,False);
              PutStr(string1,25+xx,11,ExeCmdAtt);
              SaveScreen(3);
            end; {if file to be copied is not on dest drive}
          end; {see if need to overwrite}
        end; {if file is TAGGED}
       if TagOrCurrent='C' then goto AllDone;
       GetNextFile:
        new_dir:=next_dir;
      end; {with new dir do}
    until new_dir=nil;
   AllDone:
    DisposeFiles;
    GetFile(SourceString,ShortFile);
    if first_dir=nil then begin
      ClearBox(15,6,65,13,ErrAtt,2,False);
      PutStr('NO FILES IN THIS DIRECTORY!',27,8,ErrAtt);
      PutStr('Depress Esc to EXIT',30,9,ErrAtt);
      PutStr('or',39,10,ErrAtt);
      PutStr('Any Other Key to Re-enter Source Drive',21,11,ErrAtt);
      ch1:=ReadKey;
      if ch1=ESC then
        GoodBye
      else begin
        if ch1=NUL then ch1:=ReadKey;
        ReDoSourceDrive:=True;
        exit;
      end;
    end; {if no files found}
    GetFileNumber(NumOfFiles);
    TotalFilesTagged:=0;
    TaggedFilesSize:=0;
    Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
  end; {GoMove - Move tagged files}

{-------------------------------------------------------------------------}

BEGIN
END.

