{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
UNIT Ez2;

INTERFACE

USES  BINED,
      CRT,
      DOS,
      PRINTER,
      POPSCRN,
      SCRNHEAP,
      MENU,
      GETSUB,
      GETFILES,
      GLOBALS,
      EZ0,
      EZ1;

{$V-}

Procedure GoMask;
Procedure GoPattern;
Procedure GoExpand;
Procedure DisplayNoTaggedFiles;
Procedure GoDelete(TagOrCurrent: Char);
Procedure GoRename(TagOrCurrent: Char);
Procedure GoLocate;
Procedure GoPrint(TagOrCurrent: Char);
Procedure GoFindDup;

IMPLEMENTATION
{---------------------------------------------------------------------------}
Procedure GoPattern;
  begin
    SaveScreen(5);
    Case monitor of
      1: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmc',true,true)
           else
             PoPObjLib(@ezd,'hb2fc',true,true);
         end; {1}
      2: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmm',true,true)
           else
             PoPObjLib(@ezd,'hb2fm',true,true);
         end; {2}
    end; {Case monitor of}
    MPLFileName(2,string1);
    RestoreScreen(5);
    if EscDepressed then exit;
    TagByPattern(string1);
    DisplayFirstPage;
  end; {GoPattern}
{---------------------------------------------------------------------------}
Procedure GoMask;
  label GetThoseFiles;

  begin
    SaveScreen(1);
    Case monitor of
      1: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmc',true,true)
           else
             PoPObjLib(@ezd,'hb2fc',true,true);
         end; {1}
      2: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmm',true,true)
           else
             PoPObjLib(@ezd,'hb2fm',true,true);
         end; {2}
    end; {Case monitor of}
    MPLFileName(3,string1);
    RestoreScreen(1);
    if EscDepressed then exit;
    l:=length(DriveNSub);
    if copy(DriveNSub,l,1)='\' then
      SourceString:=DriveNSub+string1
    else
    SourceString:=DriveNSub+'\'+string1;
   GetThoseFiles:
    DisposeFiles;
    GetFile(SourceString,ShortFile);
    if first_dir=nil then begin
      ClearBox(25,6,55,13,ErrAtt,2,False);
      PutStr('NO MATCHING FILES!',31,8,ErrAtt);
      PutStr('Depress Esc to EXIT',30,9,ErrAtt);
      PutStr(' Depress Any Key. ',31,11,15);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
      l:=length(DriveNSub);
      if copy(DriveNSub,l,1)='\' then
        SourceString:=DriveNSub+'*.*'
      else
        SourceString:=DriveNSub+'\*.*';
      goto GetThoseFiles;
    end; {if no files found}
    GetFileNumber(NumOfFiles);
    TotalFilesTagged:=0;
    TaggedFilesSize:=0;
    Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
  end; {GoMask}
{---------------------------------------------------------------------------}
 Procedure GoExpand;
    var
      x1,x2,y1,y2          : Integer;
    begin
      if ShortFile then begin
        SaveScreen(1);
        with new_dir^do begin
          Case x of
             6:  begin
                  x1:=6; x2:=49;
                end;
            20: begin
                  x1:=21; x2:=64;
                end;
            35: begin
                  x1:=21; x2:=64;
                end;
            49: begin
                  x1:=34; x2:=77;
                end;
            63: begin
                  x1:=34; x2:=77;
                end;
          end; {Case x of}

          if y<11 then begin
            y1:=y+1; y2:=y+4;
          end
          else begin
            y1:=y-4; y2:=y-1;
          end;

          ClearBox(x1,y1,x2,y2,ExpandAtt,4,False);
          PutStr('File Name',x1+4,y1+1,ExpandTitle);
          PutStr('Size',x1+17,y1+1,ExpandTitle);
          PutStr('Date',x1+26,y1+1,ExpandTitle);
          PutStr('Time',x1+36,y1+1,ExpandTitle);

          PutStr(FileName,x1+2,y1+2,ExpandAtt);
          str(FileSize:7,string1);
          PutStr(string1,x1+14,y1+2,ExpandAtt);
          PutStr(FileSDate,x1+24,y1+2,ExpandAtt);
          PutStr(FileSTime,x1+34,y1+2,ExpandAtt);
        end; {with new dir ^}

        RemBlkR(24,20,56,22,ErrAtt,False);
        Box(24,20,56,22,ErrAtt+128,4);
        PutStr('Depress Any Key to Continue',27,21,ErrAtt);
        ch1:=ReadKey;
        if ch1=NUL then ch1:=ReadKey;
        RestoreScreen(1);
    end {if ShortFile}
    else
      write(BELL);
  end; {Expand File}

{---------------------------------------------------------------------------}
Procedure DisplayNoTaggedFiles;
  begin
    SaveScreen(5);
    ClearBox(20,8,60,13,ErrAtt,4,False);
    PutStr('There are no TAGGED files!',27,10,ErrAtt);
    PutStr('Depress Any Key',33,11,ErrAtt);
    ch1:=ReadKey;
    if ch1=NUL then ch1:=ReadKey;
    RestoreScreen(5);
  end; {Display NoTagged Files}

{-------------------------------------------------------------------------}
  Procedure GoDelete(* TagOrCurrent: Char *);
     var
       x            : Integer;
       DelFileName  : Text;

     label DoCurrentDelete, AllDone;
     begin
      ReDoSourceDrive:=False;
      if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
        DisplayNoTaggedFiles;
        EscDepressed:=True;
        exit;
      end; {if no files have been tagged}

        SaveScreen(1);
        if not InMainMenu then begin
          Case monitor of
            1: PoPObjLib(@ezd,'hb2fc',true,true);
            2: PoPObjLib(@ezd,'hb2fm',true,true);
          end; {Case monitor of}
        end; {if not in MainMenu}
        x:=3;
        str(TotalFilesTagged,string1);
        if TotalFilesTagged<100 then x:=2;
        if TotalFilesTagged<10 then x:=1;
        if TagOrCurrent='T' then
          string1:='Delete the '+string1+' tagged files?'
        else
          string1:='Delete the Highlighted file?';
        ClearBox(22,6,58,13,VerifyAtt,3,True);

        if TagOrCurrent='T' then begin
           PutStr('Delete Tagged Files',31,7,VerifyTitle);
           PutStr(string1,27+x,9,VerifyAtt);
        end
        else begin
          PutStr('Delete File',37,7,VerifyTitle);
          PutStr(string1,27,9,VerifyTitle);
        end;

        ChooseMenu(41,42,1,VerifyAtt,VerifyHigh,True,False,0,0,0);
        if (EscDepressed) or (value=42) then begin
          EscDepressed:=True;
          RestoreScreen(1);
          exit;
        end;

      if not ExpertMode then begin
        ClearBox(20,6,60,13,Verify2Att,3,True);
        if TagOrCurrent='T' then begin
          PutStr('Delete Tagged Files',31,7,Verify2Title);
          str(TotalFilesTagged,string1);
          string1:='LAST CHANCE! Delete '+string1+' files?';
          PutStr(string1,25+x,9,Verify2Att);
        end
        else begin
          PutStr('Delete File',37,7,Verify2Title);
          PutStr('LAST CHANCE! Delete Highlighted File?',22,9,Verify2Att);
        end;

        ChooseMenu(41,42,1,Verify2Att,Verify2High,True,False,0,0,0);
        if (EscDepressed) or (value=42) then begin
          EscDepressed:=True;
          RestoreScreen(1);
          exit;
        end;

        RestoreScreen(1);
      end; {if not ExpertMode}
      SaveScreen(1);

      if TagOrCurrent='C' then begin
        with new_dir^ do DirTag:=True;
        goto DoCurrentDelete;
      end;

      ClearBox(22,9,57,13,ExeCmdAtt,2,True);
      PutStr('DELETE',37,10,ExeCmdAtt);
      str(TotalFilesTagged,string1);
      string1:=string1+' Files Are to Be Deleted';
      PutStr(string1,27+x,11,ExeCmdAtt);
      new_dir:=first_dir;
      repeat
        with new_dir^ do begin
          if DirTag then begin
            dec(TotalFilesTagged);
            x:=3;
            str(TotalFilesTagged,string1);
            if TotalFilesTagged<100 then x:=2;
            if TotalFilesTagged<10 then x:=1;
            RemBlkR(23,11,55,11,ExeCmdAtt,False);
            string1:=string1+' Files Are to Be Deleted';
            PutStr(string1,27+x,11,ExeCmdAtt);
          DoCurrentDelete:
            l:=length(DriveNSub);
            if copy(DriveNSub,l,1)='\' then
              string2:=DriveNSub+FileName
            else
              string2:=DriveNSub+'\'+FileName;

            Assign(DelFileName,string2);
            Erase(DelFileName);
          end; {if DirTag}
          if TagOrCurrent='C' then goto AllDone;
          new_dir:=next_dir;
        end; {with new_dir do}
      until new_dir=nil;
     AllDone:
      RestoreScreen(1);
      DisposeFiles;
      GetFile(SourceString,ShortFile);
      if first_dir=nil then begin
        ClearBox(15,6,65,13,ErrAtt,2,False);
        PutStr('NO FILES IN THIS DIRECTORY!',27,8,ErrAtt);
        PutStr('Depress Esc to EXIT',30,9,ErrAtt);
        PutStr('or',39,10,ErrAtt);
        PutStr('Any Other Key to Re-enter Source Drive',21,11,ErrAtt);
        ch1:=ReadKey;
        if ch1=ESC then
          GoodBye
        else begin
          if ch1=NUL then ch1:=ReadKey;
          ReDoSourceDrive:=True;
          exit;
        end;
      end; {if no files found}      TotalFilesTagged:=0;
      GetFileNumber(NumOfFiles);
      TaggedFilesSize:=0;
      Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
     end;  {Delete Tag}

{---------------------------------------------------------------------------}
Procedure GoLocate;
  var
    SubFile               : Text;
    att,
    att1                  : Byte;
    LineNumber,
    x,
    TotalFilesLocated     : Integer;
    LDrive                : Char;
    LocateInfo            : SearchRec;
    s,s1                  : String[60];
    LocateFileName        : String[12];

  Label EnterFileName;

  begin
    if monitor=1 then begin
      att:=113;
      att1:=1;
    end
    else begin
      att:=7;
      att1:=7;
    end;

    FillHeap(1,1,1,80,25,#32,15);
    PutHeap(1,'EzDoss',37,1,15);
    FillHeap(1,1,3,80,22,SHADE,att);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Exit Locate',61,25,HelpBar);

    FillHeap(1,30,17,76,21,SHADE1,att1);
    ClearBoxHeap(1,32,16,78,20,att,3);
    PutHeap(1,'Enter the Source Drive for Locating Files.',34,18,att);
    RestoreScreen(1);
    ChooseDrive(LDrive);
    if EscDepressed then exit;

    FillHeap(1,1,3,80,22,SHADE,FileNameAtt);
    FillHeap(1,30,25,55,25,#32,HelpBar);
    RestoreScreen(1);
   EnterFileName:
    MPLFileName(1,LocateFileName);
    if EscDepressed then exit;

    if copy(LocateFileName,1,1)='.' then begin
      SaveScreen(1);
      ClearBox(18,7,62,10,ErrAtt,2,False);
      PutStr('A FILENAME must be specified!',27,8,ErrAtt);
      PutStr('Depress Any Key to Re-Enter File Name',22,9,ErrAtt);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
      RestoreScreen(1);
      goto EnterFileName;
    end; {no file name}

    att:=FileNameAtt div 16;
    FillHeap(1,4,5,76,21,SHADE,att);
    FillHeap(1,1,23,80,25,#32,15);
    ClearBoxHeap(1,6,4,78,20,FileNameAtt,1);
    PutHeap(1,'EzDoss - Locate Option',31,5,FileNameAtt);

    RestoreScreen(1);
    PutStr('Searching for Subdirectories',28,10,FileNameAtt+128);
    FindSubdirectory(LDrive);
    RemBlkR(26,10,70,10,FileNameAtt,False);

    LineNumber:=7;
    TotalFilesLocated:=0;

    string1:=LDrive+'.ezd';
    Assign(SubFile,string1);
    Reset(SubFile);
      while not eof(SubFile) do begin
        readln(SubFile,string2);
        delete(string2,1,2);
        string2:=LDrive+':'+string2;
        l:=length(string2);
        if copy(string2,l,1)<>'\' then string2:=string2+'\';
        s:=string2+LocateFileName;
        FindFirst(s,AnyFile,LocateInfo);
        while DosError<>18 do begin
          inc(TotalFilesLocated);
          s1:=string2+LocateInfo.Name;
           PutStr(s1,20,LineNumber,FileNameAtt);
           inc(LineNumber);
           if LineNumber=20 then begin
             LineNumber:=7;
             PutStr('Page Full - Depress Any Key to Continue',21,24,143);
             ch1:=ReadKey;
             if ch1=NUL then ch1:=ReadKey;
             RemBlkR(20,7,75,19,FileNameAtt,False);
             RemBlkR(1,24,80,24,15,False);
           end; {LineNumber=20}
           FindNext(LocateInfo);
        end; {While Dos Error=0}
      end;  {while not eof}
      str(TotalFilesLocated,string1);
      x:=3;
      if TotalFilesLocated<100 then x:=2;
      if TotalFilesLocated<10 then x:=1;
      PutStr('Location of Files Complete. '+string1+' files located. Depress Any Key to Continue.',
             2+x,24,15);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
    Close(SubFile);
  end; {GoLocate - Locate all matches on a given drive}

{---------------------------------------------------------------------------}
Procedure GoRename(* TagOrCurrent: Char *);
  var
    i,
    xx,
    att,
    att1            : ShortInt;
    err             : Integer;
    ch,
    DestDrive       : Char;
    RenameSource,
    RenameDest,
    RenameString    : String[80];
    s,
    s1,
    RenameFileName,
    flename         : String[12];
    filext          : String[3];
    EndofString     : Boolean;
    p               : Dir_Ptr;

  label File_Name, File_Extension, GetRename, PerformRename, AllDone;

  begin
    if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
      DisplayNoTaggedFiles;
      EscDepressed:=True;
      exit;
    end; {if no files have been tagged}

    p:=new_dir; {Set pointer to current file being highlighted}

   {----------------- This Section Asks for New Name -------------------}
     Case monitor of
       1: att:=111;
       2: att:=112;
     end;

     ClearBox(24,5,51,16,att,2,False);
     PutStr('Rename',35,6,att);
     PutStr('Enter the NEW name.',29,8,att);
     PutStr('Name',30,10,att);
     PutStr('Ext',31,11,att);
     PutStr('Existing FileName',29,13,att);

     if TagOrCurrent='C' then begin
       with new_dir^ do DirTag:=True;
       goto PerformRename;
     end;

     new_dir:=first_dir;
     repeat
       with new_dir^ do begin
         if DirTag then begin
        PerformRename:
         s1:=FileName;
           while pos(SPC,s1)>0 do begin
             xx:=pos(SPC,s1);
             delete(s1,xx,1);
           end;
           l:=length(s1);
           l:=12-l;
           l:=l div 2;
           if xx>0 then begin
             for i:=1 to l do s1:=' '+s1;
           end;
           RemBlkR(29,14,45,14,15,False);
           PutStr(s1,32,14,15);
          {--------------- Get New Name -------------------}
          GetRename:
           PutStr('[        ]',36,10,15);
           PutStr('[   ]',36,11,15);

          {---------------------  Get Data into fields --------------------}
            bf(0,15);
            EndOfString:=False;
            File_Name:
              s:='';
              i:=1;
              PutStr('[        ]',36,10,15);
              gotoxy(37,10);
              CursorOn;
              repeat
                ch:=ReadKey;
                ch:=UpCase(ch);
                if ch=NUL then begin
                  ch:=ReadKey;
                  Case ch of
                    F1: begin
                          SaveScreen(4);
                          CursorOff;
                          Case monitor of
                            1: PoPObjLib(@ezd,'renhelpc',true,true);
                            2: PoPObjLib(@ezd,'renhelpm',true,true);
                          end; {Case monitor of}
                          ch1:=ReadKey;
                          if ch1=NUL then ch1:=ReadKey;
                          CursorOn;
                          RestoreScreen(4);
                        end;
                    else
                      write(BELL);
                  end; {Case Ch of}
                end                                     {End if ESC hit}
                else begin
                  Case ch of
                    ESC: begin
                           CursorOff;
                           EscDepressed:=True;
                           new_dir:=p;
                           exit;
                         end; {Esc}
                     BS: begin
                           Case i of
                              1: write(BELL);
                           2..9: begin
                                   EndofString:=False;
                                   i:=i-1;
                                   gotoxy(36+i,10);
                                   write(' ');
                                   gotoxy(36+i,10);
                                 end;
                           end; {Case i of}
                         end; {if BackSpace}
                'A'..'Z',
                '0'..'9',
                '@','-',
                '!'..'&': begin
                            Case i of
                              1..7: begin
                                      if EndofString then
                                        write(BELL)
                                      else begin
                                        write(ch);
                                        i:=i+1;
                                        gotoxy(36+i,10);
                                      end;
                                    end; {1..7}
                                 8: begin
                                      write(ch);
                                      i:=9;
                                      EndofString:=True;
                                      gotoxy(45,10);
                                      end;
                                    else
                                      write(BELL);
                            end; {Case i of}
                          end; {Valid Input}
                          else
                            if ch<>CR then write(BELL);
                   end; {Case ch of}
                 end; {Key pressed not ESC}
               until ch=CR;
               GetStr(s,37,10,8);
               l:=length(s);
               while copy(s,l,1)=SPC do begin
                 delete(s,l,1);
                 l:=length(s);
               end;
               flename:=s;
               if length(flename)=0 then begin
                 SaveScreen(1);
                 ClearBox(17,18,63,23,ErrAtt,4,False);
                 PutStr('In order to RENAME a file, you must have',20,19,ErrAtt);
                 PutStr('enter a file name.',32,20,ErrAtt);
                 PutStr(' Depress Any Key to Re-enter Name ',24,22,15);
                 ch1:=ReadKey;
                 if ch1=NUL then ch1:=ReadKey;
                 RestoreScreen(1);
                 goto GetRename;
               end; {if no filename}

             File_Extension:
              s:='';
              i:=1;
              PutStr('[   ]',36,11,15);
              gotoxy(36+i,11);
              CursorOn;
              repeat
                 ch:=ReadKey;
                 ch:=UpCase(ch);
                 if ch=NUL then begin
                   ch:=ReadKey;
                   Case ch of
                          F1: begin
                                SaveScreen(4);
                                CursorOff;
                                Case monitor of
                                  1: PoPObjLib(@ezd,'renhelpc',true,true);
                                  2: PoPObjLib(@ezd,'renhelpm',true,true);
                                end; {Case monitor of}
                                ch1:=ReadKey;
                                if ch1=NUL then ch1:=ReadKey;
                                CursorOn;
                                RestoreScreen(4);
                              end; {F1}
                     UPARROW: begin
                                PutStr('[   ]',36,11,15);
                                goto File_Name;
                              end; {UpArrow}
                   end; {Case ch of}
                 end
                 else begin
                   Case ch of
                        BS: begin
                              Case i of
                                1: write(BELL);
                             2..4: begin
                                     i:=i-1;
                                     gotoxy(36+i,11);
                                     write(' ');
                                     gotoxy(36+i,11);
                                   end;
                              end; {Case i of}
                            end; {if BackSpace}
                      'A'..'Z',
                      '0'..'9',
                      '@','-',
                      '!'..'&': begin
                                   Case i of
                                     1..2:
                                         begin
                                          write(ch);
                                          i:=i+1;
                                          gotoxy(36+i,11);
                                        end;
                                     3: begin
                                          write(ch);
                                          i:=4;
                                          gotoxy(40,11);
                                        end;
                                     else
                                       write(BELL);
                                   end; {Case i of}
                                 end; {Valid Input}
                              else
                        if ch<>CR then write(BELL);
                   end; {Case ch of}
                 end; {Key pressed not ESC}
               until ch=CR;
               CursorOff;
               GetStr(s,37,11,3);
               l:=length(s);
               while copy(s,l,1)=SPC do begin
                 delete(s,l,1);
                 l:=length(s);
               end;
               filext:=s;
               RenameFileName:=flename+'.'+filext;

           if not ExpertMode then begin
             SaveScreen(1);
             ClearBox(22,18,54,23,ErrAtt,3,False);
             PutStr('Are you sure the',30,19,ErrAtt);
             PutStr('new name is correct?',28,20,ErrAtt);
             ChooseMenu(47,48,1,ErrAtt,15,True,False,0,0,0);
             if (EscDepressed) or (value=48) then begin
               RestoreScreen(1);
               goto GetRename;
             end;
             RestoreScreen(1);
             CursorOff;
           end;
           RenameString:=DriveNSub;
           l:=length(RenameString);
           if copy(RenameString,l,1)<>'\' then
             RenameString:=RenameString+'\';
           RenameSource:=RenameString+FileName;
           RenameDest:=RenameString+RenameFileName;
           RenameFile(RenameSource,RenameDest,err);
         end; {if File is Tagged}
         if TagOrCurrent='C' then goto AllDone;
         new_dir:=next_dir;
       end; {with new_dir do}

     until new_dir=nil;
    AllDone:
     DisposeFiles;
     GetFile(SourceString,ShortFile);
     GetFileNumber(NumOfFiles);
     TotalFilesTagged:=0;
     TaggedFilesSize:=0;
     Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
     CursorOff;
  end; {DoRename - Rename tagged Files}

{---------------------------------------------------------------------------}
Procedure GoPrint(* TagOrCurrent: Char *);
  var
    regs             : Registers;
    PageCounter,
    LineCounter      : Integer;
    att,
    att1,
    att2,
    i                : ShortInt;
    PFile            : Text;
    s                : String[80];
    s1               : String[255];
    PrintedFile      : Boolean;

  label GetNextFile, DoPrint, AllDone;

  begin
    if (TotalFilesTagged=0) and (TagOrCurrent='T') then begin
      DisplayNoTaggedFiles;
      EscDepressed:=True;
      exit;
    end; {if no files have been tagged}

    Case monitor of
      1: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmc',true,true)
           else
             PoPObjLib(@ezd,'hb2fc',true,true);
         end; {1}
      2: begin
           if FromMenu then
             PoPObjLib(@ezd,'hb2mmm',true,true)
           else
             PoPObjLib(@ezd,'hb2fm',true,true);
         end; {2}
    end; {Case monitor of}
    Case monitor of
      1: att2:=47;
      2: att2:=112;
    end;

    PrintedFile:=False;
    if TagOrCurrent='C' then begin
      new_dir^.DirTag:=True;
      goto DoPrint;
    end;

    new_dir:=first_dir;
    repeat
     DoPrint:
      with new_dir^ do begin
        if DirTag then begin
          if not ExpertMode then begin
            Case monitor of
              1: begin
                   att:=113;
                   att1:=31;
                 end; {1}
              2: begin
                   att:=112;
                   att1:=15;
                 end;
            end; {Case monitor of}
            ClearBox(22,4,58,13,att,2,False);
            if TagOrCurrent='T' then
              PutStr('Are you sure the TAGGED',29,6,att)
            else
              PutStr('Are you sure the Highlighted',26,6,att);
            PutStr('file is an ASCII file?',29,7,att);
            PutStr('FILE:',31,9,att);
            RemBlkR(36,9,50,9,att1,False);
            PutStr(filename,37,9,att1);
            ChooseMenu(41,42,1,att,att1,True,False,0,0,0);
            if EscDepressed then exit;
            if value=42 then begin
              goto GetNextFile;
            end; {if hit Esc or choose NO}
          end; {if not Expert Mode}

         if  not PrintedFile then begin
          {----------------------- Reset Printer -----------------------}
            with regs do begin
              AH := 1;        { Set AH to 1.                     }
              DX := 0;        { Set DL to indicate which printer.}
              Delay(800);     { Wait for prior functions to finish.       }
              Intr($17,regs); { Invoke interrupt hex 17.                  }
              Delay(1000);    { Wait for the printer to finish resetting. }
            end; {with regs do}
            PrintedFile:=True;

           SaveScreen(1);
            ClearBox(15,12,65,15,ErrAtt,3,False);
            PutStr('Align the paper to the top of the page',22,13,ErrAtt);
            PutStr('and Depress Any Key to Begin.',26,14,ErrAtt);
            ch1:=ReadKey;
            if ch1=NUL then ch1:=ReadKey;
           RestoreScreen(1);
         end; {Reset printer for first file printed}

         SaveScreen(1);
         ClearBox(25,12,55,17,att2,4,False);
         PutStr('Printing File',34,13,att2);
         PutStr('Lines Printed =      ',30,15,att2);

         s:=DriveNSub;
         l:=length(s);
         if copy(s,l,1)<>'\' then s:=s+'\';
         s:=s+filename;
         while pos(SPC,s)>0 do begin
           l:=pos(SPC,s);
           delete(s,l,1);
         end; {strip out spaces}
         writeln(lst,'File: ',s);
         writeln(lst,' ');
         Assign(PFile,s);
         Reset(PFile);
           PageCounter:=3;
           LineCounter:=0;
           while not eof(PFile) do begin
             readln(PFile,s1);
             inc(LineCounter);
             CheckPrinter;
             writeln(lst,s1);
             str(LineCounter:4,string1);
             PutStr(string1,46,15,15);

             inc(PageCounter);
             if PageCounter=62 then begin
               writeln(lst,chr(12));
               PageCounter:=1;
             end; {if end of page}
           end; {while not eof}
         Close(PFile);
         writeln(lst,chr(12));
         RestoreScreen(1);
         end; {if DirTag}

         if TagOrCurrent='C' then begin
           DirTag:=False;
           EscDepressed:=True;
           exit;
         end;

       GetNextFile:
        new_dir:=next_dir;
      end; {with new_dir do}
    until new_dir=nil;
   AllDone:
    DisposeFiles;
    GetFile(SourceString,ShortFile);
    GetFileNumber(NumOfFiles);
    TotalFilesTagged:=0;
    TaggedFilesSize:=0;
    Case LastSort of
         1: GoNameSortA;
         2: GoNameSortD;
         3: GoExtSortA;
         4: GoExtSortD;
         5: GoSizeSortA;
         6: GoSizeSortD;
         7: GoDateSortA;
         8: GoDateSortD;
      end; {Case Last Sort of}
  end; {GoPrint - Print ASCII files to LPT1}

{----------------------------------------------------------------------------}
Procedure GoFindDup;
  type
    Tree_Ptr  = ^Tree_List;
    Tree_List = Record
                  prev_limb       :Tree_Ptr;
                  branch          :String[50];
                  next_limb       :Tree_Ptr;
                End;

    File_Ptr  = ^File_List;
    File_List = Record
                  FileFoundName: String[13];
                  next_file    : File_Ptr;
                End;
  var
    first_branch,
    new_branch,
    last_branch          : Tree_Ptr;
    first_file,
    last_file,
    new_file             : File_Ptr;
    DteTme               : DateTime;
    att,
    att1,
    att2,
    ScreenPage,
    PrinterPage          : ShortInt;
    FDrive               : Char;
    SubFile              : Text;
    ScreenCounter,
    PrinterCounter,
    SubDirectoryCounter,
    TotalSubs            : ShortInt;
    SourceInfo,
    DestInfo             : SearchRec;
    s                    : String[80];
    s1                   : String[3];
    s2,
    s3,
    s4,
    s5                   : String[80];
    s10,
    s12,
    s13                  : String[12];
    Match,
    MatchFound,
    FirstMatch,
    TotalMatch,
    ToPrinter,
    ValidFile            : Boolean;

  Procedure NewPrinterPage(FF: Boolean);
    var
      i            : ShortInt;
      s            : String[75];
    begin
      if FF then writeln(lst,chr(12));
      for i:=5 to 6 do begin
        GetStr(s,4,i,73);
        writeln(lst,'    ',s);
      end;
      writeln(lst,' ');
      PrinterCounter:=4;
      inc(PrinterPage);
    end; {New Printer Page}



  Procedure NewScreenPage;
    var
      i       : ShortInt;
      s       : String[75];
    begin
      if ToPrinter then begin
        for i:=7 to 18 do begin
          GetStr(s,4,i,73);
          writeln(lst,'    ',s);
          inc(PrinterCounter);
          if PrinterCounter=63 then NewPrinterPage(True);
        end; {Read Data Off Screen and print to printer}
      end
      else begin
        PutStr('Page Full! Depress Any Key for Next Page.',20,25,143);
        for i:=1 to 5 do write(BELL);
        ch1:=ReadKey;
        if ch1=NUL then ch1:=ReadKey;
      end;
      ScreenCounter:=7;
      RemBlkR(1,25,80,25,15,False);
      inc(ScreenPage);
      RemBlkR(4,7,78,19,att,False);
    end; {new Screen Page}
 {=======================================================================}

  label DoMatch, DoOutput;

  begin
    ScreenCounter:=7;
    PrinterCounter:=3;
    ScreenPage:=1;
    PrinterPage:=1;
    first_file:=nil;
    if monitor=1 then begin
      att:=113;
      att1:=1;
      att2:=31;
    end
    else begin
      att:=7;
      att1:=7;
      att2:=112;
    end;

  DoMatch:
  {------------------------ Type of Match Section -----------------------}
    FillHeap(1,1,1,80,25,#32,15);
    FillHeap(1,1,3,80,21,SHADE,att2);
    FillHeap(1,16,8,61,15,SHADE1,att1);
    ClearBoxHeap(1,18,7,63,14,att,2);
    PutHeap(1,'Find Duplicate Matching Criteria',25,9,att);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Exit Find Duplicate',52,25,HelpBar);
    PutHeap(1,'Description:',1,23,15);
    RestoreScreen(1);

    ChooseMenu(43,44,1,att,att2,True,True,14,23,15);
    if EscDepressed then exit;
    if value=43 then TotalMatch:=True else TotalMatch:=False;

  DoOutPut:
  {------------------- Select type of OutPut ----------------------------}
    FillHeap(1,1,1,80,25,#32,15);
    FillHeap(1,1,3,80,21,SHADE,att);
    FillHeap(1,24,8,57,15,SHADE1,att1);
    ClearBoxHeap(1,26,7,59,14,att2,2);
    PutHeap(1,'Type of OutPut',36,9,att2);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Re-Do Match Type',55,25,HelpBar);
    RestoreScreen(1);

    ChooseMenu(45,46,1,att2,att,True,False,0,0,0);
    if EscDepressed then goto DoMatch;
    if value=45 then ToPrinter:=False else ToPrinter:=True;

  {-------------------- Select Drive ------------------------------------}
    FillHeap(1,1,1,80,25,#32,15);
    PutHeap(1,'EzDoss',37,1,15);
    FillHeap(1,1,3,80,21,SHADE,att);
    FillHeap(1,1,25,80,25,#32,HelpBar);
    PutHeap(1,'F1 - Help',4,25,HelpBar);
    PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
    PutHeap(1,'Esc - Re-Do Output',60,25,HelpBar);

    FillHeap(1,35,17,67,20,SHADE1,att1);
    ClearBoxHeap(1,37,16,69,19,att,3);
    PutHeap(1,'Enter the Source Drive for',40,17,att);
    PutHeap(1,'Locating Duplicating Files.',40,18,att);
    RestoreScreen(1);
    ChooseDrive(FDrive);
    if EscDepressed then goto DoOutPut;

    RemBlkR(1,25,80,25,15,False);
    PutStr('Searching for SubDirectories',27,24,143);
    FindSubdirectory(FDrive);
    RemBlkR(1,24,80,24,15,False);

  {------------------------- Clear Screen for search -------------------}
    Case monitor of
      1: begin
           att:=47;
           att1:=2;
         end; {1}
      2: begin
           att:=15;
           att1:=7;
         end; {2}
    end;
    FillHeap(1,1,1,80,25,#32,15);
    PutHeap(1,'EzDoss',37,1,15);
    FillHeap(1,1,3,80,22,SHADE,att);
    FillHeap(1,2,5,77,21,SHADE1,att1);
    ClearBoxHeap(1,3,4,79,20,att,1);
    PutHeap(1,'EzDoss - Find Duplicates',30,5,att);
    PutHeap(1,'Location & FileName',4,6,att);
    PutHeap(1,'Date',54,6,att);
    PutHeap(1,'Time',63,6,att);
    PutHeap(1,'Size',73,6,att);
    RestoreScreen(1);

  {------------------------ Start Search -------------------------------}
    if ToPrinter then begin
     {----------------------- Reset Printer -----------------------}
      with regs do begin
        AH := 1;        { Set AH to 1.                     }
        DX := 0;        { Set DL to indicate which printer.}
        Delay(800);     { Wait for prior functions to finish.       }
        Intr($17,regs); { Invoke interrupt hex 17.                  }
        Delay(1000);    { Wait for the printer to finish resetting. }
      end; {with regs do}

      SaveScreen(1);
      ClearBox(15,12,65,15,ErrAtt,3,False);
      PutStr('Align the paper to the top of the page',22,13,ErrAtt);
      PutStr('and Depress Any Key to Begin.',26,14,ErrAtt);
      ch1:=ReadKey;
      if ch1=NUL then ch1:=ReadKey;
      RestoreScreen(1);
      NewPrinterPage(False);
    end;
    TotalSubs:=0;
    first_branch:=nil;
    string1:=FDrive+'.ezd';
    Assign(SubFile,string1);
    Reset(SubFile);
      while not eof(SubFile) do begin
        readln(SubFile,string2);
        delete(string2,1,2);
        inc(TotalSubs);
        new(new_branch);                {Create record in Heap}
        new_branch^.branch:=string2;
        if first_branch=nil then begin
          first_branch:=new_branch;
          new_branch^.prev_limb:=nil;
        end
        else begin
          last_branch^.next_limb:=new_branch;
          new_branch^.prev_limb:=last_branch;
        end;

        last_branch:=new_branch;
        last_branch^.next_limb:=nil;
      end;
    Close(SubFile);

    s1:=FDrive+':';
    SubDirectoryCounter:=1;
    while SubDirectoryCounter<TotalSubs do begin
      new_branch:=first_branch;
      i:=1;
      while i<SubDirectoryCounter do begin
         with new_branch^ do
           new_branch:=next_limb;
         inc(i);
      end; {go through link list to source directory}
      s2:=s1+new_branch^.branch;

    {--------------- Make Message String ---------------------------}
     RemBlkR(1,24,80,24,15,False);
     s4:='Using SubDirectory '+s2+' as a base to search from';
     l:=length(s4);
     l:=80-l;
     l:=l div 2;
     PutStr(s4,l,24,15);

     MatchFound:=False;
    {--------------------- Make SearchString -------------------------}
      l:=length(s2);
      if copy(s2,l,1)<>'\' then s2:=s2+'\';
      s2:=s2+'*.*';
      FindFirst(s2,AnyFile,SourceInfo);
      while DosError<>18 do begin
        Case SourceInfo.Attr of
          Hidden,
          SysFile,
          VolumeID,
          Directory : ValidFile:=False;
          else
            ValidFile:=True;
        end; {Case if file attribute of}

        if (ValidFile) and (SubdirectoryCounter<>1) then begin
          new_file:=first_file;
          while new_file<>nil do begin
            with new_file^ do begin
              if FileFoundName=SourceInfo.Name then
                ValidFile:=False;
              new_file:=next_file;
            end;
          end; {Search through link list}
        end; {check to see if this file has been previously searched}

        if ValidFile then begin
          FirstMatch:=True;
          new_branch:=first_branch;
          i:=1;
          while i<SubDirectoryCounter+1 do begin
          with new_branch^ do
            new_branch:=next_limb;
          inc(i);
          end; {go through link list to next directory after source}
          repeat
            s3:=s1+new_branch^.branch;
            l:=length(s3);
            if copy(s3,l,1)<>'\' then s3:=s3+'\';
            s3:=s3+SourceInfo.Name;
            FindFirst(s3,AnyFile,DestInfo);
            if DosError<>18 then begin
              Match:=True;
              if TotalMatch then begin
                if SourceInfo.Time<>DestInfo.Time then Match:=False;
                if SourceInfo.Size<>DestInfo.Size then Match:=False;
              end;
              if Match then begin
                MatchFound:=True;
                if FirstMatch then begin
                  new(new_file);
                  new_file^.FileFoundName:=SourceInfo.Name;
                  if first_file=nil then
                    first_file:=new_file
                  else
                    last_file^.next_file:=new_file;
                  last_file:=new_file;
                  last_file^.next_file:=nil;

                  s5:=s2;
                  l:=pos('*.*',s5);
                  delete(s5,l,3);
                  s5:=s5+SourceInfo.Name;
                  UnPackTime(SourceInfo.Time,DteTme);
                 {------------------- Make Date String (s1) -----------------}
                  str(DteTme.month,s10);
                  if DteTme.month<10 then s10:='0'+s10+'/' else s10:=s10+'/';
                  str(DteTme.day,s12);
                  if DteTme.day<10 then s10:=s10+'0'+s12+'/' else s10:=s10+s12+'/';
                  str(DteTme.year-1900,s12);
                  s10:=s10+s12;

                 {----------------- Make Time String (s2) ---------------------}
                  str(DteTme.hour,s12);
                  if DteTme.hour<10 then s12:='0'+s12+':' else s12:=s12+':';
                  str(DteTme.min,s13);
                  if DteTme.min<10 then s12:=s12+'0'+s13+'.' else s12:=s12+s13+'.';
                  str(DteTme.sec,s13);
                  if DteTme.sec<10 then s12:=s12+'0'+s13 else s12:=s12+s13;

                  Str(SourceInfo.Size:7,s13);

                  PutStr(s5,4,ScreenCounter,att);
                  PutStr(s10,52,ScreenCounter,att);
                  PutStr(s12,62,ScreenCounter,att);
                  PutStr(s13,70,ScreenCounter,att);
                  inc(ScreenCounter);
                  if ScreenCounter=19 then NewScreenPage;
                  FirstMatch:=False;
                end; {if FirstMatch}
              {--------------------- List Matching File -----------------}
              UnPackTime(DestInfo.Time,DteTme);
             {------------------- Make Date String (s1) -----------------}
              str(DteTme.month,s10);
              if DteTme.month<10 then s10:='0'+s10+'/' else s10:=s10+'/';
              str(DteTme.day,s12);
              if DteTme.day<10 then s10:=s10+'0'+s12+'/' else s10:=s10+s12+'/';
              str(DteTme.year-1900,s12);
              s10:=s10+s12;

             {----------------- Make Time String (s2) ---------------------}
              str(DteTme.hour,s12);
              if DteTme.hour<10 then s12:='0'+s12+':' else s12:=s12+':';
              str(DteTme.min,s13);
              if DteTme.min<10 then s12:=s12+'0'+s13+'.' else s12:=s12+s13+'.';
              str(DteTme.sec,s13);
              if DteTme.sec<10 then s12:=s12+'0'+s13 else s12:=s12+s13;

                PutStr(s3,4,ScreenCounter,att);
                PutStr(s10,52,ScreenCounter,att);
                PutStr(s12,62,ScreenCounter,att);
                Str(DestInfo.Size:7,s13);
                PutStr(s13,70,ScreenCounter,att);
                inc(ScreenCounter);
                if ScreenCounter=19 then NewScreenPage;
              end; {if Match}
            end; {if DosError<>18}
            with new_branch^ do
              new_branch:=next_limb;
            inc(i);
          until i>TotalSubs;

        end; {if a valid file}
        if MatchFound then begin
          inc(ScreenCounter);
          if ScreenCounter=19 then NewScreenPage;
          MatchFound:=False;
        end;
        FindNext(SourceInfo);
      end; {while valid file}
      inc(SubDirectoryCounter);
    end; {while searching through subdirectories}
   {-------------- Reclaim Heap for Subdirectories ----------------}
     new_branch:=first_branch;
     while new_branch<>nil do begin
       with new_branch^ do last_branch:=next_limb;
       dispose(new_branch);
       new_branch:=last_branch;
     end;
   {-------------- Reclaime Heap from Files ------------------------}
     new_file:=first_file;
     while new_file<>nil do begin
       with new_file^do last_file:=next_file;
       dispose(new_file);
       new_file:=last_file;
     end;

     if (ToPrinter) and (ScreenPage<>PrinterPage) then begin
       for i:=7 to 18 do begin
       GetStr(s,4,i,73);
       writeln(lst,'    ',s);
       end;
       writeln(lst,chr(12));
     end;

     if not ToPrinter then begin
       for i:=1 to 5 do write(BELL);
       RemBlkR(1,24,80,25,15,False);
       PutStr('I am Finally Done!. Depress Any Key to Continue',17,23,15);
       ch1:=ReadKey;
       if ch1=NUL then ch1:=ReadKey;
     end;
  end; {GoFindDup - Find Duplicate files on given disk}


{----------------------------------------------------------------------------}

BEGIN
END.
