{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
UNIT Ez0;

INTERFACE

USES  CRT,
      DOS,
      PRINTER,
      POPSCRN,
      SCRNHEAP,
      MENU,
      GLOBALS,
      GETFILES;

{$V-}


Procedure ezd;
Procedure CheckPrinter;
Procedure GoLeft;
Procedure GoRight;
Procedure GoUp;
Procedure GoDown;
Procedure GoPageUp;
Procedure GoPageDown;
Procedure GoEnd;
Procedure GoHome;

IMPLEMENTATION


{---------------------------------------------------------------------------}
{$L ez.obj}
Procedure ezd; external;

{---------------------------------------------------------------------------}
 Procedure CheckPrinter;
    var
      PrinterOk                   : Boolean;
      i,
      l,
      x,
      num,
      PrinterStatus               : Integer;

      regs                        : Registers;

    Label CheckPrinter;

    begin

     CheckPrinter:

        with regs do begin
          AH := 2;                   { Set AH to 2.                      }
          DX := 0;                   { Set DX to indicate which printer. }
          Intr($17,regs);            { Invoke interrupt hex 17.          }
          PrinterStatus := AH;
        end;

      {---------------------- Check to See if Out of Paper -------------------}
        if (32 and PrinterStatus)<>0 then begin
          SaveScreen(1);

          ClearBox(25,8,56,16,ErrAtt,2,False);
          PutStr('Printer is out of Paper!',29,10,att);
          PutStr('Insert Paper',35,12,att);
          PutStr('and',39,13,att);
          PutStr('Depress Any Key to Retry',29,14,att);
          for i:=1 to 5 do begin
            write(BELL); delay(50);
          end; {for i=1 to 5}
          ch1:=ReadKey;
          if ch1=NUL then ch1:=ReadKey;
          RestoreScreen(1);
          goto CheckPrinter;
        end;

      {------------------------ Check to See if Online -----------------------}
        if (8 and PrinterStatus)<>0 then begin
          SaveScreen(1);
          ClearBox(25,8,56,16,ErrAtt,2,False);
          PutStr('Printer is Offline!',31,10,att);
          PutStr('Put Online',36,12,att);
          PutStr('and',39,13,att);
          PutStr('Depress Any Key to Retry',29,14,att);
          for i:=1 to 5 do begin
            write(BELL); delay(50);
          end; {for i=1 to 5}
          ch1:=ReadKey;
          if ch1=NUL then ch1:=ReadKey;
          RestoreScreen(1);
          goto CheckPrinter;
        end;
    end; {Check Printer}

{-------------------------------------------------------------------------}
Procedure GoLeft;         {Move cursor one file left}
  begin
    if ShortFile then begin
      i:=new_dir^.x;
      case i of
         6: begin
              GetStr(string1,20,new_dir^.y,1);
              if string1=SPC then
                write(BELL)
              else begin
                with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesMain);
                GetStr(string1,20,new_dir^.y,1);
                if string1<>SPC then k:=10;
                GetStr(string1,35,new_dir^.y,1);
                if string1<>SPC then k:=20;
                GetStr(string1,49,new_dir^.y,1);
                if string1<>SPC then k:=30;
                GetStr(string1,63,new_dir^.y,1);
                if string1<>SPC then k:=40;
                for j:=1 to k do begin
                  with new_dir^ do
                    new_dir:=next_dir;
                end;
                with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesHigh);
              end;
            end;  {first column}
        20,
        35,
        49,
        63: begin
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesMain);
              for j:=1 to 10 do begin
                with new_dir^ do
                  new_dir:=prev_dir;
              end;
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesHigh);
            end;
      end; {Case i of}
    end {if Short File}
    else
      write(BELL);
  end; {Go Left - Move cursor left one file}

{--------------------------------------------------------------------------}
Procedure GoRight;         {Move highlight bar to the right}
  begin
    if ShortFile then begin
      i:=new_dir^.x;
      case i of
         6: begin
              GetStr(string1,20,new_dir^.y,1);
              if string1<>SPC then begin
                with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesMain);
                for j:=1 to 10 do begin
                  with new_dir^ do
                  new_dir:=next_dir;
                end;
                with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesHigh);
              end
              else
                write(BELL);
            end; {6}
        20: begin
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesMain);
              GetStr(string1,35,new_dir^.y,1);
              if string1<>SPC then begin
                for j:=1 to 10 do begin
                  with new_dir^ do
                    new_dir:=next_dir;
                end;
              end
              else begin
                with new_dir^ do begin
                  SetAtt(x,y,x+fofs,y,FilesMain);
                  j:=y;
                end;
                new_dir:=first_dir;
                while(new_dir^.y<>j) do begin
                  with new_dir^ do
                     new_dir:=next_dir;
                end;
              end; {if nothing to the right}
              with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesHigh);
            end; {20}
        35: begin
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesMain);
              GetStr(string1,49,new_dir^.y,1);
              if string1<>SPC then begin
                for j:=1 to 10 do begin
                  with new_dir^ do
                    new_dir:=next_dir;
                end;
              end
              else begin
                with new_dir^ do begin
                  SetAtt(x,y,x+fofs,y,FilesMain);
                  j:=y;
                end;
                new_dir:=first_dir;
                while(new_dir^.y<>j) do begin
                  with new_dir^ do
                     new_dir:=next_dir;
                end;
              end; {if nothing to the right}
              with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesHigh);
            end; {35}
        49: begin
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesMain);
              GetStr(string1,63,new_dir^.y,1);
              if string1<>SPC then begin
                for j:=1 to 10 do begin
                  with new_dir^ do
                    new_dir:=next_dir;
                end;
              end
              else begin
                with new_dir^ do begin
                  SetAtt(x,y,x+fofs,y,FilesMain);
                  j:=y;
                end;
                new_dir:=first_dir;
                while(new_dir^.y<>j) do begin
                  with new_dir^ do
                     new_dir:=next_dir;
                end;
              end; {if nothing to the right}
              with new_dir^ do
                  SetAtt(x,y,x+fofs,y,FilesHigh);
            end; {49}
        63: begin
              with new_dir^ do begin
                SetAtt(x,y,x+fofs,y,FilesMain);
                j:=y;
              end;
              new_dir:=first_dir;
              while(new_dir^.y<>j) do begin
                with new_dir^ do
                   new_dir:=next_dir;
              end;
              with new_dir^ do
                SetAtt(x,y,x+fofs,y,FilesHigh);
            end;
      end; {Case i of}
    end {if Short File}
    else
      write(BELL);
  end; {Move Cursor right one file}

{---------------------------------------------------------------------------}
Procedure GoUp;
  begin
    with new_dir^ do
      SetAtt(x,y,x+fofs,y,FilesMain);
    with new_dir^ do begin
    if (x=firstx) and (y=firsty) then
      new_dir:=ptr1
    else
      new_dir:=prev_dir;
    end;
    with new_dir^ do SetAtt(x,y,x+fofs,y,FilesHigh);
  end; {GoUp - Move cursor one file up}

{---------------------------------------------------------------------------}
Procedure GoDown;
  begin
    with new_dir^ do
      SetAtt(x,y,x+fofs,y,FilesMain);
    with new_dir^ do begin
      if (x=ptr1^.x) and (y=ptr1^.y) then
        new_dir:=ptr
      else
        new_dir:=next_dir;
    end;
    with new_dir^ do SetAtt(x,y,x+fofs,y,FilesHigh);
  end; {GoDown - Move cursor on file donw}

{---------------------------------------------------------------------------}
Procedure GoPageUp;
  begin
    if PageNumber=1 then
      write(BELL)
    else begin
      j:=PageNumber-1;
      new_dir:=first_dir;
      if j<>1 then begin
        while (new_dir^.DirPage<>j) do begin
          with new_dir^ do new_dir:=next_dir;
        end; {read until pagenumber}
      end;
      ptr:=new_dir;
      FillHeap(2,1,1,80,25,#32,FilesMain);
      repeat
        with new_dir^do begin
          if ShortFile then
            PutHeap(2,filename,x,y,FilesMain)
          else begin
            str(FileSize,string2);
            PutHeap(2,filename,x,y,FilesMain);
            PutHeap(2,FileSDate,33,y,FilesMain);
            PutHeap(2,FileSTime,45,y,FilesMain);
            PutHeap(2,FileSSize,57,y,FilesMain);
          end;
           if DirTag then PutHeap(2,TAG,x-1,y,TagAtt);
          ptr1:=new_dir;
          new_dir:=next_dir;
           if new_dir<>nil then begin
            with new_dir^do begin
              PageNumber:=DirPage;
              ptr1:=prev_dir;
            end;
          end; {if new dir <> nil}
        end;
      until (new_dir^.DirPage<>j) or (new_dir=nil);
      PageNumber:=j;
      str(PageNumber,string1);
      if PageNumber<10 then string1:=' '+string1;
      PutStr(string1,13,16,FilesMain);
      if ShortFile then
        Heap2Scr(2,5,6,75,15,5,6)
      else
        Heap2Scr(2,16,7,70,15,16,7);
      new_dir:=ptr;
      with new_dir^ do
        SetAtt(x,y,x+fofs,y,FilesHigh);
    end; {if PageNumber<>1}
  end; {GoPageUp - Displays previous page of files}

{--------------------------------------------------------------------------}
Procedure GoPageDown;
  begin
    if PageNumber=TotalPages then
      write(BELL)
    else begin
      j:=PageNumber+1;
      new_dir:=first_dir;
      while (new_dir^.DirPage<>j) do begin
        with new_dir^ do new_dir:=next_dir;
      end; {read until pagenumber}
      ptr:=new_dir;
      FillHeap(2,1,1,80,25,#32,FilesMain);
      repeat
        with new_dir^do begin
          if ShortFile then
            PutHeap(2,filename,x,y,FilesMain)
          else begin
            str(FileSize,string2);
            PutHeap(2,filename,x,y,FilesMain);
            PutHeap(2,FileSDate,33,y,FilesMain);
            PutHeap(2,FileSTime,45,y,FilesMain);
            PutHeap(2,FileSSize,57,y,FilesMain);
          end;
            if DirTag then PutHeap(2,TAG,x-1,y,TagAtt);
           ptr1:=new_dir;
           new_dir:=next_dir;
            if new_dir<>nil then begin
             with new_dir^do begin
               PageNumber:=DirPage;
               ptr1:=prev_dir;
             end;
           end; {if new dir <> nil}
        end;
      until (new_dir^.DirPage<>j) or (new_dir=nil);
      PageNumber:=j;
      str(PageNumber,string1);
      if PageNumber<10 then string1:=' '+string1;
      PutStr(string1,13,16,FilesMain);
      if ShortFile then
        Heap2Scr(2,5,6,75,15,5,6)
      else
        Heap2Scr(2,16,7,70,15,16,7);
      new_dir:=ptr;
      with new_dir^ do
        SetAtt(x,y,x+fofs,y,FilesHigh);
    end; {if PageNumber<>TotalPages}
  end; {GoPageDown - Displays next page of files}

{---------------------------------------------------------------------------}
Procedure GoEnd;
 begin
   with new_dir^ do SetAtt(x,y,x+fofs,y,FilesMain);
   with ptr1^do
     SetAtt(x,y,x+fofs,y,FilesHigh);
   new_dir:=ptr1;
 end; {GoEnd - Move cursor to last file on page}
{---------------------------------------------------------------------------}
Procedure GoHome;
  begin
    with new_dir^ do SetAtt(x,y,x+fofs,y,FilesMain);
    with ptr^do
      SetAtt(x,y,x+fofs,y,FilesHigh);
    new_dir:=ptr;
  end; {GoHome - Move cursor to first file on page}

{-------------------------------------------------------------------------}

BEGIN
END.
