{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
EZDoss (version 2.0) by John Bean is a DOS "shell" that makes it easy for a
computer novice or a non-expert typist to execute DOS commands. A command
can be selected from a menu, rather than having to type it. Written in Turbo
Pascal 4.0. NOTE:this program requires the BINED.TPU from the Turbo Pascal
Editor Toolbox (version 4.0) to compile it.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
Program EzDoss;       {Version 2.0}
{$M 20480,2816,655360}

USES  {OVERMGR,}         {This is from Turbo Power Overlay Manager}
      BINED,
      CRT,
      DOS,
      PRINTER,
      POPSCRN,
      SCRNHEAP,
      MENU,
      GLOBALS,
      GETSUB,
      GETFILES,
      EZ0,
      EZ1,
      EZ2,
      EZ3,
      EZINVOKE;


{$V-}


Label EnterSourceDrive, GetSourceFiles, MainEngine, DoMenu;
Label GetSourceSubdirectory;



BEGIN
  bf(0,15);
  CursorOff;
  ClrScr;
  IHP;
  SetMenuOptions;
  Initialize;
  IntroScreen;
  if LocateSelected then GoLocate;
  if FindDupSelected then GoFindDup;

 {------------------ Select Source Drive -------------------------}
  if monitor=1 then begin
    att:=63;
    att1:=3;
  end
  else begin
    att:=7;
    att1:=7;
  end;

EnterSourceDrive:
  ReDoSourceDrive:=False;
  FillHeap(1,1,1,80,25,#32,15);
  PutHeap(1,'EzDoss',37,1,15);
  FillHeap(1,1,3,80,22,SHADE,att);
  FillHeap(1,1,25,80,25,#32,HelpBar);
  PutHeap(1,'F1 - Help',4,25,HelpBar);
  PutHeap(1,'F2 - Quick Keys',30,25,HelpBar);
  PutHeap(1,'Esc - Exit EzDoss',61,25,HelpBar);

  if Sd=NUL then begin
    FillHeap(1,32,17,59,21,SHADE1,att1);
    ClearBoxHeap(1,34,16,61,20,att,3);
    PutHeap(1,'Enter the Source Drive',37,18,att);
    RestoreScreen(1);
    ChooseDrive(Drive);
    if EscDepressed then GoodBye;
  end
  else begin
    EscDepressed:=False;
    RestoreScreen(1);
    Drive:=Sd;
    Sd:=NUL;
  end;

 GetSourceSubdirectory:
  RemBlkR(30,25,55,25,HelpBar,False);
  ClearBox(34,16,65,20,att,3,True);
  PutStr('Enter the Source Directory',37,18,att);
  PutStr('Esc - Re-enter Drive',58,25,HelpBar);
  ChooseSubdirectory(Drive,DriveNSub,35,5,SrceMain,SrceHigh,HelpAtt);
  if EscDepressed then begin
    Sd:=NUL;
    goto EnterSourceDrive;
  end;

  l:=length(DriveNSub);
  if copy(DriveNSub,l,1)='\' then
    SourceString:=DriveNSub+'*.*'
  else
    SourceString:=DriveNSub+'\*.*';

 GetSourceFiles:
  SaveScreen(5);
  GetFile(SourceString,ShortFile);
  if first_dir=nil then begin
    RestoreScreen(5);
    ClearBox(15,6,65,13,ErrAtt,2,False);
    PutStr('NO FILES IN THIS DIRECTORY!',27,8,ErrAtt);
    PutStr('Depress Esc to EXIT',30,9,ErrAtt);
    PutStr('or',39,10,ErrAtt);
    PutStr('Any Other Key to Re-enter Source Drive',21,11,ErrAtt);
    ch1:=ReadKey;
    if ch1=ESC then
      GoodBye
    else begin
      if ch1=NUL then ch1:=ReadKey;
      Sd:=NUL;
      goto EnterSourceDrive;
    end;
  end; {if no files found}
  GetFileNumber(NumOfFiles);
  ASort('N');
  ReshuffleFiles;
  PageNumber:=1;
  LastSort:=1;
  TotalFilesTagged:=0;
  TaggedFilesSize:=0;

 DisplayFirstPage;  {Display first page of files}

{-----------------------------------------------------------------------}
 {  General Tagging Routine.  Main Engine of the Program                }
 MainEngine:
   InMainMenu:=False;
   EscDepressed:=False;
  {------------------ See if Any Files are in Directory -------------}

   ch:=ReadKey;
   if ch=NUL then begin            {Must be Function,Arrow,Alt Key}
     ch:=ReadKey;
     Case ch of
       UPARROW: GoUp;
       DNARROW: GoDown;
       LTARROW: GoLeft;
       RTARROW: GoRight;
       END_KEY: GoEnd;
           HME: GoHome;
          PGUP: GoPageUp;
          PGDN: GoPageDown;
            F1: begin
                  SaveScreen(1);
                  Case monitor of
                    1: PoPObjLib(@ezd,'ezdhelpc',true,true);
                    2: PoPObjLib(@ezd,'ezdhelpm',true,true);
                  end; {Case monitor of}
                  ch1:=ReadKey;
                  RestoreScreen(1);
                end; {Help Screen}
            F2: begin
                  SaveScreen(1);
                  Case monitor of
                    1: PoPObjLib(@ezd,'ezdqkc',true,true);
                    2: PoPObjLib(@ezd,'ezdqkm',true,true);
                  end; {Case monitor of}
                  ch1:=ReadKey;
                  RestoreScreen(1);
                end; {Quick Keys}
            F3: begin
                  SaveScreen(5);
                  TaggedFilesSize:=0;
                  TotalFilesTagged:=0;
                  new_dir:=first_dir;
                  while new_dir<>nil do begin
                    new_dir^.DirTag:=True;
                    inc(TotalFilesTagged);
                    TaggedFilesSize:=TaggedFilesSize+new_dir^.FileSize;
                    new_dir:=new_dir^.next_dir;
                  end; {while new_dir<>nil}
                  PageNumber:=1;
                  DisplayFirstPage;
                end;
            F4: begin
                  SaveScreen(5);
                  TotalFilesTagged:=0;
                  TaggedFilesSize:=0;
                  new_dir:=first_dir;
                  while new_dir<>nil do begin
                    new_dir^.DirTag:=False;
                    new_dir:=new_dir^.next_dir;
                  end; {while new_dir<>nil}
                  PageNumber:=1;
                  DisplayFirstPage;
                end;
            F5: begin
                  RemBlkR(1,25,80,25,HelpBar,False);
                  PutStr('Sorting by Name - Ascending',26,25,HelpBar+128);
                  GoNameSortA;   {Sort by Name - Ascending}
                end;
         ALTF5: GoNameSortD;   {Sort by Name - Descending}
            F6: GoExtSortA;
         ALTF6: GoExtSortD;
            F7: GoSizeSortA;
         ALTF7: GoSizeSortD;
            F8: GoDateSortA;
         ALTF8: GoDateSortD;
            F9: begin
                  if ShortFile then begin
                    ShortFile:=False;
                    fofs:=45;
                    firstx:=17;
                    lastx:=17;
                    firsty:=7;
                  end
                  else begin
                    ShortFile:=True;
                    fofs:=11;
                    firstx:=6;
                    lastx:=63;
                    firsty:=6;
                  end;
                  ReshuffleFiles;
                  PageNumber:=1;
                  DisplayFirstPage;
                end; {Toggle File Display Type}
           F10: begin
                  DisposeFiles;
                  goto EnterSourceDrive;
                end; {New Drive}
        ALTF10: begin
                  DisposeFiles;
                  FillHeap(1,1,1,80,25,#32,15);
                  PutHeap(1,'EzDoss',37,1,15);
                  FillHeap(1,1,3,80,22,SHADE,att);
                  FillHeap(1,1,25,80,25,#32,HelpBar);
                  PutHeap(1,'F1 - Help',4,25,HelpBar);
                  PutHeap(1,'Esc - Exit EzDoss',61,25,HelpBar);
                  RestoreScreen(1);
                  FromAltF10:=True;
                  goto GetSourceSubdirectory;
                end; {New Subdirectory Same Drive}
          ALTC: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoCopy('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                end; {Copy Highlighted File}
          ALTD: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoDelete('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                  if ReDoSourceDrive then goto EnterSourceDrive;
                end; {Delete Highlighted File}
          ALTF: begin
                  SaveScreen(5);
                    x:=ord(SourceString[1]);
                    x:=x-64;
                    str(DiskFree(x),string2);
                    string2:=string2+' Bytes';
                    l:=length(string2);
                    l:=l div 2;
                    i:=40-l;
                    if DiskFree(x)>1024 then
                      ClearBox(20,6,60,13,FreeAtt,2,True)
                    else
                      ClearBox(20,6,60,12,FreeAtt,2,True);
                    PutStr('Free Disk Space on Drive '+SourceString[1],
                            27,7,FreeAtt);
                    PutStr(string2,i,9,FreeAtt);
                    if DiskFree(x)>1024 then begin
                      str(DiskFree(x) div 1024,string2);
                      string2:=string2+' KBytes';
                      l:=length(string2);
                      l:=l div 2;
                      i:=40-l;
                      PutStr(string2,i,10,FreeAtt);
                      PutStr(' Depress Any Key to Continue ',26,12,15);
                    end {if DiskMemLeft is > 1 KB}
                    else
                      PutStr(' Depress Any Key to Continue ',26,11,15);
                    ch1:=ReadKey;
                    if ch1=NUL then ch1:=ReadKey;
                  RestoreScreen(5);
                end; {Display Free Disk Space}
          ALTM: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoMove('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                  if ReDoSourceDrive then goto EnterSourceDrive;
                end; {Move Highlighted File}
          ALTR: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoRename('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                end; {Rename Highlighted File}
          ALTV: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoView('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                end; {View Highlighted File}
          ALTN: begin
                  tp:=new_dir;
                  SaveScreen(5);
                  GoPrint('C');
                  if EscDepressed then begin
                     new_dir:=tp;
                     RestoreScreen(5);
                  end;
                end; {Print highlighted file}
          ALTO: begin
                  tp:=new_dir;
                  SaveScreen(1);
                  CursorOn;
                  InvokeDos;
                  CursorOff;
                  RestoreScreen(1);
                  new_dir:=tp;
                end;
     end; {Case ch of}
   end  {If function,arrow,Alt key Depressed}
   else begin
     ch:=UpCase(ch);
     Case ch of
       ESC: begin
              GoodBye;
            end; {Exit EzDos}
       '/': begin
              SaveScreen(5);
             DoMenu:
              InMainMenu:=True;
              EscDepressed:=False;
              Case monitor of
                1: begin
                     PoPObjLib(@ezd,'ezdmenuc',true,true);
                     PoPObjLib(@ezd,'hbmmc',true,true);
                   end;
                2: begin
                     PoPObjLib(@ezd,'ezdmenum',true,true);
                     PoPObjLib(@ezd,'hbmmm',true,true);
                   end;
              end; {Case monitor of}
              ChooseMenu(27,33,1,MainMenuAtt,MainMenuHigh,
                         True,True,8,21,MainMenuDscpt);
              if EscDepressed then begin
                EscDepressed:=False;
                RestoreScreen(5);
                goto MainEngine;
              end;
              Case monitor of
                1: PoPObjLib(@ezd,'hb2mmc',true,true);
                2: PoPObjLib(@ezd,'hb2mmm',true,true);
              end; {Case monitor of}
              Case value of
                27: begin   {File}
                      RemBlkR(8,21,72,21,MainMenuAtt,False);
                      ChooseMenu(34,37,1,MainMenuAtt,MainMenuHigh,
                                 True,True,8,21,MainMenuDscpt);
                      if EscDepressed then begin
                        EscDepressed:=False;
                        goto DoMenu;
                      end;
                      Case value of
                        34: begin
                              tp:=new_dir;
                              GoCopy('T');
                              if EscDepressed then begin
                                 new_dir:=tp;
                                 goto DoMenu;
                              end;
                            end; {34}
                        35: begin
                              tp:=new_dir;
                              GoDelete('T');
                              if EscDepressed then begin
                                 new_dir:=tp;
                                 goto DoMenu;
                              end;
                              if ReDoSourceDrive then goto EnterSourceDrive;
                            end; {35}
                        36: begin
                              tp:=new_dir;
                              GoMove('T');
                              if EscDepressed then begin
                                 new_dir:=tp;
                                 goto DoMenu;
                              end;
                              if ReDoSourceDrive then goto EnterSourceDrive;
                            end; {36}
                        37: begin
                              tp:=new_dir;
                              GoRename('T');
                              if EscDepressed then begin
                                 new_dir:=tp;
                                 RestoreScreen(5);
                                 goto DoMenu;
                              end;
                            end; {37}
                      end; {Choices of Copy,Delete,Move,Rename}
                    end; {File}
                28: begin  {Tag}
                      tp:=new_dir;
                      RemBlkR(8,21,72,21,MainMenuAtt,False);
                      ChooseMenu(38,40,1,MainMenuAtt,MainMenuHigh,
                                 True,True,8,21,MainMenuDscpt);
                      if EscDepressed then begin
                        new_dir:=tp;
                        EscDepressed:=False;
                        goto DoMenu;
                      end;
                      Case value of
                        38: begin
                              SaveScreen(5);
                              TaggedFilesSize:=0;
                              TotalFilesTagged:=0;

                              new_dir:=first_dir;
                              while new_dir<>nil do begin
                                new_dir^.DirTag:=True;
                                inc(TotalFilesTagged);
                                TaggedFilesSize:=TaggedFilesSize+new_dir^.FileSize;
                                new_dir:=new_dir^.next_dir;
                              end; {while new_dir<>nil}
                              PageNumber:=1;
                              DisplayFirstPage;
                            end; {Tag All}
                        39: begin
                               SaveScreen(5);
                               TotalFilesTagged:=0;
                               TaggedFilesSize:=0;
                               new_dir:=first_dir;
                               while new_dir<>nil do begin
                                 new_dir^.DirTag:=False;
                                 new_dir:=new_dir^.next_dir;
                               end; {while new_dir<>nil}
                               PageNumber:=1;
                               DisplayFirstPage;
                            end; {Untag All}
                        40: begin
                              tp:=new_dir;
                              FromMenu:=True;
                              GoPattern;
                              FromMenu:=False;
                              if EscDepressed then begin
                                new_dir:=tp;
                                goto DoMenu;
                              end;
                            end; {Pattern}
                      end; {Choices of TagAll, UntagAll, Pattern}
                    end; {Tag}
                29: begin     {Mask}
                      tp:=new_dir;
                      FromMenu:=True;
                      GoMask;
                      FromMenu:=False;
                      if EscDepressed then begin
                        new_dir:=tp;
                        goto DoMenu;
                      end;
                    end; {Mask}
                30: begin
                      GoLocate;
                      RestoreScreen(5);
                      goto DoMenu;
                    end; {Locate}
                31: begin  {view}
                      tp:=new_dir;
                      FromMenu:=True;
                      GoView('T');
                      FromMenu:=False;
                      if EscDepressed then begin
                        new_dir:=tp;
                        RestoreScreen(5);
                        goto DoMenu;
                      end; {if EscDepressed}
                    end;
                32: begin  {print}
                      tp:=new_dir;
                      FromMenu:=True;
                      GoPrint('T');
                      FromMenu:=False;
                      if EscDepressed then begin
                        new_dir:=tp;
                        RestoreScreen(5);
                        goto DoMenu;
                      end; {if EscDepressed}
                    end;
                33: begin
                      GoFindDup;
                      RestoreScreen(5);
                      goto DoMenu;
                    end; {FindDup}
              end; {Case menu choice of}

            end; {Invoke Menu}
       SPC: GoDown;
       'E': GoExpand;
       'F': begin
              SaveScreen(5);
              GoFindDup;
              RestoreScreen(5);
            end; {Find Duplicates}
       'T': begin
              with new_dir^ do begin
                if not DirTag then begin
                  DirTag:=True;
                  PutStr(TAG,x-1,y,TagAtt);
                  TotalFilesTagged:=TotalFilesTagged+1;
                  str(TotalFilesTagged,string1);
                  RemBlkR(34,21,37,21,StatusAtt,False);
                  PutStr(string1,34,21,StatusAtt);
                  TaggedFilesSize:=TaggedFilesSize+FileSize;
                  str(TaggedFilesSize,string1);
                  RemBlkR(61,21,70,21,StatusAtt,False);
                  PutStr(string1,61,21,StatusAtt);
                end
                else
                  write(BELL);
                end; {with new_dir}
            end; {Tag Highlighted File}
       'U': begin
              with new_dir^ do begin
                if DirTag then begin
                  DirTag:=False;
                  PutStr(' ',x-1,y,FilesMain);
                  TotalFilesTagged:=TotalFilesTagged-1;
                  str(TotalFilesTagged,string1);
                  RemBlkR(34,21,37,21,StatusAtt,False);
                  PutStr(string1,34,21,StatusAtt);
                  TaggedFilesSize:=TaggedFilesSize-FileSize;
                  str(TaggedFilesSize,string1);
                  RemBlkR(61,21,70,21,StatusAtt,False);
                  PutStr(string1,61,21,StatusAtt);
                end {if Dir Tag}
                else
                  write(BELL);
              end; {with new_dir}
            end; {GoUntag - Untag highlighted file}
       'C': begin
              tp:=new_dir;
              SaveScreen(5);
              GoCopy('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
            end; {Copy}
       'D': begin
              tp:=new_dir;
              SaveScreen(5);
              GoDelete('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
              if ReDoSourceDrive then goto EnterSourceDrive;
            end; {Delete}
       'M': begin
              tp:=new_dir;
              SaveScreen(5);
              GoMove('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
              if ReDoSourceDrive then goto EnterSourceDrive;
            end; {Move}
       'K': GoMask;
       'V': begin
              tp:=new_dir;
              SaveScreen(5);
              GoView('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
            end; {View File}
       'P': GoPattern;
       'L': begin
              SaveScreen(5);
              GoLocate;
              RestoreScreen(5);
            end; {Locate}
       'R': begin
              tp:=new_dir;
              SaveScreen(5);
              GoRename('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
            end; {Rename}
       'N': begin
              tp:=new_dir;
              SaveScreen(5);
              GoPrint('T');
              if EscDepressed then begin
                new_dir:=tp;
                RestoreScreen(5);
              end;
            end; {Print File}
       'X': begin
              if ExpertMode then begin
                ExpertMode:=False;
                string1:='Off';
              end
              else begin
                ExpertMode:=True;
                string1:='On ';
              end;
              PutStr(string1,61,20,StatusAtt);
            end; {Toggle ExpertMode}
     end; {Case ch of}
   end; {Not a Function Key or Arrow, Alt Key}
   goto MainEngine;

END.


