Program BoxSpeed;

{ A benchmark of Boosters' BOX procedure.

  Box size    Time (sec)*
  --------    ----------
   2x2            5    (min box size)
  40x25          13    (half-screen)
  80x25          17    (max box size)

  *Times are averages using a stopwatch,
   run on a Compaq portable with 8088 cpu }

Uses crt,BOSHARE;
var
   i : word;
   c : char;
   s,t : string;

{ ------------------ }
{ Signal end of loop }
{ ------------------ }
Procedure Speak;
var
   i,j : word;
begin
   for i := 1 to 84 do begin
      sound(900+(i-1)*60);
      delay(02);
   end;
   NoSound;
   delay(100);
   for i := 1 to 20 do begin
      for j := 1 to 8 do begin
         sound(6500-(j-1)*600);
         delay(01);
      end;
      for j := 8 downto 1 do begin
         sound(6500-(j-1)*600);
         delay(01);
      end;
   end;
   NoSound;
   sound(25);
   delay(400);
   NoSound;
end;

{ ------------------------- }
{ Get a key, halt if ESCAPE }
{ ------------------------- }
Procedure GetKey;
begin
   c := readkey;
   if c = #27 then halt;
end;

BEGIN

   s := 'Press a key to start';
   t := ' DONE - press a key ';

{---  Min screen size  ---}
   clrscr;
   box (2,2,4,4,1,7);
   ctrscr ('e',' 10,000 iterations ',40,1,1,14 );
   ctrscr ('e',s,40,1,13,30 );
   GetKey;

   for i := 1 to 10000 do
      box ( 2,2,4,4,1,7 );

   ctrscr ( 'e', t,40,1,13,14 );
   Speak;
   GetKey;

{---  Half screen size  ---}
   clrscr;
   box (1,1,40,25,1,7);
   ctrscr ('e',' 10,000 iterations ',40,1,1,14 );
   ctrscr ('e',s,40,1,13,30 );
   GetKey;

   for i := 1 to 10000 do
      box ( 1,1,40,25,1,7 );

   ctrscr ( 'e', t,40,1,13,14 );
   Speak;
   GetKey;

{---  Max screen size  ---}
   clrscr;
   box (1,1,80,25,1,7);
   ctrscr ('e',' 10,000 iterations ',80,1,1,14 );
   ctrscr ('e',s,80,1,13,30 );
   GetKey;

   for i := 1 to 10000 do
      box ( 1,1,80,25,1,7 );

   ctrscr ( 'e', t,80,1,13,14 );
   Speak;

END.