/* splwin.hpp: a class for displaying individual spells

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class spellwindow {
public:
    // handles for all relevant windows 
    HWND hwnd;  // main window
    HWND hwndmle;   // entry field
    HWND hwndframe;  // frame window

    // double linked list
    spellwindow *next;
    spellwindow *prev;

    // default is readonly; can be edited.
    boolean readonly;

    // one spelllist associated with the window:
    spelllist *sl;

    // the window that the spelllist is in, if any.
    bookwindow *parent;

    void load_attr(); // load the above from INI or EA
    void save_attr(); // save these to INI or EA
    
    spellwindow(spelllist *spll=NULL, bookwindow *p=NULL);
    ~spellwindow();
};

// attributes saved with each window, in EA or INI
class spell_attr {
  public:
    SHORT x, cx, y, cy;
    ULONG foregroundcolor, backgroundcolor;
    char fontnamesize[128];
};

#define splclass "Spellwindow"

// client window procedure
MRESULT EXPENTRY spell_window_func(HWND hwnd, ULONG msg, 
				   MPARAM param1, MPARAM param2);

