/* spl.cpp:  Spellbook control program

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Changes-

 1.73 - 7/26/94 - fixed nasty memory allocation bugs
 1.72 - 7/24/94 - fixed saving bugs
 1.71 - 7/13/94 - can load several books simultaneously
 1.7 - 5/15/94 - user can sort books by several methods
 1.6 - 5/14/94 - user can select which details fields to show
 1.5 - 4/16/94 - added working on-line help
 1.41 - 3/22/94 - added quick saving/loading of master list
 1.4 - 3/15/94 - change container view via menu/popup
 1.3 - 2/28/94 - multithreaded spell filtering, saves window positions
   in EA's, saves default positions for new, master windows.
 1.2 - 2/24/94 - multithreaded book windows
 1.1 - 2/17/94 - modularized; added .ini file for master window pos.
 1.02 - 10/12/93 - don't load full spell description at startup
 1.01 - 10/1/93 - added some error checking
 1.00 - 8/25/93 - original version
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "spl.hpp"
#include "general.hpp"
#include "spldlg.h"
#include "bookwin.hpp"
#include "splwin.hpp"
#include "spldlgs.hpp"
#include "splhelp.hpp"
#include <stdarg.h>

// stuff of interest in several modules
HAB hab;  // anchor block 
HINI hini; // handle to ini
BYTE xfer_buffer[10240];
HPOINTER dragicon; // icon for dragging spells
int windows=1000;  // used for creating new client windows
spellbook *masterlist=NULL;
HEV sem_object_started;
HEV sem_master_loading;
HWND hwndhelp;
HWND hwndspellhelp;

// stuff that's defined in other modules
extern bookwindow *first;
extern spellwindow *firstspell;

// some file names
char icon_file_name[256];
char changed_file_name[256];
char master_name[256];
char quick_master_name[256];

// table of icons for various schools and spheres.
int icons;
HPOINTER *icontable;
char **icontext;

// set up the icon table and the drag icon.
void setupicons() {
    FILE *infile;
    char buffer[256];
    int i,j,k;

    dragicon=WinLoadFileIcon((PSZ)"spl.ico",FALSE);

    // get spell icons out of file.
    icons=0;
    if ((infile=fopen(icon_file_name,"r"))==NULL) return;

    // count lines
    while (!feof(infile)) {
	fgets(buffer,256,infile);
	if ((buffer[0]!=';') && (strlen(buffer)>2)) {
	    icons++;
	}
    }
    rewind(infile);

    icontable=new HPOINTER[icons];
    icontext=new PCHAR[icons];

    for (i=0; i<icons; i++) {
	do {
	    fgets_no_cr(buffer,256,infile);
	} while ((buffer[0]==';') || (strlen(buffer)<=1));

	// find first space in line
	if (strchr(buffer,' ')==NULL) {
	    icons=0;
	    return;
	}
	// with no error handling whatsoever!
	j=strlen(buffer)-strlen(strchr(buffer,' '));
	icontext[i]=new char[j+1];
	icontext[i][j]=(char)0;
	strncpy(icontext[i],buffer,j);
	icontable[i]=WinLoadFileIcon((PSZ)(buffer+j+1),FALSE);
    }

    fclose(infile);
}

// return the appropriate icon for a spell, from the icon table
HPOINTER lookup_icon(spell *s) {
    magespell *ms;
    priestspell *ps;
    int i;

    // if a priest spell, try to look it up by sphere
    if (s->type=='P') {
	ps=(priestspell *)s;
	if (ps->sphere) {
	    for (i=0; i<icons; i++) 
		if (strstr(ps->sphere,icontext[i])!=0)
		    return(icontable[i]);
	}
    }

    // try looking it up by school.
    if ((s->type=='M') || (s->type=='P')) {
	ms=(magespell *)s;
	if (ms->school) {
	    for (i=0; i<icons; i++) 
		if (strstr(ms->school,icontext[i])!=0)
		    return(icontable[i]);
	}
    }

    // return generic icon if nothing else works.
    return(dragicon);
}

// read in the ini file
void load_ini() {
    char *ini_name=INIFILE;

    hini = PrfOpenProfile(hab,ini_name);

    // find name of changed spellbook file
    PrfQueryProfileString(hini,
			  "spellbook",
			  "changefile",
			  CHANGEFILE,
			  changed_file_name,
			  256);

    // find name of icon file
    PrfQueryProfileString(hini,
			  "spellbook",
			  "iconfile",
			  ICONFILE,
			  icon_file_name,
			  256);
    
    // find name of master spell list
    PrfQueryProfileString(hini,
			  "spellbook",
			  "masterlist",
			  ALLSPELLS,
			  master_name,
			  256);

    // find name of quick master spell list
    PrfQueryProfileString(hini,
			  "spellbook",
			  "quickmaster",
			  QUICKALL,
			  quick_master_name,
			  256);
}

// quick enabling of menu items
VOID enable_menu_item( HWND hwndMenu, SHORT sIditem, BOOL bEnable) {
  SHORT sFlag;

  if(bEnable)
    sFlag = 0;
  else
    sFlag = MIA_DISABLED;

  WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(sIditem, TRUE),
               MPFROM2SHORT(MIA_DISABLED, sFlag));
}

// checks or unchecks an item on a given menu
void check_menu_item(HWND hwndframe, 
		     short submenu_id, 
		     short item_id, 
		     BOOL checked) {
    MENUITEM mi;
    HWND hwndmenu;

    mi.hwndSubMenu=NULL;

    hwndmenu=WinWindowFromID(hwndframe,
			     FID_MENU);

    WinSendMsg(hwndmenu,
	       MM_QUERYITEM,
	       MPFROM2SHORT(submenu_id,TRUE),
	       MPFROMP(&mi));

    hwndmenu=mi.hwndSubMenu;

    WinCheckMenuItem(hwndmenu,item_id,checked);
}

// print a message to the window's title
void titleprintf(HWND hwndframe, char *fmt, ...) {
    char buffer[256];

    va_list ap;
    
    va_start(ap,fmt);
    vsprintf(buffer,fmt,ap);
    va_end(ap);

    WinSetWindowText(hwndframe,(PSZ)buffer);
}

// main program
int main(int argc, char **argv) {
    int i;
    HMQ hand_mq;  // message queue 
    QMSG q_mess;  // message queue 
    HWND logo;

    // create semaphores
    DosCreateEventSem(NULL,
		      &sem_object_started,
		      0,
		      TRUE);

    DosCreateMutexSem(NULL,
		      &sem_master_loading,
		      0,
		      FALSE);
    
    hab=WinInitialize(0);  // get anchor block 
    hand_mq = WinCreateMsgQueue(hab, 0); // start queue 
 
    // register the classes 
    if (!WinRegisterClass(
			  hab,
			  (PSZ) spbclass,
			  (PFNWP) book_window_func,
			  CS_SIZEREDRAW,
			  sizeof(bookwindow *)))
	exit(1);
    if (!WinRegisterClass(
			  hab,
			  (PSZ) splclass,
			  (PFNWP) spell_window_func,
			  CS_SIZEREDRAW,
			  sizeof(spellwindow *)))
	exit(1);


    // show copyright notice
    logo=WinLoadDlg(HWND_DESKTOP,
		    HWND_DESKTOP,
		    about_dlg_func,
		    0L,
		    ABOUT_DLG,
		    NULL);

    // load in init file and icons
    load_ini();
    setupicons();

    // load help
    init_help(hab);
 
    // create first spell book with master list
    if (argc<2)
	new bookwindow(NULL, true);
    else
	for (i=1; i<argc; i++) 
	    new bookwindow(argv[i],false);
    
    // dismiss dialog automatically
    WinSendMsg(logo,WM_COMMAND,0,0);

    // message loop 
    while(WinGetMsg(hab, &q_mess, 0L,0,0))
	WinDispatchMsg(hab, &q_mess);

    // shut down all remaining windows and quit 
    while (first!=NULL) delete first;
    while (firstspell!=NULL) delete firstspell;
    PrfCloseProfile(hini);
    if (hwndhelp)
	WinDestroyHelpInstance(hwndhelp);
    if (hwndspellhelp)
	WinDestroyHelpInstance(hwndspellhelp);
    WinDestroyMsgQueue(hand_mq);
    WinTerminate(hab);
    return(0);
}



