#ifndef WBOARD_INCLUDED
#define WBOARD_INCLUDED
//**************************************************************************
// Class:   BoardWindow                                                    *
//                                                                         *
// Purpose: Chessboard subwindow.                                          *
//                                                                         *
//**************************************************************************

#include <istattxt.hpp>
#include <icolor.hpp>
#include <ipainhdr.hpp>
#include <imchdr.hpp>
#include <ihandler.hpp>
#include "game.hh"

class BoardWindow;

class BoardHandler : public IHandler
{
public:
  Boolean dispatchHandlerEvent(IEvent &evt);
  BoardHandler(BoardWindow *w) {}
};



class BoardWindow : public IStaticText, 
                    public IPaintHandler,
                    public IMouseClickHandler
{
public:                               //Define the public Information
  BoardWindow(unsigned long windowId, //Constructor for this class
	      IWindow *parent,
	      int     size);

  Boolean paintWindow(IPaintEvent&) ; //Handle the paint window event
  Boolean mouseClicked(IMouseClickEvent &keyevt);

  void BoardWindow::plotPiece(AGame::Piece piece, char rank, char file);
  void setup(int size);		      // set bitmap, colors, board size
  Boolean whiteAtBottom() { return orientation == 0; }
  void flip() { orientation = (orientation+180) % 360; }
  void plot(Boolean force=false);
  void setPromotePiece(char c) { promotePiece = c; }
  int pixelSize() { return squareSize*8; }

private:                              //Define the private Information
  BoardHandler  *boardHandler;
  int     squareSize;		      // bit dimension of board square
  char    *pi_bits[13];   	// bitmap pointers
  char    promotePiece;
  int     orientation;
  AGame   prevGame;		// to update only changed squares
};

#endif
