VERSION 2.00
Begin Form Setup1 
   BackColor       =   &H00400000&
   Caption         =   "Test App Setup"
   ControlBox      =   0   'False
   FillStyle       =   0  'Solid
   FontBold        =   -1  'True
   FontItalic      =   -1  'True
   FontName        =   "MS Sans Serif"
   FontSize        =   24
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   ForeColor       =   &H00000000&
   Height          =   2556
   Left            =   1812
   LinkMode        =   1  'Source
   LinkTopic       =   "Form3"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   178
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   470
   Top             =   2244
   Width           =   5736
   Begin Label Label2 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "To customize this setup program, modify the FORM_LOAD event procedure in this form."
      Height          =   435
      Left            =   15
      TabIndex        =   1
      Top             =   15
      Visible         =   0   'False
      Width           =   5625
   End
   Begin Label Label1 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "This label used for DDE connection to the Program Manager"
      Height          =   390
      Left            =   15
      TabIndex        =   0
      Top             =   525
      Visible         =   0   'False
      Width           =   5610
   End
End

Const APPNAME = "Scroll"

Const APPDIR = "C:\SCROLL"     ' The default install directory


' Set the total uncompressed file sizes
' by adding the sizes of the files
Const WINSYSNEEDED = 2694908' Files that go into WINDOWS and SYSTEM directory

Const OTHERNEEDED = 171267' Files that don't go into the WINDOWS or SYSTEM directory

Sub DrawBackground ()
    Setup1.CurrentY = 5
    Setup1.CurrentX = 5
'    Setup1.ForeColor = QBColor(13)
    Print APPNAME + " Setup"
End Sub

Sub Form_Load ()
    
    '----------
    ' Initialize
    '----------
    dialogCaption$ = APPNAME + " Setup"
    ShowMainForm dialogCaption$

    winDrive$ = UCase$(Left$(winDir$, 1))
    winDir$ = UCase$(GetWindowsDir$())
    winSysDir$ = UCase$(GetWindowsSysDir$())
    
    '----------------------------------------------------
    ' Get Window version
    '----------------------------------------------------
    TheVerInfo& = GetVersion()
    WinVer& = TheVerInfo& And &HFFFF&
    If Val(Format$(WinVer& Mod 256) + "." + Format$(WinVer& \ 256)) >= 3.1 Then
	gfWin31% = True
    End If
    
    '----------------------------------------------------
    ' SETUP.EXE passes the source drive in a command
    ' argument.  If it is empty,  that means the user
    ' executed this .exe directly.  In that case, show
    ' a dialog to get the desired source directory.
    '----------------------------------------------------
    SourcePath$ = Command$
    If SourcePath$ = "" Then
	title$ = dialogCaption$
	caption1$ = "Please enter the drive or path containing the " + APPNAME + " source files."
	caption2$ = "Install From:"
	defaultDrive$ = "A:"
	defaultText$ = "A:\"

	ShowPathDialog title$, caption1$, caption2$, defaultDrive$, defaultText$, SourcePath$, outButton$

	If outButton$ = "exit" Then GoTo ErrorSetup
    Else
	If Right$(SourcePath$, 1) <> "\" Then
	    SourcePath$ = SourcePath$ + "\"
	End If
    End If


    '--------------------
    ' Get Destination Path
    '--------------------
    title$ = dialogCaption$
    caption1$ = "If you want to install the test application in a different directory and/or drive, type the name of the directory."
    caption2$ = "Install To:"
    defaultDrive$ = "C:"
    defaultText$ = APPDIR

    ShowPathDialog title$, caption1$, caption2$, defaultDrive$, defaultText$, destPath$, outButton$

    If outButton$ = "exit" Then GoTo ErrorSetup
    

    '-----------------------------------------
    ' Dim disk space variables as Long Integers
    '-----------------------------------------
    Dim winSpaceFree As Long
    Dim sourceSpaceFree As Long
    Dim destSpaceFree As Long
    Dim totalNeeded As Long

    '---------------------------------------------------------
    ' If the Windows \SYSTEM directory is a subdirectory
    ' of the Windows directory, the proper place for
    ' installation of .VBXs and shared .DLLs is the
    ' Windows \SYSTEM directory.
    '
    ' If the Windows \SYSTEM directory is *not* a subdirectory
    ' of the Windows directory, then the user is running a
    ' shared version of Windows, and the proper place for
    ' installation of .VBXs and shared .DLLs is the
    ' Windows directory.
    '---------------------------------------------------------
    If InStr(winSysDir$, winDir$) = 0 Then
	winSysDir$ = winDir$
    End If

    
    '---------------------------------
    ' Get Drive Letters of directories
    '---------------------------------
    destDrive$ = UCase$(Left$(destPath$, 1))
    sourceDrive$ = UCase$(Left$(SourcePath$, 1))

    '---------------------------------
    ' Compute free disk space variables
    '---------------------------------
    winSpaceFree = GetDiskSpaceFree(winDrive$)
    destSpaceFree = GetDiskSpaceFree(destDrive$)
    
    '-----------------------------------------
    ' Check for enough disk space.
    '
    ' Some components are being installed into the
    ' Windows\SYSTEM directory.
    '
    ' So if the main destination path is on a
    ' different drive than the drive with
    ' the Windows \SYSTEM directory, we have to
    ' check both drives.
    '
    ' An example of this is when the user is installing
    ' the main product to drive D:, but the Windows
    ' directory is on drive c:
    ' -----------------------------------------
    totalNeeded = WINSYSNEEDED + OTHERNEEDED
    
    If winDrive$ = destDrive$ Then
	If destSpaceFree < totalNeeded Then
	    MsgBox "There is not enough disk space on drive " + destDrive$ + ":   An estimated" + Str$(totalNeeded - destSpaceFree) + " additional bytes are needed.", 16, dialogCaption$
	    GoTo ErrorSetup
	End If
    Else
	If winSpaceFree < WINSYSNEEDED Then
	    MsgBox "There is not enough disk space on drive " + winDrive$ + ":  An estimated" + Str$(WINSYSNEEDED - winSpaceFree) + " additional bytes are needed.", 16, dialogCaption$
	    GoTo ErrorSetup
	End If
	If destSpaceFree < OTHERNEEDED Then
	    MsgBox "There is not enough disk space on drive " + destDrive$ + ":  An estimated" + Str$(OTHERNEEDED - destSpaceFree) + " additional bytes are needed.", 16, dialogCaption$
	    GoTo ErrorSetup
	End If
	
    End If



    '----------------------------
    ' Create destination directory
    '----------------------------
    If Not CreatePath(destPath$) Then GoTo ErrorSetup
    

    '-----------------------------------------------------------
    ' Show Status Dialog -- This stays up while copying files
    ' It is required by the CopyFile routine
    '-----------------------------------------------------------
    ShowStatusDialog dialogCaption$, totalNeeded
    
    
    '-----------
    ' Copy Files
    '-----------

    ' Test to see if scroll.exe is on the disk, if not then you know the user
    ' did not insert the first disk
If Not PromptForNextDisk(1, SourcePath$ + "SCROLL.EX_") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QELINK.VB_", "QELINK.VBX") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMBLB.DL_", "QMBLB.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMGUI03.DL_", "QMGUI03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMUTL03.DL_", "QMUTL03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMMDS03.DL_", "QMMDS03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, destPath$, "QEMLRUN.LI_", "QEMLRUN.LIC") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, destPath$, "SCROLL.EX_", "SCROLL.EXE") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "ODBC.DL_", "ODBC.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "ODBCINST.DL_", "ODBCINST.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "ODBCINST.HL_", "ODBCINST.HLP") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "CTL3D.DL_", "CTL3D.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "COMMDLG.DL_", "COMMDLG.DLL") Then GoTo ErrorSetup

'
' dBASE Tables do not have an _ in the extension.  See PACKDIRS.BAT for details
'
If Not CopyFile(SourcePath$, destPath$, "EMP.DBF", "EMP.DBF") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, destPath$, "EMP.DBT", "DEPT.DBT") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, destPath$, "DEPT.DBF", "DEPT.DBF") Then GoTo ErrorSetup

If Not CopyFile(SourcePath$, winSysDir$, "QMBAS03.DL_", "QMBAS03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMSQL03.DL_", "QMSQL03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMDBF03.DL_", "QMDBF03.DLL") Then GoTo ErrorSetup
If Not CopyFile(SourcePath$, winSysDir$, "QMFLT03.DL_", "QMFLT03.DLL") Then GoTo ErrorSetup

' Uncomment the following code if your product spans more than one disk

    ' Test to see if ???.??? is on the disk, if not then you know the user
    ' did not insert the first disk

' If Not PromptForNextDisk(2, SourcePath$ + "???.???") Then GoTo ErrorSetup
' copy additional files

    '--------------------------------------------------
    ' File Copying is over, so unload the status dialog
    '--------------------------------------------------
    Unload StatusDlg


    '-----------------------------------------------------------
    ' Show static message while working on DDE to Program Manager
    '-----------------------------------------------------------
    ShowStaticMessageDialog dialogCaption$, "Creating Program Manager Icon..."


    '--------------------------------------
    ' Create program manager group and icon
    '--------------------------------------
CreateProgManGroup Setup1, "Scroll", "SCROLL.GRP"

CreateProgManItem Setup1, destPath$ + "SCROLL.EXE", "Scroll"
    
    '---------------------
    ' Install Q+E Drivers
    '---------------------

    ShowStaticMessageDialog dialogCaption$, "Installing Q+E Drivers"

    'Initialize Q+E Setup stuff
    QEInitSetup

    'Add entry to ODBCINST.INI
    res% = QEInstallDriver("Q+E ML dBASEFile (*.dbf)", winSysDir$ + "QMDBF03.DLL")
    If res% = 0 GoTo ErrorSetup


    'NOTE:
    ' Unlike the sample in \qelink\scroll, this version of SCROLL.EXE
    ' Does not connect to the dBASEFile data source.  Instead, we
    ' create a datasource especially for this program called "Scroll"
    ' The Q+E dBASEFile driver allows us to specify a default directory
    ' for database files, by using the "Database=" option.  When we
    ' create this datasource, we set "Database=" to the directory
    ' specified by destPath$.  Thus, the user can install the product
    ' anywhere and the pTables properties will not have to be changed.
    
    'Create datasource
    res% = QECreateDataSource("Scroll", "Q+E ML dBASEFile (*.dbf)")
    If res% = 0 GoTo ErrorSetup

    'Set datasource options
    res% = QESetDataSourceOption("Scroll", "Locking", "RECORD")
    If res% = 0 GoTo ErrorSetup
    res% = QESetDataSourceOption("Scroll", "Database", destPath$)
    If res% = 0 GoTo ErrorSetup

    '-------------------
    ' Hide Static Message
    '-------------------
    MessageDlg.Hide
    
    '------------------
    ' Show Final message
    '------------------
    MsgBox APPNAME + " Installation is Complete!", 48, dialogCaption$
   
ExitSetup:
    Setup1.Hide
    RestoreProgMan         'Show the program manager
    End
    Exit Sub

ErrorSetup:
    MsgBox APPNAME + " is not properly installed.  Please re-run setup at a later time to install the Test Application properly.", 48, dialogCaption$
    ChDrive winDrive$   ' Set back to hard disk
    ChDir Left$(winDir$, Len(winDir$) - 1)
    End
    Exit Sub
    
End Sub

Sub Form_Paint ()
    DrawBackground
End Sub

'---------------------------------------------------------------
' Sets the form's caption, Paints 3-D Background Text, Shows Form
'---------------------------------------------------------------
Sub ShowMainForm (Caption$)
    Screen.MousePointer = 11
    Setup1.Caption = Caption$
    Setup1.Move 0, 0, Screen.Width, Screen.Height * .85
    Setup1.Show
    Setup1.ForeColor = QBColor(15)
    Setup1.Refresh

    Setup1.ScaleMode = 2
    Setup1.FontSize = 24
    Setup1.FontBold = True
    Setup1.FontItalic = True
    
    Setup1.ForeColor = QBColor(13)
    DrawBackground
End Sub

Sub ShowPathDialog (title$, caption1$, caption2$, defaultDrive$, defaultText$, SourcePath$, outButton$)
	Screen.MousePointer = 11
	Load PathDlg
	PathDlg.Caption = title$
	PathDlg.Label1.Caption = caption1$
	PathDlg.Label2.Caption = caption2$
	PathDlg.inDrive.Tag = defaultDrive$
	PathDlg.Text1.Text = defaultText$
	PathDlg.Text1.SelStart = 0
	PathDlg.Text1.SelLength = Len(defaultText$)
	CenterForm PathDlg
	Screen.MousePointer = 0

	PathDlg.Show 1
	
	SourcePath$ = PathDlg.outPath.Tag
	outButton$ = PathDlg.outButton.Tag
	Unload PathDlg
End Sub

Sub ShowStaticMessageDialog (title$, Caption$)

    Load MessageDlg
    CenterForm MessageDlg
    MessageDlg.Caption = title$
    MessageDlg.Label.Caption = Caption$
    MessageDlg.Show
    MessageDlg.Refresh

End Sub

Sub ShowStatusDialog (title$, totalBytes As Long)

    Load StatusDlg
    StatusDlg.Caption = title$
    StatusDlg.total.Tag = Str$(totalBytes)
    CenterForm StatusDlg
    StatusDlg.Show

End Sub

