'======================================================================='
'                                                                       '
'                          MultiLink.txt                                '
'                                                                       '
'                  Q+E Visual Basic Custom Controls                     '
'                         for All drivers                               '
'                      Global Constants File                            '
'                                                                       '
'======================================================================='

'======================================================================='
'         Copyright: 1992-93 Pioneer Software, Inc.                     '
'                                                                       '
'         This software contains confidential and proprietary           '
'           information of Pioneer Software Systems, Inc.               '
'======================================================================='

'==============='
'  Error Codes  '
'==============='

Global Const QE_ERROR_CODES = 31000
Global Const QE_FUNCTION_ABORTED = 31001
Global Const QE_RECORD_NOT_FOUND = 31002
Global Const QE_DB_ERROR = 31003
Global Const QE_RECORD_LOCKED = 31004
Global Const QE_RECORD_CHANGED = 31005
Global Const QE_LOGON_CANCELLED = 310008

'======================'
'  Record State Codes  '
'======================'

Global Const RECSTATE_NO_RECORD = 0
Global Const RECSTATE_FETCHING = 1
Global Const RECSTATE_UNCHANGED = 2
Global Const RECSTATE_CHANGED = 3
Global Const RECSTATE_NEW_UNCHANGED = 4
Global Const RECSTATE_NEW_CHANGED = 5
Global Const RECSTATE_QBE_UNCHANGED = 6
Global Const RECSTATE_QBE_CHANGED = 7
Global Const RECSTATE_COPYING = 8
Global Const RECSTATE_ENTERING_QBE = 9
Global Const RECSTATE_CLEARING_QBE = 10
Global Const RECSTATE_CLEARING_NEW = 11

'=================='
'  Function Codes  '
'=================='

Global Const F_DOQUERY = 1
Global Const F_ENDQUERY = 2
Global Const F_NEXT = 3
Global Const F_PREVIOUS = 4
Global Const F_RANDOM = 5
Global Const F_NEW = 6
Global Const F_ENTERQBE = 7
Global Const F_CLEARQBE = 8
Global Const F_INSERT = 9
Global Const F_UPDATE = 10
Global Const F_DELETE = 11
Global Const F_LOCK = 12
Global Const F_TRANBEGIN = 13
Global Const F_TRANCOMMIT = 14
Global Const F_TRANROLLBACK = 15
Global Const F_EXECSQL = 16
Global Const F_LOGON = 17
Global Const F_LOGOFF = 18

'========================================================'
' The following keywords can be used as the controltype  '
' in Visual Basic's "If...TypeOf" statement to identify  '
' the exact type of a QEVBDBF control.                   '
'                                                        '
'       ConnectClass                                     '
'       QueryClass                                       '
'       QGrid                                            '
'       DB_CommandClass                                  '
'       DB_HScrollClass                                  '
'       DB_VScrollClass                                  '
'       DB_TextClass                                     '
'       DB_ComboClass                                    '
'       DB_ListClass                                     '
'       DB_CheckClass                                    '
'       DB_RadioGroupClass                               '
'       DB_PictureClass                                  '
'                                                        '
' ====================================================== '

'====================='
'  Declare Functions  '
'====================='

Declare Function fDoQuery Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fEndQuery Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fNext Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fPrevious Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fRandom Lib "qelink.vbx" (queryCtl As Control, ByVal RecNumber&) As Integer
Declare Function fNew Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%, ByVal before%) As Integer
Declare Function fEnterQBE Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fClearQBE Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fInsert Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fUpdate Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fDelete Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fLock Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fTranBegin Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fTranCommit Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fTranRollback Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fExecSQL Lib "qelink.vbx" (queryCtl As Control, ByVal SQLStmt$) As Integer
Declare Function fLogon Lib "qelink.vbx" (connectionCtl As Control) As Integer
Declare Function fLogoff Lib "qelink.vbx" (connectionCtl As Control) As Integer

