/*********************************************************************/
/* 09/03/93  Create GammaTech Folder and all GammaTech ICONS         */
/*                                                                   */
/* Copyright (C) GammaTech Inc. 1993            All Rights Reserved. */
/*                                                                   */
/* Creates Icons for:                                                */
/*                                                                   */
/*    GammaTech Utilities for OS/2     Version 2.10                  */
/*    GammaTech File Secure            Version 1.00                  */
/*    GammaTech Power Pack             Version 1.00                  */
/*                                                                   */
/*********************************************************************/

Trace 'O'
Address CMD
'@ECHO OFF'

/*********************************************************************/
/* Initialization                                                    */
/*********************************************************************/
Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs
instdrive = ''
instpath = ''
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

/*********************************************************************/
/* Get the installation drive and path                               */
/*********************************************************************/
If Pos('\GAMMA32',Translate(Value('PATH',,'OS2ENVIRONMENT'))) > 0 Then instdrive = Translate(Substr(Value('PATH',,'OS2ENVIRONMENT'),Pos('\GAMMA32',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2))
If instdrive = '' Then Do
   Say "No path found for the GammaTech directory, please enter the drive."
   Say "Example) C:"
   Parse Upper Pull instdrive
   instpath=instdrive||"\GAMMA32"

   Say "GammaTech Installation DRIVE =" instdrive
   Say "GammaTech Installation PATH =" instpath
   Say "Is the GammaTech directory on drive" instdrive"? (Y/N)"
   Parse Upper Pull response
   If response <> 'Y' Then Do
      instdrive = ''
      Say "Re-enter the Drive for the GammaTech directory."
      Parse Upper Pull instdrive

     instpath = instdrive||'\GAMMA32'
   End
End

Else Do
   Say "Path found for the GammaTech Directory."
   instpath = instdrive||'\GAMMA32'

   Say "GammaTech installation DRIVE =" instdrive
   Say "GammaTech installation PATH =" instpath
   Say "Is the above information correct? (Y/N)"
   Parse Upper Pull response
   If response <> 'Y' Then Do
      instdrive = ''
      Say "Re-enter the Drive where the GammaTech directory resides."
      Parse Upper Pull instdrive

     instpath = instdrive||'\GAMMA32'
   End
End

Do Until file.0 <> 0
   ret = SysFileTree(instpath, 'file', 'D')

   If file.0 = 0 Then Do
      'CLS'
      Say "The GammaTech directory is not on drive" instdrive"."
      Say "Do you want to exit now? (Y/N)"
      Parse Upper Pull response
      If Substr(response,1,1) = 'Y' Then Call Endit

      instdrive=''
      Say "Please re-enter the drive for the GammaTech Directory."
      Say "Example) C:"
      Parse Upper Pull instdrive
      instpath=instdrive||"\GAMMA32"

      Say "GammaTech installation DRIVE =" instdrive
      Say "GammaTech installation PATH =" instpath
      Say "Is the GammaTech directory on drive" instdrive"? (Y/N)"
      Parse Upper Pull response
      If response <> 'Y' Then Do
         instdrive = ''
         Say "Re-enter the Drive where the GammaTech directory resides."
         Parse Upper Pull instdrive
         instpath = instdrive||'\GAMMA32'
      End
   End
End

/*********************************************************************/
/*  Ask User for the drive if there is no info in system             */
/*********************************************************************/

'CLS'
Say "Your OS/2 system is installed on the" bootdrive "drive."
Say " "
Say "The GammaTech Directory has been found:"
Say " "
If instdrive <> '' Then Say "     GammaTech Directory on" instpath
Say " "
Say "This program will now create a folder for the GammaTech products"
Say "you have installed on your desktop."
Say " "
Say "Do you want to continue (Y/N)?"
Parse Upper Pull yesno .
If Substr(yesno,1,1) <> 'Y' Then Call Endit

/*********************************************************************/
/* Define and Create the Folder                                      */
/*********************************************************************/

If instdrive <> '' Then Do
   Call SysCreateObject 'WPFolder', 'GammaTech','<WP_DESKTOP>','OBJECTID=<GT_Folder>;ICONFILE='||instpath||'\GAMMA.ICO','R'

/*********************************************************************/
/* Create Reference Program ICONs in the Folder                      */
/*********************************************************************/
   rc = SysFileTree(instpath||'\gtbook.ico', 'find', 'F')
   If find.0 = 1 then do
      Call SysCreateObject 'WPProgram','Information','<GT_Folder>','OBJECTID=<GT_Info>;ICONFILE='||instpath||'\GTBOOK.ICO;EXENAME='||bootdrive||'\OS2\VIEW.EXE;PROGTYPE=PM;PARAMETERS=GAMMA.INF;STARTUPDIR='||instpath||';','R'
   End

   progtype = 'PM'

   progname = 'Analyze'
   progtitl = 'Analyze'
   progicon =  progname
   call DoProgram

   progname = 'Sentry'
   progtitl = 'Sentry'
   progicon =  progname
   call DoProgram

   progname = 'UnDelete'
   progtitl = 'UnDelete'
   progicon =  progname
   call DoProgram

   progname = 'SysInfo'
   progtitl = 'SysInfo'
   progicon =  progname
   call DoProgram

   progname = 'Optimize'
   progtitl = 'HPFS-Opt'
   progicon =  progname
   call DoProgram

   progname = 'Find'
   progtitl = 'Find'
   progicon =  progname
   call DoProgram

   progname = 'Delete'
   progtitl = 'Delete'
   progicon =  progname
   call DoProgram

   progname = 'Attr'
   progtitl = 'Attribute'
   progicon =  progname
   call DoProgram

   progname = 'Secure'
   progtitl = 'File Secure'
   progicon =  progname
   call DoProgram

   progname = 'GtHotKey'
   progtitl = 'HotKey'
   progicon =  progname
   call DoProgram

   progname = 'GtIniEdt'
   progtitl = 'Ini-Edit'
   progicon =  progname
   call DoProgram

   progname = 'GtEaEdit'
   progtitl = 'EA-Edit'
   progicon =  progname
   call DoProgram

   progname = 'GtScrSav'
   progtitl = 'ScrSave'
   progicon =  progname
   call DoProgram

   progtype = 'WINDOWABLEVIO'

   progname = 'fatopt'
   progtitl = 'FAT-Opt'
   progicon = 'Optimize'
   call DoProgram

   progname = 'gtdisk'
   progtitl = 'DiskUtil'
   progicon =  progname
   call DoProgram
End

/*********************************************************************/
/* Exit Program                                                      */
/*********************************************************************/

Endit:
Exit 0

/*********************************************************************/
/* Create a Program object in the GammaTech Folder                   */
/*********************************************************************/

DoProgram:
   rc = SysFileTree(instpath||'\'progname'.*', 'find', 'F')
   If find.0 <> 0 then do
      Call SysCreateObject 'WPProgram',progtitl,'<GT_Folder>','OBJECTID=<GT_'progname'>;ICONFILE='||instpath||'\'progicon'.ICO;EXENAME='||instpath||'\'progname'.EXE;PROGTYPE='progtype';','R'
   End
Return

