/*
	==========================================================================
	Module: uiDDE.c
	==========================================================================
	This module contains DDE invocation code for RPC search.
	
	$Header
	                      
	==========================================================================
		Copyright (c) 1992, Adobe Systems Incorporated, All Rights Reserved.
		Confidential, Unpublished Property of Adobe Systems Incorporated.
	==========================================================================
*/           

#ifndef UIDDE_H
#define UIDDE_H

#include "siPltfrm.h"

typedef enum {
	QLangType_Simple,
	QLangType_CQL,
	QLangType_Passthrough
} eQLangType;

// Word Options.
typedef enum {
	QPON_Case		= 0,		// Option: Case sensitive.
	QPON_Stemming,	 			// Option: Stemming.
	QPON_SoundsLike,			// Option: Sounds like.
	QPON_Thesaurus,				// Option: Thesaurus.
	QPON_Proximity,				// Option: Proximity.
	QPON_Refine					// Option: Refine search.
} WordOptionsType;

#define QP_NUM_WORD_OPTIONS 6
#define QP_MAX_SORT_FIELDS		16

typedef struct _QueryData
{
	eQLangType qlt;
	boolean bOverrideWordOptions;
	uns32 nWordOptions;
	uns16 nMaxDocs;
	uns16 nQueryOffset;
	uns16 nNumSorts;
	uns16 nSortOffset[QP_MAX_SORT_FIELDS];
	boolean bSortWays[QP_MAX_SORT_FIELDS];
	unsigned char cData[1];
} QueryData;

typedef enum {
	IndexAction_Add,
	IndexAction_Remove,
	IndexAction_Enable,
	IndexAction_Disable
} IndexActionType;

typedef struct _IndexData
{
	IndexActionType eAction;			// Add, Remove, Enable, Disable.
	int16 nIndexOffset;					// Offset to *.PDX name of index.
	int16 nTempNameOffset;				// Offset to temp name if index down.
	unsigned char cData[1];				// Data.
} IndexData;

extern boolean DDE_Init(void);
extern boolean DDE_PokeData(void *vData, int nLen);
extern void DDE_Term(void);
       
#endif 
