// cntritem.cpp : implementation of the CCntrItem class
//

#include "stdafx.h"

#include "cntritem.h"

typedef void** LPLP;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCntrItem implementation

IMPLEMENT_SERIAL(CCntrItem, COleClientItem, 0)

CCntrItem::CCntrItem(COleDocument* pContainer)
	: COleClientItem(pContainer)
{
	m_rect.SetRect(10, 10, 50, 50);
}

CCntrItem::~CCntrItem()
{
	// TODO: add cleanup code here
}

void CCntrItem::InvalidateItem()
{
}

void CCntrItem::UpdateFromServerExtent()
{
	CSize size;
	if (GetExtent(&size))
	{
		// OLE returns the extent in HIMETRIC units -- we need pixels
		CClientDC dc(NULL);
		dc.HIMETRICtoDP(&size);

		// only invalidate if it has actually changed
		if (size != m_rect.Size())
		{
			// invalidate old, update, invalidate new
			InvalidateItem();
			m_rect.bottom = m_rect.top + size.cy;
			m_rect.right = m_rect.left + size.cx;
			InvalidateItem();

			// mark document as modified
			GetDocument()->SetModifiedFlag();
		}
	}
}

void CCntrItem::OnChange(OLE_NOTIFICATION nCode, DWORD dwParam)
{
	ASSERT_VALID(this);

	COleClientItem::OnChange(nCode, dwParam);

	// When an item is being edited (either in-place or fully open)
	//  it sends OnChange notifications for changes in the state of the
	//  item or visual appearance of its content.

	switch (nCode)
	{
	case OLE_CHANGED:
		InvalidateItem();
		UpdateFromServerExtent();
		break;
	case OLE_CHANGED_STATE:
	case OLE_CHANGED_ASPECT:
		InvalidateItem();
		break;
	}
}

BOOL CCntrItem::OnChangeItemPosition(const CRect& rectPos)
{
	ASSERT_VALID(this);

	// During in-place activation CCntrItem::OnChangeItemPosition
	//  is called by the server to change the position of the in-place
	//  window.  Usually, this is a result of the data in the server
	//  document changing such that the extent has changed or as a result
	//  of in-place resizing.
	//
	// The default here is to call the base class, which will call
	//  COleClientItem::SetItemRects to move the item
	//  to the new position.

	if (!COleClientItem::OnChangeItemPosition(rectPos))
		return FALSE;

	InvalidateItem();
	m_rect = rectPos;
	InvalidateItem();

	// mark document as dirty
	GetDocument()->SetModifiedFlag();

	return TRUE;
}

void CCntrItem::OnGetItemPosition(CRect& rPosition)
{
	ASSERT_VALID(this);

	// return rect relative to client area of view
	rPosition = m_rect;
}

void CCntrItem::OnDeactivateUI(BOOL bUndoable)
{
	COleClientItem::OnDeactivateUI(bUndoable);

	// Close an in-place active item whenever it removes the user
	//  interface.  The action here should match as closely as possible
	//  to the handling of the escape key in the view.

	Deactivate();   // nothing fancy here -- just deactivate the object
}

void CCntrItem::Serialize(CArchive& ar)
{
	ASSERT_VALID(this);

	// Call base class first to read in COleClientItem data.
	// Since this sets up the m_pDocument pointer returned from
	//  CCntrItem::GetDocument, it is a good idea to call
	//  the base class Serialize first.
	COleClientItem::Serialize(ar);

	// now store/retrieve data specific to CCntrItem
	if (ar.IsStoring())
	{
		ar << m_rect;
	}
	else
	{
		ar >> m_rect;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCntrItem diagnostics

#ifdef _DEBUG
void CCntrItem::AssertValid() const
{
	COleClientItem::AssertValid();
}

void CCntrItem::Dump(CDumpContext& dc) const
{
	COleClientItem::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////


// HGLOBAL must be allocated as SHARED
void CCntrItem::LoadEmbedding(HGLOBAL hGlobal)
{
	ASSERT_VALID(this);
	ASSERT(m_lpStorage == NULL);
	ASSERT(m_lpLockBytes == NULL);

	HRESULT hr = ::CreateILockBytesOnHGlobal(hGlobal, TRUE, &m_lpLockBytes);
	if (hr != NOERROR)
		AfxThrowOleException(hr);
	ASSERT(m_lpLockBytes != NULL);

	hr = ::StgCreateDocfileOnILockBytes(m_lpLockBytes,
		STGM_SHARE_EXCLUSIVE|STGM_CONVERT|STGM_READWRITE, 0, &m_lpStorage);
	if ((SCODE)hr != STG_S_CONVERTED)
	{
		VERIFY(m_lpLockBytes->Release() == 0);
		m_lpLockBytes = NULL;
		AfxThrowOleException(hr);
	}
	ASSERT(m_lpStorage != NULL);

	ASSERT_VALID(this);

	// load the embedding...
	// attempt to load the object from the storage
	hr = ::OleLoad(m_lpStorage, IID_IOleObject, GetClientSite(), (LPLP)&m_lpObject);
	CheckGeneral(hr);
}

// HGLOBAL must be allocated as SHARED
void CCntrItem::LoadEmbedding2()
{
	ASSERT_VALID(this);
	ASSERT(m_lpStorage != NULL);
	ASSERT(m_lpLockBytes != NULL);
	LPLOCKBYTES lpLockBytes;
	LPSTORAGE lpStorage;
	LPOLEOBJECT lpObject;

	HGLOBAL hGlobal;
	HRESULT hr;
	hr = ::GetHGlobalFromILockBytes(m_lpLockBytes, &hGlobal);
	if (hr != NOERROR) {
		AfxThrowOleException(hr);
	}

	// Create a new LockBytes structure after freeing the old one
//	VERIFY(m_lpLockBytes->Release() == 0);
	hr = ::CreateILockBytesOnHGlobal(hGlobal, TRUE, &lpLockBytes);
	if (hr != NOERROR)
		AfxThrowOleException(hr);
	ASSERT(lpLockBytes != NULL);

	// create a new LPStorage Object after freeing the old one
//	VERIFY(m_lpStorage->Release() == 0);
	hr = ::StgOpenStorageOnILockBytes(lpLockBytes, NULL,
		STGM_SHARE_EXCLUSIVE | STGM_READWRITE,NULL, 0, &lpStorage);
	if ((SCODE)hr != S_OK)
	{
		VERIFY(lpLockBytes->Release() == 0);
		lpStorage = NULL;
		AfxThrowOleException(hr);
	}
	ASSERT(lpStorage != NULL);

	{
		LPSTREAM lpStream;
		hr = lpStorage->OpenStream("Contents",0,STGM_READWRITE|
			STGM_SHARE_EXCLUSIVE,0,&lpStream);
		char pBuffer[256];
		ULONG nCount;
		hr = lpStream->Read(pBuffer,256,&nCount);
		VERIFY(lpStream->Release() == 0);
	}

	{
		LPSTREAM lpStream;
		hr = m_lpStorage->OpenStream("Contents",0,STGM_READWRITE|
			STGM_SHARE_EXCLUSIVE,0,&lpStream);
		char pBuffer[256];
		ULONG nCount;
		hr = lpStream->Read(pBuffer,256,&nCount);
		VERIFY(lpStream->Release() == 0);
	}

	ASSERT_VALID(this);

	// load the embedding...
	// attempt to load the object from the storage
	hr = ::OleLoad(lpStorage, IID_IOleObject, GetClientSite(), (LPLP)&lpObject);
	CheckGeneral(hr);

	hr = lpObject->DoVerb(OLEIVERB_OPEN, NULL, NULL, 0, NULL, NULL);

	lpObject->Release();
	lpStorage->Release();
	lpLockBytes->Release();
}

void CCntrItem::LoadEmbedding3()
{
	ASSERT_VALID(this);
	ASSERT(m_lpStorage != NULL);
	ASSERT(m_lpLockBytes != NULL);

	HGLOBAL hGlobal;
	HRESULT hr;
	hr = ::GetHGlobalFromILockBytes(m_lpLockBytes, &hGlobal);
	if (hr != NOERROR) {
		AfxThrowOleException(hr);
	}

	// Create a new LockBytes structure after freeing the old one
	VERIFY(m_lpLockBytes->Release() == 0);
	hr = ::CreateILockBytesOnHGlobal(hGlobal, TRUE, &m_lpLockBytes);
	if (hr != NOERROR)
		AfxThrowOleException(hr);
	ASSERT(m_lpLockBytes != NULL);

	// create a new LPStorage Object after freeing the old one
	VERIFY(m_lpStorage->Release() == 0);
	hr = ::StgCreateDocfileOnILockBytes(m_lpLockBytes,
		STGM_SHARE_EXCLUSIVE|STGM_CONVERT|STGM_READWRITE, 0, &m_lpStorage);
	if ((SCODE)hr != STG_S_CONVERTED)
	{
		VERIFY(m_lpStorage->Release() == 0);
		m_lpStorage = NULL;
		AfxThrowOleException(hr);
	}
	ASSERT(m_lpStorage != NULL);

	ASSERT_VALID(this);

	// load the embedding...
	// attempt to load the object from the storage
	hr = ::OleLoad(m_lpStorage, IID_IOleObject, GetClientSite(), (LPLP)&m_lpObject);
	CheckGeneral(hr);
}
