THE BASICS OF DOS AND SUBDIRECTORIES


ACTIVITY A     -   GETTING STARTED

               /   Boot-Up Process
               /   Disk Drives
               /   Default Drive
               /   Version of DOS


BOOT-UP PROCESS:   When the computer is switched on it carries out
a start-up process which is known as booting up.  During the final
step in the boot process, the operating system is loaded into the
computer's memory.  The operating system provides the essential
basics that are necessary for the operation of the system.  We will
assume that the operating system you will be using is the DOS
operating system.  Once the system is started you will be in the
DOS environment where you can execute any of the DOS commands which
you will use primarily for disk and file operations or you can
proceed to load other programs (like Turbo Pascal).  You can tell
that you are in DOS if you see a DOS prompt ending with the " >"
symbol like c\:> or a:>  

DISK DRIVES:     The operating system, DOS, usually designates the
diskette drive(s) for removable diskettes as drive A and drive B,
and the fixed hard drive(s) as drive C and drive D. If a computer
has only one diskette drive, it is usually drive A. If a computer
has two diskette drives, usually the upper (or left-hand) drive is
drive A and the other is drive B.

DEFAULT DRIVE:  The default drive is the drive on which DOS file
operations will take place by default.  You can tell which is the
default drive by looking at the DOS prompt.  Suppose that the DOS
prompt is A> or A:\>. In that case the default drive is drive A. 
If you do not indicate a drive when specifying a file in a file
command, the computer will assume that the intended drive is the
default drive.          

VERSION OF DOS:   Each IBM compatible computer uses a particular
version of DOS such as DOS 3.0, DOS 3.3, DOS 5.0 or DOS 6.0. The
larger the DOS number, the more recent the version. There are
situations in which you might need to know the version of DOS that
your computer uses. 

YOU ARE NOW READY TO DO BASICS OF DOS ACTIVITY A IN APPENDIX H

=============================================================================
ACTIVITY B    -    MAKING A BACKUP COPY OF A DISKETTE

              /    Using CHKDSK
              /    Making a backup copy of a diskette using the
                   DISKCOPY or XCOPY command


DENSITY OF A DISKETTE:   3.5" diskettes come in two densities: low
density and high  density  (which can hold more information). 5.25"
floppy diskettes also come in two densities: low density and high
density. Usually, the sticker label on a diskette will give the
density.

USING CHKDSK TO DETERMINE A FORMATTED DISK'S DENSITY:
You can also determine a diskette's density by using the CHKDSK
command to produce a status report for the diskette. The top line
of the status report will say

   _____ bytes total disk space

from which you can conclude the density.

For a 3.5" diskette: 720K bytes is low density and 1.44M bytes is 
high density.
For a 5.25" diskette: 360K bytes is low density and 1.2M bytes is
high density.


DISKCOPY versus XCOPY command:  You may often need to make a backup
copy of an entire diskette because the original diskette might get
damaged. You can use the DISKCOPY command or the XCOPY command to
make a copy of the diskette depending on what types of drives and
diskettes you are using. If the source diskette and the target
diskette are of the same type, for example, both are 5.25"  
diskettes or both are 3.5" diskettes, then you use the DISKCOPY
command. If the source diskette and the target diskette are of
different types, for  example, one is a 5.25" diskette  and  the 
other one is a 3.5" diskette, then you need to use the XCOPY
command.


YOU ARE NOW READY TO DO BASICS OF DOS ACTIVITY B IN APPENDIX H

=============================================================================
ACTIVITY C    -    INTRODUCTION TO SUBDIRECTORIES

              /    Subdirectories and paths
              /    Using the DIR, CHKDSK, and TREE commands

     
                   WORKING WITH SUBDIRECTORIES

              /    Creating a new subdirectory
              /    Changing the current subdirectory
              /    Removing a subdirectory


INTRODUCTION TO SUBDIRECTORIES

SUBDIRECTORIES ANALOGY:   Imagine that you have cut out and saved
100 newspaper articles on various subjects, such as Sports, Movies,
Politics, and Science. One possible way to store these articles is
simply to put them loose in one big folder. A better way to store
them is to use additional folders so that all the Sports articles
will be in a folder labelled Sports, all the Movie articles will be
in a folder labelled Movies, and so on, and then put all these
labelled folders in a big folder. 

In the discussion of subdirectories below, the root directory
corresponds to the big folder, subdirectories correspond to the
labelled subfolders and files correspond to the individual files. 

SUBDIRECTORIES:    When DOS formats a diskette, it creates a main
directory known as the root directory. (The root directory
corresponds to the big folder.)  The root directory may contain
individual files. To make your filing system better organized, you
may also create additional directories off the root directory,
called subdirectories. (They correspond to the labelled folders.)
These subdirectories may contain individual files and/or further
subdirectories of their own. (A subdirectory having its own
subdirectories is like putting a Baseball folder within the Sports
folder.) Even further nesting is possible. This gives rise to a
tree-structured filing system. 

The following diagram illustrates how files and subdirectories on
a diskette could be organized. In diagram 3.1 each name in capital
letters represents a  directory, whereas each name in lowercase
letters represents an individual file.

ROOT LAB   
             block1.pas
             block2.pas
             editexer.pas
             basicdos.pas
             elemedit.pas
             moreedit.pas       
         
         HIST
                usa.txt
                europe.txt
                
         CHEM
                 periodic.txt
 
                 
       Diagram 3.1 -- Example of how files and subdirectories
                      could be organized on a diskette

PATHNAME -- Specifying a Particular File
In this section, you will learn how to specify a desired file from
an existing tree of subdirectories and files. Creating the actual
subdirectory will be discussed in this Activity and creating the
Pascal files under subdirectories will be discussed in Activity D.

To specify which file is intended, a full path called the pathname
must be given. The pathname tells DOS not only the name of the
file, but also where the file is located in the directory system.
A pathname consists of a sequence of subdirectory names followed by
a filename. Each subdirectory name is separated from the previous
one by a backslash (\). 

For example, in the previous diagram, assuming that you are at the
root directory, and you want to specify the file BLOCK1.PAS which
is stored under the subdirectory LAB, the pathname is
\LAB\BLOCK1.PAS.  To specify the file EUROPE.TXT under the
subdirectory HIST, the pathname is \LAB\HIST\EUROPE.TXT.
 
WORKING WITH SUBDIRECTORIES

Listing Files and Subdirectories 

The three basic commands for looking at what is on a diskette are: 
DIR, CHKDSK, and TREE. If the DOS prompt is A>, 
    
  dir            lists the files and subdirectories off the root
                 directory of drive A 
  chkdsk /v      lists all the files and subdirectories (not just
                 those off the root) indicating which subdirectory
                 each file is in 
  tree /f        gives a tree listing for all the files and 
                 subdirectories (available in DOS 4.0 and higher) 
 
REMARK 
1.  If you include >prn at the end of any of these commands, (for
    example, tree /f >prn), the list will be printed on paper. 
2.  If the current directory is not the root directory, 
    a) each command restricts its list to just what is under 
       the current subdirectory.   
    b) however, including the backslash (\) after the command word
       (for example, chkdsk \ /v) will produce the list under the
       root directory instead of under the current subdirectory 
 


CREATING A NEW SUBDIRECTORY:   To create a new subdirectory,  use
the MKDIR or MD command. For example, assume that the current
directory is drive A, typing md biol would create the subdirectory
biol off the root directory of drive A.

CHANGING THE CURRENT SUBDIRECTORY:   To change the current
directory, use the CHDIR or CD command. If you type

   cd dirname       DOS changes the directory to dirname off the
                    current directory
   cd \             DOS changes to the root directory of the
                    default drive
   cd ..            DOS changes the current directory to its
                    parent directory

REMOVING A SUBDIRECTORY:    To remove a subdirectory, use the RMDIR
or RD command. The command can be used to delete any subdirectory
by specifying its path, but all the files stored under that
subdirectory must be erased first. To remove all the files in the
subdirectory, use the ERASE or DEL command discussed in the
previous session. After you have deleted all the files in the
subdirectory, you can use the RMDIR or RD command to remove that
subdirectory. For example, assume that the current directory is
drive A, typing rd biol will remove the subdirectory biol off the
root directory.

YOU ARE NOW READY TO DO BASICS OF DOS ACTIVITY C IN APPENDIX H

=============================================================================
ACTIVITY D    -    WORKING WITH FILES

              /    More on the DIR command
              /    Erasing a file
              /    Copying a file
              /    Copying and erasing files within subdirectories
              /    Using wildcard characters


Using the DIR Command 

Suppose the DOS prompt is A> 
        
   dir        will list on the screen drive A's  files 
              (and subdirectories in <..>) 
   dir >prn   the effect of the >prn is to print the list of files
              and subdirectories on paper 
   dir /p     the effect of the /p is to pause after a screenful 
   dir /w     the effect of the /w is to fit more on one screenful 
 
 
COPYING A FILE:   To make copies of files, we use the COPY command.
The format of the COPY command is:

            copy sourcefile targetfile 

where sourcefile is the name of the file to be copied and
targetfile is the name of the copy to be made. 
Suppose that the DOS prompt is A>. If you type
 
  copy a:prog7.pas  b:            DOS will copy a duplicate of the
                                  file prog7.pas on drive A to
                                  drive B, giving it the same name.

  copy a:prog7.pas  b:prog8.pas   DOS will copy the file prog7.pas
                                  to drive B, but the name of the
                                  duplicate saved on drive B is
                                  prog8.pas 

REMARK    The drive letter of the default drive can be omitted. 
Thus, if drive a: is default, then the a: in the above examples
could be omitted.

CAUTION   If the diskette in drive B already contained a file
prog8.pas, then the above copy command would replace its contents
with the contents of prog7.pas (erasing its previous contents).
More generally, if targetfile already exists, its contents will be
erased and then be replaced by sourcefile. 

ERASING A FILE:  To erase a file, we use the ERASE or DEL command.
Assume that the DOS prompt is A>. If you type
  
   erase b:prog7.pas    DOS will erase prog7.pas from drive B 
   erase prog7.pas      DOS will erase prog7.pas from drive A 
                        Note that it is not necessary to include
                        a: since drive A is the default drive. 
    
When we say that a file is erased from a certain drive, we mean it
is erased from the diskette that is in that drive at the time the
erase command is given. 
 

Using Pathnames in COPY and ERASE Commands 

In the previous examples of COPY and ERASE commands, all the files
were off the root directory.  When files are stored under
subdirectories, you need to include the pathnames in the COPY and
ERASE commands. 

   
EXAMPLE   Assume that the diskette in drive A contains the files
and subdirectories as depicted in Diagram 3.1, and the DOS prompt
is A>. Then, 

  copy \lab\hist\usa.txt  \lab\chem\
 
copies the file usa.txt under the HIST subdirectory and stores it
under the CHEM subdirectory without changing the file name.

  erase \lab\hist\usa.txt

erases the file usa.txt from within the HIST subdirectory.

USING WILDCARD CHARACTERS:   The two wildcard characters * and ?
enable a single command to refer to a whole collection of files.
The asterisk (*) used in a file name or file name extension
indicates that any character can occupy that position or any of the
remaining positions in the file name or extension. The question
mark (?) in a file name or file name extension indicates that any
single character can occupy that position. 

For example, if you type

copy a:*.*  b:      

DOS copies all the files from drive A to drive B without changing
the file names


copy a:prog?.pas  b:   

DOS copies all the files from drive A to drive B whose first part
begins with prog and followed by any single character and extension
is .pas (i.e. prog1.pas, prog2.pas, progA.pas etc.)


erase a:*.pas         

DOS erases all .pas files from drive A 


copy \lab\hist\*.pas   \lab\chem\*.pas 

will make duplicate copies of all the files of the HIST
subdirectory with .PAS extension and store them under the CHEM
subdirectory without changing the file names. That is, the CHEM
subdirectory would acquire files named usa.txt and europe.txt.

YOU ARE NOW READY TO DO BASICS OF DOS ACTIVITY D IN APPENDIX H
