program FullScores;
type
  StudObj = Object
    Name: string;
    score1, score2: integer;
    procedure Init (nm: string; s1, s2: integer);
    function FindQuizAvg: real;
    procedure Report;
  end;

  FullObj = Object (StudObj)
    FinalExam: integer;
    procedure Init (nm: string; s1, s2, fe: integer);
    procedure Report;
  end;

procedure StudObj.Init (nm: string; s1, s2: integer);
  begin
    name := nm;
    score1 := s1;
    score2 := s2
  end;

function StudObj.FindQuizAvg: real;
  begin
    FindQuizAvg := (score1 + score2)/2
  end;

procedure StudObj.Report;
  begin
    writeln (name, ' just term average ', FindQuizAvg:4:1)
  end;

procedure FullObj.Init (nm: string; s1, s2, fe: integer);
  begin
    FinalExam := fe;
    StudObj.Init (nm, s1, s2)
  end;

procedure FullObj.Report;
  var FinalAvg: real;
  begin
    FinalAvg := (FinalExam + FindQuizAvg)/2;
    writeln (name, ' full course avg ', FinalAvg:4:1)
  end;

var StudTerm: StudObj;
    StudFull: FullObj;

begin {main}
  StudTerm.Init ('Henson', 90, 95);
  StudTerm.Report;
  StudFull.Init ('Jones', 70, 80, 95);
  StudFull.Report
end.
