program applicants;
uses printer;
{prints names of applicants with the needed skills}
type skills = (Algol, BASIC, COBOL, FORTRAN, Pascal);
     SkillSetType = set of skills;
     str7 = string[7];
var ApplicantSkills, NeededSkills: SkillSetType;
    name: string[20];

function TRANSLATE (skill: skills): str7;
  {translates enumerated type value into string value}
  begin
    case skill of
      Algol   : TRANSLATE := 'Algol';
      BASIC   : TRANSLATE := 'BASIC';
      COBOL   : TRANSLATE := 'COBOL';
      FORTRAN : TRANSLATE := 'FORTRAN';
      Pascal  : TRANSLATE := 'Pascal'
    end {case}
  end; {TRANSLATE}

procedure CREATE_SET (var SkillSet: SkillSetType);
  {interactively creates skill set of applicant}
  var skill: skills;
      ans: char;
  begin
    SkillSet := [];
    for skill := Algol to Pascal do
      begin
        write ('Does the applicant know ');
        writeln (TRANSLATE (skill), '?  (Y/N) ');
        readln (ans);
        if ans in ['y', 'Y'] then
          SkillSet := SkillSet + [skill]
      end {for}
  end; {CREATE_SET}

begin {main}
  NeededSkills := [Basic, COBOL, Pascal];
  write ('enter name of applicant or xyz to stop ');
  readln (name);
  while name <> 'xyz' do
    begin
      CREATE_SET (ApplicantSkills);
      if ApplicantSkills >= NeededSkills
        then writeln (lst,name);
      write ('Enter name of applicant or xyz to stop ');
      readln (name)
    end {while}
end.