program ch26_p449;
type
  str20 = string[20];
  ListPtr = ^NodeType;
  NodeType = record
    name: string[20];
    next: ListPtr
  end; {NodeType}
var head, last, extra, prev, curr, ptr: ListPtr;
    KeyName: string[20];
    NameFile: text;

procedure SEARCH (head: ListPtr;
                  KeyName: str20;
                  var prev, curr: ListPtr;
                  var OnList: boolean);
  var done: boolean;

  begin
    curr := head;
    prev := nil;
    done := false;
    OnList := false;
    while (not done) and (curr <> nil) do
      if KeyName > curr^.name then
        begin
          prev := curr;
          curr := curr^.next
        end
      else
        begin
          done := true;
          if KeyName = curr^.name then OnList := true
        end
  end; {SEARCH}

procedure INSERT (var head: listPtr;
                  KeyName: str20);
  {Inserts keyname into ordered linked list if keyname is new}
  var prev, curr, betw: ListPtr;
      OnList: boolean;

  begin
    SEARCH (head, KeyName, prev, curr, OnList);
    if OnList then
      writeln (KeyName, ' is already on list')
    else
      begin
        new (betw);                   {create new node}
        betw^.name := KeyName;        {put KeyName in }
        if curr = head then
          begin                       {insert at head of list}
            betw^.next := head;       {attach betw on its right}
            head := betw              {on its left}
          end {then}
        else
          begin                       {insert at middle or end}
            betw^.next := curr;       {attach betw on its right}
            prev^.next := betw        {on its left}
          end {else}
      end {main else}
  end; {INSERT}

begin {main}
  assign (NameFile, 'name2.dat');
  reset (NameFile);
  head := nil;
  while not seekeof (NameFile) do
    if head = nil then
      begin
        new (head);
        readln (NameFile, head^.name);
        last := head
      end
    else
      begin
        new (extra);
        readln (NameFile, extra^.name);
        last^.next := extra;
        last := extra
      end;
  if head <> nil then last^.next := nil;
  close (NameFile);
  write ('which name to insert ');
  readln (Keyname);
  INSERT (head, KeyName);
  ptr := head;
  while ptr <> nil do
    begin
      writeln (ptr^.name);
      ptr := ptr^.next
    end
end.
