program SearchClass;
{presents user with a menu from which to select}
{desired type of list}
const maxsize = 30;
type
  studentrec = record
     name: string[20];
     major: string[4];
     grade: char
  end; {studentrec}
  classtype = array [1..maxsize] of studentrec;
var
  class: classtype;
  size, choice: integer;

procedure GETDATA (var class: classtype;
                   var size: integer);
  {reads from file into array of records}
  var fileA: text;
      i: integer;
  begin
    assign (fileA, 'class.dat');
    reset (fileA);
    i := 0;
    while not seekeof (fileA) do
      begin
        i := i + 1;
        with class[i] do
          begin
            readln (fileA, name);
            readln (fileA, major);
            readln (fileA, grade)
          end {with}
      end; {while}
    size := i;
    close (fileA)
  end; {GETDATA}

procedure PRINTMENU;
  begin
    writeln ('MENU OF CHOICES');
    writeln ('  1. All students with a given major');
    writeln ('  2. All students with a given grade');
    writeln ('  3. Quit')
  end; {PRINTMENU}

procedure HAVING_MAJOR (class: classtype;
                        size: integer);
  {User inputs a major.  Procedure prints list of all}
  {students having that major}
  var stud: integer;
      WantedMajor: string[4];
  begin
    writeln ('Enter first four letters (all capitals)');
    write ('of desired major ');
    readln (WantedMajor);
    writeln ('  List of ', WantedMajor, ' Majors ');
    for stud := 1 to size do
      with class[stud] do
        if major = WantedMajor then
          writeln (name, '  ', grade)
  end; {HAVING_MAJOR}


procedure HAVING_GRADE (class: classtype;
                        size: integer);
  {User inputs a grade.  Procedure prints list of all}
  {students having that grade}
  var stud: integer;
      WantedGrade: char;
  begin
    writeln ('Enter desired grade in capital ');
    readln (WantedGrade);
    for stud := 1 to size do
      with class[stud] do
        if grade = WantedGrade then
          writeln (name, ' ', major)
  end; {HAVING_GRADE}

begin {main}
  GETDATA (class, size);
  PRINTMENU;
  repeat
    write ('Enter choice ');
    readln (choice);
    case choice of
      1: HAVING_MAJOR (class, size);
      2: HAVING_GRADE (class, size);
      3: {quit the loop}
      else writeln ('invalid choice -- choose again')
    end; {case}
    writeln;
  until choice = 3
end.



