{$R+}
program ReadAndInsert;
{reads in alphabetized list}
{adds input name and prints sorted list}
uses printer;
const maxsize = 50;
type EntryType = string[15];
     listtype = array[1..maxsize] of EntryType;
var i, size: integer;
    name: EntryType;
    list: listtype;

procedure GETFILE (var list: listtype;
                   var size: integer);
  {reads contents of file into an array}
  var NameFile: text;
  begin
    assign (NameFile, 'info.dat');
    reset (NameFile);
    size := 0;
    while not seekeof (NameFile) do
      begin
        size := size + 1;
        readln (NameFile, list[size])
      end; {while}
    close (NameFile)
  end; {GETFILE}

procedure INSERTING (entry: EntryType;
                     var list: listtype;
                     var size: integer);
  {inserts into a sorted array}
  {resulting array is still sorted}
  var i, spot: integer;
      SpotFound: boolean;
  begin
    {locate spot}
    SpotFound := false;
    spot := 1;
    while (not SpotFound) and (spot <= size) do
      if entry <= list[spot]
        then SpotFound := true
        else spot := spot + 1;

    {shift to make room for new entry}
    for i := size downto spot do
      list[i + 1] := list[i];

    size := size + 1;    {update size}
    {put new entry into list[spot]}
    list[spot] := entry
  end; {INSERTING}

begin {main}
  GETFILE (list, size);
  write ('Enter name or xyz to quit ');
  readln (name);
  while (name <> 'xyz') and (size < maxsize) do
    begin
      INSERTING (name, list, size);
      write ('Enter name or xyz to quit ');
      readln (name)
    end; {while}
  if name <> 'xyz' then
    writeln ('Array full. Cannot add ', name);

  {print final list}
  writeln (lst, 'Final List');
  for i := 1 to size do
    writeln (lst, list[i])
end.

