(******************************************************************************)
(*                       ALLFIX 4.31 sample procedures                        *)
(*          Copyright (C) 1992,93,94 Harald Harms, all rights reserved        *)
(*                                                                            *)
(*                 All information in this documentation is                   *)
(*                  subject to change without prior notice                    *)
(******************************************************************************)

Uses Types;

Procedure ReadStatFile;

  (* This procedure demonstrates how to read the STATFILE.FIX file *)

  Var Index, Data : file;
      Cnt,
      Nr          : word;
      Rec         : StatisticRecord;
      Idx         : StatisticIndex;
      Node        : NetAddress;

  Begin
    WriteLn('Reading STATFILE.FIX');

    Assign(Index, 'STATFILE.IDX');
    Reset(Index, Sizeof(Idx));

    Assign(Data, 'STATFILE.FIX');
    Reset(Data, 1);

    Blockread(Index, Idx, 1, Nr);
    While Nr > 0 Do
    Begin
      Seek(Data, Index.Offset);
      Blockread(Data, Rec, Sizeof(Rec), Nr);

      WriteLn('File echo : ', Rec.FileEcho);
      WriteLn('File name : ', Rec.FileName);
      WriteLn('Downlinks : ');

      For Cnt := 1 to Rec.NumDown Do
      Begin
        Blockread(Data, Node, Sizeof(Node), Nr);
        WriteLn('            ', Node.Zone,':', Node.Net, '\', Node.Node, '.', Node.Point);
      End;

      Blockread(Index, Idx, 1, Nr);
    End;

    Close(Index);
    Close(Data);
  End;

