.386
.model small
.stack 100
locals
jumps
    
include disk.inc

vr  macro
local l1,l2
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2

endm

include mouse.inc

_CODE segment para public USE16
assume cs:_CODE

start:

   mov ax,0013h
   int 10h

   mov ax,cs
   mov ds,ax
   mov dx,offset bin_file
   mov ax,3d00h
   int 21h                       ; open file

   mov bx,ax
   mov ax,0a000h
   mov ds,ax
   xor dx,dx
   mov cx,64000
   mov ah,3fh
   int 21h                       ; read file to screen

   mov ax,cs
   mov ds,ax
   mov dx,offset pal
   mov cx,768
   mov ah,3fh
   int 21h                       ; read pal

   mov ah,3eh
   int 21h                 ;  close file

   mov ax,cs
   mov ds,ax
   mov si,offset pal
   mov cx,768
   mov dx,03c8h
   mov al,0
   out dx,al
   inc dx
   rep outsb

   call _init_mouse
   call createfile

   intro:
   vr

   call update_mouse
   jnz button

   mov ah,1
   int 16h
   jz intro
   jmp gone
   
   button:
   mov al,cs:[mouse_b]
   dec al
   or al,al
   jz w4r                        ; this means it was button 1 so goto save part
   
   w4rR:
   mov al,cs:[mouse_b]
   or al,al
   jnz w4rR                         ; wait for them to get off the mouse button

   not cs:[switch]
   jmp intro
      
   w4r:
   mov al,cs:[mouse_b]
   or al,al
   jnz w4r                          ; wait for them to get off the mouse button

   mov al,cs:[switch]
   or al,al
   jz t16x16                           ; zero switch means save 16x16 tile..

   ; Save a sprite
   mov ax,320
   xor dx,dx
   mul cs:[mouse_y]
   add ax,cs:[mouse_x]
   mov dx,ax
   mov ax,0a000h
   mov ds,ax
   call restore_old
   call save_sprite
   jmp intro

   t16x16:
   mov ax,320
   xor dx,dx
   mul cs:[mouse_y]
   add ax,cs:[mouse_x]
   mov dx,ax
   mov ax,0a000h
   mov ds,ax
   call restore_old
   call save_16x16
   jmp intro

gone:
   call closefile

   mov ax,0003h
   int 10h

   mov ax,4c00h
   int 21h

bin_file db 'capture.bin',0
pal      db 768 dup (0)

last_x   dw 0
last_y   dw 0
switch   db 0


update_mouse   proc

   call restore_old           ; restore old gfx under mouse

   mov ax,cs:[mouse_x]
   mov cs:[last_x],ax
   mov ax,cs:[mouse_y]
   mov cs:[last_y],ax

   mov ax,320
   xor dx,dx
   mul cs:[mouse_y]
   add ax,cs:[mouse_x]

   push ax
   
   mov si,ax
   mov di,offset saved
   mov ax,cs
   mov es,ax
   mov ax,0a000h
   mov ds,ax
   
   rept 16
   movsd
   movsd
   movsd
   movsd
   add si,320-16
   endm

   mov ax,0a000h
   mov es,ax
   mov ax,cs
   mov ds,ax
   pop di                              ; pushed as AX
   
   mov al,cs:[switch]
   shr al,4
   add al,40
   mov ah,al
   push ax
   shl eax,16
   pop ax
   ;mov eax,30303030h
      
   rept 16
   add dword ptr es:[di+0],eax
   add dword ptr es:[di+4],eax
   add dword ptr es:[di+8],eax
   add dword ptr es:[di+12],eax
   add di,320
   endm

   mov al,cs:[mouse_b]
   or al,al
   ret

saved    db 256 dup (0)
;cursor   db 64 dup (0)
cursor dd 000000010h,000000000h,000101114h,000000000h,01011101Ah,000000010h,010101800h,000101010h
 dd 010180000h,010101010h,019000000h,010101010h,000000000h,000101017h,000000000h,000001700h

update_mouse   endp
   
restore_old    proc  

   push cx dx bx ds es
   
   ; restore screen at old position  
   mov ax,320
   xor dx,dx
   mul cs:[last_y]
   add ax,cs:[last_x]
   mov di,ax
   mov ax,0a000h
   mov es,ax
   mov ax,cs
   mov ds,ax
   mov si,offset saved

   rept 16
   movsd
   movsd
   movsd
   movsd
   add di,320-16
   endm

   pop es ds bx dx cx
   ret

restore_old endp

_CODE ends
end start
