.386
.model small

include sprite.inc

locals
jumps

public createfile,closefile,save_16x16,save_sprite

_CODE  segment para public USE16
assume cs:_CODE

createfile proc

   pusha

   mov ax,cs
   mov ds,ax
   mov dx,offset filename
   mov ah,03ch
   mov cx,0
   int 21h                          ; create file
   jc error
   mov cs:[handle],ax
   
   error:                           ; he.. error handling can get fucked..

   popa
   ret

createfile endp

filename db 'tiles.res',0
handle   dw 0

closefile   proc

   pusha

   mov bx,cs:[handle]
   mov ah,3eh
   int 21h

   popa
   ret

closefile   endp

save_16x16  proc        ; DS:DX = start of graphic to save

   pusha

   mov cx,16
   rows:
   push cx
   
   mov bx,cs:[handle]
   mov cx,16
   mov ah,40h
   int 21h              ; write out a row
   add dx,320-16

   pop cx
   loop rows

   popa
   ret

save_16x16  endp

save_sprite proc     ; ds:si start of 16x16 sprite... alternate sizes l8r

   pusha
   
   mov si,dx

   mov ax,cs
   mov es,ax
   mov di,offset spr_data

   xor ah,ah                     ; our filled run counter   
   xor cx,cx                     ; our total x counter
   xor bx,bx                     ; our total y counter
   xor dx,dx                     ; our gap counter (could be down a
                                 ;              line to so needs a WORD

   jmp start_sprite              ; sprite has to start with a blank..
                                 ; even it is a 0..

   do_FILLED:                    ; Doing a filled run
   
   inc ah                        ; increment fill counter
   inc cx                        ; .. total x counter
   cmp cx,16   ; MAX_X
   jae FILLhitedge 
      
   lodsb
   cmp al,CLEAR_CLR
   jne do_FILLED
   jmp short saveRUN

   FILLhitedge:

   shr ax,8                   ; don't need AL.. convert RUNlength to WORD
   sub si,ax                  ; get back to the start of the run.
   ;dec ax                     ; seems to end up one extra NOT!
   mov cx,ax                  ; put it in CX (for movsb)
   stosb                      ; save the runlength
   rep movsb                  ; save the run data

   mov dx,SCR_WIDTH
   sub dx,16
   add si,dx
   xor cx,cx
   xor ah,ah

   inc bx
   cmp bx,16   ; MAX_Y
   jae finished_sprite

   lodsb
   cmp al,CLEAR_CLR
   je do_BLANK
   mov es:[di],dx
   add di,2
   xor dx,dx
   jmp short do_FILLED

   saveRUN:

   push cx                    ; save the total x counter
   shr ax,8                   ; don't need AL.. convert RUNlength to WORD
   sub si,ax                  ; get back to the start of the run.
   dec si                     ; also an extra CLEAR_CLR to skip
   ;dec ax                     ; seems to end up one extra NOT!
   mov cx,ax                  ; put it in CX (for movsb)
   stosb                      ; save the runlength
   rep movsb                  ; save the run data
   pop cx                     ; and back comes our total x counter

   xor ah,ah                  ; clear that run length

   lodsb                      ; that should be our CLEAR_CLR.. 
                              ; so we just drop right thru..

   do_BLANK:                     ; Doing a blank run (gap)
   
   inc dx                        ; increment empty counter
   inc cx                        ; .. total x counter
   cmp cx,16  ; MAX_X               
   jb  dont_add_a_line
   
   mov ax,SCR_WIDTH              ; width of the screen.. usually 320 but ..
   sub ax,16                     ; down a line means si = si+320-current x
   add si,ax         
   xor cx,cx                     ; we're back to left part now, reset total x
   ;sub ax,16  ; MAX_X
   add dx,ax                     ; add a whole line on the empty counter
   
   inc bx
   cmp bx,16   ; MAX_Y
   jae finished_sprite

   xor ah,ah                     ; in case we goto RUNS next..
   
   dont_add_a_line:
   start_sprite:
   
   lodsb
   cmp al,CLEAR_CLR              ; is it a blank lot ?
   jz do_BLANK                   ; yep.. goto blank counting code

   mov es:[di],dx                ; nup.. save the blank word, scan the fill..
   add di,2
   xor dx,dx                     ; clear that gap counter
   
   jmp do_FILLED

   finished_sprite:
   xor ax,ax                     ; it'll be looking for a blank here.
   stosw                         ; so give em a zero
   stosb                         ; and a zero-length file to let em know
                                 ;           we're finished

   mov ax,cs
   mov ds,ax
   mov bx,cs:[handle]
   mov dx,offset spr_data
   sub di,offset spr_data        ; gives us the length of the sprite
   mov cx,di
   mov ah,40h
   int 21h              ; write that sprite

   ; here have code to write out the offsets of sprites for a resource file
   
   popa
   ret

save_sprite endp

spr_data db 512 dup (0)

redraw_for_modeX  proc        ; DS:SI = start of 16x16 block to redraw

   pusha
   push ds es

   mov ax,0a000h
   mov es,ax
   xor di,di

   mov cx,4
   planes:
   push cx si di

   mov cx,4
   rd_cols:
   push cx si di
   mov cx,16 
   rd_rows:
   movsb
   add di,320-1
   add si,320-1
   loop rd_rows
   pop di si cx 
   inc di
   add si,4
   loop rd_cols

   pop di si cx
   add di,4
   inc si
   loop planes

   pop es ds
   popa
   ret

redraw_for_modeX  endp

_CODE ends
end
