/*
 *  Program: extract -- a Portable Game Notation (PGN) extractor.
 *  Copyright (C) 1994 David Barnes
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  David Barnes may be contacted as D.J.Barnes@ukc.ac.uk
 *
 */
	/* Define indices into the Details[] tag record. */

/* List the tags of the Seven Tag Roster in order. */
#define EVENT_TAG 0
#define SITE_TAG 1
#define DATE_TAG 2
#define ROUND_TAG 3
#define WHITE_TAG 4
#define BLACK_TAG 5
#define RESULT_TAG 6
#define ECO_TAG 7
#define WHITE_TITLE_TAG 8
#define BLACK_TITLE_TAG 9
#define WHITE_ELO_TAG 10
#define BLACK_ELO_TAG 11
#define WHITE_USCF_TAG 12
#define BLACK_USCF_TAG 13
#define WHITE_NA_TAG 14
#define BLACK_NA_TAG 15
#define WHITE_TYPE_TAG 16
#define BLACK_TYPE_TAG 17
#define ANNOTATOR_TAG 18
/* The following _TAG is not a real PGN one.  It is used with the -t
 * argument so that it becomes possible to indicate a player of either colour.
 */
#define PSEUDO_PLAYER_TAG 19
/* The following should always be last, and not used. */
#define LAST_TAG 20

/* The following must use the largest proper _TAG number +1 as it
 * is used to define the Details array.
 */
#define NUM_TAGS (LAST_TAG)
