;***********************************************************************
;*            Real Weather Pilot - (C) 1993-1994 TekMate               *                                                            *
;*                                                                     *
;* A sample ASPECT script file for logging onto CompuServe via local   *
;* CIS number using ProComm Plus - DataStorm Technologies.             *
;* Acquires aviation weather for BOS, JFK, ORD, LAX, SFO, SEA          *
;*                                                                     *
;* As a user, you need to make up your own AIRPORT list and CIS.LOG.   *
;***********************************************************************
;
;***********************************************************************
; The following three defines should be customized with the dialing    *
; directory entry for your local CIS number, your CompuServe ID, and   *
; your CompuServe password.  The rest of the script should need no     *
; modification.  COMPILE WITH ASPCOMP.EXE before using.                *
;***********************************************************************
                              ;=========================================
                              ; #1 refers to your dialing directory entry
                              ; may be any number in your's
define CIS_NUMBER "1"         ; make sure entry is full duplex, VT102 term
define ID "77777,7777"        ; your ID number goes here
define PASSWORD "MY PASSWORD" ; your password goes here
                              ;=========================================
proc main                                       ; start of main procedure
   clear                                        ; clear screen
   locate 0 0                                   ; locate cursor at 0,0
   box 0 0 4 29 14                              ; draw box
   atsay 2 2 14 "Logging onto COMPUSERVE..."    ; put message in box
   locate 6 0                                   ; cursor to row 6
   if not fromddir                              ; if not via Dial Dir link
      dial CIS_NUMBER                           ; use dialing directory entry
   endif
   pause 3                    ; wait three seconds
   transmit "^C"              ; transmit CTRL-C
   waitfor "User ID:"         ; wait for "User ID:" to come in COM port
   transmit ID                ; send your ID
   transmit "^M"              ; send carriage return
   waitfor "Password:"        ; wait for "Password:" to come in COM port
   transmit PASSWORD          ; send password
   transmit "^M"              ; send carriage return
   waitfor "!" 60             ; wait for CompuServe prompt
   transmit "g wea^M"         ; go to WEATHER forum

                              ;TURN ON CAPTURE LOG HERE ===============
   log open "C:\RWP\CIS.LOG"                     ;My raw CIS log file
   waitfor "choice"                              ;DELETE THE OLD ONE. IT
                                                 ;APPENDS to old ones.
   transmit "9^M"                                ;Select AVIATION WX
   waitfor "choice"                              ;Select FT,SA,FDLO/U
   transmit "FT BOS,JFK,ORD,LAX,SFO,SEA;SA `";FDLO/U `"^M"
   waitfor "choice"
   transmit "BYE^M"
endproc                       ; end of main procedure
