echo off
cls
if "%1" == "" goto BAD_PARAMETER

if "%1" == "VESA" goto PARAMETER_OK
if "%1" == "vesa" goto PARAMETER_OK

if "%1" == "ATI" goto PARAMETER_OK
if "%1" == "ati" goto PARAMETER_OK

if "%1" == "VIDEO7" goto PARAMETER_OK
if "%1" == "video7" goto PARAMETER_OK

if "%1" == "TSENG" goto PARAMETER_OK
if "%1" == "tseng" goto PARAMETER_OK

if "%1" == "TRIDENT" goto PARAMETER_OK
if "%1" == "trident" goto PARAMETER_OK

if "%1" == "PARADISE" goto PARAMETER_OK
if "%1" == "paradise" goto PARAMETER_OK

if "%1" == "S3" goto PARAMETER_OK
if "%1" == "s3" goto PARAMETER_OK

if "%1" == "CIRRUS" goto PARAMETER_OK
if "%1" == "cirrus" goto PARAMETER_OK

if "%1" == "TRIDENTA" goto PARAMETER_OK
if "%1" == "tridenta" goto PARAMETER_OK

if "%1" == "NONE" goto PARAMETER_OK
if "%1" == "none" goto PARAMETER_OK

:BAD_PARAMETER
echo To run this program, please type:
echo       FRAMERAT mode
echo where "video" is the SVGA (640 x 400) setting you use for FS5:
echo   VESA       = VESA 1.2 Compatible
echo   ATI        = ATI VGA Winder +/XL
echo   VIDEO7     = Video 7
echo   TSENG      = Tseng 4000
echo   TRIDENT    = Trident 8900
echo   PARADISE   = Paradise SVGA
echo   S3         = S3 86C911
echo   CIRRUS     = Cirrus Logic 542X
echo   TRIDENTA   = Trident Alternate
echo   NONE       = No SVGA mode -- Standard VGA only (320 x 400)
goto   END

:PARAMETER_OK
echo **********************************************************
echo *     Flight Simulator 5.0 Frame Rate Test
echo *          Created by Steve Wigginton
echo *      CompuServe Flight Simulation Forum
echo *                 GO FSFORUM
echo **********************************************************
echo .
echo This test will configure Flight Simulator 5.0 with a special frame
echo rate counter and will start FS5 in various configurations to test
echo video performance.  
echo .
echo You will see a view of downtown Chicago.  This is view number 1.
echo After about 30 seconds, the view will pan away from downtown.
echo This is the second view.  The ADF will show either 001 or 002 depending 
echo on the view. The 2 views will repeat until you press CTRL-BREAK.
echo .
echo Look at the number displayed in the Transponder.  This is the frame
echo rate for the current view.  Note this number for each test.  It may
echo take a moment for the number to calm down.  If it fluctuates between 
echo 2 numbers, use the average.  For example, if it varies between 6 and 7, 
echo use 6.5.
pause

cls
echo .
echo            ****** TEST SCENARIO #1 ********
echo First, we'll start with very sparse scenery.
echo There is a 30 second delay between the 2 views.
echo .
echo Record the frame rate for the 2 views.  Then press CTRL-BREAK.
echo NOTE: Only press CTRL-BREAK once to exit FS5.
echo .
echo To stop the test now, press CTRL-BREAK and answer Y to the prompt.
pause

cls
echo          ******** Beginning Test 1 *********
echo .
echo Copying files...
echo If you see any errors, something went wrong.

REM ===== Create the \FRAME directory =====
if exist FRAME\NUL goto SKIP_DIRECTORY
md FRAME
:SKIP_DIRECTORY

REM ===== Extract the other test files =====
copy FRAME2.EXE FRAME
cd FRAME
FRAME2
del FRAME2.EXE

REM ===== Save original FS5.INI ===== 
copy ..\FS5.INI *.*
if not exist FS5.INI goto NO_FS5_INI

copy *.STN ..\PILOTS\*.*
copy *.VID ..\PILOTS\*.*

REM ===== Test begins here ===== 
copy VGA.IN1 FS5.XXX
type SPARSE.IN2 >> FS5.XXX
copy FS5.XXX ..\FS5.INI
echo Starting Flight Simulator...
cd..
FS5

REM ===== Put back old INI file in case user breaks out here. ===== 
cd FRAME
copy FS5.INI ..\*.*

cls
echo            ****** TEST SCENARIO #2 ********
echo .
echo Now, we'll do the same test, but with more scenery displayed.
echo There is a 30 second delay between the 2 views.
echo .
echo Record the frame rate for the 2 views.  Then press CTRL-BREAK.
echo NOTE: Only press CTRL-BREAK once to exit FS5.
echo .
echo To stop the test now, press CTRL-BREAK and answer Y to the prompt.
pause
cls
echo          ******** Beginning Test 2 *********
echo .
echo Copying files...
echo If you see any errors, something went wrong.
copy VGA.IN1 FS5.XXX
type DENSE.IN2 >> FS5.XXX
copy FS5.XXX ..\fs5.ini
echo Starting Flight Simulator...
cd..
FS5

REM ===== Put back old INI file in case user breaks out here. ===== 
copy FRAME\FS5.INI ..\*.*

REM ===== SVGA Mode Testing begins here =====
REM ===== Don't do SVGA test if user specified "none"
if "%1" == "NONE" goto CLEAN_UP
if "%1" == "none" goto CLEAN_UP

cls
echo            ****** TEST SCENARIO #3 ********
echo .
echo Now, we'll try SVGA mode with sparse scenery
echo There is a 30 second delay between the 2 views.
echo .
echo Record the frame rate for the 2 views.  Then press CTRL-BREAK.
echo NOTE: Only press CTRL-BREAK once to exit FS5.
echo .
echo To stop the test now, press CTRL-BREAK and answer Y to the prompt.
pause
cls
echo          ******** Beginning Test 3 *********
echo .
echo Copying files...
echo If you see any errors, something went wrong.
cd FRAME
copy SVGA.IN1 FS5.XXX
if "%1" == "VESA" echo>>FS5.XXX SVGA_BOARD=000
if "%1" == "vesa" echo>>FS5.XXX SVGA_BOARD=000
if "%1" == "ATI" echo>>FS5.XXX SVGA_BOARD=001
if "%1" == "ati" echo>>FS5.XXX SVGA_BOARD=001
if "%1" == "VIDEO7" echo>>FS5.XXX SVGA_BOARD=002
if "%1" == "video7" echo>>FS5.XXX SVGA_BOARD=002
if "%1" == "TSENG" echo>>FS5.XXX SVGA_BOARD=003
if "%1" == "tseng" echo>>FS5.XXX SVGA_BOARD=003
if "%1" == "TRIDENT" echo>>FS5.XXX SVGA_BOARD=004
if "%1" == "trident" echo>>FS5.XXX SVGA_BOARD=004
if "%1" == "PARADISE" echo>>FS5.XXX SVGA_BOARD=005
if "%1" == "paradise" echo>>FS5.XXX SVGA_BOARD=005
if "%1" == "S3" echo>>FS5.XXX SVGA_BOARD=006
if "%1" == "s3" echo>>FS5.XXX SVGA_BOARD=006
if "%1" == "CIRRUS" echo>>FS5.XXX SVGA_BOARD=007
if "%1" == "cirrus" echo>>FS5.XXX SVGA_BOARD=007
if "%1" == "TRIDENTA" echo>>FS5.XXX SVGA_BOARD=008
if "%1" == "tridenta" echo>>FS5.XXX SVGA_BOARD=008
type SPARSE.IN2 >> FS5.XXX
copy FS5.XXX ..\fs5.ini
echo Starting Flight Simulator...
cd..
FS5

REM ===== Put back old INI file in case user breaks out here. ===== 
cd FRAME
copy FS5.INI ..\*.*

cls
echo            ****** TEST SCENARIO #4 ********
echo .
echo For the last test, we'll try SVGA mode with dense scenery
echo There is a 30 second delay between the 2 views.
echo .
echo Record the frame rate for the 2 views.  Then press CTRL-BREAK.
echo NOTE: Only press CTRL-BREAK once to exit FS5.
echo .
echo To stop the test now, press CTRL-BREAK and answer Y to the prompt.
pause
cls
echo          ******** Beginning Test 4 *********
echo .
echo Copying files...
echo If you see any errors, something went wrong.
copy SVGA.IN1 FS5.XXX
if "%1" == "VESA" echo>>FS5.XXX SVGA_BOARD=000
if "%1" == "vesa" echo>>FS5.XXX SVGA_BOARD=000
if "%1" == "ATI" echo>>FS5.XXX SVGA_BOARD=001
if "%1" == "ati" echo>>FS5.XXX SVGA_BOARD=001
if "%1" == "VIDEO7" echo>>FS5.XXX SVGA_BOARD=002
if "%1" == "video7" echo>>FS5.XXX SVGA_BOARD=002
if "%1" == "TSENG" echo>>FS5.XXX SVGA_BOARD=003
if "%1" == "tseng" echo>>FS5.XXX SVGA_BOARD=003
if "%1" == "TRIDENT" echo>>FS5.XXX SVGA_BOARD=004
if "%1" == "trident" echo>>FS5.XXX SVGA_BOARD=004
if "%1" == "PARADISE" echo>>FS5.XXX SVGA_BOARD=005
if "%1" == "paradise" echo>>FS5.XXX SVGA_BOARD=005
if "%1" == "S3" echo>>FS5.XXX SVGA_BOARD=006
if "%1" == "s3" echo>>FS5.XXX SVGA_BOARD=006
if "%1" == "CIRRUS" echo>>FS5.XXX SVGA_BOARD=007
if "%1" == "cirrus" echo>>FS5.XXX SVGA_BOARD=007
if "%1" == "TRIDENTA" echo>>FS5.XXX SVGA_BOARD=008
if "%1" == "tridenta" echo>>FS5.XXX SVGA_BOARD=008
type DENSE.IN2 >> FS5.XXX
copy FS5.XXX ..\fs5.ini
echo Starting Flight Simulator...
cd..
FS5
goto CLEAN_UP

:NO_FS5_INI
cls
echo Could not find original FS5.INI.
echo Please run the test file from your Flight Simulator 5 directory.
echo Usually, this is C:\FLTSIM5
goto END

REM ===== Must be in FS5 Subdirectory here =====
:CLEAN_UP
cls
echo Restoring original configuration.
copy FRAME\FS5.INI *.*
echo Cleaning up files...
del FRAME < FRAME\YES.PMT >NUL
rd FRAME
del PILOTS\FRAME*.*

echo .
echo All Done!!  
:END
