;  This script is for use with the Trade Wars Assistant by Albin Gersich,
;but the information it obtains can be used with a number of Trade Wars
;utilities.  It was compiled and tested with Procomm Plus for Dos, version
;2.01.  I'm not sure of it's compatibility with Procomm Plus for Windows.
;  This script is released to the public domain.  The author of this script
;will in no way be held liable for any damage or harm of any kind.  This
;script has been tested extensively by myself, and so is as bug free as
;possible, but nothing is absolutely 100% safe.  Let the buyer beware!
;  The script captures your CIM port and sector reports, fighter, mines,
;avoids, and the game status in a variety of ways.  You can also use it to
;access TW Assistant easily while online.
;  The macro was designed so that you don't have to capture a complete data
;file all the time.  Often times, you only want to capture the latest port
;information, or update your fighter info in the database for transwarp
;calculations while online.  I wanted to do these things quickly and
;efficiently, so I took the heart of Casey Stemp's macro and greatly
;expanded on it.
;  Everything is accessed through the main menu.  When you run the macro,
;the menu will be displayed with the items and their hot-keys.  To access
;an item, just press the appropriate hotkey.  Each menu item is explained
;below:
;
;  "<A>ssistant" - This takes you directly to Trade Wars Assistant.  It
;skips the checking for old capture files so they remain intact.  Note,
;too, that it calls the program with no parameters, so you can enter the
;database name if you keep multiple databases.  If not, you can edit the
;macro to load a particular database each time.
;
;  "<B>oth F,M,A, & Port rep." - This creates a capture file with just the
;CIM port report, fighters, mines, and avoids.  Read the next two sections
;for more information.  Note too that this, like all the capturing menu
;items, checks for old capture files first and erases them if found.
;
;  "<P>ort report" - This accesses the CIM (Computer Interrogation Mode) of
;your Cray XXV (ship computer) and captures the newest port information.
;
;  "<F>ighters, mines, avoids" - This produces a capture file of the three
;things listed.  Great for updating your database for online calculations
;after deploying a lot of new fighters or mines (or after those fighters or
;mines have been destroyed).
;
;  "<C>omplete capture file" - This captures everything if you want to
;create a new database, or update all your database information.  This is
;the only menu item that will capture your CIM sector information and your
;game status.  Since I explore my universe completely and very quickly (in
;two days), I never need to update my sector info.  And I rarely bother
;updating my game status information, so I put them here.  I'm sorry if you
;have different needs.  If there's a demand, then I could revise the script
;for a future version.
;
;    Some notes:
;
;  - I recommend setting up the macro as a Meta Key (an Alt-Key
;    combination) for quick and smooth access.  You can put the script file
;    in any directory, just specify the correct path to the macro in the
;    Meta Key definition.  The script will automatically save your current
;    directory, switch to the directory which contains your Trade Wars
;    Assistant files, and switch back to the original directory when
;    finished.
;  - I designed the macro to use the same WAITFOR and TRANSMIT commands to
;    reduce size, giving the macro a kind of "spaghetti" look.  It runs
;    very smoothly, however.
;
;  - When checking for the hotkey presses, it looks for the escape key for
;    quick exiting in case you access the macro accidentally (enter the
;    wrong Alt-Key combination).  When this is done, it skips the checking
;    for old capture file to maintain capture file integrity.
;
;  - When you select a menu item, it displays the the macro name in bold
;    letters on the screen and pauses for 750 milliseconds (3/4ths of a
;    second), then continues with the macro.
;
;  - Make sure you run the macro from the main Trade Wars command line, and
;    not from the Computer command line, for proper operation.
;
;
;  The script is easily customizable as well.  Especially with the Aspect
;Script Language reference.  You can change colors, move menu items around,
;change the item titles and hotkeys, and edit the directory information,
;the pause time, or capture file name.  I'll indicate sections where you
;might want to customize.  Any necessary or important customization sections
;will be indicated by "***" followed by all capitals.
;
;  *** NOTE! ***  There is one area you MUST change for proper operation!
;This is the directory which contains your TW Assistant executable and
;data files.  They should BOTH be in the same directory.  I put the macro
;in a separate directory, but you can keep everything in one directory if
;you like.
;
;
;  Here's the macro:


PROC MAIN
  CLEAR
 MENU:
  BOX 1 22 9 55 49                  ; Edit colors and box size here
  ATSAY 2 27 48 "<A>ssistant"                  ;
  ATSAY 3 27 48 "<B>oth F,M,A, & Port rep."    ;  Edit the titles or
  ATSAY 4 27 48 "<P>ort report"                ; hotkeys here
  ATSAY 5 27 48 "<F>ighters, mines, avoids"    ;  (Read further if you
  ATSAY 6 27 48 "<C>omplete capture file"      ; edit the hotkeys)
  ATSAY 8 25 49 "Enter macro choice : "
  LOCATE 8,46
  KEYGET N1
  IF N1 == 27    ; Looks for the escape key
    GOTO END
  ENDIF
  KEY2ASCII N1 S1
  STRUPR S1
  CLEAR
  ;                       *** YOU MUST CHANGE THIS NEXT LINE!! ***
  ASSIGN S2 "C:\PCPLUS\TW"  ; This is the path to your TW Assist files
  GETDIR 0 S3  ; Stores current directory
  CHDIR S2     ; Switches to the TW Assist directory
  ;
  SWITCH S1
    CASE "A"  ; *** IF YOU CHANGE the hotkeys, do it here as well!!
      RUN "TWASSIST" ; Command that starts TW Assistant. If you want to
      GOTO END       ; auto load a database put "TWASSIST filename"
    CASE "B"  ; *** HOTKEY location
      FATSAY 3 20 31 " B O T H   F, M, A,  &   P O R T   R E P T. "
      MSPAUSE 750    ; Here is the pause time.  Change it if you like
      CLEAR
      CALL OPENFILE
      ASSIGN S1 "P"
      GOTO FTR
    ENDCASE
    CASE "C"  ; *** HOTKEY location
      FATSAY 3 20 31 " C O M P L E T E   C A P T U R E   F I L E "
      MSPAUSE 750
      CLEAR
      CALL OPENFILE
      GOTO CAP
    ENDCASE
    CASE "F"  ; *** HOTKEY location
      FATSAY 3 20 31 " F I G H T E R S,  M I N E S,  A V O I D S "
      MSPAUSE 750
      CLEAR
      CALL OPENFILE
      GOTO FTR
    ENDCASE
    CASE "P"  ; *** HOTKEY location
      FATSAY 3 22 31 " G E T T I N G   P O R T   R E P O R T "
      MSPAUSE 750
      CLEAR
      CALL OPENFILE
      TRANSMIT "C"
      WAITFOR  "Help) ?" FOREVER
      GOTO PRT
    ENDCASE
    DEFAULT
      GOTO MENU
    ENDCASE
  ENDSWITCH
  ;
 CAP:
  TRANSMIT "V"
  WAITFOR  "Help)? " FOREVER
 FTR:
  TRANSMIT "G"
  WAITFOR  "Help)? " FOREVER
  TRANSMIT "K"
  WAITFOR  "Help)? " FOREVER
  TRANSMIT "C"
  WAITFOR  "Help) ?" FOREVER
  TRANSMIT "X"
  WAITFOR  "Help) ?" FOREVER
  STRCMP S1 "F"
  IF SUCCESS
    GOTO Q2
  ENDIF
 PRT:
  TRANSMIT ""
  WAITFOR  ": "      FOREVER
  TRANSMIT "R"
  WAITFOR  ": "      FOREVER
  STRCMP S1 "P"
  IF SUCCESS
    GOTO Q1
  ENDIF
  TRANSMIT "I"
  WAITFOR  ": "      FOREVER
 Q1:
  TRANSMIT "Q"
  WAITFOR  "Help) ?" FOREVER
 Q2:
  TRANSMIT "Q"
  ;
  LOG CLOSE
 END:
  CLEAR
  CHDIR S3       ; Here it switches back to the original directory
  EXIT
ENDPROC

PROC OPENFILE
  FINDFIRST "CAPTURE.TXT"   ;
  IF FOUND                  ;
    DELETE "CAPTURE.TXT"    ; *** CHANGE name of capture file here!
  ENDIF                     ;
  LOG OPEN "CAPTURE.TXT"    ;
ENDPROC


;  Now I'd like to thank the Martins for such a great game, and of course
;Albin Gersich for such an excellent database program, and for all his
;help, listening, and generosity.  Without his utility day-to-day trading
;would be much less enjoyable.
;  And a thank you to Casey Stemp, the author of the original Procomm Plus
;script, for supplying the original from which this script was written, and
;for his initial praise of my efforts.
;  And another thank you goes to Dan Roseen, sysop of The Night Owl BBS in
;Kent, Washington.  He's the one that first told me about Trade Wars
;Assistant and recommended it so enthusiastically.  The Night Owl is an
;excellent source of Trade Wars utilities, as well as a planned beta site
;for TW2002 v2.0.  The number is (206)631-4949.

