/*************************************************/
/*  This file uses the INTERSOLV dbase driver.   */
/*************************************************/
/*
     File:       v2featur.CPP
    
    Revision:   2.0 release

    Date:       9-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
     of the library's new features in version 2.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/

//#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <time.h>
#include <windows.h>

// instantiate an environment.  This allocates
// an ODBC environment handle for the app.
odbcENV env;

// final letter for loops... from 'A' to FINAL_LETTER
#define FINAL_LETTER 'Z'

/* SELECT * FROM TESTV2
*/
// sTESTV2
// AutoBind() struct definition

const int FIRSTNAME_SIZE                   = 21 ;
const int MIDINIT_SIZE                     = 5 ;
const int LASTNAME_SIZE                    = 21 ;

// AutoBind() uses byte alignment when it generates its
// internal structure. pragma pack(1) forces correct alignment.
#pragma pack(1)

 struct sTESTV2 {
  double               dKeyField;
  char                 szFirstName[ FIRSTNAME_SIZE ];
  char                 szMidInit[ MIDINIT_SIZE ];
  char                 szLastName[ LASTNAME_SIZE ];
};


#pragma pack()
// sCOLBIND array definition

static sCOLBIND sTESTV2ColDefs[] = 
{
{ 	1,
	SQL_C_DOUBLE,
	FIELDOFFSET( sTESTV2, dKeyField ),
	8,
	0,
	FALSE,
	"KEYFIELD",
	SQL_NUMERIC,
	4,
	1,
	NULL,

},
{ 	2,
	SQL_C_CHAR,
	FIELDOFFSET( sTESTV2, szFirstName ),
	FIRSTNAME_SIZE, // 21 when we generated...
	0,
	FALSE,
	"FIRSTNAME",
	SQL_CHAR,
	0,
	1,
	NULL,

},
{ 	3,
	SQL_C_CHAR,
	FIELDOFFSET( sTESTV2, szMidInit ),
	MIDINIT_SIZE, // 5 when we generated...
	0,
	FALSE,
	"MIDINIT",
	SQL_CHAR,
	0,
	1,
	NULL,

},
{ 	4,
	SQL_C_CHAR,
	FIELDOFFSET( sTESTV2, szLastName ),
	LASTNAME_SIZE, // 21 when we generated...
	0,
	FALSE,
	"LASTNAME",
	SQL_CHAR,
	0,
	1,
	NULL,

},
};
const int sTESTV2ColDefsCount
	= sizeof(sTESTV2ColDefs) / sizeof(sTESTV2ColDefs[ 0 ]);

static  char szStmtOut[ 5000 ] ;

static  time_t _start, _end ;
    // for timing
static  long seconds = 0L;
static  long minutes = 0L;
    // for timing output
static  FILE *fd = stderr ;
static  char buffer[ 300 ] ;

static char UID[ 80];
static char PWD[ 80 ];
static char DSN[ 80 ];

#define start _start = time( NULL )

#define end   _end   = time( NULL )

#define showtime( what )\
        end ;\
        seconds = (long)difftime( _end, _start );\
        minutes = seconds / 60L ;\
        seconds = seconds % 60L ; \
        fprintf( fd, "\n%s\n\t%6ld minutes\t%6ld seconds",\
                    #what, \
                    minutes, \
                    seconds \
                    );\
        start

void DataSources( odbcENV &env )
    {
    for ( env.FirstDataSource(); env.sqlsuccess(); env.NextDataSource() )
        {
        fprintf( stderr, "\n%30.30s %-40.40s",
                env.DSN(),
                env.Description()
                );
        }

    fprintf( stderr, "\n" );
    }
BOOL CreateATable( podbcCONNECT pConnect )
    {
    char *szStmtIn = "CREATE TABLE TESTV2 (\n"
                    "\tKEYFIELD <NUMERIC(12,0)>,\n"
                    "\tFIRSTNAME <CHAR(20)>,\n"
                    "\tMIDINIT <CHAR(4)>,\n"
                    "\tLASTNAME  <CHAR(20)>\n)\n\n";
    UWORD uStmtSize = sizeof(szStmtOut);

    // create a table-creator
    podbcTABLECREATOR pCreator
        = new odbcTABLECREATOR(pConnect);

    if ( !pCreator )
        return FALSE;

    else if ( !pCreator->sqlsuccess())
            {
            pCreator->Report();
            delete pCreator;
            return FALSE;
            }

    start ;
    // drop table if it already exists
    pCreator->ExecDirect("DROP TABLE TESTV2");
    showtime( Drop-Table );
    if ( pCreator->sqlsuccess())
        pCreator->Close();
        
    // automatically retrieve error info when return code
    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
    pCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
    pCreator->AutoReport(odbcREPSUCCESSWITHINFO);
    start ;
    // create a table
    pCreator->CreateTable
                (
                szStmtIn,
                szStmtOut,
                &uStmtSize,
                FALSE // actually create a table this time.
                );
    showtime( CreateTable ) ;
#if defined(VERBOSE)
    fprintf(stderr, "\ncreate table statement:\n'%s'\n", szStmtOut);
#endif
    // if we failed, we already reported; just get out.
    if ( !pCreator->sqlsuccess())
        {
        // delete the table creator
        delete pCreator;
        pCreator = NULL;
#if defined(VERBOSE)
        fprintf(stderr, "\nCreate table failed.\n");
#endif
        return FALSE;
        }
    else
#if defined(VERBOSE)
        fprintf(stderr, "\nCreate table succeeded.\n")
#endif
        ;

    // create index
    pCreator->ExecDirect("CREATE UNIQUE INDEX TESTV2 ON TESTV2"
                        "(KEYFIELD)");

    // if we failed to create an index, note and continue on.
#if defined(VERBOSE)
    if ( !pCreator->sqlsuccess())
        fprintf(stderr, "\nCreate index failed.\n");
    else
        fprintf(stderr, "\nCreate index succeeded.\n");
#endif
    // delete the table creator
    delete pCreator;
    pCreator = NULL;
    return TRUE;
    }

// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( -1 );
#if defined( WIN32) || defined( __WIN32__ )
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
#endif    
    }

void main(int , char *[])
    {
    // for loop index
    int i, max;

    // long for record IDs
    long l, lKey;

    // for DriverConnectPrompt
    static char szConnBuf[ 512 ];

    // structures for making records for insertion into table.
    sTESTV2 sTestV2, sResultSet;

    // characters for loop to make silly names
    char ch1, ch2;

    // for MoveRowsetRowToRecord
    size_t uBytesCopied;

    // inserter object pointer
    podbcRECINSERTER pInserter = NULL;

    // updater object pointer
    podbcRECUPDATER pUpdater = NULL;

    // for saving SQL type of our key field, for BindParameter
    SWORD fSqlType = 0;
    
    // column info
    psCOLBIND pColBind = NULL;
    SDWORD pcbLength[ 4 ]; // one for each column

    fprintf( stderr, "Enter filename for timing output (Enter for stderr):\n" );

    if (gets(buffer) == NULL )
       {
       fprintf( stderr, "filename get failed, or you pressed ctrl-Z.\n");
       return;
       }

    if (lstrlen(buffer) > 0)
        if ((fd = fopen(buffer, "w")) == NULL)
           {
           fprintf(stderr, "open failed.\n");
           return;
           }


    fprintf( stderr, "Enable transaction bracketing? (Y/N):\n" );

    if (gets(buffer) == NULL )
       {
       fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
       return;
       }

    BOOL bTransactions = (buffer[0] == 'y' || buffer[0] == 'Y');

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32) && !defined( __WIN32__ )
    // this code depends on SS == DS
    FARPROC proc = MakeProcInstance( (FARPROC)PrintErr,
                                    (HINSTANCE)HIWORD( (LONG)&bTransactions ) );
    env.SetErrHandler( (odbcERRHANDLER)proc );
#else
    env.SetErrHandler( PrintErr );
#endif
    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_DRIVER;
    //env.nCursorLibUsage = SQL_CUR_USE_ODBC;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

        // trim trailing blanks on all result set columns of type SQL_CHAR
        // and SQL_VARCHAR
        connect.bTrimAllTrailingBlanks = TRUE;

#if defined(VERBOSE)
        fprintf(stderr, "\nConnecting ");
#endif
        start ;

        connect.Connect(
               "dBASEFile",
               "",
               ""
               );

        showtime( Connect );

        if (connect.sqlsuccess())
            {
            if ( !((connect.SetPosSupport() & SQL_POS_UPDATE)
                    && (connect.SetPosSupport() & SQL_POS_DELETE))
                 && !connect.PosStmtSupport() )
                {
                connect.Disconnect();
                connect.SetConnectOption( SQL_ODBC_CURSORS, SQL_CUR_USE_ODBC );
                connect.Connect(
                       "dBASEFile",
                       "",
                       ""
                       );

                }
            }

        if (connect.sqlsuccess())
            {
            // create a cursor
            podbcCURSOR cursor = NULL;
            BOOL bKeysetsSupported = 0;
            UDWORD ScrollOptions = 0;
            connect.GetInfo( SQL_SCROLL_OPTIONS,
                            &ScrollOptions,
                            sizeof( UDWORD ),
                            NULL );

            bKeysetsSupported =  ( ScrollOptions & SQL_SO_KEYSET_DRIVEN );

            if ( !CreateATable(&connect))
                {
#if defined(VERBOSE)
                    fprintf( stderr, "\nCreateTable failed.\n");
#endif
                    goto bypass;
                }

            // enable transactions only after creating table and index.
            if ( bTransactions )
                {
#if defined(VERBOSE)
                    fprintf( stderr, "\nEnabling transaction bracketing.\n");
#endif
                connect.SetConnectOption( SQL_AUTOCOMMIT, SQL_AUTOCOMMIT_OFF );
                }


            // create an inserter
            start ;
            pInserter
                = new odbcRECINSERTER(&connect, "TESTV2",
                            sTESTV2ColDefs,
                            sTESTV2ColDefsCount,
                            &sResultSet);
            showtime( odbcRECINSERTER-CTor );

            // save SQL type of KEYFIELD column for later use.
            fSqlType = pInserter->ColResultInfo("KEYFIELD")->fSqlType;
            
            // now set up a loop to insert records
            start;
            for ( l = 1, ch1 = 'A'; pInserter->sqlsuccess()
                                && ch1 <= FINAL_LETTER; ch1++ )
                for ( ch2 = 'A'; pInserter->sqlsuccess()
                                    && ch2 <= FINAL_LETTER; ch2++, l++ )
                    {
                    // clear and fill the record.
                    memset( &sTestV2, 0, sizeof(sTestV2));
                    strcpy( sTestV2.szLastName, "Clone" );
                    sTestV2.szFirstName[ 0 ] = ch1;
                    sTestV2.szFirstName[ 1 ] = '.';
                    sTestV2.szMidInit[ 0 ] = ch2;
                    sTestV2.szMidInit[ 1 ] = '.';
                    sTestV2.dKeyField = (double)l;
                    
                    // empty row array
                    memset( pcbLength, 0, 4 * sizeof( SDWORD ) );
                    pcbLength[ 1 ] = SQL_NTS ;
                    pcbLength[ 2 ] = SQL_NULL_DATA ;
                    szStmtOut[ 0 ] = 0;
                    pInserter->InsertRecord(
                            &sTestV2,           // rec address
                            sizeof(sTestV2),    // rec size
                            pcbLength
                            );

                    if ( pInserter->sqlsuccess())
                        {
#if defined(VERBOSE)
                        fprintf( stderr, "\nInserted record "
                                        "for %s %s %s (%f)...",
                            sTestV2.szFirstName,
                            sTestV2.szMidInit,
                            sTestV2.szLastName,
                            sTestV2.dKeyField
                            );
#endif
                        }

                    } // end for loop

            if ( !pInserter->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nInsert failed.\n");
#endif
                goto bypass;
                }
            max = (int)(l - 1);
#if defined(VERBOSE)
            fprintf(stderr, "\nInsertion completed, %ld records inserted.\n",
                        (long)max);
#endif
            // commit
            connect.Commit();

            // now let's cycle thru what we inserted...
            delete pInserter;

            showtime( insert-loop );
#if 0   // TR-1 and TR-2 beta drivers needed to disconnect here to avoid
        // exclusive lock error.
            connect.Disconnect();
            connect.DriverConnectNoPrompt(
                    szConnBuf,
                    szStmtOut,
                    sizeof( szStmtOut )
                    );
            if ( bTransactions )
                connect.SetConnectOption( SQL_AUTOCOMMIT, SQL_AUTOCOMMIT_OFF );
#endif            
            cursor = new odbcCURSOR( &connect ) ;

            start;

            cursor->ExecDirect( "SELECT * FROM TESTV2" );

            showtime( ExecDirect );
            if ( !cursor->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nExecDirect() failed.\n");
#endif                
                goto bypass;
                }
            else
                {
                cursor->SetColBindings
                            (
                            sTESTV2ColDefs,
                            sTESTV2ColDefsCount,
                            &sResultSet);
                cursor->BindCol();
                }
                
            start;
            for ( cursor->Fetch(); cursor->sqlsuccess(); cursor->Fetch() )
                {
                // get record from rowset row
                cursor->MoveRowsetRowToRecord( 1,
                    &sTestV2,
                    sizeof(sTestV2),
                    &uBytesCopied );
                pColBind = cursor->ColResultInfo( "MIDINIT" );
                if ( cursor->sqlsuccess())
                    {
#if defined(VERBOSE)
                    fprintf( stderr, "\nRetrieved record "
                                    "for %s %s %s (%f, %ld)...",
                        sTestV2.szFirstName,
                        pColBind->cbValue != SQL_NULL_DATA ? 
                                sTestV2.szMidInit : "<null>",
                        sTestV2.szLastName,
                        sTestV2.dKeyField,
                        pColBind->cbValue
                        );
#endif
                    }
                }
            showtime( fetch-loop-1 );
            // now let's do some random updates
            cursor->Close();
            cursor->Unbind();

            start;
            
            // an admittedly tenuous connection, but if the
            // ODBC Desktop Drivers v2.0 are in use, positioned
            // statements are not supported, and the cursor must
            // be keyset-driven rather than the static default.

            if ( connect.PosStmtSupport() )
                {
                pUpdater = new odbcRECUPDATER(
                                &connect,
                                "TESTV2",
                                "SELECT * FROM TESTV2 "
                                  "WHERE KEYFIELD = ? "
                                  "FOR UPDATE OF "
                                  "KEYFIELD, FIRSTNAME, "
                                  "MIDINIT, LASTNAME",
                                NULL, //
                                0,    /////// not using data dictionary
                                NULL, //
                                FALSE,// prepare, don't exec direct
                                SQL_CONCUR_VALUES,
                                bKeysetsSupported ?
                                    SQL_CURSOR_KEYSET_DRIVEN :
                                    SQL_CURSOR_STATIC
                                );
                }
            else
                {
                pUpdater = new odbcRECUPDATER(
                                &connect,
                                "TESTV2",
                                "SELECT * FROM TESTV2 "
                                  "WHERE KEYFIELD = ? ",
                                NULL, //
                                0,    /////// not using data dictionary
                                NULL, //
                                FALSE, // prepare, don't exec direct
                                SQL_CONCUR_VALUES,
                                bKeysetsSupported ?
                                    SQL_CURSOR_KEYSET_DRIVEN :
                                    SQL_CURSOR_STATIC
                                );
                }

            showtime( odbcRECUPDATER-CTor );
            if ( !pUpdater->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nodbcRECUPDATER CTor failed.\n");
#endif
                goto bypass;
                }
            // bind the key field parameter
            pUpdater->BindParameter(
                    1,              // col number
                    SQL_PARAM_INPUT,// parm bind type - input only
                    SQL_C_LONG,     // C type of our storage location
                    fSqlType,       // SQL type of the column
                    pUpdater->PrecisionForSqlType(
                      fSqlType, 4 ),// precision
                    0,              // not used for integral types
                    &lKey,          // address of our storage location
                    0,              // max length
                    NULL            // address of actual length buffer,
                                    //  which could also be used to
                                    //  indicate NULL data or data to
                                    //  be provided at execution time.
                                    //  left NULL, since the length is
                                    //  fixed and the data is not NULL.
                    );

            //pUpdater->AutoReport( odbcNOREPORT ) ;
            if ( !pUpdater->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nBindParameter() failed.\n");
#endif
                goto bypass;
                }
            start;
            // do 50 random updates
            for ( i = 0; pUpdater->sqlsuccess() && i < 50; i++ )
                {
                // generate a random number
                lKey = (long)(rand() % max);

                // execute
                pUpdater->Execute();

                if ( pUpdater->sqlsuccess())
                    {
                    pUpdater->ExtFetchFirst(); // first and only
                    }

                if ( pUpdater->sqlsuccess())
                    {
                    // get record from rowset row
                    pUpdater->MoveRowsetRowToRecord( 1,
                        &sTestV2,
                        sizeof(sTestV2),
                        &uBytesCopied );

                    }

                if ( pUpdater->sqlsuccess())
                    {
#if defined(VERBOSE)
                    fprintf( stderr, "\nRetrieved record "
                                    "for %s %s %s (%f)...",
                        sTestV2.szFirstName,
                        sTestV2.szMidInit,
                        sTestV2.szLastName,
                        sTestV2.dKeyField
                        );
#endif
                    // change some values
                    strcpy( sTestV2.szLastName, "Clooney" );

#if defined(VERBOSE)
                    // update
                    fprintf( stderr, "\nNew values "
                                    "are %s %s %s (%f).",
                        sTestV2.szFirstName,
                        sTestV2.szMidInit,
                        sTestV2.szLastName,
                        sTestV2.dKeyField
                        );
#endif
                    pUpdater->UpdateRecord(
                            1,
                            &sTestV2,
                            sizeof(sTestV2)
                            );

                    if ( pUpdater->sqlsuccess())
                        pUpdater->Close();
                    } // end if
                } // end for loop

            // commit
            connect.Commit();
            showtime( update-loop );

            // cycle thru again
            cursor->ExecDirect( "SELECT * FROM TESTV2" );
            if ( !cursor->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nExecDirect() failed.\n");
#endif
                goto bypass;
                }
            else
                cursor->AutoBind();
            start;
            for ( cursor->Fetch(); cursor->sqlsuccess(); cursor->Fetch() )
                {
                // get record from rowset row
                cursor->MoveRowsetRowToRecord( 1,
                    &sTestV2,
                    sizeof(sTestV2),
                    &uBytesCopied );

                if ( cursor->sqlsuccess())
                    {
#if defined(VERBOSE)
                    fprintf( stderr, "\nRetrieved record "
                                    "for %s %s %s (%f)...",
                        sTestV2.szFirstName,
                        sTestV2.szMidInit,
                        sTestV2.szLastName,
                        sTestV2.dKeyField
                        );
#endif
                    }
                }

            showtime( fetch-loop-2 );

            // do 50 random deletes
            for ( i = 0; pUpdater->sqlsuccess() && i < 50; i++ )
                {
                // generate a random number
                lKey = (long)(rand() % max);

                // execute
                pUpdater->Execute();

                if ( pUpdater->sqlsuccess())
                    {
                    pUpdater->ExtFetchFirst(); // first and only
                    }

                if ( pUpdater->sqlsuccess())
                    {
                    // get record from rowset row
                    pUpdater->MoveRowsetRowToRecord( 1,
                        &sTestV2,
                        sizeof(sTestV2),
                        &uBytesCopied );

                    }

                if ( pUpdater->sqlsuccess())
                    {
                    
#if defined(VERBOSE)
                    fprintf( stderr, "\nDeleting record "
                                    "for %s %s %s (%f)...",
                        sTestV2.szFirstName,
                        sTestV2.szMidInit,
                        sTestV2.szLastName,
                        sTestV2.dKeyField
                        );
#endif
                    // delete
                    pUpdater->DeleteRecord( 1 );

                    if ( pUpdater->sqlsuccess())
                        pUpdater->Close();
                    } // end if
                } // end for loop
            showtime( delete-loop );
            // commit
            connect.Commit();

            delete cursor ;
            delete pUpdater;

bypass:
            // cursor object will be freed as it goes out of
            // scope on this next closing brace.

		    fprintf( stderr, "\n\nComplete. Press Enter to continue...\n");
                
		    gets(buffer);

            } // end if (connect.sqlsuccess())

            // disconnection occurs in the connect destructor,
            // and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    if (fd != NULL && fd != stderr)
        fclose(fd);
//#if defined(VERBOSE)
    fprintf( stderr, "\nExecution complete!\n" );
//#endif
    }
