/*************************************************/
/*  This file uses the INTERSOLV dbase driver.   */
/*************************************************/
/*
     File:       v2blobs4.CPP
    
    Revision:   2.0 release
    
    Date:       29-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into BLOB
    handling features in version 2. This module shows "automatic"
    use of odbcBLOB objects (i.e. with automatic binding of columns
    and parameters).  This program looks at the Clipboard, first
    for a bitmap object and if not found, for a metafile; whichever
    one it finds (if any) it puts in a BLOB for insertion in the
    database.  It demonstrates using the bitmap- and metafile-specific
    BLOB functions.

    Having thus created and filled the MMBLOBS table, you can run the
    V2BLOBS5 sample to view what you have put into the table.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/

#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>

#include <windows.h>

// odbcBLOB items


typedef struct {
    double dKeyField;
    podbcBLOB pBlob;
    } sMMBLOBS;

static char szStmtOut[ 5000 ] ;

BOOL CreateATable( podbcCONNECT pConnect )
    {
    char *szStmtIn = "CREATE TABLE MMBLOBS (\n"
                    "\tKEYFIELD <NUMERIC(12,0)>,\n"
                    "\tBLOB <LONGVARBINARY(16000000)>)\n\n";
    UWORD uStmtSize = sizeof(szStmtOut);

    // create a table-creator
    podbcTABLECREATOR pCreator
        = new odbcTABLECREATOR(pConnect);

    if ( !pCreator )
        return FALSE;

    else
        {
        if ( !pCreator->sqlsuccess())
            {
            pCreator->Report();
            delete pCreator;
            return FALSE;
            }
        }

    // drop table if it already exists
    pCreator->ExecDirect("DROP TABLE MMBLOBS");

    if ( pCreator->sqlsuccess())
        pCreator->Close();

    // automatically retrieve error info when return code
    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
    pCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
    pCreator->AutoReport(odbcREPSUCCESSWITHINFO);

    // create a table
    pCreator->CreateTable
                (
                szStmtIn,
                szStmtOut,
                &uStmtSize,
                FALSE // actually create a table this time.
                );

#if defined(VERBOSE)
    fprintf(stderr, "\ncreate table statement:\n'%s'\n", szStmtOut);
#endif
    // if we failed, we already reported; just get out.
    if ( !pCreator->sqlsuccess())
        {
        // delete the table creator
        delete pCreator;
        pCreator = NULL;
        fprintf(stderr, "\nCreate table failed.\n");
        return FALSE;
        }
    else
        fprintf(stderr, "\nCreate table succeeded.\n");

    // drop table if it already exists
    pCreator->ExecDirect("CREATE UNIQUE INDEX MMBLOBS ON MMBLOBS"
                        "(KEYFIELD)");

    // if we failed to create an index, note and continue on.
    if ( !pCreator->sqlsuccess())
        fprintf(stderr, "\nCreate index failed.\n");
    else
        fprintf(stderr, "\nCreate index succeeded.\n");

    // delete the table creator
    delete pCreator;
    pCreator = NULL;
    return TRUE;
    }

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif
void main(int , char *[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

	//buffer for input
    char buf[ 80 ];

    // for loop index
    long i;

    // for DriverConnectPrompt
    static char szConnBuf[ 512 ];

    // structure for making records for insertion into table.
    sMMBLOBS sTestV2;

    // character buffer for loop
    char ch1[3];

    // for MoveRowsetRowToRecord
    size_t uBytesCopied;

    // inserter
    podbcRECINSERTER pInserter = NULL;

	 // for saving MetaFilePicts in Blobs
	 HGLOBAL hGMemMFP;
	 METAFILEPICT* pMFP;

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

#if defined(VERBOSE)
        fprintf(stderr, "\nConnecting ");
#endif
        connect.Connect(
               "dBASEFile",
               "",
               ""
               );

        if (connect.sqlsuccess())
            {

            if ( !CreateATable(&connect))
                {
                fprintf( stderr, "\nCreateTable failed.\n");
                goto bypass;
                }

            // creater inserter
            pInserter = new odbcRECINSERTER
                                (
                                &connect,
                                "MMBLOBS"
                                );

            if ( !pInserter || !pInserter->sqlsuccess())
                {
                fprintf( stderr, "\ninserter constructor or allocation failed.\n");
                goto bypass;
                }

                fprintf( stderr, "\nYou may go to another application now"
                                " and \nput something else in the Clipboard."
                                "\nPress B to put in as a bitmap, M to put in"
                                "\n as a metafile, any other key to exit app.\n");

                fgets(ch1, sizeof(ch1), stdin);
                strupr( ch1 );
				for ( i = 1; ch1[0] == 'B' || ch1[0] == 'M'; i++ )
                    {
                    OpenClipboard(GetActiveWindow());

                    // if the clipboard contains a bitmap, save it
                    if (IsClipboardFormatAvailable( CF_BITMAP ) &&
                        ch1[0] == 'B' )
                        {
                        pInserter->MoveRowsetRowToRecord(
                        1,
                        &sTestV2,
                        sizeof(sTestV2),
                        &uBytesCopied );

                        // set up key field
                        sTestV2.dKeyField = (double)i;


                        sTestV2.pBlob->SetBitmapInBlob(
                                                 (HBITMAP) GetClipboardData ( CF_BITMAP ) );
                        pInserter->InsertRecord(
                                    &sTestV2,           // rec address
                                    sizeof(sTestV2)     // rec size
                                    );

                        if ( pInserter->sqlsuccess())
                              {
                              i++;
#if defined(VERBOSE)
                              fprintf( stderr, "\nInserted bitmap blob "
                                                    "at key #%f...",
                                                    sTestV2.dKeyField );
#endif
                              }

                        if ( !pInserter->sqlsuccess())
                            {
#if defined(VERBOSE)
                            fprintf( stderr, "\nInsert failed.\n");
#endif
                            CloseClipboard();
                            goto bypass;
                            }
                        }

                    // if the clipboard contains a metafilepict, save it
                    if (IsClipboardFormatAvailable( CF_METAFILEPICT ) &&
                        ch1[0] == 'M' )
                        {
                        // set up key field
                        sTestV2.dKeyField = (double)i;

                        hGMemMFP = GetClipboardData ( CF_METAFILEPICT ) ;
                        pMFP = (METAFILEPICT*) GlobalLock( hGMemMFP );

                        sTestV2.pBlob->SetMetaFilePictInBlob( pMFP );
                        GlobalUnlock( hGMemMFP );

                        pInserter->InsertRecord(
                            &sTestV2,           // rec address
                            sizeof(sTestV2)     // rec size
                            );

                        if ( pInserter->sqlsuccess())
                            {
#if defined(VERBOSE)
                            fprintf( stderr, "\nInserted metafile blob "
                                            "at key #%f...",
                            sTestV2.dKeyField
                            );
#endif
                            }

                        if ( !pInserter->sqlsuccess())
                            {
#if defined(VERBOSE)
                            fprintf( stderr, "\nInsert failed.\n");
#endif
                            CloseClipboard();
                            goto bypass;
                            }
                        } // end if metafile format is available

                    CloseClipboard();
                    fprintf( stderr, "\nYou may go to another application now"
                                    " and \nput something else in the Clipboard."
                                    "\nPress B to put in as a bitmap, M to put in"
                                    "\n as a metafile, any other key to exit app.\n");

                    fgets(ch1, sizeof(ch1), stdin);
                    strupr( ch1 );
                    } // end for loop

                delete pInserter;
bypass:
				// cursor object will be freed as it goes out of
				// scope on this next closing brace.

            ; // Microsoft VC++ is unhappy without an empty statement here.

            } // end if (connect.sqlsuccess())

			else
				{
				fprintf( stderr, "\nCould not connect!\n" );
				gets( buf );
				}

            // disconnection occurs in the connect destructor,
            // and so is the freeing of the connection handle

		  } // if (env.sqlsuccess())

	 fprintf( stderr, "\nExecution complete!\n" );
	 }
