/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       v2blobs2.CPP
    
    Revision:   2.0 release
    
    Date:       29-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into BLOB
    handling features in version 2. This module shows "manual"
    use of odbcBLOB objects (i.e. without automatic binding).
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994 by INTERSOLV, Inc.  All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/

#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>

#include <windows.h>

#define SIZEOF_BINARY  135000L

// odbcBLOB items


typedef struct {
    double dKeyField;
    char HUGE *pData;
    } sBLOBS;

static char szStmtOut[ 5000 ] ;

// sCOLBIND array definition

static sCOLBIND QueryResultSet[] = 
{
{ 	1,
	SQL_C_DOUBLE,
	FIELDOFFSET( sBLOBS, dKeyField ),
	8,
	0,
	FALSE,
	"KEYFIELD",
	SQL_NUMERIC,
	4,
	1,
	NULL,
},
};
const int QueryResultSetCount
	= sizeof(QueryResultSet) / sizeof(QueryResultSet[ 0 ]);


BOOL CreateATable( podbcCONNECT pConnect )
    {
    char *szStmtIn = "CREATE TABLE BLOBS (\n"
                    "\tKEYFIELD <NUMERIC(12,0)>,\n"
                    "\tBLOB <LONGVARBINARY(135000)>)\n\n";
    UWORD uStmtSize = sizeof(szStmtOut);

    // create a table-creator
    podbcTABLECREATOR pCreator
        = new odbcTABLECREATOR(pConnect);

    if ( !pCreator )
        return FALSE;

    else
        {
        // set window in case we need to report
#if !defined( WIN32 )
        pCreator->SetWnd(GetActiveWindow());
#endif
        if ( !pCreator->sqlsuccess())
            {
            pCreator->Report();
            delete pCreator;
            return FALSE;
            }
        }

    // drop table if it already exists
    pCreator->ExecDirect("DROP TABLE BLOBS");

    if ( pCreator->sqlsuccess())
        pCreator->Close();
        
    // automatically retrieve error info when return code
    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
    pCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
    pCreator->AutoReport(odbcREPSUCCESSWITHINFO);

    // create a table
    pCreator->CreateTable
                (
                szStmtIn,
                szStmtOut,
                &uStmtSize,
                FALSE // actually create a table this time.
                );

#if defined(VERBOSE)
    fprintf(stderr, "\ncreate table statement:\n'%s'\n", szStmtOut);
#endif
    // if we failed, we already reported; just get out.
    if ( !pCreator->sqlsuccess())
        {
        // delete the table creator
        delete pCreator;
        pCreator = NULL;
        fprintf(stderr, "\nCreate table failed.\n");
        return FALSE;
        }
    else
        fprintf(stderr, "\nCreate table succeeded.\n");

    // drop table if it already exists
    pCreator->ExecDirect("CREATE UNIQUE INDEX BLOBS ON BLOBS"
                        "(KEYFIELD)");

    // if we failed to create an index, note and continue on.
    if ( !pCreator->sqlsuccess())
        fprintf(stderr, "\nCreate index failed.\n");
    else
        fprintf(stderr, "\nCreate index succeeded.\n");

    // delete the table creator
    delete pCreator;
    pCreator = NULL;
    return TRUE;
    }

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_OK );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif

void main(int , char *[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

    // for loop index
    long i;

    // longs for record IDs
    long l, lKey;

	// buffer for input
	char buf[ 80 ];

    // for DriverConnectPrompt
    static char szConnBuf[ 512 ];

    // structure for making records for insertion into table.
    sBLOBS sTestV2;

    // character for loop
    char ch1;

    // return code
    RETCODE ret;

    // cursor object pointer
    podbcCURSOR pCursor = NULL;

    // BLOB object pointers
    podbcBLOB pBlob = NULL;
    podbcBLOB pBlob2 = NULL;

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
		odbcCONNECT connect( &env );
#if defined(VERBOSE)
        fprintf(stderr, "\nConnecting ");
#endif
        connect.Connect(
               "dBASEFile",
               "",
               "");

        if (connect.sqlsuccess())
            {

            if ( !CreateATable(&connect))
                {
                    fprintf( stderr, "\nCreateTable failed.\n");
                    goto bypass;
                }
            // create a cursor
            pCursor
                = new odbcCURSOR(&connect);

            // automatically retrieve error info when return code
            // is SQL_ERROR or SQL_SUCCESS_WITH_INFO

            pCursor->AutoRetrieve( odbcREPSUCCESSWITHINFO );
            pCursor->AutoReport( odbcREPERRS );
#if !defined( WIN32 )
            pCursor->SetWnd(GetActiveWindow());
#endif

            // bind the key field parameter
            pCursor->BindParameter(
                    1,              // col number
                    SQL_PARAM_INPUT,// parm bind type - input only
                    SQL_C_LONG,     // C type of our storage location
                    SQL_NUMERIC,    // SQL type of the column
                    12,              // precision and scale are
                    0,              // not used for integral types
                    &lKey,          // address of our storage location
                    0,              // max length
                    NULL            // address of actual length buffer,
                                    //  which could also be used to
                                    //  indicate NULL data or data to
                                    //  be provided at execution time.
                                    //  left NULL, since the length is
                                    //  fixed and the data is not NULL.
                    );

            if ( !pCursor->sqlsuccess())
                {
                    fprintf( stderr, "\nBinding 1st parameter failed.\n");
                    goto bypass;
                }

            // create BLOB but don't bind the BLOB parameter yet.
            // bind before each execute, to be safe, since many
            // of the newer drivers require the length to be
            // passed in advance.

            // note that this BLOB is a SQL_LONGVARBINARY column
            // even though we happen to be filling it with character
            // data. If you want to store and retrieve null-terminated
            // character strings, it would be better to override
            // the default data type and make this a SQL_LONGVARCHAR
            // BLOB.
            pBlob = new odbcBLOB(
                            pCursor,
                            2,
                            SIZEOF_BINARY
                            // accept defaults for remaining
                            // arguments.
                            );

            pCursor->Prepare( "INSERT INTO BLOBS VALUES (?, ?)");

            if ( !pCursor->sqlsuccess())
                {
                    fprintf( stderr, "\nPrepare() for insert failed.\n");
                    goto bypass;
                }

            // now set up a loop to insert 5 records
            for ( l = 1, ch1 = 'a';
                    pCursor->sqlsuccess() && l <= 5;
                    l++, ch1++ )
                {
                // set up parameter for input.
                lKey = l;

                sTestV2.pData = (char HUGE *)pBlob->GetMem( SIZEOF_BINARY );

                if ( !sTestV2.pData )
                    {
                    fprintf( stderr, "\nmemory allocation failed.\n");
                    goto bypass;
                    }
                    
                // fill array with character for this record
                for ( i = 0; i < SIZEOF_BINARY; i++)
                    sTestV2.pData[ i ] = ch1;

                // bind the parameter now.
                ret = pBlob->BindParameter();

                if ( ret != SQL_SUCCESS )
                    {
                        fprintf( stderr,
                                "\nBinding 2d parameter failed.\n");
                        goto bypass;
                    }

                // do the insert: this calls blob->PutData()
                // transparently for you.
                ret = pCursor->Execute();
                } // end for loop on insertions

            // free BLOB: outside of the auto binding world,
            // we are responsible for freeing our own blobs.
            delete pBlob;
            pBlob = NULL;
            sTestV2.pData = NULL;

            if ( !pCursor->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nInsert failed.\n");
#endif
                goto bypass;
                }

            pCursor->Close();
            pCursor->ResetParams();

            pCursor->ExecDirect( "SELECT * FROM BLOBS" );
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nExecDirect() failed.\n");
                goto bypass;
                }

            // bind columns using data dictionary, which just binds
            // a column for the keyfield.
            pCursor->BindCol(
                        QueryResultSet,
                        QueryResultSetCount,
                        &sTestV2
                        );

            // get yourself a BLOB.
            pBlob = new odbcBLOB(
                            pCursor,
                            2,
                            SIZEOF_BINARY
                            // accept defaults for remaining
                            // arguments.
                            );

            for ( pCursor->Fetch(); pCursor->sqlsuccess(); pCursor->Fetch() )
                {
                // do GetData on the BLOB.
                ret = pBlob->GetData();
                if ( ret != SQL_SUCCESS )
                    continue;

                sTestV2.pData = (char HUGE *)pBlob->GetMem();

#if defined(VERBOSE)
                if ( pBlob->IsNull() )
                    sTestV2.pData = "<null data>";
                else if ( pBlob->IsEmpty() )
                    sTestV2.pData = "<empty>";
                else
                    // guarantee our bogus data is null-terminated.
                    // remember, this is really a binary BLOB,
                    // so don't try this one at home. We know
                    // it's OK here, since we know what we put
                    // in the BLOB.
                    sTestV2.pData[ pBlob->GetcbValue() - 1 ] = 0;

                fprintf( stderr, "\nRetrieved record "
                                "for %15.15s %10.10s (%f)...",
                    !sTestV2.pData ?
                        "?" :
                        (char *)sTestV2.pData,
                    !sTestV2.pData ?
                        "?" :
                        (sTestV2.pData[0] == '<' ?
                          (char *)sTestV2.pData :
                          (char *)&sTestV2.pData[ pBlob->GetcbValue() - 11 ]),
                    sTestV2.dKeyField
                    );
#endif
                }

            // in this "manual" world, we must free our own
            // blob...
            delete pBlob;
            if ( sTestV2.pData )
                {
                sTestV2.pData = NULL;
                }

bypass:
            // cursor object will be freed as it goes out of
            // scope on this next closing brace.

            ; // Microsoft VC++ is unhappy without an empty statement here.

            } // end if (connect.sqlsuccess())

			else
				{
				fprintf( stderr, "\nCould not connect!\n" );	
			    gets(buf);
				}

            // disconnection occurs in the connect destructor,
            // and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete!\n" );
    }
