/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       SLCTAUTB.CPP
    
    Revision:   1.0 release
    
    Date:       14-Mar-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library for performing SELECT statements and taking
    advantage of the library's automatic column binding features.
    
    With fully automatic column binding, you accept the database's
    definition of the columns returned by the query and the default
    conversions from SQL data type to C data type.  A structure
    is dynamically allocated and columns are automatically bound
    to their locations in the structure.  
    
    The order of structure members is the order of columns in the 
    query. In the case of SELECT * FROM X queries, the order of
    struct members is the order of columns returned by SQLDescribeCol,
    presumably the order in which the columns are named in the CREATE 
    TABLE statement.  Automatic binding occurs either during the 
    Prepare() or ExecDirect() function.
    
    After a Fetch() operation, the dynamically allocated structure's 
    address can be obtained by calling the pResultSet() member 
    function.  The data for the current row will be found in the
    structure. You can also obtain the address of the column data
    for a given column by calling one of the versions of the 
    odbcCURSOR member function ColResultAddr().  It accepts either
    an integer argument (column number, beginning with 1) or 
    string (column name).

    A warning: ONLY use AutoBind() if you can guarantee
    that your SQL table structure will always match your C/C++
    structure definition if you are using the pResultSet() member
    function to access results.  If the table definitions get out of
    sync with the defined structures, misaligned member boundaries
    will result and protection violations are possible.
    
    A third method for accessing column data is glimpsed here,
    using the function ColResultAsLPSTR() to access a string
    column value.

    Corresponding functions exist for signed and unsigned short
    and long integers, floats, and double values.

    PLEASE NOTE: The ColResultAddr() and ColResultAs<type>()
    functions only work with automatic binding methods!

    Warning: for SQL data types that map to SQL_C_CHAR, an extra
    byte is added to the length of the column returned by the 
    DescribeCol() member function, to accommodate the null-terminator
    byte.  When a SQL table is created, its column size is assumed
    to describe the size of the data that can be stored in the
    column, not the (language-dependent) size of the buffer that 
    would be required to store the data on retrieval.
    
    This behavior can be suppressed by calling the odbcCURSOR member
    function SetNoExtraByte(TRUE) before the call to Prepare() or
    ExecDirect().  Having done this, buffers for the string types 
    will be allocated according to their definition in the DBMS's
    system tables, per the CREATE TABLE statement.

    Call SetNoExtraByte() again with the argument set to
    FALSE to turn on the adding of the extra byte again.
                                          
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

// sizes for structure definition for parameters.
// structure of accounts table is
// acctno       char(10)
// accttype     char(1)
// acctname     char(5)
// openbal      numeric(10,2)

const int ACCTNOSIZE = 11;
const int ACCTTYPESIZE = 2;
const int ACCTNAMESIZE = 6;
const int OPENBALSIZE = sizeof(double);
const int OPENBALPRECISION = 10;
const int OPENBALSCALE = 2;

// structure of result set is a little different because we are
// retrieving only a subset of the columns.
struct ACCTS {
        UCHAR   AcctNo[ACCTNOSIZE];
        UCHAR   AcctName[ACCTNAMESIZE];
        double  OpenBal;
        };

typedef ACCTS FAR *pACCT;

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char **)
    {
    pACCT  pAcct;                   // for use with pResultSet().
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

	// buffer for input
    char buf[ 80 ];

    env.AutoRetrieve( odbcREPSUCCESSWITHINFO );
    env.AutoReport( odbcREPSUCCESSWITHINFO );
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    if (env.sqlsuccess())
        {
        // connect to sample data source
        odbcCONNECT connect(&env);
        connect.Connect(
                        "dBASEFile",
                        "",
                        "");
        
        // make library collect error info automatically.
        // this is handled by odbcBASE class.
                        
        connect.AutoRetrieve( odbcREPSUCCESSWITHINFO );
        connect.AutoReport( odbcREPSUCCESSWITHINFO );
#if !defined( WIN32 )
        connect.SetWnd( GetActiveWindow() );
#endif

        if (connect.sqlsuccess())
            {
            // create a cursor
            odbcCURSOR cursor(&connect);
            cursor.AutoRetrieve( odbcREPSUCCESSWITHINFO );
            cursor.AutoReport( odbcREPSUCCESSWITHINFO );
#if !defined( WIN32 )
            cursor.SetWnd( GetActiveWindow() );
#endif
            if (cursor.sqlsuccess())
                {
                // bind some parameters
                char szAcctType[3];

                // initialize parameter buffer
                strcpy(szAcctType, "X");
                
                // bind now
                cursor.SetParam(
                        1,          // first parameter
                        SQL_C_CHAR, // character type
                        SQL_CHAR,   // likewise
                        sizeof(szAcctType), // buffer size
                        0,          // for string types
                        szAcctType, // address of buffer
                        NULL        // string is null-terminated
                        );
                        
                // execute the statement
                if (cursor.sqlsuccess())
                    cursor.ExecDirect(
                            (LPUCSTR)"SELECT ACCTNO, ACCTNAME, OPENBAL "
                                             "FROM ACCOUNTS "
                                             "WHERE ACCTTYPE = ?"
                                );
                else
                    fprintf(stderr, "parameter binding failed.\n");
                    
                // bind columns

                if (cursor.sqlsuccess())
                    {
                    // bind all columns
                    cursor.AutoBind();
                    if (!cursor.sqlsuccess())
                        {
                        fprintf(stderr, "column binding failed.");
                        }
                    }
                else
                    {
                    fprintf(stderr, "execution of SELECT statement failed.");
                    }

                // use a for loop to fetch & display rows
                if (cursor.sqlsuccess())
                   {
                   // get a pointer to the result set structure
                   // produced by AutoBind().

                   pAcct = (pACCT)cursor.pResultSet();

                   for  (
                    cursor.GetFirst();
                    cursor.sqlsuccess();
                    cursor.GetNext()
                    )
                    {
                    // output the results.
                    fprintf(stderr,
                        " Account No.: %s\n", pAcct->AcctNo);
                    fprintf(stderr,
                        "Account Name: %s\n", cursor.ColResultAsLPSTR("ACCTNAME"));
                    fprintf(stderr,
                        "     Balance: %10.2f\n\n", cursor.ColResultAsDouble("OPENBAL"));
                    } // end for loop
                   } // if (cursor.sqlsuccess())
				   fprintf(stderr, "\nExecution complete\nPress Enter to continue:\n");
				   gets( buf );
                } // if (cursor.sqlsuccess())
            } // if (connect.sqlsuccess())
        else
            {
            fprintf(stderr, "connection failed.\n");
			gets( buf );
            }
        } // if (env.sqlsuccess())
    else
        fprintf(stderr, "could not create environment.\n");
    } // end of main
    

