/****************************************************/
/*  This file uses the INTERSOLV SQLServer driver.  */
/****************************************************/
/*
    File:       PRIMKEYS.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this EasyWin/QuickWin file will give you insight into the use
    of the library's features to use the system catalog functions. This
    program features the odbcPrimaryKeysIterator class, which invokes
    the odbcCURSOR::PrimaryKeys function and in turn the ODBC API function
    SQLPrimaryKeys.

    To use this program, run it; enter a filename for the output,
    and select a data source.
       
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

	//buffer for input
    char buf[ 80 ], UID[80], PWD[80];

    // for fopen() 
    char buffer[255] ; 
    
    FILE *fd = stderr ;
    static char *opening[] = {
    "                           PRIMKEYS\n\n",
    "This program will allow you to connect to an ODBC driver\n",
    "and will then write information on the primary keys of tables in\n",
    "the data source to a file of your choice.\n\n",
    } ;
    static int nOpenings = sizeof(opening)/sizeof(opening[0]);
    for ( int i = 0 ; i < nOpenings ; i++ )
        fprintf( stderr, opening[ i ]);
        
    fprintf( stderr, "Enter filename for output (Enter for stderr):\n" );

    if (gets(buffer) == NULL )
       {
       fprintf( stderr, "filename get failed, or you pressed ctrl-Z.\n");
       goto afterwards;
       }

    if (lstrlen(buffer) > 0)
        if ((fd = fopen(buffer, "w")) == NULL)
           {
           fprintf(stderr, "open failed.\n");
           goto afterwards;
           }

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    if (env.sqlsuccess())
        {
        // use Cursor Library if needed
        env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;
        
        // using environment constructed in WinMain(),
        // instantiate a connection. This does not perform the
        // connection.
        odbcCONNECT connect( &env ) ;

        // use the default error handling mechanism to report
        // errors; ignore success-with-info returns.

        connect.AutoRetrieve(odbcREPERRS);
        connect.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
        connect.SetWnd( GetActiveWindow() );
#endif
        fprintf(stderr, "\nConnecting to target...\n");
            fprintf( stderr, "\nEnter your SQLServer User ID: " );

        	if (gets(UID) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}

        	fprintf( stderr, "\nEnter your SQLServer password: " );

        	if (gets(PWD) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}
            connect.Connect(
                   "SQLServer",
                   UID,
                   PWD
                   );

        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !connect.sqlsuccess() )
          {
          fprintf( stderr, "\nConnection failed.\n") ;
          goto afterwards ;
          }

        // instantiate a primary keys iterator. This executes the
        // query, so we need to do after construction is begin
        // using the result set.

        odbcPrimaryKeysIterator iter(&connect,(LPSTR)NULL,(LPSTR)NULL,"cppsamp1");

        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !iter.sqlsuccess())
          {
          fprintf( stderr, "\nodbcPrimaryKeysIterator constructor"
                           " failed.\n") ;
          goto afterwards ;
          }

        // get a pointer to the result set structure:
        /*
        struct odbcEXPORTED sPRIMARYKEYSRESULTSET {
            char                 szTable_qualifier[ TABLE_QUALIFIER_SIZE ];
            char                 szTable_owner[ TABLE_OWNER_SIZE ];
            char                 szTable_name[ TABLE_NAME_SIZE ];
            char                 szColumn_name[ COLUMN_NAME_SIZE ];
            short                nKey_seq;
        };
        */
        cpsPRIMARYKEYSRESULTSET pResult = iter.pPrimaryKeysResultSet();

        memset( (void *)pResult, 0, sizeof(*pResult));

        for ( iter.GetFirst() ;
              iter.sqlsuccess() ;
              iter.GetNext()
            )
          {
            fprintf( fd,
                      "Table qualifier:\t%s\n",
                      iter.IsColValueNull( 1 ) ? "<null>" :
                      pResult->szTable_qualifier
                      );

            fprintf( fd,
                      "Table owner:\t%s\n",
                      iter.IsColValueNull( 2 ) ? "<null>" :
                      pResult->szTable_owner
                      );

            fprintf( fd,
                      "Table name:\t%s\n",
                      iter.IsColValueNull( 3 ) ? "<null>" :
                      pResult->szTable_name
                      );

            fprintf( fd,
                      "Column name:\t%s\n",
                      pResult->szColumn_name
                      );

            fprintf( fd,
                      "Key sequence:\t%d\n",
                      pResult->nKey_seq
                      );

            fprintf( fd, "\n" ) ;

            if ( fd == stderr )
                {
                fprintf( stderr, "More...");
                getchar();
                fprintf( stderr, "\n\n");
                }

          } // end for loop

      } // env.sqlsuccess()

afterwards:
    if (fd != NULL && fd != stderr)
        fclose(fd);

    fprintf( stderr, "\nExecution complete!\n" );
	gets( buf );

  }
