/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       ERRHNDLG.CPP
    
    Revision:   1.0 release
    
    Date:       14-Mar-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library for taking advantage of the library's error-
    handling features.
    
    The odbcCONNECT object uses the default error handler, Report(),
    which causes a MessageBox() to appear when the (deliberate)
    error occurs and a second one to appear when the success-with-
    info occurs (during the connection when the driver's function
    SetConnectOption fails).
    
    The odbcCURSOR uses an installed error handler.  This one calls
    fprintf() to output the result (you may get a linker warning
    since this results in a program that can have only one instance
    running at any given time).
    
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

// sizes for structure definition for parameters.
// structure of accounts table is
// acctno       char(10)
// accttype     char(1)
// acctname     char(5)
// openbal      numeric(10,2)

const int ACCTNOSIZE = 11;
const int ACCTTYPESIZE = 2;
const int ACCTNAMESIZE = 6;
const int OPENBALSIZE = sizeof(double);
const int OPENBALPRECISION = 10;
const int OPENBALSCALE = 2;

// this error routine will be called automatically when
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {

#if !defined( WIN32 )
    MessageBox( GetActiveWindow(),
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                MB_OK);
#else
    char buf[ 80 ];

    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
	gets( buf );

#endif
    if (!lstrcmp((LPSTR)szSqlState, "S1001")) // memory allocation error
      {
      PostQuitMessage(0);
      }
    }

void main(int argc, char *argv[])
    {
    char szAccount[ACCTNAMESIZE-2]; // column 1 (but too small)
    double dOpenBal;                // column 2
    SDWORD dwNameLen;               // return length for account name
    SDWORD dwBalLen;                // return length for open balance
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
    env.AutoRetrieve(odbcREPSUCCESSWITHINFO); 
    env.AutoReport(odbcREPSUCCESSWITHINFO);
    env.SetErrHandler(PrintErr);
    // we'll use the return code from time to time
    RETCODE ret;
    
    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);
        
        // make library collect error info automatically.
        // this is handled by odbcBASE class.
                        
        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
        connect.SetWnd( GetActiveWindow());
#endif
        // We could install our own error handler, but let's see
        // what the default error handler looks like.
        // we would install our own error handler by use of
        // the following:

        // connect.SetErrHandler(PrintErr);

        // this will fail
        connect.Connect(
                    "FOXPROTUTU",
                    "",
                    ""
                    );
        
        // this will succeed
        fprintf( stderr, "connecting ");
        connect.Connect(
                       "dBASEFile",
                       "",
                       "");

        if (connect.sqlsuccess())
            {                      
            // create a cursor 
            odbcCURSOR cursor(&connect);
            
            cursor.AutoRetrieve(odbcREPSUCCESSWITHINFO);
            cursor.AutoReport(odbcREPSUCCESSWITHINFO);
            cursor.SetErrHandler(PrintErr);
            
            if (cursor.sqlsuccess())
                {
                // bind a parameter
                char szAcctType[3];
                long len = sizeof(szAcctType);
                
                // initialize parameter buffer
                strcpy(szAcctType, "X");
                
                // bind now
                ret = cursor.SetParam(
                        1,          // first parameter
                        SQL_C_CHAR, // character type
                        SQL_CHAR,   // likewise
                        sizeof(szAcctType), // buffer size
                        0,          // for string types
                        szAcctType, // address of buffer
                        NULL        // string is null-terminated
                        );
                        
                // execute the statement
                if (cursor.sqlsuccess())
                    ret = cursor.ExecDirect(
                            (LPUCSTR)"SELECT ACCTNAME, OPENBAL FROM ACCOUNTS "
                                "WHERE ACCTTYPE = ?"
                                );
                else
                    fprintf(stderr, "parameter binding failed.\n");
                    
                // bind columns
                
                // we'll force a SUCCESS_WITH_INFO return by passing
                // in a small buffer for one of our two columns
                
                if (cursor.sqlsuccess())
                    {
                    // bind account name column
                    ret = cursor.BindCol(
                            1,
                            SQL_C_CHAR,
                            szAccount,
                            sizeof(szAccount), // too small!
                            &dwNameLen
                            );
                            
                    if (cursor.sqlsuccess())
                        {
                        // bind open balance column
                        ret = cursor.BindCol(
                                2,
                                SQL_C_DOUBLE,
                                &dOpenBal,
                                sizeof(dOpenBal),
                                &dwBalLen
                                );
                        }
                    if (!cursor.sqlsuccess())
                        {
                        fprintf(stderr, "column binding failed.");
                        }
                    }
                else
                    {
                    fprintf(stderr, "execution of SELECT statement failed.");
                    }


                // use a for loop to fetch & display rows
                // success-with-info message will appear
                // each time a row is fetched unless the
                // data is really small enough to fit in
                // the buffer.

                if (cursor.sqlsuccess())
                    for (
                        cursor.Fetch();
                        cursor.sqlsuccess();
                        cursor.Fetch()
                        )
                        {
                        // output the results.
                        fprintf(stderr,
                            "Account Name: %s\n", szAccount);
                        fprintf(stderr,
                            "     Balance: %10.2f\n\n", dOpenBal);
                        }
                } // if (cursor.sqlsuccess())
            } // if (connect.sqlsuccess())
            
        // disconnection occurs in the destructor,
        // and so is the freeing of the connection handle
        
        } // if (env.sqlsuccess())
    }
    
