/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       EFTCHROW.CPP
    
    Revision:   2.0 beta
    
    Date:       07-Jun-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to accomplish extended (block cursor)
    selects and obtain a record from a rowset.
    
    This example program takes advantage of the library's AutoBind()
    mechanism.  AutoBind() must be called after calling ExtFetchSetup()
    to establish the number of result set rows to fetch in the block
    cursor's rowset.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1993 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>


// number of rows of data in our rowset.
const int ROWS = 4;
// sizes for structure definition for parameters.
// structure of accounts table is
// acctno       char(10)
// accttype     char(1)
// acctname     char(5)
// openbal      numeric(10,2)

const int ACCTNOSIZE = 11;
const int ACCTTYPESIZE = 2;
const int ACCTNAMESIZE = 6;
const int OPENBALSIZE = sizeof(double);
const int OPENBALPRECISION = 10;
const int OPENBALSCALE = 2;

// block result storage structure.  SQL expects addresses of 
// arrays of storage locations when binding multiple result
// rows.                

struct ACCTSPARMS {
        UCHAR   AcctNos[ACCTNOSIZE];
        UCHAR   AcctTypes[ACCTTYPESIZE];
        UCHAR   AcctNames[ACCTNAMESIZE];
        double  OpenBals;
        } AcctParm;

// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
#if !defined( WIN32 )
    MessageBox( HWND_DESKTOP,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                MB_OK);
#else
    char buf[ 80 ];
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
#endif

    if (!lstrcmp((LPSTR)szSqlState, "S1001")) // memory allocation error
      {
      PostQuitMessage(0);
      }
    }


void main(int argc, char *argv[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
	// buffer for input
    char buf[ 80 ];
    // we'll use the return code from time to time
    RETCODE ret;
    // for loop index
    int i;
    // number of returned rows
    UDWORD nReturnedRows;
    
    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);

    // set cursor lib usage as desired
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);
        
        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.
                        
        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
        connect.SetErrHandler(PrintErr);
        
        fprintf(stderr, "\nConnecting...\n");
        connect.Connect(
                       "dBASEFile",
                       "",
                       "");
        if (connect.sqlsuccess())
            {                      
            // create a cursor 
            odbcCURSOR cursor(&connect);
            
            // automatically retrieve error info when return code
            // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
            cursor.AutoRetrieve(odbcREPSUCCESSWITHINFO);
            cursor.AutoReport(odbcREPSUCCESSWITHINFO);

            fprintf(stderr, "\nConnection succeeded.\n");
        
            // does driver support scrolling/block cursors?
            
            if (connect.GetFunctions(SQL_API_SQLSETSCROLLOPTIONS))  
                {
                
                fprintf(stderr, "\ninvoking ExtFetchSetup...\n");   
                ret = cursor.ExtFetchSetup
                                    (
                                    SQL_CONCUR_READ_ONLY,
                                    SQL_CURSOR_DYNAMIC,
                                    ROWS
                                    );
                if (!cursor.sqlsuccess())
                    {
                    goto after_select;
                    }
                    
            
                // perform the select
                cursor.ExecDirect("SELECT * FROM ACCOUNTS ORDER BY 2, 3");
                if (!cursor.sqlsuccess())
                    {
                    goto after_select;
                    }
                     
                // bind columns automatically
                
                fprintf(stderr, "binding columns...\n");

                cursor.AutoBind();
                if (!cursor.sqlsuccess())
                    {
                    goto after_select;
                    }
                
                for (
                    nReturnedRows = cursor.ExtFetchFirst();
                    cursor.sqlsuccess() &&
                        nReturnedRows;
                    nReturnedRows = cursor.ExtFetchNext()
                    )
                    {
                    size_t uBytesReturned = 0;
                    
                    fprintf(stderr, "\n\n%s rowset, %lu of %u possible rows:\n\n",
                            cursor.GetExtFetchType() == SQL_FETCH_FIRST
                                ? "First" : "Next",
                            cursor.GetExtFetchRow(),
                            cursor.GetExtFetchRowCount()
                            );
                            
                    for (i = 0; i < nReturnedRows; i++)
                        {
                        if (cursor.GetExtFetchStatus(i+1) != SQL_SUCCESS)
                            fprintf(stderr, "Row status for row %u not success: %d\n", i+1, 
                                        cursor.GetExtFetchStatus(i+1));
                        fprintf(stderr, "row size: %u\n",
                                cursor.RowsetRowRecordSize());
                        fprintf(stderr, "Using access via RowsetRowAsRecord()\n");
                        
                        // get row here
                        ret = cursor.MoveRowsetRowToRecord(
                                i+1,
                                &AcctParm,
                                sizeof(AcctParm),
                                &uBytesReturned
                                );
                                
                        if (ret != TRUE)
                            fprintf(stderr, "error: %d\n", ret);
                        fprintf(stderr, "row %u: %s %s %s %10.2f\n",
                                i+1,
                                AcctParm.AcctNos,
                                AcctParm.AcctTypes,
                                AcctParm.AcctNames,
                                AcctParm.OpenBals
                                );
                        } // end inner for loop
                    fprintf(stderr, "\n");
                    } // end outer for loop
                    
                } // end if                
                
after_select:
            fprintf(stderr, "SELECT is complete.\n"); 
            gets( buf );          
            } // if (connect.sqlsuccess())
            
        // disconnection occurs in the destructor,
        // and so is the freeing of the connection handle
        
        } // if (env.sqlsuccess())
    }
    
