/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       BLKINSRT.CPP
    
    Revision:   1.0 release
    
    Date:       14-Mar-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to accomplish both single-row and bulk
    inserts.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
        
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

// number of rows of data we are inserting.
const int ROWS = 10;
                              

// sizes for structure definition for parameters.
// structure of accounts table is
// acctno       char(10)
// accttype     char(1)
// acctname     char(5)
// openbal      numeric(10,2)
const int ACCTNOSIZE = 11;
const int ACCTTYPESIZE = 2;
const int ACCTNAMESIZE = 6;
const int OPENBALSIZE = sizeof(double);
const int OPENBALPRECISION = 10;
const int OPENBALSCALE = 2;

// the column lengths defined below reflect the fact that
// the defined constants allow for the extra byte for null-
// terminated strings.

// these must be real storage locations because we must pass the
// address.

SDWORD dwAcctNoSize   = ACCTNOSIZE - 1;
SDWORD dwAcctTypeSize = ACCTTYPESIZE - 1;
SDWORD dwAcctNameSize = ACCTNAMESIZE - 1;
SDWORD dwOpenBalSize  = OPENBALSIZE;


// parameter storage structure.  SQL expects addresses of arrays of                 
// parameter values when multiple parameter values are in use.

struct ACCTSPARMS {
        UCHAR   AcctNos  [ROWS][ACCTNOSIZE];
        UCHAR   AcctTypes[ROWS][ACCTTYPESIZE];
        UCHAR   AcctNames[ROWS][ACCTNAMESIZE];
        double  OpenBals [ROWS];
        };

// bind arrays of parameter values
static ACCTSPARMS AcctsParms =
    {
        // AcctNos
        {
        "0000100001",
        "0000100002",
        "0000100003",
        "0000100004",
        "0000100005",
        "0000100006",
        "0000100007",
        "0000100008",
        "0000100009",
        "0000100010",
        },
        // AcctTypes
        {
        "R",
        "R",
        "X",
        "X",
        "X",
        "X",
        "X",
        "X",
        "X",
        "X",
        },
        // AcctNames
        {
        "PAY1",
        "PAY2",
        "FOOD",
        "FUEL",
        "RENT",
        "ELECT",
        "LPGAS",
        "SEWER",
        "CLTHG",
        "MISC",
        },
        // OpenBals
        {
        12605.07,
        6754.33,
        1256.78,
        687.34,
        3000.0,
        453.22,
        321.98,
        26.87,
        1204.30,
        998.6,
        },
    };

// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
#if !defined( WIN32 )
    MessageBox( GetActiveWindow(),
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                MB_OK);
#else
    char buf[ 80 ];
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
    gets(buf);
#endif
    if (!lstrcmp((LPSTR)szSqlState, "S1001")) // memory allocation error
      {
      PostQuitMessage(0);
      }
    }

SWORD   GetSqlTypeForColumn( podbcCURSOR pCursor, LPSTR szColName )
    {
    psCOLBIND pColBind = pCursor->ColResultInfo( szColName );
    if ( pColBind )
        return pColBind->fSqlType;
    else
        return 0;
    }

void main(int argc, char *argv[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
    // we'll use the return code from time to time
    RETCODE ret;
    // for loop index
    int i;
    // table creator
    podbcTABLECREATOR pTblCreator = NULL;
    static char szStmtOut[ 1000 ] ; 
    char buf[200];
    char *szStmtIn ;
    BOOL bSave;
    podbcCURSOR pCursor = NULL;

    // make library collect and report error info automatically.
    // this is handled by odbcBASE class.
    // these settings will be "inherited" by all owned objects
    // under this environment.

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
    env.SetErrHandler(PrintErr);
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;
    
    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

        fprintf(stderr, "\nConnecting...\n");

        szStmtOut[0] = 0;

        // use DriverConnectPrompt()
        connect.Connect(
            "dBASEFile",
            "",
            ""
            );

        if (!connect.sqlsuccess())
            {
            connect.Report();
            }
        else
            {
            // create a statement
            odbcSTMT stmt(&connect);

            fprintf(stderr, "\nConnection succeeded.\n");

            // automatically retrieve error info when return code

            // first clear any old contents from the file
            fprintf(stderr, "\ndeleting old records...\n");
            bSave = stmt.AutoReport( odbcNOREPORT );
            stmt.ExecDirect("DELETE FROM ACCOUNTS");
            stmt.AutoReport( bSave );
            if (stmt.sqlsuccess())
                {
                fprintf(stderr, "\nnumber of rows affected by "
                        "delete: %ld\n",  
                        stmt.RowCount());

                // Commit doesn't do much on a dBase file-- but we
                // do it to keep in practice.
                
                connect.Commit();
                }
            else
                {
                fprintf(stderr, "\nrecreating table...\n");
                bSave = stmt.AutoReport( odbcNOREPORT );
                stmt.ExecDirect("DROP TABLE ACCOUNTS");
                bSave = stmt.AutoReport( bSave );
                pTblCreator = new odbcTABLECREATOR(&connect);
                pTblCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
                pTblCreator->AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
                pTblCreator->SetWnd( GetActiveWindow());
#endif
                szStmtOut[0] = 0;

                UWORD uStmtSize = sizeof(szStmtOut);
                // try to create a table with all possible types
                szStmtIn =
                        "CREATE TABLE ACCOUNTS\n"
                        "    (\n"
                        "    acctno    <char(10)>,\n"
                        "    accttype  <char(1)>,\n"
                        "    acctname  <char(5)>,\n"
                        "    openbal   <decimal(10,2)>\n"
                            "    )\n";

                    fprintf( stderr,
                             "Processing '%s'\n",
                             szStmtIn);

                    ret = pTblCreator->CreateTable(
                            szStmtIn,
                            szStmtOut,
                            &uStmtSize,
                            FALSE        // actually create.
                            ) ;

                fprintf( stderr,
                         "Ret=%ld, translated as:\n '%s'\n",
                         (long)ret,
                         szStmtOut);

                // if we succeeded, test the statement out
                //    by preparing it on a second cursor.
                if (!pTblCreator->sqlsuccess())
                    {
                    fprintf( stderr, "Can't create table.\n");
                    delete pTblCreator;
                    goto bypass;
                    }
                else
                    {
                    pTblCreator->Close();
                    pTblCreator->ExecDirect( "CREATE UNIQUE INDEX "
                                            "ACCOUNTS ON ACCOUNTS (ACCTNO)"
                                            );
                    delete pTblCreator;
                    }
                }

            pCursor = new odbcCURSOR( &connect,
                                    "SELECT * FROM ACCOUNTS",
                                    TRUE, // prepare
                                    FALSE, // don't execute
                                    TRUE // do AutoBind()
                                    );

            if ( !pCursor->sqlsuccess() )
                {
                pCursor->Report();
                goto bypass;
                }

            // there are two ways to do this, depending on whether the
            // driver supports bulk inserts. (I don't have a driver
            // that does support them, so I'm not sure the bulk insert
            // code will work, but it should... really...)
            if (connect.GetFunctions(SQL_API_SQLPARAMOPTIONS))
                {
                // we'll set the number of elements in the
                // parameter arrays, and use the protected
                // data member iParmRow to store the row
                // of an error, if one should occur.  We can
                // access this data member's value by calling 
                // the member function GetParmRow().
                
                        fprintf(stderr, "\nBulk inserts are supported.\n");
                fprintf(stderr, "\ninvoking ParamOptions...\n");
                        ret = stmt.ParamOptions(ROWS);
                        // bind now
                fprintf(stderr, "\nBinding parameter 1...\n");  
                ret = stmt.BindParameter(
                        1,                    // first parameter
                        SQL_PARAM_INPUT,       // parameter type
                        SQL_C_CHAR,           // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTNO"
                            ),                // column data type
                        ACCTNOSIZE,           // precision
                        0,                    // scale (num dec places)
                        AcctsParms.AcctNos,   // address of buffer
                        sizeof(AcctsParms.AcctNos[0]), // max buffer size
                        NULL                  // no NULL parms
                        );
                        
                        // bind now
                fprintf(stderr, "\nBinding parameter 2...\n");  
                ret = stmt.BindParameter(
                        2,                    // second parameter 
                        SQL_PARAM_INPUT,      // parameter type
                        SQL_C_CHAR,           // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTTYPE"
                            ),                // column data type
                        ACCTTYPESIZE,         // precision
                        0,                    // scale (num dec places)
                        AcctsParms.AcctTypes, // address of buffer 
                        sizeof(AcctsParms.AcctTypes[0]), // max buffer size
                        NULL                  // no NULL parms
                        );
                        
                        // bind now
                fprintf(stderr, "\nBinding parameter 3...\n");
                ret = stmt.BindParameter(
                        3,                    // third parameter
                        SQL_PARAM_INPUT,      // parameter type
                        SQL_C_CHAR,           // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTNAME"
                            ),                // column data type
                        ACCTNAMESIZE,         // precision
                        0,                    // scale (num dec places)
                        AcctsParms.AcctNames, // address of buffer
                        sizeof(AcctsParms.AcctNames[0]), // max buffer size
                        NULL                  // no NULL parms
                        );

                        // bind now
                  fprintf(stderr, "\nBinding parameter 4...\n");
                  ret = stmt.BindParameter(
                        4,                    // fourth parameter 
                        SQL_PARAM_INPUT,      // parameter type
                        SQL_C_DOUBLE,         // local data type
                        SQL_NUMERIC,          // column data type
                        12,                   // precision
                        2,                    // scale (num dec places)
                        AcctsParms.OpenBals,  // address of buffer
                        0,                    // max buffer size
                        NULL                  // no NULL parms
                        );
           
                // perform the insert
                stmt.ExecDirect("INSERT INTO ACCOUNTS "
                        "VALUES (?, ?, ?, ?)");
                        
                // if we succeeded, commit the transaction
                if (stmt.sqlsuccess())
                    {
                    fprintf(stderr, "\nnumber of rows affected by insert: %ld\n",
                            stmt.RowCount());
                    connect.Commit();
                    }

                }
            else
                {
                // if we get here, bulk inserts are not supported.
                // we have to loop through the parameter arrays ourselves.
                // hooray for bulk inserts, when they are available!

                fprintf(stderr, "\nBulk inserts are not supported.\n");
                for (stmt.Close(), i = 0; stmt.sqlsuccess() && i < ROWS; i++)
                   {
                       // bind current row of parameter data
                   fprintf(stderr, "\nBinding parameters for row %d.\n",
                            i
                            );
                   fprintf(stderr, "\nBinding parameter 1...\n");
                   ret = stmt.BindParameter(
                        1,                      // first parameter
                        SQL_PARAM_INPUT,        // parameter type
                        SQL_C_CHAR,             // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTNO"
                            ),                  // column data type
                        ACCTNOSIZE,             // precision
                        0,                      // scale (num dec places)
                        AcctsParms.AcctNos[i],  // address of buffer
                        sizeof(AcctsParms.AcctNos[i]), // max buffer size
                        NULL                    // no NULL parms
                        );

                       // bind now
                   fprintf(stderr, "\nBinding parameter 2...\n");
                   ret = stmt.BindParameter(
                        2,                      // second parameter 
                        SQL_PARAM_INPUT,        // parameter type
                        SQL_C_CHAR,             // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTTYPE"
                            ),                  // column data type
                        ACCTTYPESIZE,           // precision
                        0,                      // scale (num dec places)
                        AcctsParms.AcctTypes[i],// address of buffer
                        sizeof(AcctsParms.AcctTypes[i]), // max buffer size
                        NULL                    // no NULL parms
                        );

                       // bind now
                   fprintf(stderr, "\nBinding parameter 3...\n");
                   ret = stmt.BindParameter(
                        3,                      // third parameter 
                        SQL_PARAM_INPUT,        // parameter type
                        SQL_C_CHAR,             // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "ACCTNAME"
                            ),                  // column data type
                        ACCTNAMESIZE,           // precision
                        0,                      // scale (num dec places)
                        AcctsParms.AcctNames[i],// address of buffer
                        sizeof(AcctsParms.AcctNames[i]), // max buffer size
                        NULL                    // no NULL parms
                        );

                       // bind now
                   fprintf(stderr, "\nBinding parameter 4...\n");
                   ret = stmt.BindParameter(
                        4,                      // first parameter
                        SQL_PARAM_INPUT,        // parameter type
                        SQL_C_DOUBLE,           // local data type
                        GetSqlTypeForColumn(
                            pCursor,
                            "OPENBAL"
                            ),                  // column data type
                        12,                      // precision
                        0,                      // scale (num dec places)
                        &AcctsParms.OpenBals[i],// address of buffer
                        sizeof(AcctsParms.OpenBals[i]), // max buffer size
                        NULL                    // no NULL parms
                        );

                   // perform the insert
                   stmt.ExecDirect("INSERT INTO ACCOUNTS "
                        "VALUES (?, ?, ?, ?)");

                   // if we succeeded, commit the transaction
                   if (stmt.sqlsuccess())
                       {
                       fprintf(stderr, "\nnumber of rows affected by insert: %ld\n",
                            stmt.RowCount());
                       connect.Commit();
                       stmt.ResetParams();
                       }

                   } // end for loop

               } // end if bulk inserts are supported
bypass:
            if ( pCursor )
                delete pCursor;
            } // end if (connect.sqlsuccess())
            
            // disconnection occurs in the destructor,
            // and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete!\n" );
    gets(buf);
    }
    
