/*******************************************************************/
/*  This file uses the INTERSOLV dBASE and the INTERSOLV SQLServer */
/*  driver to connect.                                             */
/*******************************************************************/
/*
    File:       AUTOCRE3.CPP
    
    Revision:   2.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to copy table definitions from one
    data source to another, even with different ODBC drivers, using the
    odbcTABLECREATOR class's column-binding-to-create-table-statement
    translation mechanism.

    To use this file:

    1) Connect to the first (source) data source.

    2) Connect to a second (destination) data source.

    3) Enter a valid SELECT statement. The program will use Prepare()
    and AutoBind() to obtain a definition of the result set.

    4)  A CREATE TABLE statement will be generated and prepared
    for the table on the other data source.

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
    RETCODE ret;
    char inbuf[2];
    static char UID[80], PWD[80];
    static char szStmtIn[ 5000 ] ;
    static char szStmtOut[ 5000 ] ;
    static char szBuf[ 128 ];
    UWORD uStmtSize = sizeof(szStmtOut);

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);
        odbcCONNECT connect2(&env);

        if ( !connect.sqlsuccess() || !connect2.sqlsuccess())
            {
            fprintf( stderr, "Couldn't create connection objects.\n");
            goto done;
            }

        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.

        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
		connect.SetWnd(GetActiveWindow());
#endif
        connect2.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect2.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
        connect2.SetWnd(GetActiveWindow());
#endif
            static char szConnBuf[ 256 ];

            // do the connection
            fprintf(stderr, "\nConnecting to source Data Source...\n");
            connect.Connect(
                   "dBASEFile",
                   "",
                   ""
                   );

            if (!connect.sqlsuccess())
				{
				fprintf(stderr, "\nCould not connect to source Data Source...\n");
				gets( inbuf );
                
				}

            // create an odbcCURSOR object for the source
            podbcCURSOR pcursor1 = new odbcCURSOR(&connect);
            if ( !pcursor1 || !pcursor1->sqlsuccess())
                {
                fprintf( stderr, "\nCouldn't create odbcCURSOR"
										  " object.\n");
					 goto done;
                }
                pcursor1->AutoRetrieve(odbcREPSUCCESSWITHINFO);
                pcursor1->AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
                pcursor1->SetWnd(GetActiveWindow());
#endif
            fprintf(stderr, "\nConnecting to target...\n");
            fprintf( stderr, "\nEnter your SQLServer User ID: " );

        	if (gets(UID) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}

        	fprintf( stderr, "\nEnter your SQLServer password: " );

        	if (gets(PWD) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}
            connect2.Connect(
                   "SQLServer",
                   UID,
                   PWD
                   );

            if (!connect2.sqlsuccess())
				{
				fprintf(stderr, "\nCould not connect to target Data Source...\n");
				gets( inbuf );
				goto done;
				}
			else
                {
                // create an odbcTABLECREATOR object for the destination
                podbcTABLECREATOR ptblcreator
                        = new odbcTABLECREATOR(&connect2);
                if ( !ptblcreator->sqlsuccess())
                    {
                    fprintf( stderr, "\nCouldn't create odbcTABLECREATOR"
												" object.\n");
						  goto done;
                    }
                ptblcreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
                ptblcreator->AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
                ptblcreator->SetWnd(GetActiveWindow());
#endif
                
                    fprintf( stderr,
             "Now you will enter a SELECT statement for the first connection,\n"
             "to be translated to a CREATE TABLE statement on the second:\n\n");

                    fprintf( stderr, "\nEnter SELECT statement:\n");

                    strcpy ( szStmtIn, "SELECT " );
                    fprintf(stderr, szStmtIn);
                    for ( ;; )
                        {
                        if (gets( szBuf) == NULL)
                            break;
                        else if (strlen(szBuf) == 0)
                            break;
                        else
                           strcat( szStmtIn, szBuf );
                        }

                    fprintf( stderr,
                             "Processing '%s'\n",
                             szStmtIn);

                    pcursor1->Prepare( szStmtIn );

                    if ( !pcursor1->sqlsuccess() )
                        {
                        fprintf( stderr,
                            "Couldn't prepare SQL statement.\n"
                            );
								goto done;
                        }

                    pcursor1->AutoBind();

                    if ( !pcursor1->sqlsuccess() )
                        {
                        fprintf( stderr,
                            "Couldn't AutoBind.\n"
                            );
								goto done;
                        }

                    fprintf( stderr, "\nEnter table name "
                                     "(empty line to return to\n"
                                     "SELECT prompt):\n");

                  	gets( szBuf);
                       
                    ret = ptblcreator->CreateTable(
                            szBuf,      // table name
                            pcursor1,   // column bindings
                                        // come from cursor
                            NULL,       // table constraints- null for now
                            szStmtOut,  // output statement buffer
                            &uStmtSize, // size of buffer
                            TRUE        // just parse for now.
                            ) ;

                    // clear first cursor
                    pcursor1->Close();
                    fprintf( stderr,
                             "Ret=%ld, translated as:\n '%s'\n",
                             (long)ret,
                             szStmtOut);

                    // if we succeeded, test the statement out
                    //    by preparing it on a second cursor.
                    if (ret == SQL_SUCCESS)
                        {
                        podbcCURSOR pcursor2 = new odbcCURSOR(&connect2);
                        if ( !pcursor2 || !pcursor2->sqlsuccess())
                            {
                            fprintf( stderr, "\nCouldn't create second "
                                    "cursor for Prepare() call.\n");
                            }
                        else
                            {
                            pcursor2->AutoRetrieve(odbcREPERRS);
                            pcursor2->AutoReport(odbcREPERRS);
#if !defined( WIN32 )
                            pcursor2->SetWnd(GetActiveWindow());
#endif
                            fprintf(stderr, "\ncreate parsing succeeded.\n");
                            ret = pcursor2->Prepare( szStmtOut );
                            if ( pcursor2->sqlsuccess() )
                                {
                                fprintf(stderr,
                                        "\nstatement preparation "
                                        "succeeded.\n\n");
                                pcursor2->Close();
                                }
                            else
                                fprintf(stderr, "\nstatement preparation"
                                                " failed.\n");
                            }
                        if ( pcursor2 )
                           delete pcursor2;
                        }
                    else
                        {
                        fprintf(stderr, "\nTranslation failed.\n");
                        }

                    ptblcreator->Close();
                delete ptblcreator;
                } // if connect2.sqlsuccess()
        } // if (env.sqlsuccess())
done:
    fprintf( stderr, "\nExecution complete, use System Menu to exit program!\n" );
    gets(szBuf);
  }
