/*************************************************/
/*  This file uses the INTERSOLV dBASE driver.   */
/*************************************************/
/*
    File:       AUTOCRE1.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to create tables automatically using the
    in-place translation method. This file allows you to enter your own
    driver-independent create table statement, and see its translation
    into a statement tailored to the particular data source.

    To use this file:

    1) Choose a data source.

    2) Enter the table definition in driver-independent syntax.

    3) View the translated statement, including an columns that
       could not be translated or other syntax errors.

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#if defined(__WATCOMC__)
    #include <mem.h>
#else
    #include <memory.h>
#endif

#include <windows.h>

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
    RETCODE ret;

	//buffer for input
    char buf[ 80 ];


    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    
    // enable cursor library in connections.
    env.nCursorLibUsage = SQL_CUR_USE_ODBC;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.

        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
        static char szConnBuf[ 256 ];
        fprintf(stderr, "\nConnecting...\n");
        connect.Connect(
               "dBASEFile",
               "",
               ""
               );


            if (connect.sqlsuccess())
                {
                // create a statement
                odbcTABLECREATOR   tblcreator(&connect);
                tblcreator.AutoRetrieve(odbcREPSUCCESSWITHINFO);
                tblcreator.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
                tblcreator.SetWnd( GetActiveWindow());
#endif
                    static char szStmtOut[ 5000 ] ;
                    static char szStmtIn[ 5000 ] ;
                    static char szBuf[ 128 ];

                    UWORD uStmtSize = sizeof(szStmtOut);
                    fprintf( stderr,
             "Use the following types in your CREATE TABLE statement,\n"
             "with precision and scale in parentheses where appropriate:\n\n");
                    fprintf( stderr,
             "\tCHAR, VARCHAR, LONGVARCHAR\n"
             "\tFLOAT, REAL, DOUBLE\n"
             "\tBINARY, VARBINARY, LONGVARBINARY\n"
             "\tNUMERIC, DECIMAL, INTEGER\n"
             "\tSMALLINT, TINYINT, BIGINT\n"
             "\tTIME, DATE, TIMESTAMP\n"
             "\tBIT\n\n");

                    fprintf( stderr,
             "Wrap types to be translated in <>, like this:\n"
             "\t<CHAR(20)>\t<INTEGER>\t<NUMERIC(10,2)>\n");

                    fprintf( stderr,
             "Example:\n"
             "CREATE TABLE test1 (\n"
             "\tcolumn1 <CHAR(20)> NOT NULL,\n"
             "\tcolumn2 <INTEGER>,\n"
             "\tcolumn3 <NUMERIC(10,2)>\n)\n\n");

                    fprintf( stderr, "\nEnter CREATE TABLE statement "
                                     "(empty line to return to\n"
                                     "connect prompt):\n");

                    strcpy ( szStmtIn, "CREATE TABLE " );
                    fprintf(stderr, szStmtIn);
                    for ( ;; )
                        {
                        if (gets( szBuf) == NULL)
                            break;
                        else if (strlen(szBuf) == 0)
                            break;
                        else
                           strcat( szStmtIn, szBuf );
                        }

                    fprintf( stderr,
                             "Processing '%s'\n",
                             szStmtIn);

                    ret = tblcreator.CreateTable(
                            szStmtIn,
                            szStmtOut,
                            &uStmtSize,
                            TRUE        // just parse for now.
                            ) ;

                    fprintf( stderr,
                             "Ret=%ld, translated as:\n '%s'\n",
                             (long)ret,
                             szStmtOut);

                    // if we succeeded, test the statement out
                    //    by preparing it on a second cursor.
                    if (ret == SQL_SUCCESS)
                       {
                       odbcCURSOR cursor(&connect);
                       cursor.AutoRetrieve(odbcREPERRS);
                       cursor.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
					   cursor.SetWnd( GetActiveWindow());
#endif
                       fprintf(stderr, "\ncreate parsing succeeded.\n");
                       if ( !cursor.sqlsuccess())
                           {fprintf( stderr,
                                    "Unable to create second cursor"
                                    " to try Prepare() call.\n");
		          			goto done;
		          		    }
                       else
                           {
                           cursor.Prepare( szStmtOut );
                           if ( cursor.sqlsuccess() )
                               {
                               fprintf(stderr,
                                        "\nstatement preparation "
                                        "succeeded.\n\n");
                               }
                           else
                               fprintf(stderr, "\nstatement preparation"
                                                " failed.\n");
			       goto done;
                           }
                       }
                    else
                       {
                       fprintf(stderr, "\nCreate failed.\n");
		       goto done;
                       }

                    // close cursor
                    tblcreator.Close();
                                        
                } // if connect.sqlsuccess()
            else
				{
				fprintf( stderr, "\nCould not connect!\n" );
				gets( buf );
				goto done;
                }

            // disconnect
            connect.Disconnect();
            // end outer for loop
        } // if (env.sqlsuccess())

done:    fprintf( stderr, "\nExecution complete, use System Menu to exit program!\n" );
         gets (buf);
  }
