/*
	File:		CONNLIST.CPP
	
	Revision:	2.0 Release
	
	Date:		20-Oct-94

	Author:		Dale Hunscher
	
	Description:
	
	This file is the implementation of the connection list used by
	the environment class.
	
	Engineers:

	DAH - Dale A. Hunscher

	History:

	8-8-93	  DAH	Created.
	10-Nov-94 DAH	Added virtual destructor for odbcCONNELEM.

	/////////////////////////////////////////////////////////////
	///////////////////// NOTICE ////////////////////////////////
	/////////////////////////////////////////////////////////////
		                                                             
	Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.
	
	Information in this document is subject to change without
	notice and does not represent a commitment on the part of
	INTERSOLV, Inc. This software is provided under
	a license agreement or non-disclosure agreement. The software
	may be used and/or copied only in accordance with the terms
	of the governing agreement. It is against the law to copy
	the software on any medium except as specifically allowed
	in the governing agreement. No part of this software may be 
	reproduced or transmitted in any form or by any means, 
	electronic or mechanical, including photocopying, recording,
	or information storage and retrieval systems, for any purpose
	other than the licensee's personal use, without the express
	written permission of INTERSOLV, Inc.
	
	/////////////////////////////////////////////////////////////
*/

#include <sql.hpp>

////////////////////////////////////////////////////////////
///////////////////// connection list //////////////////////
////////////////////////////////////////////////////////////

// see macro definition in sqldefs.hpp

		MSVC_BUGFIX_DEF(odbcCONNELEM)

/**********************************************************
        ~odbcCONNELEM
        
        The class's Destructor.                            
**********************************************************/

        odbcCONNELEM::~odbcCONNELEM( void ){}

// see macro definition in sqldefs.hpp

		MSVC_BUGFIX_DEF(odbcCONNLIST)

/**********************************************************
	odbcCONNLIST
	
	The class's only constructor. Flag argument determines
	whether we automatically invoke delete on the pItem
	member of the list element; default is to delete.                            
**********************************************************/

odbcCONNLIST::odbcCONNLIST(int DestroyElems)
	{
	pBegin = pEnd = NULL;
	fDestroyElems = DestroyElems;
	};                        
	
/**********************************************************
	~odbcCONNLIST
	
	The class's destructor.                            
**********************************************************/

odbcCONNLIST::~odbcCONNLIST()
	{
	odbcCONNELEM *pCurr;
	
	for (pCurr = pBegin; pCurr; )
		{
		odbcCONNELEM *pNext = pCurr->pNext;
		if (fDestroyElems == TRUE
				&& pCurr->pItem)
				delete pCurr->pItem;
		pCurr = pNext;
		}
	};

/**********************************************************
	Add
	
	Add a new item to the list.                            
**********************************************************/

void odbcCONNLIST::Add(odbcCONNECT *pItem)
	{
	odbcCONNELEM *pCurr;
	odbcCONNELEM *pNew = new odbcCONNELEM(pItem);
	
	// if this is the first element, stick in the beginning
	if (!pBegin)
		{
		pBegin = pNew;
		}
	else
		{
		// not the first; find the end of the chain and
		// attach there.
		for (pCurr = pBegin; pCurr->pNext; pCurr = pCurr->pNext)
			;
		pCurr->pNext = pNew;
		}
	};

/**********************************************************
	Remove
	
	Remove a given item from the list. Invoke delete on the
	pItem member of the list element if the DestroyElems
	flag is set.
**********************************************************/

void odbcCONNLIST::Remove(odbcCONNECT *pItem)
	{
	odbcCONNELEM *pCurr, *pElem;    
	// beginning item is a special case
	if (pBegin->pItem == pItem)
		{
		// save the next pointer (may be NULL)
		pCurr = pBegin->pNext;
		// destroy the item if set up to do so
		if (fDestroyElems == TRUE)
			delete pItem;                        
		// delete the conn element
		delete pBegin;
		pBegin = pCurr;
		}
	else
		{
		// walk the list to find the item
		for (
			pCurr = pBegin,
			pElem = pCurr->pNext;              
			pElem != NULL &&
				pElem->pItem != pItem;
			pCurr = pElem,
			pElem = pCurr->pNext
			)
			;
		// if we found the item...                   
		if (pElem != NULL)
			{
			// close the gap created by removal
			pCurr->pNext = pElem->pNext;
			// delete the item if supposed to do so
			if (fDestroyElems == TRUE)
				delete pItem;
			// delete the list element
			delete pElem;
			}			
		}
			
	}



