/*
    File:       CONNECT.CPP
    
    Revision:   2.0 Release
    
    Date:       14-Mar-94

    Author:     Dale Hunscher
    
    Description:
    
    This file gives the implementation of the connection class. It
    provides connection functionality for the library.

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.
    
    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
    
    Engineers:
    DAH     Dale A. Hunscher
    
    Revision History
    ================
    Date        Who     Did What
    -------------------------------------------------------------
    16-Sep-93   DAH     Corrected arguments to cursor constructor
                        due to adding fully automatic binding functions.
    26-Jan-94   DAH 	Enum... functions that created a cursor
                		for enumeration were not always checking
                		the correct object for result codes
                		(sqlsuccess() calls on the connection
                		rather than on the cursor object).
    04-Mar-94   DAH     Added support for ODBC Cursor Library.
    01-Apr-94   DAH     Bug fix: udTimeout argument default value of 5 in the
                        constructors was producing misleading success-with-
                        info returns in some drivers and failure in the Btrieve
                        driver. Default changed to zero and logic changed to
                        call SQLSetConnectOption only if udTimeout > 0.
    17-Apr-94   DAH     Bug fix: was not autoconnecting in constructors
                        if udTimeout was zero (default).
    28-May-94   DAH     Changed logic for RegisterError().  
    28-Jul-94   DAH     Changed order of events in destructor; added
                        check to disconnect if already connected in
                        DriverConnect() and Connect().
    25-Jan-95   MAP 	Added Alloc and DeAlloc functions for RecUpdater,
                		RecInserter, TableCreator, Blobs, and iterators.
						Added array sizes for data dictionary entries for
						sys info iterators to aid in 16-bit static libraries
						not generating "Data segment exceeds 64K" link errors.
*/

#include <sql.hpp>

/**********************************************************
    _SQLStatisticsRSB
    
    Column bindings for result set for SQLStatistics.
**********************************************************/

static sCOLBIND _SQLStatisticsRSB[12] =
    { 
        _colbindChar(1,sSQLSTATISTICSRESULTSET,szTableQualifier,TABLE_QUALIFIER_MAX),
        _colbindChar(2,sSQLSTATISTICSRESULTSET,szTableOwner,TABLE_OWNER_MAX),
        _colbindChar(3,sSQLSTATISTICSRESULTSET,szTableName,TABLE_NAME_MAX),
        _colbindShort(4,sSQLSTATISTICSRESULTSET,fNonUnique),
        _colbindChar(5,sSQLSTATISTICSRESULTSET,szIndexQualifier,INDEX_QUALIFIER_MAX),
        _colbindChar(6,sSQLSTATISTICSRESULTSET,szIndexName,INDEX_NAME_MAX),
        _colbindShort(7,sSQLSTATISTICSRESULTSET,fType),
        _colbindShort(8,sSQLSTATISTICSRESULTSET,fSeqInIndex),
        _colbindChar(9,sSQLSTATISTICSRESULTSET,szColumnName,COLUMN_NAME_MAX),
        _colbindChar(10,sSQLSTATISTICSRESULTSET,cCollation,COLLATION_SIZE),
        _colbindLong(11,sSQLSTATISTICSRESULTSET,nCardinality),
        _colbindLong(12,sSQLSTATISTICSRESULTSET,nPages),
        
    };
        
/**********************************************************
    _SQLTypeInfoRSB
    
    Column bindings for result set for SQLGetTypeInfo.
**********************************************************/

static sCOLBIND _SQLTypeInfoRSB[13] =
    {
        {
        1, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,szTypeName),
        STRING1_MAX,
        },
        
        {
        2, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fDataType),
        sizeof(SWORD),
        },
        
        {
        3, 
        SQL_C_LONG, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fPrecision),
        sizeof(SDWORD),
        },
        
        {
        4, 
        SQL_C_CHAR,
        FIELDOFFSET(sSQLTYPEINFORESULTSET,szLiteralPrefix),
        STRING1_MAX,
        },
        
        {
        5, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,szLiteralSuffix),
        STRING1_MAX,
        },
        
        {
        6, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,szCreateParams),
        STRING1_MAX,
        },
        
        {
        7, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fNullable),
        sizeof(SWORD),
        },
        
        {
        8, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fCaseSensitive),
        0,
        },
        
        {
        9, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fSearchable),
        sizeof(SWORD),
        },
        
        {
        10, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fUnsigned),
        0,
        },
        
        {
        11, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fMoney),
        sizeof(SWORD),
        },
        
        {
        12, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLTYPEINFORESULTSET,fAutoIncrement),
        sizeof(SWORD),
        },
        
        {
        13, 
        SQL_C_CHAR,
        FIELDOFFSET(sSQLTYPEINFORESULTSET,szLocalTypeName),
        STRING1_MAX,
        },
        
    };
        
/**********************************************************
    _SQLTablesRSB
    
    Column bindings for result set for SQLTables.
**********************************************************/

static sCOLBIND _SQLTablesRSB[5] =
    {
        {
        1, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTABLESRESULTSET,szTableQualifier),
        TABLE_QUALIFIER_MAX,
        },
        
        {
        2, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTABLESRESULTSET,szTableOwner),
        TABLE_OWNER_MAX,
        },
        
        {
        3, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTABLESRESULTSET,szTableName),
        TABLE_NAME_MAX,
        },
        
        {
        4, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTABLESRESULTSET,szTableType),
        TABLE_TYPE_MAX,
        },
        
        {
        5, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLTABLESRESULTSET,Remarks),
        REMARKS_MAX,
        },
        
    };
        
/**********************************************************
    _SQLColumnsRSB
    
    Column bindings for result set for SQLColumns.
**********************************************************/

static sCOLBIND _SQLColumnsRSB[ 12 ] =
    {
        {
        1, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,szTableQualifier),
        TABLE_QUALIFIER_MAX,
        },
        
        {
        2, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,szTableOwner),
        TABLE_OWNER_MAX,
        },
        
        {
        3, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,szTableName),
        TABLE_NAME_MAX,
        },
        
        {
        4, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,szColumnName),
        COLUMN_NAME_MAX,
        },
        
        {
        5, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,fDataType),
        sizeof(SWORD),
        },
        
        {
        6, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,szTypeName),
        TYPE_NAME_MAX,
        },
        
        {
        7, 
        SQL_C_LONG, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,fPrecision),
        sizeof(SDWORD),
        },
        
        {
        8, 
        SQL_C_LONG, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,fLength),
        sizeof(SDWORD),
        },
        
        {
        9, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,Scale),
        sizeof(SWORD),
        },
        
        {
        10, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,Radix),
        sizeof(SWORD),
        },
        
        {
        11, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,Nullable),
        sizeof(SWORD),
        },
        
        {
        12, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLCOLUMNSRESULTSET,Remarks),
        REMARKS_MAX,
        },
        
    };
    

/**********************************************************
    _SQLSpecialColumnsRSB
    
    Column bindings for result set for SQLSpecialColumns.
**********************************************************/

static sCOLBIND _SQLSpecialColumnsRSB[ 7 ] =
    {
        {
        1, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,fScope),
        sizeof(SWORD),
        },
        
        {
        2, 
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,szColumnName),
        COLUMN_NAME_MAX,
        },
        
        {
        3, 
        SQL_C_SHORT, 
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,fDataType),
        sizeof(SWORD),
        },
        
        {
        4,
        SQL_C_CHAR, 
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,szTypeName),
        TYPE_NAME_MAX,
        },
        
        {
        5, 
        SQL_C_LONG,
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,fPrecision),
        sizeof(SDWORD),
        },
        
        {
        6, 
        SQL_C_LONG, 
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,fLength),
        sizeof(SDWORD),
        },
        
        {
        7, 
        SQL_C_SHORT,
        FIELDOFFSET(sSQLSPECIALCOLRESULTSET,Scale),
        sizeof(SWORD),
        },
        
    };
        
// new in v2.0

static sCOLBIND _SQLColumnPrivilegesRSB[8] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szTable_qualifier ),
    TABLE_QUALIFIER_SIZE,
    0,
    FALSE,
    "TABLE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szTable_owner ),
    TABLE_OWNER_SIZE,
    0,
    FALSE,
    "TABLE_OWNER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szTable_name ),
    TABLE_NAME_SIZE,
    0,
    FALSE,
    "TABLE_NAME",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   4,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szColumn_name ),
    COLUMN_NAME_SIZE,
    0,
    FALSE,
    "column_name",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   5,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szGrantor ),
    GRANTOR_SIZE,
    0,
    FALSE,
    "GRANTOR",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   6,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szGrantee ),
    GRANTEE_SIZE,
    0,
    FALSE,
    "GRANTEE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   7,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szPrivilege ),
    PRIVILEGE_SIZE,
    0,
    FALSE,
    "PRIVILEGE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   8,
    SQL_C_CHAR,
    FIELDOFFSET( sCOLUMNPRIVILEGESRESULTSET, szIs_grantable ),
    IS_GRANTABLE_SIZE,
    0,
    FALSE,
    "IS_GRANTABLE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
};
const int _SQLColumnPrivilegesRSBCount
    = sizeof(_SQLColumnPrivilegesRSB) / sizeof(_SQLColumnPrivilegesRSB[ 0 ]);

static sCOLBIND _SQLProceduresRSB[7] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURESRESULTSET, szProcedure_qualifier ),
    PROCEDURE_QUALIFIER_SIZE,
    0,
    FALSE,
    "PROCEDURE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURESRESULTSET, szProcedure_owner ),
    PROCEDURE_OWNER_SIZE,
    0,
    FALSE,
    "PROCEDURE_OWNER",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURESRESULTSET, szProcedure_name ),
    PROCEDURE_NAME_SIZE,
    0,
    FALSE,
    "PROCEDURE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   4,
    SQL_C_LONG,
    FIELDOFFSET( sPROCEDURESRESULTSET, lNum_input_params ),
    sizeof(SDWORD),
    0,
    FALSE,
    "NUM_INPUT_PARAMS",
    SQL_INTEGER,
    0,
    0,
    NULL,

},
{   5,
    SQL_C_LONG,
    FIELDOFFSET( sPROCEDURESRESULTSET, lNum_output_params ),
    sizeof(SDWORD),
    0,
    FALSE,
    "NUM_OUTPUT_PARAMS",
    SQL_INTEGER,
    0,
    0,
    NULL,

},
{   6,
    SQL_C_LONG,
    FIELDOFFSET( sPROCEDURESRESULTSET, lNum_result_sets ),
    sizeof(SDWORD),
    0,
    FALSE,
    "NUM_RESULT_SETS",
    SQL_INTEGER,
    0,
    0,
    NULL,

},
{   7,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURESRESULTSET, szRemarks ),
    REMARKS_SIZE,
    0,
    FALSE,
    "REMARKS",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
};
const int _SQLProceduresRSBCount
    = sizeof(_SQLProceduresRSB) / sizeof(_SQLProceduresRSB[ 0 ]);

static sCOLBIND _SQLProcedureColumnsRSB[13] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szProcedure_qualifier ),
    PROCEDURE_QUALIFIER_SIZE,
    0,
    FALSE,
    "PROCEDURE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szProcedure_owner ),
    PROCEDURE_OWNER_SIZE,
    0,
    FALSE,
    "PROCEDURE_OWNER",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szProcedure_name ),
    PROCEDURE_NAME_SIZE,
    0,
    FALSE,
    "PROCEDURE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   4,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szColumn_name ),
    COLUMN_NAME_SIZE,
    0,
    FALSE,
    "COLUMN_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   5,
    SQL_C_SHORT,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, nColumn_type ),
    sizeof(SWORD),
    0,
    FALSE,
    "COLUMN_TYPE",
    SQL_SMALLINT,
    0,
    0,
    NULL,

},
{   6,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szData_type ),
    DATA_TYPE_SIZE,
    0,
    FALSE,
    "DATA_TYPE",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   7,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szType_name ),
    TYPE_NAME_SIZE,
    0,
    FALSE,
    "TYPE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   8,
    SQL_C_LONG,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, lPrecision ),
    sizeof(SDWORD),
    0,
    FALSE,
    "PRECISION",
    SQL_INTEGER,
    0,
    1,
    NULL,

},
{   9,
    SQL_C_LONG,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, lLength ),
    sizeof(SDWORD),
    0,
    FALSE,
    "LENGTH",
    SQL_INTEGER,
    0,
    1,
    NULL,

},
{   10,
    SQL_C_SHORT,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, nScale ),
    sizeof(SWORD),
    0,
    FALSE,
    "SCALE",
    SQL_SMALLINT,
    0,
    1,
    NULL,

},
{   11,
    SQL_C_SHORT,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, nRadix ),
    sizeof(SDWORD),
    0,
    FALSE,
    "RADIX",
    SQL_SMALLINT,
    0,
    0,
    NULL,

},
{   12,
    SQL_C_SHORT,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, nNullable ),
    sizeof(SWORD),
    0,
    FALSE,
    "NULLABLE",
    SQL_SMALLINT,
    0,
    1,
    NULL,

},
{   13,
    SQL_C_CHAR,
    FIELDOFFSET( sPROCEDURECOLUMNSRESULTSET, szRemarks ),
    REMARKS_SIZE,
    0,
    FALSE,
    "REMARKS",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
};
const int _SQLProcedureColumnsRSBCount
    = sizeof(_SQLProcedureColumnsRSB) / sizeof(_SQLProcedureColumnsRSB[ 0 ]);

static sCOLBIND _SQLForeignKeysRSB[12] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szPktable_qualifier ),
    PKTABLE_QUALIFIER_SIZE,
    0,
    FALSE,
    "PKTABLE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szPktable_owner ),
    PKTABLE_OWNER_SIZE,
    0,
    FALSE,
    "PKTABLE_OWNER",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szPktable_name ),
    PKTABLE_NAME_SIZE,
    0,
    FALSE,
    "PKTABLE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   4,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szPkcolumn_name ),
    PKCOLUMN_NAME_SIZE,
    0,
    FALSE,
    "PKCOLUMN_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   5,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szFktable_qualifier ),
    FKTABLE_QUALIFIER_SIZE,
    0,
    FALSE,
    "FKTABLE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   6,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szFktable_owner ),
    FKTABLE_OWNER_SIZE,
    0,
    FALSE,
    "FKTABLE_OWNER",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   7,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szFktable_name ),
    FKTABLE_NAME_SIZE,
    0,
    FALSE,
    "FKTABLE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   8,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szFkcolumn_name ),
    FKCOLUMN_NAME_SIZE,
    0,
    FALSE,
    "FKCOLUMN_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   9,
    SQL_C_SHORT,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, nKey_seq ),
    sizeof(SWORD),
    0,
    FALSE,
    "KEY_SEQ",
    SQL_SMALLINT,
    0,
    1,
    NULL,

},
{   10,
    SQL_C_SHORT,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, nUpdate_rule ),
    sizeof(SWORD),
    0,
    FALSE,
    "Update_Rule",
    SQL_SMALLINT,
    0,
    0,
    NULL,

},
{   11,
    SQL_C_SHORT,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, nDelete_rule ),
    sizeof(SWORD),
    0,
    FALSE,
    "Delete_Rule",
    SQL_SMALLINT,
    0,
    0,
    NULL,

},
{   12,
    SQL_C_CHAR,
    FIELDOFFSET( sFOREIGNKEYSRESULTSET, szRole_name ),
    ROLE_NAME_SIZE,
    0,
    FALSE,
    "ROLE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
};
const int _SQLForeignKeysRSBCount
    = sizeof(_SQLForeignKeysRSB) / sizeof(_SQLForeignKeysRSB[ 0 ]);

static sCOLBIND _SQLTablePrivilegesRSB[7] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szTable_qualifier ),
    TABLE_QUALIFIER_SIZE,
    0,
    FALSE,
    "TABLE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szTable_owner ),
    TABLE_OWNER_SIZE,
    0,
    FALSE,
    "TABLE_OWNER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szTable_name ),
    TABLE_NAME_SIZE,
    0,
    FALSE,
    "TABLE_NAME",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   4,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szGrantor ),
    GRANTOR_SIZE,
    0,
    FALSE,
    "GRANTOR",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   5,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szGrantee ),
    GRANTEE_SIZE,
    0,
    FALSE,
    "GRANTEE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   6,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szPrivilege ),
    PRIVILEGE_SIZE,
    0,
    FALSE,
    "PRIVILEGE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   7,
    SQL_C_CHAR,
    FIELDOFFSET( sTABLEPRIVILEGESRESULTSET, szIs_grantable ),
    IS_GRANTABLE_SIZE,
    0,
    FALSE,
    "IS_GRANTABLE",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
};
const int _SQLTablePrivilegesRSBCount
    = sizeof(_SQLTablePrivilegesRSB) / sizeof(_SQLTablePrivilegesRSB[ 0 ]);

static sCOLBIND _SQLPrimaryKeysRSB[5] =
{
{   1,
    SQL_C_CHAR,
    FIELDOFFSET( sPRIMARYKEYSRESULTSET, szTable_qualifier ),
    TABLE_QUALIFIER_SIZE,
    0,
    FALSE,
    "TABLE_QUALIFIER",
    SQL_VARCHAR,
    0,
    1,
    NULL,

},
{   2,
    SQL_C_CHAR,
    FIELDOFFSET( sPRIMARYKEYSRESULTSET, szTable_owner ),
    TABLE_OWNER_SIZE,
    0,
    FALSE,
    "TABLE_OWNER",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   3,
    SQL_C_CHAR,
    FIELDOFFSET( sPRIMARYKEYSRESULTSET, szTable_name ),
    TABLE_NAME_SIZE,
    0,
    FALSE,
    "TABLE_NAME",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   4,
    SQL_C_CHAR,
    FIELDOFFSET( sPRIMARYKEYSRESULTSET, szColumn_name ),
    COLUMN_NAME_SIZE,
    0,
    FALSE,
    "column_name",
    SQL_VARCHAR,
    0,
    0,
    NULL,

},
{   5,
    SQL_C_SHORT,
    FIELDOFFSET( sPRIMARYKEYSRESULTSET, nKey_seq ),
    sizeof(SWORD),
    0,
    FALSE,
    "KEY_SEQ",
    SQL_SMALLINT,
    0,
    1,
    NULL,

},
};
const int _SQLPrimaryKeysRSBCount
    = sizeof(_SQLPrimaryKeysRSB) / sizeof(_SQLPrimaryKeysRSB[ 0 ]);

// end new in v2.0


///////////////////////////////////////////////////////////
//////////////////////// connections
///////////////////////////////////////////////////////////

/**********************************************************
    odbcCONNECT
    
    constructor.  Environment handle is required; other
    arguments are optional.
**********************************************************/

odbcCONNECT::odbcCONNECT(
        podbcENV    penv,
        LPUSTR      szDSN,
        LPUSTR      szUID,
        LPUSTR      szAuthStr,
        UDWORD      udTimeout
        ) : odbcBASE()
    {
    pEnv = penv;
    pStmtList = 0;
    isConnected = 0;
    hdbc = 0;
    bTrimAllTrailingBlanks = FALSE;
    AutoRetrieve(odbcREPERRS);
    SetRC(SQLAllocConnect(
        pEnv->GetHenv(),
        &hdbc
        ));

    if (sqlsuccess() && udTimeout > 0)
        {
        SQLSetConnectOption(
                hdbc, 
                SQL_LOGIN_TIMEOUT, 
                udTimeout);

        }

    if (sqlsuccess())
        {
#if (ODBCVER >= 0x0200)

        SetRC(
             SetConnectOption(SQL_ODBC_CURSORS, pEnv->nCursorLibUsage)
             );

#endif  // ODBCVER >= 0x0200
        if (szDSN && szUID && szAuthStr && sqlsuccess())
            Connect(
                szDSN,
                szUID,
                szAuthStr
                );
        }
    // inherit error handling from environment
    ErrHandler          = pEnv->ErrHandler;
    bGetErrorInfo       = pEnv->bGetErrorInfo;
    bReportErrorInfo    = pEnv->bReportErrorInfo;
    hwnd                = pEnv->hwnd;
    flags               = pEnv->flags;

    pEnv->RegisterConnection(this);
    };

odbcCONNECT::odbcCONNECT(
        podbcENV    penv,
        LPSTR       szDSN,
        LPSTR       szUID,
        LPSTR       szAuthStr,
        UDWORD      udTimeout
        ) : odbcBASE()
    {
    pEnv = penv;
    pStmtList = 0;
    isConnected = 0;
    hdbc = 0;
    bTrimAllTrailingBlanks = FALSE;
    AutoRetrieve(odbcREPERRS);
    SetRC(SQLAllocConnect(
        pEnv->GetHenv(),
        &hdbc
        ));

    if (sqlsuccess() && udTimeout > 0)
        {
        SQLSetConnectOption(
                hdbc, 
                SQL_LOGIN_TIMEOUT, 
                udTimeout);

        }

    if (sqlsuccess())
        {
#if (ODBCVER >= 0x0200)

        SetRC(
             SetConnectOption(SQL_ODBC_CURSORS, pEnv->nCursorLibUsage)
             );

#endif  // ODBCVER >= 0x0200

        if (szDSN && szUID && szAuthStr && sqlsuccess())
            Connect(
                szDSN,
                szUID,
                szAuthStr
                );
        }

    // inherit error handling from environment
    ErrHandler          = pEnv->ErrHandler;
    bGetErrorInfo       = pEnv->bGetErrorInfo;
    bReportErrorInfo    = pEnv->bReportErrorInfo;
    hwnd                = pEnv->hwnd;
    flags               = pEnv->flags;

    pEnv->RegisterConnection(this);
    };

/**********************************************************
    ~odbcCONNECT
    
    Destructor.
**********************************************************/

odbcCONNECT::~odbcCONNECT() 
    {
    // close cursors first
    if (pStmtList)
        {
        delete pStmtList;
        pStmtList = NULL;
        }

    // then disconnect
    if (isConnected)
        Disconnect();

    // then free the connection handle
    if (hdbc)
        {
        SQLFreeConnect(hdbc);
        hdbc = NULL;
        }

    if ( pEnv && !IsBadReadPtr( pEnv, sizeof(*pEnv)))    
        pEnv->UnregisterConnection(this);
    };

/**********************************************************
    Connect
    
    Call to SQLConnect, passing data set name, user ID,
    and password.
**********************************************************/

RETCODE odbcCONNECT::Connect(
        LPUSTR szDSN,
        LPUSTR szUID,
        LPUSTR szAuthStr
        )
        {
        if (!hdbc)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }

        // if already connected, disconnect
        if ( isConnected )
            Disconnect();

        SetRC(
            SQLConnect(
                hdbc,
                szDSN,
                SQL_NTS,
                szUID,
                SQL_NTS,
                szAuthStr,
                SQL_NTS
                ));

        if (sqlsuccess())
           {
            isConnected = TRUE;
           }

        return lastRC();
        };

/**********************************************************
    Disconnect
    
    Call to SQLDisconnect.
**********************************************************/

RETCODE odbcCONNECT::Disconnect(void)
        {
        if (!hdbc)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        if (isConnected)
            {
            SetRC(SQLDisconnect(hdbc));

            if (sqlsuccess())
                isConnected = FALSE;
            }
        return lastRC();
        };

/**********************************************************
    Commit
    
    Call to SQLTransact to commit a transaction.
**********************************************************/

RETCODE odbcCONNECT::Commit(void)
        {
        if (!hdbc)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }

        SetRC(SQLTransact(
            SQL_NULL_HENV,
            hdbc,
            SQL_COMMIT
            ));

        return lastRC();
        };

/**********************************************************
    RollBack
    
    Call to SQLTransact to roll back a transaction.
**********************************************************/

RETCODE odbcCONNECT::RollBack(void)
        {
        if (!hdbc)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }

        SetRC(SQLTransact(
            SQL_NULL_HENV,
            hdbc,
            SQL_ROLLBACK
            ));

        return lastRC();
        };

/**********************************************************
    RegisterError

    Get more information on the most recent error code
    from an ODBC operation. Results can be retrieved using
    member functions in the parent odbcBASE class.
    
    This function calls the base class member function Error()
    with arguments appropriate for this object type.
**********************************************************/

RETCODE odbcCONNECT::RegisterError(void)
    {
    return Error(
        henv,
        (hdbc != NULL) ? hdbc : SQL_NULL_HDBC,
        SQL_NULL_HSTMT
        );
    }


/**********************************************************
    AllocStmt
    
    Allocate a statement object.
    
    lpszStmt:       SQL statement to use.
    bPrepare:       if non-zero, call SQLPrepare.
    bExecute:       Call SQLExecDirect (or SQLExecute
                    if bPrepare was non-zero).
    psParmBindings: address of array of parameter bindings.
    uParmCount:     count of array elements.
    pvParmStruct:   Address of structure containing
                    parameter values.
**********************************************************/

podbcSTMT      odbcCONNECT::AllocStmt
            (
            LPUSTR      lpszSentStmt,
            BOOL        bPrepare,
            BOOL        bExecute,
            psPARMBIND  psParmBindings,
            UWORD       uParmCount,
            PTR         pvParmStruct
            )
        {
        podbcSTMT pS = new odbcSTMT
                        (
                        this,
                        lpszSentStmt,
                        bPrepare,
                        bExecute,
                        psParmBindings,
                        uParmCount,
                        pvParmStruct
                        );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }            
            
        return pS;
        };
        
        
/**********************************************************
    RegisterStmt
    
    Register an odbcSTMT object.
**********************************************************/

void odbcCONNECT::RegisterStmt(podbcSTMT pStmt)
    {
        if (!pStmtList)
            pStmtList = new odbcSTMTLIST;
        if (!pStmtList)
           {
           SetRC(SQL_ALLOC_FAILED);
           }
        else
            pStmtList->Add(pStmt);
        
    }
        

/**********************************************************
    UnregisterStmt
    
    Unregister an odbcSTMT object.
**********************************************************/

void odbcCONNECT::UnregisterStmt(podbcSTMT pStmt)
    {
    if (pStmtList)
        pStmtList->Remove(pStmt);
    }
        

/**********************************************************
    AllocCursor
    
    Allocate a cursor object.

    lpszStmt:       SQL statement to use.
    bPrepare:       if non-zero, call SQLPrepare.
    bExecute:       Call SQLExecDirect (or SQLExecute
                    if bPrepare was non-zero).
    bAutoBind:      Automatically bind columns 
                    to dynamically allocated struct?
    psParmBindings: Address of array of parameter bindings.
    uParmCount:     Count of array elements.
    pvParmStruct:   Address of structure containing
                    parameter values.
    pColBindings:   Address of array of column bindings.
    uColcount:      Count of array elements.
    pvColStruct:    Address of structure for column bindings.                   
**********************************************************/

podbcCURSOR      odbcCONNECT::AllocCursor
            (
            LPUSTR  lpszSentStmt,
            BOOL        bPrepare,
            BOOL        bExecute,
            BOOL        bAutoBind,
            psPARMBIND  psParmBindings,
            UWORD       uParmCount,
            PTR         pvParmStruct,
            psCOLBIND   psColBindings,
            UWORD       uColCount,
            PTR         pvColStruct
            )
        {
        podbcCURSOR pS = new odbcCURSOR
                        (
                        this,
                        lpszSentStmt,
                        bPrepare,
                        bExecute,
                        bAutoBind,
                        psParmBindings,
                        uParmCount,
                        pvParmStruct,
                        psColBindings,
                        uColCount,
                        pvColStruct
                        );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocStmt

    Deallocate a statement object.
**********************************************************/

void odbcCONNECT::DeAllocStmt(
            podbcSTMT pS
            )
        {
        delete pS;
        };           
        
        
/**********************************************************
    AllocRecInserter
    
    Allocate a RecInserter object.
    
    lpszSentTableName   Name of the table into which you
                        are inserting records.  This must be a
                        table on the current connection.

    pColBinds
    uNumColBindings
    pRecord             If supplied, these are used for data
                        dictionary-style column binding instead
                        of the default AutoBind() mechanism.
                        The user is responsible for ensuring'
                        that the dictionary entry's column
                        definitions will match the order
                        of the query result set's columns
                        (matching SELECT * FROM <tablename>),
                        and that the conversion types make
                        sense (e.g., if you bind a SQL_NUMERIC
                        column to a storage location of type
                        SQL_DATE, you are responsible for the
                        resulting garbaggio in your record).

**********************************************************/

podbcRECINSERTER odbcCONNECT::AllocRecInserter
            (
            LPCSTR          lpszSentTblName,
            psCOLBIND       pColBinds       /* = NULL */,
            UWORD           uNumColBindings /* = 0 */,
            PTR             pRecord         /* = NULL */
            )
        {
        podbcRECINSERTER pS = new odbcRECINSERTER
                        (
                        this,
                        lpszSentTblName,
                        pColBinds,
                        uNumColBindings,
                        pRecord
                        );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocRecInserter

    Deallocate a statement object.
**********************************************************/

void odbcCONNECT::DeAllocRecInserter(
            podbcRECINSERTER pS
            )
        {
        delete pS;
        };  
        
/**********************************************************
    AllocRecUpdater
    
    Allocate a RecUpdater object.
    
    lpszSentTableName   Name of the table into which you
                        are inserting records.  This must be a
                        table on the current connection.

    pColBinds
    uNumColBindings
    pRecord             If supplied, these are used for data
                        dictionary-style column binding instead
                        of the default AutoBind() mechanism.
                        The user is responsible for ensuring'
                        that the dictionary entry's column
                        definitions will match the order
                        of the query result set's columns
                        (matching SELECT * FROM <tablename>),
                        and that the conversion types make
                        sense (e.g., if you bind a SQL_NUMERIC
                        column to a storage location of type
                        SQL_DATE, you are responsible for the
                        resulting garbaggio in your record).

**********************************************************/

podbcRECUPDATER odbcCONNECT::AllocRecUpdater
            (
            LPCSTR          lpszSentTblName,
            LPCSTR          lpszSelectStmt,
            psCOLBIND       pColBinds       /* = NULL*/,
            UWORD           uNumColBindings /* = 0*/,
            PTR             pRecord         /* = NULL*/,
            BOOL            bExecDirect     /* = TRUE*/,
            UWORD           fConcur         /* = SQL_CONCUR_VALUES*/,
            SDWORD          fKeyset         /* = SQL_CURSOR_STATIC*/,
            UWORD           fRowSet         /* = 1 */
            )
        {
        podbcRECUPDATER pS = new odbcRECUPDATER
                        (
                        this,
                        lpszSentTblName,
                        lpszSelectStmt,
                        pColBinds,
                        uNumColBindings,
                        pRecord,
                        bExecDirect,
                        fConcur,
                        fKeyset,
                        fRowSet
                        );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocRecUpdater

    Deallocate a RecUpdater object.
**********************************************************/

void odbcCONNECT::DeAllocRecUpdater(
            podbcRECUPDATER pS
            )
        {
        delete pS;
        };
        
/**********************************************************
    AllocTableCreator
    
    Allocate a TableCreator object.    
**********************************************************/
                 
podbcTABLECREATOR odbcCONNECT::AllocTableCreator(void)
        {
        podbcTABLECREATOR pS = new odbcTABLECREATOR
                        (
                        this
                        );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocTableCreator

    Deallocate a TableCreator object.
**********************************************************/

void odbcCONNECT::DeAllocTableCreator(
            podbcTABLECREATOR pS
            )
        {
        delete pS;
        };                 
                 
/**********************************************************
    AllocBLOB
    
    Allocate a BLOB object.  
    
    Pass address of owning cursor, number of the
    associated column, and maximum size of the parameter;
    optionally also pass the column's SQL data type and
    put- and get-chunk granularities.  
**********************************************************/
                 
podbcBLOB odbcCONNECT::AllocBLOB(
            podbcCURSOR pCurs,
            UWORD iSentCol,
            UDWORD cbSentMaxSize,
            SWORD  fSentSqlType,            /* = SQL_LONGVARBINARY */
            UWORD  iSentParam,              /* = 0 */
            SDWORD cbSentPutChunkSize,      /* = BLOB_CHUNK_PUT_SIZE */
            SDWORD cbSentGetChunkSize       /* = BLOB_CHUNK_GET_SIZE */
            )
        {
        podbcBLOB pS = new odbcBLOB
            (
            pCurs,
            iSentCol,
            cbSentMaxSize,
            fSentSqlType,
            iSentParam,
            cbSentPutChunkSize,
            cbSentGetChunkSize      
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocBLOB

    Deallocate a BLOB object. 
    
    pS      BLOB to deallocate.
**********************************************************/

void odbcCONNECT::DeAllocBLOB(
            podbcBLOB pS
            )
        {
        delete pS;
        };                 


/**********************************************************
    AllocColumnIterator
    
    Allocate a ColumnIterator object.  
**********************************************************/
                 
podbcColumnIterator odbcCONNECT::AllocColumnIterator(
            LPSTR szTableQualifier,
            LPSTR szTableOwner,
            LPSTR szTableName,
            LPSTR szColumnName
            )
        {
        podbcColumnIterator pS = new odbcColumnIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName,
            szColumnName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocColumnIterator

    Deallocate a ColumnIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocColumnIterator(
            podbcColumnIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocColumnPrivilegesIterator
        
    Allocate a ColumnPrivilegesIterator object.  
**********************************************************/
                 
podbcColumnPrivilegesIterator odbcCONNECT::AllocColumnPrivilegesIterator(
            LPSTR szTableQualifier,
            LPSTR szTableOwner,
            LPSTR szTableName,
            LPSTR szColumnName
            )
        {
        podbcColumnPrivilegesIterator pS = new odbcColumnPrivilegesIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName,
            szColumnName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocColumnPrivilegesIterator

    Deallocate a ColumnPrivilegesIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocColumnPrivilegesIterator(
            podbcColumnPrivilegesIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocForeignKeysIterator
    
    Allocate a ForeignKeysIterator object.  
**********************************************************/
                 
podbcForeignKeysIterator odbcCONNECT::AllocForeignKeysIterator(
            LPSTR szPkTableQualifier,
            LPSTR szPkTableOwner,
            LPSTR szPkTableName,
            LPSTR szFkTableQualifier,
            LPSTR szFkTableOwner,
            LPSTR szFkTableName
            )
        {
        podbcForeignKeysIterator pS = new odbcForeignKeysIterator
            (
            this,
            szPkTableQualifier,
            szPkTableOwner,
            szPkTableName,
            szFkTableQualifier,
            szFkTableOwner,
            szFkTableName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocForeignKeysIterator

    Deallocate a ForeignKeysIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocForeignKeysIterator(          
            podbcForeignKeysIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocPrimaryKeysIterator
    
    Allocate a PrimaryKeysIterator object.  
**********************************************************/
                 
podbcPrimaryKeysIterator odbcCONNECT::AllocPrimaryKeysIterator(
            LPSTR szTableQualifier,
            LPSTR szTableOwner,
            LPSTR szTableName
            )
        {
        podbcPrimaryKeysIterator pS = new odbcPrimaryKeysIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocPrimaryKeysIterator

    Deallocate a PrimaryKeysIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocPrimaryKeysIterator(          
            podbcPrimaryKeysIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocProcedureColumnsIterator
    
    Allocate a ProcedureColumnsIterator object.  
**********************************************************/
                 
podbcProcedureColumnsIterator odbcCONNECT::AllocProcedureColumnsIterator(
            LPSTR szProcQualifier,
            LPSTR szProcOwner,
            LPSTR szProcName,
            LPSTR szProcColumn
            )
        {
        podbcProcedureColumnsIterator pS = new odbcProcedureColumnsIterator
            (
            this,
            szProcQualifier,
            szProcOwner,
            szProcName,
            szProcColumn
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocProcedureColumnsIterator

    Deallocate a ProcedureColumnsIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocProcedureColumnsIterator(
            podbcProcedureColumnsIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocProceduresIterator
    
    Allocate a ProceduresIterator object.  
**********************************************************/
                 
podbcProceduresIterator odbcCONNECT::AllocProceduresIterator(
            LPSTR szProcQualifier,
            LPSTR szProcOwner,
            LPSTR szProcName
            )
        {
        podbcProceduresIterator pS = new odbcProceduresIterator
            (
            this,
            szProcQualifier,
            szProcOwner,
            szProcName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocProceduresIterator

    Deallocate a ProceduresIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocProceduresIterator(
            podbcProceduresIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocSpecialColumnIterator
    
    Allocate a SpecialColumnIterator object.  
**********************************************************/
                 
podbcSpecialColumnIterator odbcCONNECT::AllocSpecialColumnIterator(
            UWORD                   fColType,
            LPSTR                   szTableQualifier,
            LPSTR                   szTableOwner,
            LPSTR                   szTableName,
            UWORD                   fScope,
            UWORD                   fNullable
            )
        {
        podbcSpecialColumnIterator pS = new odbcSpecialColumnIterator
            (
            this,
            fColType,
            szTableQualifier,
            szTableOwner,
            szTableName,
            fScope,
            fNullable
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocSpecialColumnIterator

    Deallocate a SpecialColumnIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocSpecialColumnIterator(
            podbcSpecialColumnIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocStatisticsIterator
    
    Allocate a StatisticsIterator object.  
**********************************************************/
                 
podbcStatisticsIterator odbcCONNECT::AllocStatisticsIterator(
            LPSTR                   szTableQualifier,
            LPSTR                   szTableOwner,
            LPSTR                   szTableName,
            UWORD                   fTblUnique,
            UWORD                   fTblAccuracy
            )
        {
        podbcStatisticsIterator pS = new odbcStatisticsIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName,
            fTblUnique,
            fTblAccuracy
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocStatisticsIterator

    Deallocate a StatisticsIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocStatisticsIterator(         
            podbcStatisticsIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocTableIterator
    
    Allocate a TableIterator object.  
**********************************************************/
                 
podbcTableIterator odbcCONNECT::AllocTableIterator(
            LPSTR                  szTableQualifier,
            LPSTR                  szTableOwner,
            LPSTR                  szTableName,
            LPSTR                  szTableType
            )
        {
        podbcTableIterator pS = new odbcTableIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName,
            szTableType
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocTableIterator

    Deallocate a TableIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocTableIterator(
            podbcTableIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocTablePrivilegesIterator
    
    Allocate a TablePrivilegesIterator object.  
**********************************************************/
                 
podbcTablePrivilegesIterator odbcCONNECT::AllocTablePrivilegesIterator(
            LPSTR szTableQualifier,
            LPSTR szTableOwner,
            LPSTR szTableName
            )
        {
        podbcTablePrivilegesIterator pS = new odbcTablePrivilegesIterator
            (
            this,
            szTableQualifier,
            szTableOwner,
            szTableName
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocTablePrivilegesIterator

    Deallocate a TablePrivilegesIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocTablePrivilegesIterator(
            podbcTablePrivilegesIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    AllocTypeInfoIterator
    
    Allocate a TypeInfoIterator object.  
**********************************************************/
                 
podbcTypeInfoIterator odbcCONNECT::AllocTypeInfoIterator(void)
        {
        podbcTypeInfoIterator pS = new odbcTypeInfoIterator
            (
            this
            );

        if (!pS)
            {
            SetRC(SQL_ALLOC_FAILED);
            return NULL;
            }
        
        return pS;
        };

/**********************************************************
    DeAllocTypeInfoIterator

    Deallocate a TypeInfoIterator object. 
**********************************************************/

void odbcCONNECT::DeAllocTypeInfoIterator(
            podbcTypeInfoIterator pS
            )
        {
        delete pS;
        };                 

/**********************************************************
    GetConnectOption
    
    Call SQLGetConnectOption.
    
    The various Get... member functions call the same
    function with the appropriate flag.
**********************************************************/

UDWORD odbcCONNECT::GetConnectOption(UWORD      fOption)
        {
        UDWORD Result = 0;
        
        SetRC(
            SQLGetConnectOption(
                hdbc,
                fOption,
                &Result
                ));
        
        return Result;
        }


/**********************************************************
    SetConnectOption
    
    Call SQLSetConnectOption.
    
    The various Set... member functions call the same
    function with the appropriate flag.
**********************************************************/

RETCODE odbcCONNECT::SetConnectOption(
                        UWORD       fOption,
                        UDWORD      ulValue
                        )
    {
    SetRC(
        SQLSetConnectOption(
                hdbc,
                fOption,
                ulValue
                ));
                
    return lastRC();
    }


/**********************************************************
    DriverConnect
    
    Call SQLDriverConnect; pass-through function.
    
**********************************************************/

RETCODE odbcCONNECT::DriverConnect(
                        HWND        hwnd,
                        LPUCSTR     szConnStrIn,
                        LPUSTR      szConnStrOut,
                        SWORD       cbConnStrOutMax,
                        SWORD      *pcbConnStrOut,
                        UWORD       fDriverCompletion
                        )
    {
    // if we didn't construct, don't try to connect
    if (!hdbc)
       {
       SetRC(SQL_ALLOC_FAILED);
       return lastRC();
       }

    // if already connected, disconnect
    if ( isConnected )
        Disconnect();
    
    if ( hwnd && !IsWindow(hwnd))
    {
        return SQL_ERROR;
    }
        
    SetRC(
        SQLDriverConnect(
                hdbc,
                hwnd,
                (LPUSTR)szConnStrIn,
                SQL_NTS,
                szConnStrOut,
                cbConnStrOutMax,
                pcbConnStrOut,
                fDriverCompletion
                ));
                
    if (sqlsuccess())
        isConnected = TRUE;

    return lastRC();
    }

/**********************************************************
    DriverConnectNoPrompt
    
    Call SQLDriverConnect, using contents of szConnStrIn;
    do not prompt with any dialog, but return an error if
    the connection information in the string is not enough.
    Use strlen() to obtain the length of szConnStrOut,
    but only if the function succeeded.
**********************************************************/

RETCODE odbcCONNECT::DriverConnectNoPrompt(
                        LPUCSTR     szConnStrIn,
                        LPUSTR      szConnStrOut,
                        SWORD       cbConnStrOutMax
                        )
    {
    SWORD  cbConnStrOut;
    
    DriverConnect(
                NULL,
                szConnStrIn,
                szConnStrOut,
                cbConnStrOutMax,
                &cbConnStrOut,
                SQL_DRIVER_NOPROMPT
                );

    return lastRC();
    }

/**********************************************************
    DriverConnectComplete
    
    Call SQLDriverConnect; prompt to complete the connection,
    if insufficient information is provided in szConnStrIn.
    Use strlen() to obtain the length of szConnStrOut,
    but only if the function succeeded.
**********************************************************/

RETCODE odbcCONNECT::DriverConnectComplete(
                        HWND        hwnd,
                        LPUCSTR     szConnStrIn,
                        LPUSTR      szConnStrOut,
                        SWORD       cbConnStrOutMax
                        )
    {
    SWORD  cbConnStrOut;
    
    DriverConnect(
                hwnd,
                szConnStrIn,
                szConnStrOut,
                cbConnStrOutMax,
                &cbConnStrOut,
                SQL_DRIVER_COMPLETE
                );
                
    return lastRC();
    }

/**********************************************************
    DriverConnectPrompt

    Call SQLDriverConnect; tells driver to prompt for
    connection information.
    Use strlen() to obtain the length of szConnStrOut,
    but only if the function succeeded.
**********************************************************/

RETCODE odbcCONNECT::DriverConnectPrompt(
                        HWND        hwnd,
                        LPUSTR      szConnStrOut,
                        SWORD       cbConnStrOutMax
                        )
    {
    SWORD   cbConnStrOut;
    UCHAR   szConnStrIn[255];
    
    szConnStrIn[0] = 0;
    
    DriverConnect(
                hwnd,
                szConnStrIn,
                szConnStrOut,
                cbConnStrOutMax,
                &cbConnStrOut,
                SQL_DRIVER_PROMPT
                );
                
    return lastRC();
    }

/**********************************************************
    DriverConnectCompleteRequired
    
    Calls SQLDriverConnect; tells driver to complete any
    required items not in the szConnStrIn argument.
    Use strlen() to obtain the length of szConnStrOut,
    but only if the function succeeded.
**********************************************************/

RETCODE odbcCONNECT::DriverConnectCompleteRequired(
                        HWND        hwnd,
                        LPUCSTR     szConnStrIn,
                        LPUSTR      szConnStrOut,
                        SWORD       cbConnStrOutMax
                        )
    {
    SWORD  cbConnStrOut;

    DriverConnect(
                hwnd,
                szConnStrIn,
                szConnStrOut,
                cbConnStrOutMax,
                &cbConnStrOut,
                SQL_DRIVER_COMPLETE_REQUIRED
                );
                
    return lastRC();
    }

/**********************************************************
    GetFunctions
    
    Call SQLGetFunctions.
    
**********************************************************/

UWORD odbcCONNECT::GetFunctions(UWORD fFunction)
    {
    UWORD uExists = 0;
    
    SetRC(
        SQLGetFunctions(
                hdbc,
                fFunction,
                &uExists
                ));
                
    return uExists;
    }

/**********************************************************
    GetInfo
    
    Call SQLGetInfo.
    
**********************************************************/

RETCODE odbcCONNECT::GetInfo(
    UWORD      fInfoType,
    PTR        rgbInfoValue,
    SWORD      cbInfoValueMax,
    SWORD      *pcbInfoValue)
    {
    SetRC(
        SQLGetInfo(
            hdbc,
            fInfoType,
            rgbInfoValue,
            cbInfoValueMax,
            pcbInfoValue
            ));
            
    return lastRC();
    }

/**********************************************************
    SQLColumnsRSBCount
    
    Count of structures in array of column bindings for the
    result set of SQLColumns.
**********************************************************/

UWORD odbcCONNECT::SQLColumnsRSBCount(void)
    {
    return sizeof(_SQLColumnsRSB) / sizeof(_SQLColumnsRSB[0]);
    }
    
/**********************************************************
    SQLColumnsRSB
    
    Address of array of structures describing column bindings 
    for the result set of SQLColumns.
**********************************************************/

psCOLBIND odbcCONNECT::SQLColumnsRSB(void)
    {
    return _SQLColumnsRSB;
    }
    
/**********************************************************
    SQLSpecialColumnsRSBCount
    
    Count of structures in array of column bindings for the
    result set of SQLSpecialColumns.
**********************************************************/

UWORD odbcCONNECT::SQLSpecialColumnsRSBCount(void)
    {
    return sizeof(_SQLSpecialColumnsRSB) / sizeof(_SQLSpecialColumnsRSB[0]);
    }
    
/**********************************************************
    SQLSpecialColumnsRSB
    
    Address of array of structures describing column bindings 
    for the result set of SQLSpecialColumns.
**********************************************************/

psCOLBIND odbcCONNECT::SQLSpecialColumnsRSB(void)
    {
    return _SQLSpecialColumnsRSB;
    }
    
/**********************************************************
    SQLTypeInfoRSBCount
    
    Count of structures in array of column bindings for the
    result set of SQLTypeInfo.
**********************************************************/

UWORD odbcCONNECT::SQLTypeInfoRSBCount(void)
    {
    return sizeof(_SQLTypeInfoRSB) / sizeof(_SQLTypeInfoRSB[0]);
    }
    
/**********************************************************
    SQLTypeInfoRSB
    
    Address of array of structures describing column bindings 
    for the result set of SQLTypeInfo.
**********************************************************/

psCOLBIND odbcCONNECT::SQLTypeInfoRSB(void)
    {
    return _SQLTypeInfoRSB;
    }
    
/**********************************************************
    SQLProcedureColumnsRSBCount

    Count of structures in array of column bindings for the
    result set of SQLProcedureColumns.
**********************************************************/

UWORD odbcCONNECT::SQLProcedureColumnsRSBCount(void)
    {
    return sizeof(_SQLProcedureColumnsRSB) / sizeof(_SQLProcedureColumnsRSB[0]);
    }
    
/**********************************************************
    SQLProcedureColumnsRSB
    
    Address of array of structures describing column bindings 
    for the result set of SQLProcedureColumns.
**********************************************************/

psCOLBIND odbcCONNECT::SQLProcedureColumnsRSB(void)
    {
    return _SQLProcedureColumnsRSB;
    }

/**********************************************************
    SQLTablesRSBCount
    
    Count of structures in array of column bindings for the
    result set of SQLTables.
**********************************************************/

UWORD odbcCONNECT::SQLTablesRSBCount(void)
    {
    return sizeof(_SQLTablesRSB) / sizeof(_SQLTablesRSB[0]);
    }
    
/**********************************************************
    SQLTablesRSB
    
    Address of array of structures describing column bindings 
    for the result set of SQLTables.
**********************************************************/

psCOLBIND odbcCONNECT::SQLTablesRSB(void)
    {
    return _SQLTablesRSB;
    }
    
/**********************************************************
    SQLStatisticsRSBCount

    Count of structures in array of column bindings for the
    result set of SQLStatistics.
**********************************************************/

UWORD odbcCONNECT::SQLStatisticsRSBCount(void)
    {
    return sizeof(_SQLStatisticsRSB) / sizeof(_SQLStatisticsRSB[0]);
    }
    
/**********************************************************
    SQLStatisticsRSB
    
    Address of array of structures describing column bindings
    for the result set of SQLStatistics.
**********************************************************/

psCOLBIND odbcCONNECT::SQLStatisticsRSB(void)
    {
    return _SQLStatisticsRSB;
    }
    
/**********************************************************
    SQLColumnPrivilegesRSBCount

    Count of structures in array of column bindings for the
    result set of SQLColumnPrivileges.
**********************************************************/

UWORD odbcCONNECT::SQLColumnPrivilegesRSBCount(void)
    {
    return sizeof(_SQLColumnPrivilegesRSB) / sizeof(_SQLColumnPrivilegesRSB[0]);
    }

/**********************************************************
    SQLColumnPrivilegesRSB

    Address of array of structures describing column bindings
    for the result set of SQLColumnPrivileges.
**********************************************************/

psCOLBIND odbcCONNECT::SQLColumnPrivilegesRSB(void)
    {
    return _SQLColumnPrivilegesRSB;
    }

/**********************************************************
    SQLProceduresRSBCount

    Count of structures in array of column bindings for the
    result set of SQLProcedures.
**********************************************************/

UWORD odbcCONNECT::SQLProceduresRSBCount(void)
    {
    return sizeof(_SQLProceduresRSB) / sizeof(_SQLProceduresRSB[0]);
    }

/**********************************************************
    SQLProceduresRSB

    Address of array of structures describing column bindings
    for the result set of SQLProcedures.
**********************************************************/

psCOLBIND odbcCONNECT::SQLProceduresRSB(void)
    {
    return _SQLProceduresRSB;
    }

/**********************************************************
    SQLForeignKeysRSBCount

    Count of structures in array of column bindings for the
    result set of SQLForeignKeys.
**********************************************************/

UWORD odbcCONNECT::SQLForeignKeysRSBCount(void)
    {
    return sizeof(_SQLForeignKeysRSB) / sizeof(_SQLForeignKeysRSB[0]);
    }

/**********************************************************
    SQLForeignKeysRSB

    Address of array of structures describing column bindings
    for the result set of SQLForeignKeys.
**********************************************************/

psCOLBIND odbcCONNECT::SQLForeignKeysRSB(void)
    {
    return _SQLForeignKeysRSB;
    }

/**********************************************************
    SQLTablePrivilegesRSBCount

    Count of structures in array of column bindings for the
    result set of SQLTablePrivileges.
**********************************************************/

UWORD odbcCONNECT::SQLTablePrivilegesRSBCount(void)
    {
    return sizeof(_SQLTablePrivilegesRSB) / sizeof(_SQLTablePrivilegesRSB[0]);
    }

/**********************************************************
    SQLTablePrivilegesRSB

    Address of array of structures describing column bindings
    for the result set of SQLTablePrivileges.
**********************************************************/

psCOLBIND odbcCONNECT::SQLTablePrivilegesRSB(void)
    {
    return _SQLTablePrivilegesRSB;
    }

/**********************************************************
    SQLPrimaryKeysRSBCount

    Count of structures in array of column bindings for the
    result set of SQLPrimaryKeys.
**********************************************************/

UWORD odbcCONNECT::SQLPrimaryKeysRSBCount(void)
    {
    return sizeof(_SQLPrimaryKeysRSB) / sizeof(_SQLPrimaryKeysRSB[0]);
    }

/**********************************************************
    SQLPrimaryKeysRSB

    Address of array of structures describing column bindings
    for the result set of SQLPrimaryKeys.
**********************************************************/

psCOLBIND odbcCONNECT::SQLPrimaryKeysRSB(void)
    {
    return _SQLPrimaryKeysRSB;
    }

/**********************************************************
    EnumColumns
    
    Calls SQLColumns and enumerates the result set, passing
    each column's data attributes as a structure to the
    callback function supplied by the caller.
    
**********************************************************/

RETCODE odbcCONNECT::EnumColumns(
                        LPUSTR          szTableQualifier,
                        LPUSTR          szTableOwner,
                        LPUSTR          szTableName,
                        LPUSTR          szColumnName,
                        pfENUMCOLUMNS   pfEnum,
                        PTR             pUser
                        )
    {                             
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psSQLCOLUMNSRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sSQLCOLUMNSRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLColumnsRSB(),
                    SQLColumnsRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->Columns(
            szTableQualifier,
            szTableOwner,
            szTableName,
            szColumnName
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }


/**********************************************************
    EnumSpecialColumns

    Calls SQLSpecialColumns and enumerates the result set,
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumSpecialColumns(
                        UWORD               fColType,
                        LPUSTR              szTableQualifier,
                        LPUSTR              szTableOwner,
                        LPUSTR              szTableName,
                        UWORD               fScope,
                        UWORD               fNullable,
                        pfENUMSPECIALCOL    pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psSQLSPECIALCOLRESULTSET psResultSet;
    RETCODE ret;
    
    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sSQLSPECIALCOLRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLSpecialColumnsRSB(),
                    SQLSpecialColumnsRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
          {
          SetRC(SQL_ALLOC_FAILED);
          delete psResultSet;
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // columns
    pCursor->SpecialColumns(
            fColType,
            szTableQualifier,
            szTableOwner,
            szTableName,
            fScope,
            fNullable
            );

    if (!pCursor->sqlsuccess())
          {
          ret = pCursor->lastRC();
          delete psResultSet;
          DeAllocCursor(pCursor);
          return ret;
          }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }


/**********************************************************
    EnumTables
    
    Calls SQLTables and enumerates the result set, 
    passing each table's data attributes as a structure to 
    the callback function supplied by the caller.
    
**********************************************************/

RETCODE odbcCONNECT::EnumTables(
                        LPUSTR          szTableQualifier,
                        LPUSTR          szTableOwner,
                        LPUSTR          szTableName,
                        LPUSTR          szTableType,
                        pfENUMTABLES    pfEnum, 
                        PTR             pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psSQLTABLESRESULTSET psResultSet;
    RETCODE ret;
    
    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sSQLTABLESRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLTablesRSB(), 
                    SQLTablesRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->Tables(
            szTableQualifier,
            szTableOwner,
            szTableName,
            szTableType
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            delete psResultSet;
            DeAllocCursor(pCursor);
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumStatistics

    Calls SQLStatistics and enumerates the result set,
    passing each table's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumStatistics(
                        LPUSTR              szTableQualifier,
                        LPUSTR              szTableOwner,
                        LPUSTR              szTableName,
                        UWORD               fUnique,
                        UWORD               fAccuracy,
                        pfENUMSTATISTICS    pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psSQLSTATISTICSRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sSQLSTATISTICSRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLStatisticsRSB(),
                    SQLStatisticsRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->Statistics(
            szTableQualifier,
            szTableOwner,
            szTableName,
            fUnique,
            fAccuracy
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            delete psResultSet;
            DeAllocCursor(pCursor);
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    GetTypeInfo
    
    Calls SQLGetTypeInfo. Pass the flag of a specific type,
    and it returns the type's attributes in the result
    set structure.
    
**********************************************************/

RETCODE odbcCONNECT::GetTypeInfo    (
            UWORD                   fSQLType,
            rsSQLTYPEINFORESULTSET  rsResultSet
                                    )
    {
    // make a cursor
    psSQLTYPEINFORESULTSET  psResultSet;
    podbcCURSOR pCursor = AllocCursor();
    RETCODE ret;

    psResultSet = new sSQLTYPEINFORESULTSET;

    if (!psResultSet)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }

    // bind columns for result set
    pCursor->BindCol(
                    SQLTypeInfoRSB(),
                    SQLTypeInfoRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }


    // columns
    pCursor->GetTypeInfo(
            fSQLType
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // get the result set (first one only; there should be only one).
    pCursor->Fetch();

    // return the result set to the user
    ret = pCursor->lastRC();
    if ( pCursor->sqlsuccess() )
        {
        rsResultSet = *psResultSet;
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return ret;
    }

/**********************************************************
    EnumTypeInfo

    Calls SQLGetTypeInfo with flag to get attributes of
    all types and enumerates the result set,
    passing each table's data attributes as a structure to 
    the callback function supplied by the caller.
    
**********************************************************/

RETCODE odbcCONNECT::EnumTypeInfo(
            pfENUMTYPEINFO      pfEnum, 
            PTR                 pUser)
    {
    // make a cursor
    psSQLTYPEINFORESULTSET  psResultSet;
    podbcCURSOR pCursor = AllocCursor();
    RETCODE ret;
    
    if (!pCursor)
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sSQLTYPEINFORESULTSET;
    
    if (!psResultSet)
           {
           SetRC(SQL_ALLOC_FAILED);
           DeAllocCursor(pCursor);
           return lastRC();
           }

    // bind columns for result set
    pCursor->BindCol(
                    SQLTypeInfoRSB(), 
                    SQLTypeInfoRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // get type info for all types
    pCursor->GetTypeInfo(
            SQL_ALL_TYPES
            );
    
    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set. 
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            delete psResultSet;
            DeAllocCursor(pCursor);
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

// new in v2.0

/**********************************************************
    EnumProcedureColumns
    
    Calls SQLProcedureColumns and enumerates the result set, 
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.
    
**********************************************************/

RETCODE odbcCONNECT::EnumProcedureColumns(
                        LPUSTR              szProcQualifier,
                        LPUSTR              szProcOwner,
                        LPUSTR              szProcName,
                        LPUSTR              szColumnName,
                        pfENUMPROCEDURECOL  pfEnum, 
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psPROCEDURECOLUMNSRESULTSET psResultSet;
    RETCODE ret;

    if (!pCursor)
          {
          SetRC(SQL_ALLOC_FAILED);
          return lastRC();
          }

    psResultSet = new sPROCEDURECOLUMNSRESULTSET;
    
    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLProcedureColumnsRSB(), 
                    SQLProcedureColumnsRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        DeAllocCursor(pCursor);
        delete psResultSet;
        return ret;
        }
    
    // columns
    pCursor->ProcedureColumns(
                        szProcQualifier,
                        szProcOwner,
                        szProcName,
                        szColumnName
                        );
    
    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        DeAllocCursor(pCursor);
        delete psResultSet;
        return ret;
        }
    
    // cycle through the result set. 
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }
    
    delete psResultSet;                             
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumProcedures
    
    Calls SQLProcedures and enumerates the result set, 
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.
    
**********************************************************/

RETCODE odbcCONNECT::EnumProcedures(
                        LPUSTR              szProcQualifier,
                        LPUSTR              szProcOwner,
                        LPUSTR              szProcName,
                        pfENUMPROCEDURES    pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psPROCEDURESRESULTSET psResultSet;
    RETCODE ret;

    if (!pCursor)
          {
          SetRC(SQL_ALLOC_FAILED);
          return lastRC();
          }

    psResultSet = new sPROCEDURESRESULTSET;
    
    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLProceduresRSB(), 
                    SQLProceduresRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        DeAllocCursor(pCursor);
        delete psResultSet;
        return ret;
        }
    
    // columns
    pCursor->Procedures(
                        szProcQualifier,
                        szProcOwner,
                        szProcName
                        );
    
    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        DeAllocCursor(pCursor);
        delete psResultSet;
        return ret;
        }
    
    // cycle through the result set. 
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }
    
    delete psResultSet;                             
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumColumnPrivileges

    Calls SQLColumnPrivileges and enumerates the result set,
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumColumnPrivileges(
                        LPUSTR              szTableQualifier,
                        LPUSTR              szTableOwner,
                        LPUSTR              szTableName,
                        LPUSTR              szColumnName,
                        pfENUMCOLPRIVS      pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psCOLUMNPRIVILEGESRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sCOLUMNPRIVILEGESRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLColumnPrivilegesRSB(),
                    SQLColumnPrivilegesRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->ColumnPrivileges(
            szTableQualifier,
            szTableOwner,
            szTableName,
            szColumnName
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumTablePrivileges

    Calls SQLTablePrivileges and enumerates the result set,
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumTablePrivileges(
                        LPUSTR              szTableQualifier,
                        LPUSTR              szTableOwner,
                        LPUSTR              szTableName,
                        pfENUMTABLEPRIVS    pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psTABLEPRIVILEGESRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sTABLEPRIVILEGESRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLTablePrivilegesRSB(),
                    SQLTablePrivilegesRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->TablePrivileges(
            szTableQualifier,
            szTableOwner,
            szTableName
            );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumForeignKeys

    Calls SQLForeignKeys and enumerates the result set,
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumForeignKeys(
                        LPUSTR              szPkTableQualifier,
                        LPUSTR              szPkTableOwner,
                        LPUSTR              szPkTableName,
                        LPUSTR              szFkTableQualifier,
                        LPUSTR              szFkTableOwner,
                        LPUSTR              szFkTableName,
                        pfENUMFOREIGNKEYS   pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psFOREIGNKEYSRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sFOREIGNKEYSRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLForeignKeysRSB(),
                    SQLForeignKeysRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->ForeignKeys(
                   szPkTableQualifier,
                   szPkTableOwner,
                   szPkTableName,
                   szFkTableQualifier,
                   szFkTableOwner,
                   szFkTableName
                   );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

/**********************************************************
    EnumPrimaryKeys

    Calls SQLPrimaryKeys and enumerates the result set,
    passing each column's data attributes as a structure to
    the callback function supplied by the caller.

**********************************************************/

RETCODE odbcCONNECT::EnumPrimaryKeys(
                        LPUSTR              szTableQualifier,
                        LPUSTR              szTableOwner,
                        LPUSTR              szTableName,
                        pfENUMPRIMARYKEYS   pfEnum,
                        PTR                 pUser
                        )
    {
    // make a cursor
    podbcCURSOR pCursor = AllocCursor();
    psPRIMARYKEYSRESULTSET psResultSet;
    RETCODE ret;

    if ( !pCursor )
        {
        SetRC(SQL_ALLOC_FAILED);
        return lastRC();
        }

    psResultSet = new sPRIMARYKEYSRESULTSET;

    if (!psResultSet)
          {
          SetRC(SQL_ALLOC_FAILED);
          DeAllocCursor(pCursor);
          return lastRC();
          }

    // bind columns for result set
    pCursor->BindCol(
                    SQLPrimaryKeysRSB(),
                    SQLPrimaryKeysRSBCount(),
                    psResultSet);

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // columns
    pCursor->PrimaryKeys
                   (
                   szTableQualifier,
                   szTableOwner,
                   szTableName
                   );

    if (!pCursor->sqlsuccess())
        {
        ret = pCursor->lastRC();
        delete psResultSet;
        DeAllocCursor(pCursor);
        return ret;
        }

    // cycle through the result set.
    for (
        pCursor->Fetch();
        pCursor->sqlsuccess();
        pCursor->Fetch()
        )
        {
        ret = (*pfEnum)(*psResultSet, pUser);
        if (ret != SQL_SUCCESS)
            {
            DeAllocCursor(pCursor);
            delete psResultSet;
            return ret;
            }
        }

    delete psResultSet;
    DeAllocCursor(pCursor);
    return lastRC();
    }

// end new in v2.0

/**********************************************************
    NativeSql

    Calls SQLNativeSql to have the driver translate the
    given SQL statement into .

**********************************************************/

RETCODE odbcCONNECT::NativeSql(
    UCHAR      *szSqlStrIn,
    UCHAR      *szSqlStr,
    SDWORD     cbSqlStrMax,
    SDWORD     *pcbSqlStr)
    {
    SetRC(
        SQLNativeSql(
            hdbc,
            szSqlStrIn,
            SQL_NTS,
            szSqlStr,
            cbSqlStrMax,
            pcbSqlStr));
            
    return lastRC();
    }

    
