/*
    File:       SQLDEFS.HPP
    
    Revision:   2.0 Release
    
    Date:       14-Mar-94
    
    Author:     Dale Hunscher
    
    Description:
    
    This file provides constant and macro definitions.

        Engineers:
    DAH             Dale A. Hunscher  
    MAP             Mark A. Place
    
    Revision History
    ================
    Date            Who             Did What
    -------------------------------------------------------------
    11-Jun-94       DAH             Added new features for v2.0.
    29-Dec-94       DAH             Added MAX_REASONABLE_C_BLOB_SIZE
                                    constant; propagated changes
                                    for importing into
                                    a DLL from the 16-bit to the
                                    32-bit definitions for 
                                    odbcEXPORTED.
    25-Jan-95       MAP             Added CLASSDEFS for iterators.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/

#if !defined(_SQLDEFS_HPP)
#define _SQLDEFS_HPP

#include <stddef.h>

typedef UCHAR *             LPUSTR;
typedef const UCHAR    *   LPUCSTR;

//***********************************************************************
// This macro provides a workaround for a bug in MSVC. The bug is
// documented in the MS developer's library under "Wrong Operator
// Delete Called for Exported Class": When allocating and deleting
// an object of a class that is exported from a DLL, the DLL's delete
// operator may be called when the application's delete operator should
// be called.

// This means that if you construct/destruct an object from the class
// library using new/delete, and there are new/delete operators defined
// for the application, then the application's new will be called but
// the dll's delete will be called. If the two are not compatible then
// you will have a problem (most likely a memory leak). The workaround
// is to define new\delete operators for all classes exported from the DLL
// and these macros help do that.
//
// If you wish to remove the new/delete operators from all the exported
// classes, then comment out #define FIX_MSVC_DELETE_BUG and rebuild
// the DLL. Only do this if you are sure that the application does not
// provide new/delete operators. (NOTE that the debug version of MFC
// provides new/delete operators but the release version does not).
//***********************************************************************

#define FIX_MSVC_DELETE_BUG
#if defined(_MSC_VER) && defined(FIX_MSVC_DELETE_BUG)
#define MSVC_BUGFIX_DCL \
	void* operator new(size_t);\
	void operator delete(void*);

#define MSVC_BUGFIX_DEF(className) \
	void* className::operator new(size_t size)\
		{ return new char[size]; }\
	void className::operator delete(void* ptr)\
		{ delete ptr; }
#else
#define MSVC_BUGFIX_DCL
#define MSVC_BUGFIX_DEF(className)
#endif

// use these constants in place of NULL to overcome
// 'ambiguous call to overloaded function' errors

#define NULL_LPUSTR     ( ( LPUSTR  ) NULL )
#define NULL_LPSTR      ( ( LPSTR   ) NULL )
#define NULL_LPUCSTR    ( ( LPUCSTR ) NULL )
#define NULL_LPCSTR     ( ( LPCSTR  ) NULL )

#if !defined( WIN32 ) && !defined( __WIN32__ )
    #if defined ( __BCPLUSPLUS__ )

        #define HUGE huge
        #define odbcINTERNAL huge

        #if defined( __DLL__ ) && !defined( IMPORT_ODBCLASSLIB )
            #define odbcEXPORTED _export
        #else
            #define odbcEXPORTED huge
        #endif

    #elif defined( _MSC_VER )

        #define HUGE huge
        // for internal classes
        #define odbcINTERNAL far

        // for external classes
        #ifdef _DLL
            #define odbcEXPORTED _export
        #else
            #if defined( _WINDLL ) && !defined( IMPORT_ODBCLASSLIB )
                #define odbcEXPORTED _export
            #else
                #define odbcEXPORTED far
            #endif
        #endif

    #elif defined(__WATCOMC__)

        #define HUGE huge
        
        #if defined(__DLL__)
            // for internal classes
            #define odbcINTERNAL _cdecl

            // for external classes
            #define odbcEXPORTED _export _cdecl
        #else
            // for internal classes
            #define odbcINTERNAL far

            // for external classes
            #define odbcEXPORTED far
        #endif

    #else // or other compilers

        #define HUGE huge
        // for internal classes
        #define odbcINTERNAL

        // for external classes
        #define odbcEXPORTED _export

#endif
#else // WIN32
    #if defined ( __BCPLUSPLUS__ )
    
        #if defined( __DLL__ ) && !defined( IMPORT_ODBCLASSLIB )
            #define odbcEXPORTED _export
        #else
            #define odbcEXPORTED 
        #endif

        #define odbcINTERNAL

        #define HUGE

        // these huge memory allocation functions are not needed
        // in WIN32
        #define halloc( a, b ) new char[ (a) * (b) ]
        #define hfree( a ) delete[] (char *)(a)

    #elif defined(__WATCOMC__)

        #define odbcEXPORTED _export
        #define odbcINTERNAL
       // #define halloc(a,b)     calloc(a,b)
       // #define hfree(a)        free(a)        
        #define HUGE

    #elif defined(_MSC_VER) // MS VC++ 2.0

        #if !defined( IMPORT_ODBCLASSLIB )
//          #pragma message ( "#define odbcEXPORTED _declspec( dllexport )" )
            #define odbcEXPORTED _declspec( dllexport )
        #else
//          #pragma message ( "#define odbcEXPORTED" )
            #define odbcEXPORTED
        #endif

        #define odbcINTERNAL
        // these huge memory allocation functions are not needed
        // in WIN32
        #define halloc( a, b ) new char[ (a) * (b) ]
        #define hfree( a ) delete[] (char *)(a)
        #define HUGE

    #else  // other compilers

        #define odbcEXPORTED _export
        #define odbcINTERNAL

        #define HUGE

        // these huge memory allocation functions are not needed
        // in WIN32
        #define halloc( a, b ) new char[ (a) * (b) ]
        #define hfree( a ) delete[] (char *)(a)

    #endif

#endif // if !defined( WIN32 )

#define ___CLASSDEFS(c)\
class odbcEXPORTED c;\
typedef c     *p##c;\
typedef c     & r##c;\
typedef const c     *cp##c;\
typedef const c     & cr##c

#define ___STRUCTDEFS(s)\
struct odbcEXPORTED s;\
typedef s     *p##s;\
typedef s     & r##s;\
typedef const s     *cp##s;\
typedef const s     & cr##s

// classes in v1.0
___CLASSDEFS(odbcBASE);
___CLASSDEFS(odbcSTMTELEM);
___CLASSDEFS(odbcSTMTLIST);
___CLASSDEFS(odbcCONNELEM);
___CLASSDEFS(odbcCONNLIST);
___CLASSDEFS(odbcCURSOR);
___CLASSDEFS(odbcSTMT);
___CLASSDEFS(odbcCONNECT);
___CLASSDEFS(odbcENV);
// iterator classes in v1.0
___CLASSDEFS(odbcTableIterator);
___CLASSDEFS(odbcColumnIterator);
___CLASSDEFS(odbcStatisticsIterator);
___CLASSDEFS(odbcSpecialColumnIterator);
___CLASSDEFS(odbcTypeInfoIterator);

// new in v2.0
___CLASSDEFS(odbcTABLECREATOR);
___CLASSDEFS(odbcRECORD);
___CLASSDEFS(odbcRECINSERTER);
___CLASSDEFS(odbcRECUPDATER);
___CLASSDEFS(odbcBLOB); 
// iterator classes added in v2.0
___CLASSDEFS(odbcColumnPrivilegesIterator);
___CLASSDEFS(odbcForeignKeysIterator);
___CLASSDEFS(odbcPrimaryKeysIterator);
___CLASSDEFS(odbcProcedureColumnsIterator);
___CLASSDEFS(odbcProceduresIterator);
___CLASSDEFS(odbcTablePrivilegesIterator);

// end new in v2.0

const int odbcSTATE_SIZE = (SQL_SQLSTATE_SIZE+1);
const int odbcERRMSG_SIZE = SQL_MAX_MESSAGE_LENGTH;

const int odbcNOREPORT              = 0;
const int odbcREPERRS               = 1;
const int odbcREPSUCCESSWITHINFO    = 2;
const int STRING1_MAX               = 128;
const int TABLE_QUALIFIER_MAX       = STRING1_MAX;
const int TABLE_OWNER_MAX           = STRING1_MAX;
const int TABLE_NAME_MAX            = STRING1_MAX;
const int TABLE_TYPE_MAX            = STRING1_MAX;
const int COLUMN_NAME_MAX           = STRING1_MAX;
const int TYPE_NAME_MAX             = STRING1_MAX;
const int REMARKS_MAX               = 254;
const int DSN_DESC_MAX              = STRING1_MAX;
const int INDEX_QUALIFIER_MAX       = STRING1_MAX;
const int INDEX_NAME_MAX            = STRING1_MAX;
const int COLLATION_SIZE            = 1;
const int LIBERRMSGSIZE             = 32;

// new in v2.0

const int STRING2_MAX               = 256;
const int SQLSTMT_MAX               = 5000;

#if (ODBCVER >= 0x0200)
const int DRIVER_MAX                = STRING1_MAX;
const int DRIVER_ATTRIBS_MAX        = STRING2_MAX;
#endif // if (ODBCVER >= 0x0200)

// additional error code defines

#define UNKNOWN_ERR_MSG "[INTERSOLV][DTK for C++]Unknown error."
const RETCODE SQL_ALLOC_FAILED          = -1000;
#define MEM_ERR_MSG "[INTERSOLV][DTK for C++]Memory allocation error."

// new in v2.0
const RETCODE SQL_BUFFER_TOO_SMALL          = -1001;
#define BUF_WARN_MSG "[INTERSOLV][DTK for C++]Buffer too small."
const RETCODE SQL_BAD_PARAMETER             = -1002;
#define BADPARM_ERR_MSG "[INTERSOLV][DTK for C++]Bad parameter."
const RETCODE SQL_NOT_EXTSETUP              = -1003;
#define NOTEXT_ERR_MSG "[INTERSOLV][DTK for C++]Not set up for extended fetch operations."
const RETCODE SQL_ILLFORMED_STMT            = -1004;
#define ILLSTMT_ERR_MSG "[INTERSOLV][DTK for C++]Ill-formed statement."
const RETCODE SQL_CANT_CONVERT_DATATYPE     = -1005;
#define CVT_ERR_MSG "[INTERSOLV][DTK for C++]Can't convert data type."
const RETCODE SQL_BAD_CURSOR                = -1006;
#define BADCUR_ERR_MSG "[INTERSOLV][DTK for C++]Bad cursor pointer encountered."
const RETCODE SQL_STMT_CTOR_FAILED   = -1007;
#define INSCTOR_ERR_MSG "[INTERSOLV][DTK for C++]Internal secondary statement constructor failed."
const RETCODE SQL_INTERNAL_INSERT_FAILED    = -1008;
#define INTINS_ERR_MSG "[INTERSOLV][DTK for C++]Internal insert operation failed."
const RETCODE SQL_UPDATE_STMT_CTOR_FAILED   = -1009;
#define UPDCTOR_ERR_MSG "[INTERSOLV][DTK for C++]Internal update/delete statement failed."
const RETCODE SQL_INTERNAL_UPDATE_FAILED    = -1010;
#define INTUPD_ERR_MSG "[INTERSOLV][DTK for C++]Internal update operation failed."
const RETCODE SQL_INTERNAL_DELETE_FAILED    = -1011;
#define INTDEL_ERR_MSG "[INTERSOLV][DTK for C++]Internal delete operation failed."
const RETCODE SQL_INTERNAL_SETPOS_FAILED    = -1012;
#define INTSETPOS_ERR_MSG "[INTERSOLV][DTK for C++]Internal SetPos operation failed."
const RETCODE SQL_NULL_TBL_NAME             = -1013;
#define NULLTBL_ERR_MSG "[INTERSOLV][DTK for C++]InternalodbcRECORD class requires table name."
const RETCODE SQL_NO_SELECT                 = -1014;
#define NOT_SELECT_MSG "[INTERSOLV][DTK for C++]InternalStatement passed to odbcRECORD was not a SELECT statement."
const RETCODE SQL_INTERNAL_PREPARE_FAILED    = -1015;
#define INTPREP_ERR_MSG "[INTERSOLV][DTK for C++]Internal prepare operation failed."
const RETCODE SQL_NO_DATA_IN_BLOB            = -1016;
#define EMPTYBLOB_ERR_MSG "[INTERSOLV][DTK for C++]BLOB did not contain data."
const RETCODE SQL_CORRUPT_DATA_IN_BLOB       = -1017;
#define CORRUPTBLOB_ERR_MSG "[INTERSOLV][DTK for C++]BLOB contains corrupt data."
const RETCODE SQL_DATA_CONVERT_ERROR         = -1018;
#define DATACVT_ERR_MSG "[INTERSOLV][DTK for C++]Error converting data into BLOB format."
const RETCODE SQL_BAD_DISP_COLUMN            = -1019;
#define DISPCOL_ERR_MSG "[INTERSOLV][DTK for C++]Unknown or non-character display column in dialog operation."
const RETCODE SQL_BAD_ATTACH_COLUMN          = -1020;
#define ATTCOL_ERR_MSG "[INTERSOLV][DTK for C++]Unknown attach column in list box operation."
const RETCODE SQL_ENTRY_FMT_ERROR            = -1021;
#define ENTRYFMT_ERR_MSG "[INTERSOLV][DTK for C++]Data entry formatting error."
const RETCODE SQL_ENTRY_RANGE_ERROR          = -1022;
#define ENTRYRANGE_ERR_MSG "[INTERSOLV][DTK for C++]Data entry range error."
const RETCODE SQL_NO_EXT_OPS                = -1023;
#define NOEXTOPS_ERR_MSG "[INTERSOLV][DTK for C++]Extended ins/upd/del operations not supported."
const RETCODE SQL_APPEND_WHERE_CLAUSE_FAILED = -1024;
#define APPENDWHERE_ERR_MSG "[INTERSOLV][DTK for C++]WHERE clause append operation failed."
const RETCODE SQL_BLOB_TYPE_MISMATCH         = -1025;
#define BADBLOB_ERR_MSG "[INTERSOLV][DTK for C++]BLOB did not contain data of the expected type."

const RETCODE SQL_INTERNAL_ERR_MAX   =       SQL_ALLOC_FAILED;
const RETCODE SQL_INTERNAL_ERR_MIN   =       SQL_BLOB_TYPE_MISMATCH;

#if defined(WIN32)
#if !defined(FIELDOFFSET)
#define FIELDOFFSET(type, field)    ((int)(&((type *)1)->field)-1)
#endif // if !defined(FIELDOFFSET)

#endif // if defined(WIN32)

// Procedures and ProcedureColumns
const unsigned PROCEDURE_QUALIFIER_SIZE         = 255 ;
const unsigned PROCEDURE_OWNER_SIZE             = 129 ;
const unsigned PROCEDURE_NAME_SIZE              = 129 ;
const unsigned REMARKS_SIZE                     = 255 ;

// ProcedureColumns
const unsigned COLUMN_NAME_SIZE                 = 129 ;
const unsigned DATA_TYPE_SIZE                   = 9 ;
const unsigned TYPE_NAME_SIZE                   = 8 ;

// ForeignKeys
const unsigned PKTABLE_QUALIFIER_SIZE           = 512 ;
const unsigned PKTABLE_OWNER_SIZE               = 129 ;
const unsigned PKTABLE_NAME_SIZE                = 129 ;
const unsigned PKCOLUMN_NAME_SIZE               = 129 ;
const unsigned FKTABLE_QUALIFIER_SIZE           = 512 ;
const unsigned FKTABLE_OWNER_SIZE               = 129 ;
const unsigned FKTABLE_NAME_SIZE                = 129 ;
const unsigned FKCOLUMN_NAME_SIZE               = 129 ;
const unsigned ROLE_NAME_SIZE                   = 129 ;

// ColumnPrivileges and TablePrivileges and PrimaryKeys
const unsigned TABLE_QUALIFIER_SIZE             = 255 ;
const unsigned TABLE_OWNER_SIZE                 = 129 ;
const unsigned TABLE_NAME_SIZE                  = 129 ;
const unsigned GRANTOR_SIZE                     = 129 ;
const unsigned GRANTEE_SIZE                     = 129 ;
const unsigned PRIVILEGE_SIZE                   = 11 ;
const unsigned IS_GRANTABLE_SIZE                = 4 ;

// macros to determine type category for SQL types
#define TypeIsInteger( t ) \
    ((t)==SQL_BIT || (t)==SQL_INTEGER || \
    (t)==SQL_SMALLINT || (t)==SQL_BIGINT || (t)==SQL_TINYINT)

#define TypeIsCurrency( t ) \
    ((t)==SQL_NUMERIC || (t)==SQL_DECIMAL)

#define TypeIsDate( t ) \
    ((t)==SQL_DATE)

#define TypeIsTime( t ) \
    ((t)==SQL_TIME)

#define TypeIsTimestamp( t ) \
    ((t)==SQL_TIMESTAMP)

#define TypeIsNumeric( t ) \
    ((t)==SQL_REAL || (t)==SQL_FLOAT || (t)==SQL_DOUBLE \
         || TypeIsCurrency((t)))

#define TypeIsCharacter( t ) \
    ((t)==SQL_CHAR || (t)==SQL_VARCHAR || (t)==SQL_LONGVARCHAR)

#define TypeIsBinary( t ) \
    ((t)==SQL_BINARY || (t)==SQL_VARBINARY || (t)==SQL_LONGVARBINARY)

// in 16-bit this will be a huge void pointer - in 32-bit, just a void pointer
typedef void HUGE * HPTR;

// these are the default sizes for BLOB data transfers 
// in PutData() and GetData() calls respectively - they work
// fine with MS Access but may need to be optimized for other
// data sources.
const UDWORD BLOB_CHUNK_PUT_SIZE = 65536L;
const UDWORD BLOB_CHUNK_GET_SIZE = 32768L;

// special return codes from odbcBLOB::GetData()
const RETCODE SQL_NULL_DATA_FOUND = 32000;
const RETCODE SQL_EMPTY_DATA_FOUND = 32001;

const UDWORD MAX_REASONABLE_C_CHAR_SIZE   = (UDWORD)4096L;
const UDWORD MAX_REASONABLE_C_BINARY_SIZE = (UDWORD)4096L;
const SDWORD MAX_REASONABLE_C_BLOB_SIZE   = (SDWORD)0x3fffefL; // ~4MB

// end new in v2.0



#endif // if !defined(_SQLDEFS_HPP)
