/*
        File:           CRETABLE.HPP
        
        Revision:       2.0 Release

        Date:           24-July-94
        
        Author:         Dale Hunscher
        
        Description:

        This file describes the interface to the table creator class. It
        provides a means for driver-independent table creation.

        Engineers:
        DAH             Dale A. Hunscher

        Revision History
        ================
        Date            Who             Did What
        -------------------------------------------------------------
        24-Jul-94       DAH             Created.

        /////////////////////////////////////////////////////////////
        ///////////////////// NOTICE ////////////////////////////////
        /////////////////////////////////////////////////////////////

        Copyright (c) 1994-1995 by INTERSOLV, Inc. All rights reserved.

        Information in this document is subject to change without
        notice and does not represent a commitment on the part of
        INTERSOLV, Inc. This software is provided under
        a license agreement or non-disclosure agreement. The software
        may be used and/or copied only in accordance with the terms
        of the governing agreement. It is against the law to copy
        the software on any medium except as specifically allowed
        in the governing agreement. No part of this software may be
        reproduced or transmitted in any form or by any means,
        electronic or mechanical, including photocopying, recording,
        or information storage and retrieval systems, for any purpose
        other than the licensee's personal use, without the express
        written permission of INTERSOLV, Inc.

        /////////////////////////////////////////////////////////////

*/

#if !defined(_CRETABLE_HPP)
#define _CRETABLE_HPP

class odbcEXPORTED odbcTABLECREATOR : public odbcCURSOR {
private:
// don't allow copy
    odbcTABLECREATOR & operator=( odbcTABLECREATOR & )
        {
        return *this;
        } ;
    odbcTABLECREATOR( odbcTABLECREATOR & )
                        : odbcCURSOR( NULL ) {} ;

protected:
char *lpszCreateStmt;
char *token;
/***************************************************

    szTab

    String to use as tabs in CREATE TABLE statements.
***************************************************/

    LPSTR   szTab;
/***************************************************

    szEoln

    String to use as end-of-line in CREATE TABLE statements.
***************************************************/

    LPSTR   szEoln;
    
/***************************************************

    ConvertCreateColumnType

    Convert user-passed standard column type name to
    a data-source specific name on this connection.
***************************************************/

    virtual RETCODE ConvertCreateColumnType(
                        LPSTR      lpszCreateStmt,
                        size_t *   pi,
                        LPCSTR     token,
                        UDWORD     ibColDef,
                        SWORD      ibScale ) ;

    virtual RETCODE ConvertCreateColumnType(
                        LPUSTR     lpszCreateStmt,
                        size_t *   pi,
                        LPUCSTR    token,
                        UDWORD     ibColDef,
                        SWORD      ibScale )
                        {
                        return ConvertCreateColumnType(
                                (LPSTR)lpszCreateStmt,
                                pi,
                                (LPCSTR)token,
                                ibColDef,
                                ibScale ) ;
                        } ;

    virtual RETCODE ConvertCreateColumnType(
                        LPSTR      lpszCreateStmt,
                        size_t *   pi,
                        LPCSTR     token,
                        SWORD      fType,
                        UDWORD     ibColDef,
                        SWORD      ibScale ) ;

    virtual RETCODE ConvertCreateColumnType(
                        LPUSTR     lpszCreateStmt,
                        size_t *   pi,
                        LPUCSTR    token,
                        SWORD      fType,
                        UDWORD     ibColDef,
                        SWORD      ibScale )
                        {
                        return ConvertCreateColumnType(
                                (LPSTR)lpszCreateStmt,
                                pi,
                                (LPCSTR)token,
                                fType,
                                ibColDef,
                                ibScale ) ;
                        } ;
/***************************************************

    ColumnTypeFromToken

    Convert user-passed standard column type name to
    an ODBC SQL_xxxx data type; also set precision to
    minimum value if equal to zero.
***************************************************/

    virtual RETCODE ColumnTypeFromToken(
                        LPCSTR      lpszToken,
                        SWORD     * pfType,
                        UDWORD     *pfPrecision ) ;

    virtual RETCODE ColumnTypeFromToken(
                        LPUCSTR     lpszToken,
                        SWORD     * pfType,
                        UDWORD     *pfPrecision )
                        {
                        return
                            ColumnTypeFromToken(
                                (LPCSTR)lpszToken,
                                pfType,
                                pfPrecision ) ;

                        } ;

/***************************************************

    GetCreateTypeName

    GetCreateTypeName takes an ODBC SQL type and returns the name as
    a string for use in CreateTable.
***************************************************/

    virtual LPCSTR GetCreateTypeName( SWORD fSqlType ) ;

public:
/***************************************************

    odbcTABLECREATOR

    Constructor.
***************************************************/

    odbcTABLECREATOR( podbcCONNECT pConnect );

/***************************************************

    ~odbcTABLECREATOR

    Destructor.
***************************************************/

    virtual ~odbcTABLECREATOR( void );

/***************************************************

    SetszTab

    Set string to use as tabs in CREATE TABLE statements.
***************************************************/

    LPSTR   SetszTab(LPSTR szNew)
            {
            LPSTR szRet = szTab;
            szTab = szNew;
            return szRet;
            };
            
/***************************************************

    SetszEoln

    Set string to use as end-of-line in CREATE TABLE statements.
***************************************************/

    LPSTR   SetszEoln(LPSTR szNew)
            {
            LPSTR szRet = szEoln;
            szEoln = szNew;      
            return szRet;
            };
            
    
/***************************************************

    CreateTable

    Create a table (or just generate a CREATE TABLE
    SQL statement) from a passed SQL statement template
    using the driver-independent type names.
***************************************************/

    virtual RETCODE CreateTable(
        LPCSTR       lpszSqlIn,
        LPSTR        lpszSqlStmtCreated = NULL,
        UWORD *      puStmtBufferSize = NULL,
        BOOL         bJustGenerateSql = FALSE
        ) ;

    virtual RETCODE CreateTable(
        LPUCSTR      lpszSqlIn,
        LPUSTR       lpszSqlStmtCreated = NULL,
        UWORD *      puStmtBufferSize = NULL,
        BOOL         bJustGenerateSql = FALSE
        )
        {
        return  CreateTable
                    (
                    (LPCSTR)lpszSqlIn,
                    (LPSTR)lpszSqlStmtCreated,
                    puStmtBufferSize,
                    bJustGenerateSql
                    ) ;
        } ;

/***************************************************

    CreateTable

    Create a table (or just generate a CREATE TABLE
    SQL statement) from an array of sCOLBIND structs.
***************************************************/

    virtual RETCODE CreateTable(
        LPCSTR       lpszTableName,
        cpsCOLBIND   cpsColInfo,
        UWORD        uColCount,
        LPCSTR       lpszTableConstraints   = NULL,
        LPSTR        lpszSqlStmtCreated     = NULL,
        UWORD *      puStmtBufferSize       = NULL,
        BOOL         bJustGenerateSql       = FALSE,
        BOOL         bNoExtraByteOnStrings  = TRUE,
        BOOL         bResolveDupNames       = TRUE
        ) ;

    virtual RETCODE CreateTable(
        LPUCSTR      lpszTableName,
        cpsCOLBIND   cpsColInfo,
        UWORD        uColCount,
        LPUCSTR      lpszTableConstraints   = NULL,
        LPUSTR       lpszSqlStmtCreated     = NULL,
        UWORD *      puStmtBufferSize       = NULL,
        BOOL         bJustGenerateSql       = FALSE,
        BOOL         bNoExtraByteOnStrings  = TRUE,
        BOOL         bResolveDupNames       = TRUE
        )
            {
            return CreateTable(
                        (LPCSTR)lpszTableName,
                        cpsColInfo,
                        uColCount,
                        (LPCSTR)lpszTableConstraints,
                        (LPSTR)lpszSqlStmtCreated,
                        puStmtBufferSize,
                        bJustGenerateSql,
                        bNoExtraByteOnStrings,
                        bResolveDupNames
                        ) ;
            } ;
/***************************************************

    CreateTable

    Create a table (or just generate a CREATE TABLE
    SQL statement) from an odbcCURSOR object.
***************************************************/

    virtual RETCODE CreateTable(
        LPCSTR       lpszTableName,
        podbcCURSOR  pCursor,
        LPCSTR       lpszTableConstraints   = NULL,
        LPSTR        lpszSqlStmtCreated     = NULL,
        UWORD *      puStmtBufferSize       = NULL,
        BOOL         bJustGenerateSql       = FALSE,
        BOOL         bResolveDupNames       = TRUE
        )
        {
        cpsCOLBIND cpsColBind = NULL ;
        UWORD      uColCount  = 0 ;
        if ( pCursor && !IsBadReadPtr( pCursor, sizeof( *pCursor ) ) )
            {
            cpsColBind = pCursor->ColResultInfo( 1 ) ;
            uColCount  = pCursor->NumResultCols() ;
            }

        if ( uColCount && cpsColBind )
            {
            return CreateTable
                    (
                    lpszTableName,
                    cpsColBind,
                    uColCount,
                    lpszTableConstraints,
                    lpszSqlStmtCreated,
                    puStmtBufferSize,
                    bJustGenerateSql,
                    pCursor->GetNoExtraByteOnStrings(),
                    bResolveDupNames
                    );
            }
        else
            return SQL_BAD_CURSOR;
        } ;
        
    virtual RETCODE CreateTable(
        LPUCSTR      lpszTableName,
        podbcCURSOR  pCursor,
        LPUCSTR      lpszTableConstraints   = NULL,
        LPUSTR       lpszSqlStmtCreated     = NULL,
        UWORD *      puStmtBufferSize       = NULL,
        BOOL         bJustGenerateSql       = FALSE,
        BOOL         bResolveDupNames       = TRUE
        )
        {
        return CreateTable(
                    (LPCSTR)lpszTableName,
                    pCursor,
                    (LPCSTR)lpszTableConstraints,
                    (LPSTR)lpszSqlStmtCreated,
                    puStmtBufferSize,
                    bJustGenerateSql,
                    bResolveDupNames
                    ) ;
        } ;
};      // end of class declaration: odbcTABLECREATOR


#endif // if !defined(_CRETABLE_HPP)
