/*

    File:       RECORD.HPP

    Description:

    This file contains the declarations for the odbcRECORD class that
	support "connecting result sets to dialogs".

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994-1995 by INTERSOLV, Inc.  All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be
    reproduced or transmitted in any form or by any means,
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.

    /////////////////////////////////////////////////////////////

*/

public:
/****************************************************

    SetCheckBoxFromRecord

    Set the state of a check box control window
    based on the value for a given file in
    a record. Assumes if a numeric type, non-zero is
    checked and zero is unchecked; other data types cause
    an error.

****************************************************/
        virtual RETCODE  SetCheckBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord
                        );

        virtual RETCODE  SetCheckBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord
                        )
                        {
                        return SetCheckBoxFromRecord(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord
                                );
                        };

        virtual RETCODE  SetCheckBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord
                        );

/****************************************************

    SetRadioBtnsFromRecord

    Set the state of a set of radio button control windows
    based on the value for a given field in a record.
    Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.
    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/

        virtual RETCODE  SetRadioBtnsFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        PTR         pRecord
                        );

        virtual RETCODE  SetRadioBtnsFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName,
                        PTR         pRecord
                        )
                        {
                        return SetRadioBtnsFromRecord(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName,
                                pRecord
                                );
                        };

        virtual RETCODE  SetRadioBtnsFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        PTR         pRecord
                        );

/****************************************************

    SetListBoxFromRecord

    Set the state of a list box control window
    based on the value for a given field in
    a record. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
        virtual RETCODE  SetListBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetListBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetListBoxFromRecord(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetListBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetComboBoxFromRecord

    Set the state of a list box control window
    based on the value for a given field in
    a record. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
        virtual RETCODE  SetComboBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetComboBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetComboBoxFromRecord(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetComboBoxFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetRecordFromWndText

    Set the record value for a given field from the
    text in a control window of class EDIT.

****************************************************/
        virtual RETCODE  SetRecordFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

        virtual RETCODE  SetRecordFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        )
                        {
                        return SetRecordFromWndText(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetRecordFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

/****************************************************

    SetRecordFromCheckBox

    Set the record value for a given field from the
    setting in a control window of check box type.

****************************************************/
        virtual RETCODE  SetRecordFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord
                        );

        virtual RETCODE  SetRecordFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord
                        )
                        {
                        return SetRecordFromCheckBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord
                                );
                        };

        virtual RETCODE  SetRecordFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord
                        );

/****************************************************

    SetRecordFromRadioBtns

    Set value for a given column or column/row in
    a record based on the the state of a set of radio button
    control windows. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.

    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/
        virtual RETCODE  SetRecordFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        PTR         pRecord
                        );

        virtual RETCODE  SetRecordFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName,
                        PTR         pRecord
                        )
                        {
                        return SetRecordFromRadioBtns(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName,
                                pRecord
                                );
                        };

        virtual RETCODE  SetRecordFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        PTR         pRecord
                        );

/****************************************************

    SetRecordFromListBox

    Set the record value for a given field from the
    lookup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/
        virtual RETCODE  SetRecordFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetRecordFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetRecordFromListBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetRecordFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetRecordFromComboBox

    Set the record value for a given field from the
    lookup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/
        virtual RETCODE  SetRecordFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetRecordFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetRecordFromComboBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetRecordFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetWndTextFromRecord

    Set the text a control window (of type EDIT or STATIC)
    based on the value for a given field in a record.

****************************************************/
        virtual RETCODE  SetWndTextFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

        virtual RETCODE  SetWndTextFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        )
                        {
                        return SetWndTextFromRecord(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                pRecord,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetWndTextFromRecord(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        PTR         pRecord,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

