/*
    File:       RECORDWN.CPP

    Description:

    This file contains the methods from odbcRECORD class that
	supports "connecting result sets to dialogs".

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994-1995 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be
    reproduced or transmitted in any form or by any means,
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.

    /////////////////////////////////////////////////////////////

*/

#include <sql.hpp>
#include <string.h>

/****************************************************

    SetCheckBoxFromRecord

    Set the state of a check box control window
    based on the value for a given file in
    a record. Assumes if a numeric type, non-zero is
    checked and zero is unchecked; other data types cause
    an error.

****************************************************/

        RETCODE  odbcRECORD::SetCheckBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName )
                        );
            }


        RETCODE  odbcRECORD::SetCheckBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord
                        )
            {
            return odbcCURSOR::SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol )
                        );
            }

/****************************************************

    SetComboBoxFromRecord

    Set the state of a list box control window
    based on the value for a given field in
    a record. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/

        RETCODE  odbcRECORD::SetComboBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        bSetPos
                        );
            }


        RETCODE  odbcRECORD::SetComboBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            return odbcCURSOR::SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        bSetPos
                        );
            }

/****************************************************

    SetListBoxFromRecord

    Set the state of a list box control window
    based on the value for a given field in
    a record. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/


        RETCODE  odbcRECORD::SetListBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        bSetPos
                        );
            }


        RETCODE  odbcRECORD::SetListBoxFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            return odbcCURSOR::SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        bSetPos
                        );
            }


/****************************************************

    SetRadioBtnsFromRecord

    Set the state of a set of radio button control windows
    based on the value for a given field in a record.
    Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.
    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/

        RETCODE  odbcRECORD::SetRadioBtnsFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlIDMin,
                        UWORD   uCtlIDMax,
                        LPCSTR  ColName,
                        PTR     pRecord
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName )
                        );
            }


        RETCODE  odbcRECORD::SetRadioBtnsFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlIDMin,
                        UWORD   uCtlIDMax,
                        UWORD   icol,
                        PTR     pRecord
                        )
            {
            return odbcCURSOR::SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol )
                        );
            }

/****************************************************

    SetRecordFromCheckBox

    Set the record value for a given field from the
    setting in a control window of check box type.

****************************************************/

        RETCODE  odbcRECORD::SetRecordFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName )
                        );
            }


        RETCODE  odbcRECORD::SetRecordFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord
                        )
            {
            return odbcCURSOR::SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol )
                        );
            }

/****************************************************

    SetRecordFromComboBox

    Set the record value for a given field from the
    lookup tag in a combo box control window. Assumes the
    combo box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/
        RETCODE  odbcRECORD::SetRecordFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        bSetPos
                        );
            }


        RETCODE  odbcRECORD::SetRecordFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            return odbcCURSOR::SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        bSetPos
                        );
            }


/****************************************************

    SetRecordFromListBox

    Set the record value for a given field from the
    lookup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/

        RETCODE  odbcRECORD::SetRecordFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        bSetPos
                        );
            }


        RETCODE  odbcRECORD::SetRecordFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        BOOL    bSetPos
                        )
            {
            return odbcCURSOR::SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        bSetPos
                        );
            }


/****************************************************

    SetRecordFromRadioBtns

    Set value for a given column or column/row in
    a record based on the the state of a set of radio button
    control windows. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.

    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/

        RETCODE  odbcRECORD::SetRecordFromRadioBtns(
                        HWND    hDlg,
                        UWORD   uCtlIDMin,
                        UWORD   uCtlIDMax,
                        LPCSTR  ColName,
                        PTR     pRecord
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName )
                        );
            }


        RETCODE  odbcRECORD::SetRecordFromRadioBtns(
                        HWND    hDlg,
                        UWORD   uCtlIDMin,
                        UWORD   uCtlIDMax,
                        UWORD   icol,
                        PTR     pRecord
                        )
            {
            return odbcCURSOR::SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol )
                        );
            }

/****************************************************

    SetRecordFromWndText

    Set the record value for a given field from the
    text in a control window of class EDIT.

****************************************************/
        RETCODE  odbcRECORD::SetRecordFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        char *  fmt,
                        BOOL    fSigned /* = TRUE */
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        fmt,
                        fSigned
                        );
            }


        RETCODE  odbcRECORD::SetRecordFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        char *  fmt,
                        BOOL    fSigned /* = TRUE */
                        )
            {
            return odbcCURSOR::SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        fmt,
                        fSigned
                        );
            }

/****************************************************

    SetWndTextFromRecord

    Set the text a control window (of type EDIT or STATIC)
    based on the value for a given field in a record.

****************************************************/
        RETCODE  odbcRECORD::SetWndTextFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        PTR     pRecord,
                        char *  fmt,
                        BOOL    fSigned /* = TRUE */
                        )
            {
            // rely on protected odbcCURSOR function
            return odbcCURSOR::SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColRecAddr( pRecord, ColName ),
                        fmt,
                        fSigned
                        );
            }


        RETCODE  odbcRECORD::SetWndTextFromRecord(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        PTR     pRecord,
                        char *  fmt,
                        BOOL    fSigned /* = TRUE */
                        )
            {
            return odbcCURSOR::SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColRecAddr( pRecord, icol ),
                        fmt,
                        fSigned
                        );
            }

