/*
    File:       CURSORWN.HPP

    Date:       04-21-95

    Description:

    This file contains the declarations for the methods that allow for
    connecting result sets to dialogs on the windows platforms.


    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be
    reproduced or transmitted in any form or by any means,
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.

    /////////////////////////////////////////////////////////////

*/

public:
/****************************************************
    CleanupComboBox

    If the lookup tags are used in the FillComboBox function call,
    you must then call this function when done with the dialog
    (e.g., during OK or Cancel button processing). This will ensure
    that the memory allocated for the tags is freed.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    virtual RETCODE CleanupComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID
                        );

/****************************************************

    CleanupListBox

    If the lookup tags are used in the FillListBox function call,
    you must then call this function when done with the dialog
    (e.g., during OK or Cancel button processing). This will ensure
    that the memory allocated for the tags is freed.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    virtual RETCODE CleanupListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        );

/************************************************************
    Helper functions for browser list box and other control-related
    public functions.
*************************************************************/
 protected:
    virtual int ColValueAsInt(
                            SWORD   fCType,
                            PTR     pData
                            );

    virtual int SetColValueFromInt(
                            SWORD   fCType,
                            PTR     pData,
                            int     nValue
                            );

    virtual void DetermineColumnLen(
                    SWORD fCType,
                    char *szColName,
                    UWORD &uDisplayLen
                    );

    virtual void DetermineBrowserColumnLen(
                    SWORD fCType,
                    char *szColName,
                    UWORD &uDisplayLen
                    );

public:

    virtual void FmtColumnData(
                            SWORD   fCType,
                            char *  buffer,
                            PTR     pData,
                            char *  fmt,
                            BOOL    fSigned 
                            );

    virtual BOOL ScanColumnData(
                            SWORD   fCType,
                            char *  buffer,
                            PTR     pData,
                            char *  fmt,
                            BOOL    fSigned 
                            );

    virtual BOOL ScanColumnDateData(
                            char *  buffer,
                            PTR     pData,
                            char *  fmt 
                            );

    virtual BOOL ScanColumnDateTimeData(
                            char *  buffer,
                            PTR     pData,
                            char *  fmt 
                            );

    virtual BOOL ScanColumnTimeData(
                            char *  buffer,
                            PTR     pData,
                            char *  fmt
                            );

    virtual void FmtColumnDateData(
                            char *  buffer,
                            DATE_STRUCT *pDate,
                            char *  fmt 
                            );

    virtual void FmtColumnDateTimeData(
                            char *  buffer,
                            TIMESTAMP_STRUCT *pTs,
                            char *  fmt 
                            );

    virtual void FmtColumnTimeData(
                            char *  buffer,
                            TIME_STRUCT *pTime,
                            char *  fmt 
                            );

/****************************************************

    FillBrowserListBox

    Fill list box with the contents of a all columns,
    and optionally attach the value of a column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the list box and a code or numeric key used as the
    unique ID for the row.

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect and columns
    automatically bound by calling AutoBind or BindCol with
    an array of data dictionary structs.  The function 
    SetTabsForBrowser must have been called to set tabs in the 
    list box.  the list box must have the style
    LBS_USETABSTOPS in order for the tab setting to work.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the list box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillListBox.
    The content of the list box then acts as a scrolling window
    on the underlying database. In this case, CleanupListBox will
    be called internally before filling the list box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the list box. In this case, FillBrowserListBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupListBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Two other member functions, GetLookupTag and GetLookupTagType,
    are useful in manipulating list box data.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    virtual RETCODE FillBrowserListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPCSTR  lpszColToAttach = NULL,
                        BOOL bIncludeColNames = TRUE
                        );

    virtual RETCODE FillBrowserListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPUCSTR lpszColToAttach,
                        BOOL bIncludeColNames = TRUE
                         )
                        {
                        return FillBrowserListBox(
                                hDlg, uListBoxID,
                                (LPCSTR)lpszColToAttach
                                );
                        };

    virtual RETCODE FillBrowserListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        UWORD   uColToAttach = NULL,
                        BOOL bIncludeColNames = TRUE
                        );

/****************************************************

    SetTabsForBrowser

    Set tabs for a browser list box.  The style
    LBS_USETABSTOPS must have been applied to the list
    box resource definition for this to work.
****************************************************/
    virtual void SetTabsForBrowser(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        );

/****************************************************

    GetLookupTag

    Get the lookup tag for the currently selected item in the
    list box. Only works for single-select list boxes.

    Uses LB_GETITEMDATA to retrieve the lookup tag. The type
    of data pointed to by the returned pointer can be determined
    using ColResultInfo( number-of-column-attached ). The fCType
    member of the struct pointed to by the ColResultInfo
    return is the type of the data pointed to by the return
    from GetLookupTag; e.g., if the type is SQL_C_DOUBLE,
    the returned pointer is of type double *; accessing the
    value would work like this:

    double d;

    double *pd = (double *)pCursor->GetLookupTag( hDlg, ID_LISTBOX );

    if ( pd )
        d = *pd;

****************************************************/
    virtual PTR GetLookupTag(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        );

/****************************************************

    GetComboLookupTag

    Get the lookup tag for the currently selected item in the
    combo box.

    Uses CB_GETITEMDATA to retrieve the lookup tag. The type
    of data pointed to by the returned pointer can be determined
    using ColResultInfo( number-of-column-attached ). The fCType
    member of the struct pointed to by the ColResultInfo
    return is the type of the data pointed to by the return
    from GetLookupTag; e.g., if the type is SQL_C_DOUBLE,
    the returned pointer is of type double *; accessing the
    value would work like this:

    double d;

    double *pd = (double *)pCursor->GetLookupTag( hDlg, ID_LISTBOX );

    if ( pd )
        d = *pd;

****************************************************/
    virtual PTR GetComboLookupTag(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        );

/****************************************************

    FindLookupTag
    FindComboLookupTag

    Find the row containing a given lookup tag. Only finds the
    first instance of the tag value, so the tag column should be
    unique if this function is to be used.

    pData points to a buffer containing the data for which to
    search.  cbLen is the size of the buffer, or the constant
    SQL_NTS if pData points to a null-terminated string.

    Returns the zero-based index of the row in the list box
    associated with the first occurrence of the lookup tag,
    or LB_ERR if the value to find is not found among the
    tags.

****************************************************/
    virtual int FindLookupTag(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        PTR     pData,
                        SWORD   cbLen = SQL_NTS
                        );
    virtual int FindComboLookupTag(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        PTR     pData,
                        SWORD   cbLen = SQL_NTS
                        );

/****************************************************

    SetMaxTextLenFromCol

    Set the allowable text length a control window (of type EDIT)
    based on a given column.

****************************************************/
        virtual void  SetMaxTextLenFromCol(
                        HWND hDlg,
                        UWORD uCtlID,
                        LPCSTR ColName
                        );

        virtual void  SetMaxTextLenFromCol(
                        HWND hDlg,
                        UWORD uCtlID,
                        LPUCSTR ColName
                        )
                        {
                        SetMaxTextLenFromCol(
                                hDlg, uCtlID,
                                (LPCSTR)ColName
                                );
                        };

        virtual void  SetMaxTextLenFromCol(
                        HWND hDlg,
                        UWORD uCtlID,
                        UWORD icol
                        );

/****************************************************

    SetWndTextFromColResult

    Set the text a control window (of type EDIT or STATIC)
    based on the value for a given column or column/row in
    a rowset.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        char *      fmt,
                        BOOL    fSigned 
                        );
public:

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        );

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        )
                        {
                        return SetWndTextFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        );

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        );

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        )
                        {
                        return SetWndTextFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        );

/****************************************************

    SetCheckBoxFromColResult

    Set the state of a check box control window
    based on the value for a given column or column/row in
    a rowset. Assumes if a numeric type, non-zero is
    checked and zero is unchecked; other data types cause
    an error.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData
                        );
public:

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow
                        );

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow
                        )
                        {
                        return SetCheckBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow
                                );
                        };

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow
                        );

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName
                        );

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName
                        )
                        {
                        return SetCheckBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName
                                );
                        };

        virtual RETCODE  SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol
                        );

/****************************************************

    SetRadioBtnsFromColResult

    Set the state of a set of radio button control windows
    based on the value for a given column or column/row in
    a rowset. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.
    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        psCOLBIND   pColBind,
                        PTR         pData
                        );
public:

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        UWORD       irow
                        );

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName,
                        UWORD       irow
                        )
                        {
                        return SetRadioBtnsFromColResult(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName,
                                irow
                                );
                        };

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        UWORD       irow
                        );

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName
                        );

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName
                        )
                        {
                        return SetRadioBtnsFromColResult(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName
                                );
                        };

        virtual RETCODE  SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol
                        );

/****************************************************

    SetListBoxFromColResult

    Set the state of a list box control window
    based on the value for a given column or column/row in
    a rowset. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos = FALSE
                        );
public:

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetListBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetListBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetComboBoxFromColResult

    Set the state of a list box control window
    based on the value for a given column or column/row in
    a rowset. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos = FALSE
                        );
public:

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetComboBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetComboBoxFromColResult(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetColResultFromWndText

    Set the rowset value for a given column/row from the
    text in a control window of class EDIT.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        char *      fmt,
                        BOOL        fSigned
                        );
public:

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL    fSigned = TRUE 
                        )
                        {
                        return SetColResultFromWndText(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        );

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE
                        )
                        {
                        return SetColResultFromWndText(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                fmt,
                                fSigned
                                );
                        };

        virtual RETCODE  SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        char *      fmt = NULL,
                        BOOL        fSigned = TRUE 
                        );

/****************************************************

    SetColResultFromCheckBox

    Set the rowset value for a given column/row from the
    text in a control window of check box type.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData
                        );
public:

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow
                        );

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow
                        )
                        {
                        return SetColResultFromCheckBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow
                                );
                        };

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow
                        );

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName
                        );

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName
                        )
                        {
                        return SetColResultFromCheckBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName
                                );
                        };

        virtual RETCODE  SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol
                        );

/****************************************************

    SetColResultFromRadioBtns

    Set value for a given column or column/row in
    a rowset based on the the state of a set of radio button
    control windows. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.

    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.


****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        psCOLBIND   pColBind,
                        PTR         pData
                        );
public:

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        UWORD       irow
                        );

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName,
                        UWORD       irow
                        )
                        {
                        return SetColResultFromRadioBtns(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName,
                                irow
                                );
                        };

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        UWORD       irow
                        );

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName
                        );

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPUCSTR     ColName
                        )
                        {
                        return SetColResultFromRadioBtns(
                                hDlg,
                                uCtlIDMin,
                                uCtlIDMax,
                                (LPCSTR)ColName
                                );
                        };

        virtual RETCODE  SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol
                        );

/****************************************************

    SetColResultFromListBox

    Set the rowset value for a given column/row from the
    lokup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos = FALSE
                        );
public:

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetColResultFromListBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetColResultFromListBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    SetColResultFromComboBox

    Set the rowset value for a given column/row from the
    lokup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

****************************************************/
protected:
        // this version is used by all the others
        // to do the real work.
        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos = FALSE
                        );
public:

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetColResultFromComboBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                irow,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        UWORD       irow,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPCSTR      ColName,
                        BOOL        bSetPos = FALSE
                        );

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        LPUCSTR     ColName,
                        BOOL        bSetPos = FALSE
                        )
                        {
                        return SetColResultFromComboBox(
                                hDlg, uCtlID,
                                (LPCSTR)ColName,
                                bSetPos
                                );
                        };

        virtual RETCODE  SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        UWORD       icol,
                        BOOL        bSetPos = FALSE
                        );

/****************************************************

    FillComboBox

    Fill combo box with the contents of a given column,
    and optionally attach the value of a different column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the combo box and a code or numeric key used as the
    unique ID for the row.

    The column used to fill the combo box must be of a character
    data type (SQL_CHAR or SQL_VARCHAR).

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect and columns
    automatically bound by calling AutoBind or BindCol with
    an array of data dictionary structs.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the combo box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillComboBox.
    The content of the combo box then acts as a scrolling window
    on the underlying database. In this case, CleanupComboBox will
    be called internally before filling the combo box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the combo box. In this case, FillComboBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupComboBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Two other member functions, GetLookupTag and GetLookupTagType,
    are useful in manipulating combo box data.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    virtual RETCODE FillComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        LPCSTR  lpszColToDisplay,
                        LPCSTR  lpszColToAttach = NULL
                        );

    virtual RETCODE FillComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        LPUCSTR lpszColToDisplay,
                        LPUCSTR lpszColToAttach = NULL
                        )
                        {
                        return FillComboBox(
                                hDlg, uComboBoxID,
                                (LPCSTR)lpszColToDisplay,
                                (LPCSTR)lpszColToAttach
                                );
                        };

    virtual RETCODE FillComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        UWORD   uColToDisplay,
                        UWORD   uColToAttach = NULL
                        );

/****************************************************

    FillListBox

    Fill list box with the contents of a given column,
    and optionally attach the value of a different column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the list box and a code or numeric key used as the
    unique ID for the row.

    The column used to fill the list box must be of a character
    data type (SQL_CHAR or SQL_VARCHAR).

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect and columns
    automatically bound by calling AutoBind or BindCol with
    an array of data dictionary structs.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the list box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillListBox.
    The content of the list box then acts as a scrolling window
    on the underlying database. In this case, CleanupListBox will
    be called internally before filling the list box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the list box. In this case, FillListBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupListBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Two other member functions, GetLookupTag and GetLookupTagType,
    are useful in manipulating list box data.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    virtual RETCODE FillListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPCSTR  lpszColToDisplay,
                        LPCSTR  lpszColToAttach = NULL
                        );

    virtual RETCODE FillListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPUCSTR lpszColToDisplay,
                        LPUCSTR lpszColToAttach = NULL
                        )
                        {
                        return FillListBox(
                                hDlg, uListBoxID,
                                (LPCSTR)lpszColToDisplay,
                                (LPCSTR)lpszColToAttach
                                );
                        };

    virtual RETCODE FillListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        UWORD   uColToDisplay,
                        UWORD   uColToAttach = NULL
                        );

