/*
    File:           CURSORWN.CPP
    
    Date:           21-Apr-95

    Description:
    This file contains the methods from the cursor class that 
    "connect result sets to dialogs" in the windows environment.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                         
    Copyright (c) 1993-1995 by INTERSOLV, Inc.  All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
    

*/

#include <sql.hpp>
#if defined(__WATCOMC__)
    #include <mem.h>    // for memset
#else
    #include <memory.h> // for memset
#endif
#include <string.h>     // for strcpy, strcat, ...
#include <ctype.h>      // for isdigit, isspace, ...
#include <stdio.h>      // sprintf...
#include <stdlib.h>     // generalized max...
#include <limits.h>     // <?>_MIN, <?>_MAX

#if !defined( _MSC_VER )
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

/*
    GetDateFromStrBuf

    Local function to scan date data.
    Returns count of items found; outputs into date struct pDate and integer index i
*/
static int GetDateFromStrBuf( char * buffer, DATE_STRUCT * pDate, int & i )
    {
    long lNum;
    int nCnt = 0;
    
    while ( isspace( buffer[i] ) )
        i++;
        
    lNum = 0;
    
    // get month
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++;   
        }
        
    if ( (buffer[i] != '/' && buffer[i] != '-') || lNum == 0 )
        return 0;
    else
        pDate->month = (UWORD)lNum;
        
    nCnt++;
        
    lNum = 0;
    
    if ( !isdigit( buffer[++i] ) )
        return 0;
        
    // get day
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;  
        }
        
    if ( (buffer[i] != '/' && buffer[i] != '-') || lNum == 0 )
        return 0;
    else
        pDate->day = (UWORD)lNum;

    lNum = 0;
    nCnt++;

    if ( !isdigit( buffer[++i] ) )
        return 0;
        
    // get year
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;  
        }
        
    if ( lNum > 9999L )
        return 0;
    else
        pDate->year = (SWORD)lNum;
    nCnt++;
            
    return nCnt;
    }
    
static int GetDateFromStrBuf( char * buffer, TIMESTAMP_STRUCT * pDate, int & i )
    {
    long lNum;
    int nCnt = 0;
    
    while ( isspace( buffer[i] ) )
        i++;
        
    lNum = 0;
    
    // get month
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;  
        }
        
    if ( (buffer[i] != '/' && buffer[i] != '-') || lNum == 0 )
        return 0;
    else
        pDate->month = (UWORD)lNum;
        
    lNum = 0;
    nCnt++;

    if ( !isdigit( buffer[++i] ) )
        return 0;

    // get day
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;
        }

    if ( (buffer[i] != '/' && buffer[i] != '-') || lNum == 0 )
        return 0;
    else
        pDate->day = (UWORD)lNum;

    nCnt++;
        
    lNum = 0;
    
    if ( !isdigit( buffer[++i] ) )
        return 0;
        
    // get year
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;  
        }
        
    if ( lNum > 9999L )
        return 0;
    else
        pDate->year = (SWORD)lNum;
        
    nCnt++;
            
    return nCnt;
    }

/*
    GetTimeFromStrBuf

    Local function to scan time data.
    Returns count of items found; outputs into date struct pDate,
    integer index i, ancd character for AmOrPm (maybe)

*/
static int GetTimeFromStrBuf( char * buffer, TIME_STRUCT * pTime, char & AmOrPm, int & i )
    {
    long lNum;
    int nCnt = 0;
    
    while ( isspace( buffer[i] ) )
        i++;
        
    lNum = 0;
    
    // get hour
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++ ;  
        }
        
    if ( buffer[i] != ':' )
        return 0;
    else
        pTime->hour = (UWORD)lNum;
    
    nCnt++;
        
    lNum = 0;
    
    // get minute
    if ( !isdigit( buffer[++i] ) )
        return 0;
        
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++;   
        }
        
    pTime->minute = (UWORD)lNum;

    nCnt++;
    
    // get 'a' or 'p' if present
    AmOrPm = 0;

    while ( isspace( buffer[i] ) )
        i++;

    if ( buffer[i] )
        {
        AmOrPm = buffer[i++];
        nCnt++;
        }

    return nCnt;
    }
    
static int GetTimeFromStrBuf( char * buffer, TIMESTAMP_STRUCT * pTime, char & AmOrPm, int & i )
    {
    long lNum;
    int nCnt = 0;
    
    while ( isspace( buffer[i] ) )
        i++;
        
    lNum = 0;
    
    // get hour
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++;   
        }
        
    if ( buffer[i] != ':' )
        return 0;
    else
        pTime->hour = (UWORD)lNum;
    
    nCnt++;

    lNum = 0;

    // get minute
    if ( !isdigit( buffer[++i] ) )
        return 0;
        
    while ( isdigit( buffer[i] ) )
        {
        lNum *= 10;
        lNum += (buffer[i] - '0');
        i++;   
        }
        
    pTime->minute = (UWORD)lNum;

    nCnt++;
    
    // get 'a' or 'p' if present
    AmOrPm = 0;

    while ( isspace( buffer[i] ) )
        i++;

    if ( buffer[i] )
        {
        AmOrPm = buffer[i++];
        nCnt++;
        }

    return nCnt;
    }
    
/****************************************************

    CleanupComboBox

    If lookup tags are used in the FillComboBox function call,
    you must then call this function when done with the dialog
    (e.g., during OK or Cancel button processing). This will ensure
    that the memory allocated for the tags is freed.

    CB_SETITEMDATA and CB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    RETCODE odbcCURSOR::CleanupComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID
                        )
        {
        int i = 0;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uComboBoxID,
                        CB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;


        if ( nCount > 0 )
            {
            for ( i = 0; i < nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)CB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                    continue;
                else
                    {
                    delete[] (char *)pData;
                    SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_SETITEMDATA,
                            i,
                            0
                            );
                    }
                }

            }
        return SQL_SUCCESS;
        }

/****************************************************

    CleanupListBox

    If lookup tags are used in the FillListBox function call,
    you must then call this function when done with the dialog
    (e.g., during OK or Cancel button processing). This will ensure
    that the memory allocated for the tags is freed.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    RETCODE odbcCURSOR::CleanupListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        )
        {
        int i = 0;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;


        if ( nCount > 0 )
            {
            for ( i = 0; i < nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)LB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                    continue;
                else
                    {
                    delete[] (char *)pData;
                    SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_SETITEMDATA,
                            i,
                            0
                            );
                    }
                }

            }
        return SQL_SUCCESS;
        }

/*
    ColValueAsInt

    Return value of numeric column as integer.

*/

int odbcCURSOR::ColValueAsInt(
                            SWORD   fCType,
                            PTR     pData
                            )
    {
    // append the value
    switch ( fCType )
        {
#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
        return (int)(*((char *)pData));

    case SQL_C_UTINYINT:
        return (int)(*((unsigned char *)pData));
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_BIT:
    case SQL_C_TINYINT:
        return (int)(*((char *)pData));

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
        return (*((short *)pData));

    case SQL_C_USHORT:
        return (*((unsigned short *)pData));
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_SHORT:
        return (*((short *)pData));

#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
        return (int)(*((long *)pData));

    case SQL_C_ULONG:
        return (int)(*((unsigned long *)pData));
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_LONG:
        return (int)(*((long *)pData));


    case SQL_C_FLOAT:
        return (int)(*((float *)pData));

    case SQL_C_DOUBLE:
        return (int)(*((double *)pData));
        }

    return 0;
    }

/*
    DetermineBrowserColumnLen

    Local function to determine length of column data
    in the list box browser.

*/

void odbcCURSOR::DetermineBrowserColumnLen(
                    SWORD fCType,
                    char *szColName,
                    UWORD &uDisplayLen
                    )
    {
    switch ( fCType )
        {

    case SQL_C_CHAR:
        uDisplayLen =
        (UWORD)max(
           (UWORD)(ColResultInfo(szColName)->cbValueMax),
           (UWORD)strlen(szColName)
           );
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
    case SQL_C_UTINYINT:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_BIT:
    case SQL_C_TINYINT:
        uDisplayLen =
            (UWORD)max(
                (UWORD)3,
                (UWORD)strlen(szColName));
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
    case SQL_C_USHORT:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_SHORT:
        uDisplayLen =
            (UWORD)max(
                (UWORD)6,
                (UWORD)strlen(szColName));
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
    case SQL_C_ULONG:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_LONG:
        uDisplayLen =
            (UWORD)max(
                (UWORD)11,
                (UWORD)strlen(szColName));
        break;


    case SQL_C_FLOAT:
        uDisplayLen =
            (UWORD)max(
                (UWORD)9,
                (UWORD)strlen(szColName));
        break;


    case SQL_C_DOUBLE:
        uDisplayLen =
            (UWORD)max(
                (UWORD)14,
                (UWORD)strlen(szColName));
        break;


    case SQL_C_DATE:
        uDisplayLen =
            (UWORD)max(
                (UWORD)10,
                (UWORD)strlen(szColName));
        break;


    case SQL_C_TIME:
        uDisplayLen =
            (UWORD)max(
                (UWORD)5,
                (UWORD)strlen(szColName));
        break;


    case SQL_C_TIMESTAMP:
        uDisplayLen =
            (UWORD)max(
                (UWORD)16,
                (UWORD)strlen(szColName));
        break;
        }
    }

/*
    DetermineColumnLen

    Local function to determine length of column data.

*/

void odbcCURSOR::DetermineColumnLen(
                    SWORD fCType,
                    char *szColName,
                    UWORD &uDisplayLen
                    )
    {
    switch ( fCType )
        {

    case SQL_C_CHAR:
        uDisplayLen = (UWORD)(ColResultInfo(szColName)->cbValueMax);
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
    case SQL_C_UTINYINT:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_BIT:
    case SQL_C_TINYINT:
        uDisplayLen =
            3;
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
    case SQL_C_USHORT:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_SHORT:
        uDisplayLen =
            6;
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
    case SQL_C_ULONG:
#endif  /* ODBCVER >= 0x0200 */
    case SQL_C_LONG:
        uDisplayLen =
            11;
        break;


    case SQL_C_FLOAT:
        uDisplayLen =
            9;
        break;


    case SQL_C_DOUBLE:
        uDisplayLen =
            14;
        break;


    case SQL_C_DATE:
        uDisplayLen =
            10;
        break;


    case SQL_C_TIME:
        uDisplayLen =
            6;
        break;


    case SQL_C_TIMESTAMP:
        uDisplayLen =
            17;
        break;
        }
    }

/*

    FillBrowserListBox

    Fill list box with the contents of a all columns,
    and optionally attach the value of a column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the list box and a code or numeric key used as the
    unique ID for the row.

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect and columns
    automatically bound by calling AutoBind or BindCol with
    an array of data dictionary structs.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the list box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillListBox.
    The content of the list box then acts as a scrolling window
    on the underlying database. In this case, CleanupListBox will
    be called internally before filling the list box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the list box. In this case, FillListBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupListBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Two other member functions, GetLookupTag and GetLookupTagType,
    are useful in manipulating list box data.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
*/

const int BROWSER_BUFFER_SIZE = 600;

    RETCODE odbcCURSOR::FillBrowserListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPCSTR  lpszColToAttach /* = NULL */,
                        BOOL      bIncludeColNames /*  = TRUE  */
                        )
        {
        psCOLBIND pAttachColInfo = NULL;

        if ( lpszColToAttach != NULL )
            {
            pAttachColInfo = ColResultInfo( lpszColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                return lastRC();
                }
            }

        return FillBrowserListBox(
                    hDlg,
                    uListBoxID,
                    (UWORD)(pAttachColInfo ? pAttachColInfo->iCol : 0),
                    bIncludeColNames
                    );
        }

    RETCODE odbcCURSOR::FillBrowserListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        UWORD   uColToAttach /* = NULL */,
                        BOOL        bIncludeColNames /* = TRUE */
                        )
        {
        psCOLBIND pAttachColInfo = NULL;
        UWORD i = 0, j = 0;
        int nPos;
        int nAccumTab;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_GETCOUNT,
                        0,
                        0
                        );

        PTR pData;
        char *buffer = new char[ BROWSER_BUFFER_SIZE ];

        if ( uColToAttach != 0 )
            {
            pAttachColInfo = ColResultInfo( uColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                if ( buffer )
                    delete[] buffer;
                return lastRC();
                }
            }

        if ( !buffer )
            {
            SetRC( SQL_ALLOC_FAILED );
            return lastRC();
            }

        // if processing rowsets, clean up item data before
        // emptying list box.
        if ( ExtFetchRowCount > 1 && nCount > 0
            && uColToAttach != 0)
            {
            for ( i = 0; i < (UWORD)nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)LB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            (UINT)pAttachColInfo->cbValueMax ) )
                    continue;
                else
                    {
                    delete[] (LPSTR)pData;
                    SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_SETITEMDATA,
                            i,
                            0
                            );
                    }
                }
            }

        // empty list box.
        SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_RESETCONTENT,
                        0,
                        0
                        );

        // build line of column names
        if (bIncludeColNames )
            {
            for ( buffer[0] = 0,
                    nAccumTab = 0, j = 0;
                    j < ColCount; j++ )
                {
                // get display length
                UWORD uDisplayLen =
                    (UWORD)max(
                           (UWORD)pColBindings[j].cbValueMax,
                           (UWORD)strlen((LPSTR)pColBindings[j].szColName));

                    // we don't handle all types in the browser, just non-BLOBs that are
                    // bound as char arrays.
                    switch ( pColBindings[j].fCType )
                        {
                    case SQL_C_CHAR:
                        if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                            continue;
                        break;
                    default:
                        break;
                        }

                DetermineBrowserColumnLen
                                (
                                pColBindings[j].fCType,
                                (LPSTR)pColBindings[j].szColName,
                                uDisplayLen
                                );

                // see if we are over the limit
                if ( strlen( buffer ) + uDisplayLen + 3
                     > BROWSER_BUFFER_SIZE)
                    break;

                // see if we are over the limit
                if ( nAccumTab > 511)
                    break;

                // if we get here, we're going to use this column
                nAccumTab += ((uDisplayLen + 3) * 4);

                // add some white space
                if ( j > 0 )
                    strcat( buffer, "\t" );

                strcat( buffer, (LPSTR)pColBindings[j].szColName );
                } // end inner for loop
            SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_ADDSTRING,
                        0,
                        (LPARAM)buffer
                        );

            } // end if


        // if extended fetch, just fill from the rowset
        if ( ExtFetchRowCount > 1 )
            {
            for ( i = 1 ; i <= ExtFetchRow; i++ )
                {
                buffer[0] = 0;

                // build display line from this row of data
                for ( nAccumTab = 0, j = 0; j < ColCount; j++ )
                    {
                    // get display length
                    UWORD uDisplayLen =
                            (UWORD)max(
                                (UWORD)pColBindings[j].cbValueMax,
                                (UWORD)strlen((LPSTR)pColBindings[j].szColName));

                    // we don't handle all types in the browser, just non-BLOBs that are
                    // bound as char arrays.
                    switch ( pColBindings[j].fCType )
                        {
                    case SQL_C_CHAR:
                        if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                            continue;
                        break;
                    default:
                        break;
                        }

                    // get address of data
                    pData = ColResultAddr( pColBindings[j].iCol, i );

                    DetermineBrowserColumnLen
                                        (
                                        pColBindings[j].fCType,
                                        (LPSTR)pColBindings[j].szColName,
                                        uDisplayLen
                                        );

                    // see if we are over the limit
                    if ( strlen( buffer ) + uDisplayLen + 3
                             > BROWSER_BUFFER_SIZE)
                        break;

                    // see if we are over the limit
                    if ( nAccumTab > 511)
                        break;

                    // if we get here, we're going to use this column
                    nAccumTab += ((uDisplayLen + 3) * 4);

                    // add some white space
                    if ( j > 0 )
                        strcat( buffer, "\t" );

                    FmtColumnData(  pColBindings[j].fCType,
                                        buffer,
                                        pData,
                                        NULL,
                                        TRUE
                                        );
                    } // end inner for loop

                nPos = (int)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_ADDSTRING,
                            0,
                            (LPARAM)buffer
                            );

                // attach data if user wants to
                if ( uColToAttach )
                    {
                    // allocate memory
                    pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                    if ( !pData )
                        {
                        SetRC( SQL_ALLOC_FAILED );
                        return lastRC();
                        }
                    else
                        memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                    // copy value to allocated buffer
                    memcpy( pData, ColResultAddr( uColToAttach, i ),
                                (size_t)pAttachColInfo->cbValueMax );
                    // attach to line item
                    SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_SETITEMDATA,
                            nPos,
                            (LPARAM)pData
                            );
                    }

                }   // end for loop
            }
        else
        // otherwise, fill by looping through the result set
            {
            if ( ExtFetchRowCount )
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    buffer[0] = 0;

                    // build display line from this row of data
                    for ( nAccumTab = 0, j = 0; j < ColCount; j++ )
                        {
                        // get display length
                        UWORD uDisplayLen =
                                (UWORD)max(
                                    (UWORD)pColBindings[j].cbValueMax,
                                    (UWORD)strlen((LPSTR)pColBindings[j].szColName));

                        // we don't handle all types in the browser, just non-BLOBs that are
                        // bound as char arrays.
                        switch ( pColBindings[j].fCType )
                            {
                        case SQL_C_CHAR:
                            if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                                continue;
                            break;
                        default:
                            break;
                            }
    
                        // get address of data
                        pData = ColResultAddr( pColBindings[j].iCol, 1 );

                        DetermineBrowserColumnLen
                                            (
                                            pColBindings[j].fCType,
                                            (LPSTR)pColBindings[j].szColName,
                                            uDisplayLen
                                            );

                        // see if we are over the limit
                        if ( strlen( buffer ) + uDisplayLen + 3
                                 > BROWSER_BUFFER_SIZE)
                            break;

                        // see if we are over the limit
                        if ( nAccumTab > 511)
                            break;

                        // if we get here, we're going to use this column
                        nAccumTab += ((uDisplayLen + 3) * 4);

                        // add some white space
                        if ( j > 0 )
                            strcat( buffer, "\t" );

                        FmtColumnData(  pColBindings[j].fCType,
                                            buffer,
                                            pData,
                                            NULL,
                                            TRUE
                                            );
                        } // end inner for loop

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_ADDSTRING,
                                0,
                                (LPARAM)buffer
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach, 1 ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                }
            else
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    buffer[0] = 0;

                    // build display line from this row of data
                    for ( nAccumTab = 0, j = 0; j < ColCount; j++ )
                        {
                        // get display length
                        UWORD uDisplayLen =
                                (UWORD)max(
                                    (UWORD)pColBindings[j].cbValueMax,
                                    (UWORD)strlen((LPSTR)pColBindings[j].szColName));

                        // we don't handle all types in the browser, just non-BLOBs that are
                        // bound as char arrays.
                        switch ( pColBindings[j].fCType )
                            {
                        case SQL_C_CHAR:
                            if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                                continue;
                            break;
                        default:
                            break;
                            }
    
                        // get address of data
                        pData = ColResultAddr( pColBindings[j].iCol );

                        DetermineBrowserColumnLen
                                            (
                                            pColBindings[j].fCType,
                                            (LPSTR)pColBindings[j].szColName,
                                            uDisplayLen
                                            );

                        // see if we are over the limit
                        if ( strlen( buffer ) + uDisplayLen + 3
                                 > BROWSER_BUFFER_SIZE)
                            break;

                        // see if we are over the limit
                        if ( nAccumTab > 511)
                            break;

                        // if we get here, we're going to use this column
                        nAccumTab += ((uDisplayLen + 3) * 4);

                        // add some white space
                        if ( j > 0 )
                            strcat( buffer, "\t" );

                        FmtColumnData(  pColBindings[j].fCType,
                                            buffer,
                                            pData,
                                            NULL,
                                            TRUE
                                            );
                        } // end inner for loop

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_ADDSTRING,
                                0,
                                (LPARAM)buffer
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                } // end if ExtFetchRowCount > 0
            }  // end if ExtFetchRowCount > 1

        if ( lastRC() == SQL_NO_DATA_FOUND )
            SetRC( SQL_SUCCESS );

        if ( buffer )
            delete[] buffer;
            
        return lastRC();
        }

/****************************************************

    FillComboBox

    Fill combo box with the contents of a given column,
    and optionally attach the value of a different column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the combo box and a code or numeric key used as the
    unique ID for the row.

    The column used to fill the combo box must be of a character
    data type (SQL_CHAR or SQL_VARCHAR).

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect and columns
    automatically bound by calling AutoBind or BindCol with
    an array of data dictionary structs.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the combo box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillComboBox.
    The content of the combo box then acts as a scrolling window
    on the underlying database. In this case, CleanupComboBox will
    be called internally before filling the combo box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the combo box. In this case, FillComboBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupComboBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Two other member functions, GetLookupTag and GetLookupTagType,
    are useful in manipulating combo box data.

    CB_SETITEMDATA and CB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    RETCODE odbcCURSOR::FillComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        LPCSTR  lpszColToDisplay,
                        LPCSTR  lpszColToAttach /* = NULL */
                        )
        {
        psCOLBIND pDispColInfo = ColResultInfo( lpszColToDisplay );
        psCOLBIND pAttachColInfo = NULL;

        if ( pDispColInfo == NULL )
            {
            SetRC( SQL_BAD_DISP_COLUMN );
            return lastRC();
            }

        if ( lpszColToAttach != NULL )
            {
            pAttachColInfo = ColResultInfo( lpszColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                return lastRC();
                }
            }

        return FillComboBox(
                    (HWND)hDlg,
                    (UWORD)uComboBoxID,
                    (UWORD)pDispColInfo->iCol,
                    (UWORD)(pAttachColInfo ? pAttachColInfo->iCol : 0)
                    );
        }

    RETCODE odbcCURSOR::FillComboBox(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        UWORD   uColToDisplay,
                        UWORD   uColToAttach /* = NULL */
                        )
        {
        psCOLBIND pDispColInfo = ColResultInfo( uColToDisplay );
        psCOLBIND pAttachColInfo = NULL;
        UWORD i = 0;
        int nPos;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uComboBoxID,
                        CB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;
        char *pString;

        if ( pDispColInfo == NULL ||
            pDispColInfo->fCType != SQL_C_CHAR )
            {
            SetRC( SQL_BAD_DISP_COLUMN );
            return lastRC();
            }
        else if ( uColToAttach != 0 )
            {
            pAttachColInfo = ColResultInfo( uColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                return lastRC();
                }
            }

        // if processing rowsets, clean up item data before
        // emptying list box.
        if ( ExtFetchRowCount > 1 && nCount > 0
            && uColToAttach != 0)
            {
            for ( i = 0; i < (UWORD)nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)CB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            (UINT)pAttachColInfo->cbValueMax ) )
                    continue;
                else
                    {
                    delete[] (LPSTR)pData;
                    SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_SETITEMDATA,
                            i,
                            0
                            );
                    }
                }
            }
            
        // empty combo box.
        SendDlgItemMessage(
                        hDlg,
                        uComboBoxID,
                        CB_RESETCONTENT,
                        0,
                        0
                        );

        // if extended fetch, just fill from the rowset
        if ( ExtFetchRowCount > 1 )
            {
            for ( i = 1 ; i <= ExtFetchRow; i++ )
                {
                pString = ColResultAsLPSTR( uColToDisplay, i );
                if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                    {
                    continue;
                    }

                nPos = (int)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_ADDSTRING,
                            0,
                            (LPARAM)pString
                            );

                // attach data if user wants to
                if ( uColToAttach )
                    {
                    // allocate memory
                    pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                    if ( !pData )
                        {
                        SetRC( SQL_ALLOC_FAILED );
                        return lastRC();
                        }
                    else
                        memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                    // copy value to allocated buffer
                    memcpy( pData, ColResultAddr( uColToAttach, i ),
                                (size_t)pAttachColInfo->cbValueMax );
                    // attach to line item
                    SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_SETITEMDATA,
                            nPos,
                            (LPARAM)pData
                            );
                    }

                }   // end for loop
            }
        else
        // otherwise, fill by looping through the result set
            {
            if ( ExtFetchRowCount )
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    pString = ColResultAsLPSTR( uColToDisplay, i );
                    if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                        {
                        continue;
                        }

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uComboBoxID,
                                CB_ADDSTRING,
                                0,
                                (LPARAM)pString
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach, 1 ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uComboBoxID,
                                CB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                }
            else
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    pString = ColResultAsLPSTR( uColToDisplay );
                    if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                        {
                        continue;
                        }

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uComboBoxID,
                                CB_ADDSTRING,
                                0,
                                (LPARAM)pString
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uComboBoxID,
                                CB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                } // end if ExtFetchRowCount > 0
            }  // end if ExtFetchRowCount > 1

        if ( lastRC() == SQL_NO_DATA_FOUND )
            SetRC( SQL_SUCCESS );

        return lastRC();
        }

/****************************************************

    FillListBox

    Fill list box with the contents of a given column,
    and optionally attach the value of a different column
    to each row for use as a lookup tag.  The extra value
    is useful when there is a description column to display
    in the list box and a code or numeric key used as the
    unique ID for the row.

    The column used to fill the list box must be of a character
    data type (SQL_CHAR or SQL_VARCHAR).

    Before calling this function, a query should have been
    executed using Prepare/Execute or ExecDirect.

    If extended fetch operations were enabled and the rowset
    size is greater than one, the content of the current rowset
    will be inserted in the list box. The caller is responsible
    for calling ExtFetchFirst, etc. before calling FillListBox.
    The content of the list box then acts as a scrolling window
    on the underlying database. In this case, CleanupListBox will
    be called internally before filling the list box to assure
    that lookup tags are freed.

    If extended operations are not enabled -or- the rowset size
    for extended operations is set to one, the entire result set
    is used to fill the list box. In this case, FillListBox will
    take responsibility for calling Fetch or ExtFetchFirst/Next
    and cycling through the result set.

    If the lookup tags are used, be sure to call CleanupListBox
    when done with the dialog (e.g., during OK or Cancel button
    processing). This will ensure that the memory allocated for
    the tags is freed.

    Another member function, GetLookupTag, is useful in manipulating
    list box data.

    LB_SETITEMDATA and LB_GETITEMDATA are used to attach and
    retrieve the optional lookup tags. If lookup tags are used,
    the developer must not use the item data messages for any
    other purpose.
****************************************************/
    RETCODE odbcCURSOR::FillListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        LPCSTR  lpszColToDisplay,
                        LPCSTR  lpszColToAttach /* = NULL */
                        )
        {
        psCOLBIND pDispColInfo = ColResultInfo( lpszColToDisplay );
        psCOLBIND pAttachColInfo = NULL;

        if ( pDispColInfo == NULL )
            {
            SetRC( SQL_BAD_DISP_COLUMN );
            return lastRC();
            }

        if ( lpszColToAttach != NULL )
            {
            pAttachColInfo = ColResultInfo( lpszColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                return lastRC();
                }
            }

        return FillListBox(
                    (HWND)hDlg,
                    (UWORD)uListBoxID,
                    (UWORD)pDispColInfo->iCol,
                    (UWORD)(pAttachColInfo ? pAttachColInfo->iCol : 0)
                    );
        }

    RETCODE odbcCURSOR::FillListBox(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        UWORD   uColToDisplay,
                        UWORD   uColToAttach /* = NULL */
                        )
        {
        psCOLBIND pDispColInfo = ColResultInfo( uColToDisplay );
        psCOLBIND pAttachColInfo = NULL;
        UWORD i = 0;
        int nPos;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;
        char *pString;

        if ( pDispColInfo == NULL ||
            pDispColInfo->fCType != SQL_C_CHAR )
            {
            SetRC( SQL_BAD_DISP_COLUMN );
            return lastRC();
            }
        else if ( uColToAttach != 0 )
            {
            pAttachColInfo = ColResultInfo( uColToAttach );
            if ( !pAttachColInfo )
                {
                SetRC( SQL_BAD_ATTACH_COLUMN );
                return lastRC();
                }
            }

        // if processing rowsets, clean up item data before
        // emptying list box.
        if ( ExtFetchRowCount > 1 && nCount > 0
            && uColToAttach != 0)
            {
            for ( i = 0; i < (UWORD)nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)LB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            (UINT)pAttachColInfo->cbValueMax ) )
                    continue;
                else
                    {
                    delete[] (LPSTR)pData;
                    SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_SETITEMDATA,
                            i,
                            0
                            );
                    }
                }
            }
            
        // empty list box.
        SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_RESETCONTENT,
                        0,
                        0
                        );

        // if extended fetch, just fill from the rowset
        if ( ExtFetchRowCount > 1 )
            {
            for ( i = 1 ; i <= ExtFetchRow; i++ )
                {
                pString = ColResultAsLPSTR( uColToDisplay, i );
                if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                    {
                    continue;
                    }

                nPos = (int)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_ADDSTRING,
                            0,
                            (LPARAM)pString
                            );

                // attach data if user wants to
                if ( uColToAttach )
                    {
                    // allocate memory
                    pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                    if ( !pData )
                        {
                        SetRC( SQL_ALLOC_FAILED );
                        return lastRC();
                        }
                    else
                        memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                    // copy value to allocated buffer
                    memcpy( pData, ColResultAddr( uColToAttach, i ),
                                (size_t)pAttachColInfo->cbValueMax );
                    // attach to line item
                    SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_SETITEMDATA,
                            nPos,
                            (LPARAM)pData
                            );
                    }

                }   // end for loop
            }
        else
        // otherwise, fill by looping through the result set
            {
            if ( ExtFetchRowCount )
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    pString = ColResultAsLPSTR( uColToDisplay, i );
                    if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                        {
                        continue;
                        }

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_ADDSTRING,
                                0,
                                (LPARAM)pString
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach, 1 ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                }
            else
                {
                for ( GetFirst(); sqlsuccess(); GetNext() )
                    {
                    pString = ColResultAsLPSTR( uColToDisplay );
                    if ( IsBadStringPtr( pString, (UINT)pDispColInfo->cbValueMax ) )
                        {
                        continue;
                        }

                    nPos = (int)SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_ADDSTRING,
                                0,
                                (LPARAM)pString
                                );

                    // attach data if user wants to
                    if ( uColToAttach )
                        {
                        // allocate memory
                        pData = (PTR)(new char[ pAttachColInfo->cbValueMax + 1 ]);
                        if ( !pData )
                            {
                            SetRC( SQL_ALLOC_FAILED );
                            return lastRC();
                            }
                        else
                            memset( pData, 0, (size_t)pAttachColInfo->cbValueMax + 1 );

                        // copy value to allocated buffer
                        memcpy( pData, ColResultAddr( uColToAttach ),
                                    (size_t)pAttachColInfo->cbValueMax );
                        // attach to line item
                        SendDlgItemMessage(
                                hDlg,
                                uListBoxID,
                                LB_SETITEMDATA,
                                nPos,
                                (LPARAM)pData
                                );
                        }
                    } // end for loop
                } // end if ExtFetchRowCount > 0
            }  // end if ExtFetchRowCount > 1

        if ( lastRC() == SQL_NO_DATA_FOUND )
            SetRC( SQL_SUCCESS );

        return lastRC();
        }

/****************************************************

    FindComboLookupTag

    Find the row containing a given lookup tag. Only finds the
    first instance of the tag value, so the tag column should be
    unique if this function is to be used.

    pDataToFind points to a buffer containing the data for which to
    search.  cbLen is the size of the buffer, or the constant
    SQL_NTS if pDataToFind points to a null-terminated string.

    Returns the zero-based index of the row in the list box
    associated with the first occurrence of the lookup tag,
    or CB_ERR if the value to find is not found among the
    tags.

****************************************************/
    int odbcCURSOR::FindComboLookupTag(
                        HWND    hDlg,
                        UWORD   uComboBoxID,
                        PTR     pDataToFind,
                        SWORD   cbLen  /* = SQL_NTS */
                        )
        {
        int i = 0;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uComboBoxID,
                        CB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;


        if ( nCount <= 0 )
            i = LB_ERR;
        else
            {
            for ( i = 0; i < nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)CB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                    continue;
                else
                    {
                    if ( cbLen == SQL_NTS )
                        if ( !stricmp( (LPSTR)pData, (LPSTR)pDataToFind ) )
                            break;
                        else
                            ;
                    else
                        if ( !memcmp( pData, pDataToFind, cbLen ) )
                            break;
                        else
                            ;
                    }
                } // end for loop
            if ( i == nCount )
                i = CB_ERR;
            }

        return i;
        }

/****************************************************

    FindLookupTag

    Find the row containing a given lookup tag. Only finds the
    first instance of the tag value, so the tag column should be
    unique if this function is to be used.

    pDataToFind points to a buffer containing the data for which to
    search.  cbLen is the size of the buffer, or the constant
    SQL_NTS if pDataToFind points to a null-terminated string.

    Returns the zero-based index of the row in the list box
    associated with the first occurrence of the lookup tag,
    or LB_ERR if the value to find is not found among the
    tags.

****************************************************/
    int odbcCURSOR::FindLookupTag(
                        HWND    hDlg,
                        UWORD   uListBoxID,
                        PTR     pDataToFind,
                        SWORD   cbLen  /* = SQL_NTS */
                        )
        {
        int i = 0;
        int nCount = (int)SendDlgItemMessage(
                        hDlg,
                        uListBoxID,
                        LB_GETCOUNT,
                        0,
                        0
                        );
        PTR pData;


        if ( nCount <= 0 )
            i = LB_ERR;
        else
            {
            for ( i = 0; i < nCount; i++ )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETITEMDATA,
                            i,
                            0
                            );
                if ( !pData || (long)LB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                    continue;
                else
                    {
                    if ( cbLen == SQL_NTS )
                        if ( !stricmp( (LPSTR)pData, (LPSTR)pDataToFind ) )
                            break;
                        else
                            ;
                    else
                        if ( !memcmp( pData, pDataToFind, cbLen ) )
                            break;
                        else
                            ;
                    }
                } // end for loop
            if ( i == nCount )
                i = LB_ERR;
            }

        return i;
        }

/*
    FmtColumnDataByCType

    Local function to format a column in the list box browser.

*/

void odbcCURSOR::FmtColumnData(
                            SWORD   fCType,
                            char *  buffer,
                            PTR     pData,
                            char *  fmt,
                            BOOL    fSigned
                            )
    {
    // append the value
    switch ( fCType )
        {

    case SQL_C_CHAR:
        strcat( buffer, (LPSTR)pData );
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%3.3d", (short)(*((char *)pData)));
        break;

    case SQL_C_UTINYINT:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%3.3u", (unsigned short)(*((unsigned char *)pData)));
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_BIT:
    case SQL_C_TINYINT:
        if ( fSigned )
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%3.3d", (short)(*((char *)pData)));
        else
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%3.3u", (unsigned short)(*((unsigned char *)pData)));
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%6.6d", (short)(*((char *)pData)));
        break;

    case SQL_C_USHORT:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%6.6u", (unsigned short)(*((unsigned char *)pData)));
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_SHORT:
        if ( fSigned )
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%6.6d", (short)(*((short *)pData)));
        else
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%6.6u", (unsigned short)(*((unsigned short *)pData)));
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%11.11ld", (long)(*((long *)pData)));
        break;

    case SQL_C_ULONG:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%11.11lu", (unsigned long)(*((unsigned long *)pData)));
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_LONG:
        if ( fSigned )
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%11.11ld", (long)(*((long *)pData)));
        else
            sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%11.11ld", (unsigned long)(*((unsigned long *)pData)));
        break;


    case SQL_C_FLOAT:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%6.2f", (float)(*((float *)pData)));
        break;


    case SQL_C_DOUBLE:
        sprintf( &buffer[strlen(buffer)],
                fmt ? fmt : "%10.2lf", (double)(*((double *)pData)));
        break;


    case SQL_C_DATE:
        FmtColumnDateData(
                    buffer,
                    (DATE_STRUCT *)pData,
                    fmt
                    );
        break;


    case SQL_C_TIME:
        FmtColumnTimeData(
                buffer,
                (TIME_STRUCT *)pData,
                fmt
                );
        break;


    case SQL_C_TIMESTAMP:
        FmtColumnDateTimeData(
                buffer,
                (TIMESTAMP_STRUCT *)pData,
                fmt
                );
        break;

        }
    }

/*
    FmtColumnDateData

    Local function to format date data.

*/
void odbcCURSOR::FmtColumnDateData(
                            char *  buffer,
                            DATE_STRUCT *pDate,
                            char *  fmt
                            )
    {
    if ( pDate->year < 100 )
        pDate->year += (SWORD)1900;

    sprintf( &buffer[strlen(buffer)],
            fmt ? fmt : "%02d/%02d/%04d",
            pDate->month,
            pDate->day,
            pDate->year
            );
    }
/*
    FmtColumnDateTimeData

    Local function to format timestamp data.

*/
void odbcCURSOR::FmtColumnDateTimeData(
                            char *  buffer,
                            TIMESTAMP_STRUCT *pTs,
                            char *  fmt
                            )
    {
    if ( pTs->year < 100 )
        pTs->year += (SWORD)1900;

    int hour = pTs->hour;
    char AmOrPm;

    if ( hour < 12 )
        {
        if ( hour == 0 )
            hour = 12;
        AmOrPm = 'a';
        }
    else
        {
        if ( hour != 12 )
            hour -= 12;
        AmOrPm = 'p';
        }

    sprintf( &buffer[strlen(buffer)],
            fmt ? fmt : "%02d/%02d/%04d %02d:%02d%c",
            pTs->month,
            pTs->day,
            pTs->year,
            hour,
            pTs->minute,
            AmOrPm
            );
    }
/*
    FmtColumnTimeData

    Local function to format time data.

*/
void odbcCURSOR::FmtColumnTimeData(
                            char *  buffer,
                            TIME_STRUCT *pTime,
                            char *  fmt
                            )
    {
    int hour = pTime->hour;
    char AmOrPm;

    if ( hour < 12 )
        {
        if ( hour == 0 )
            hour = 12;
        AmOrPm = 'a';
        }
    else
        {
        if ( hour != 12 )
            hour -= 12;
        AmOrPm = 'p';
        }


    sprintf( &buffer[strlen(buffer)],
            fmt ? fmt : "%02d:%02d%c",
            hour,
            pTime->minute,
            AmOrPm
            );
    }

/****************************************************

    GetComboLookupTag

    Get the lookup tag for the currently selected item in the
    combo box.

    Uses CB_GETITEMDATA to retrieve the lookup tag. The type
    of data pointed to by the returned pointer can be determined
    using ColResultInfo( number-of-column-attached ). The fCType
    member of the struct pointed to by the ColResultInfo
    return is the type of the data pointed to by the return
    from GetLookupTag; e.g., if the type is SQL_C_DOUBLE,
    the returned pointer is of type double *; accessing the
    value would work like this:

    double d;

    double *pd = (double *)pCursor->GetLookupTag( hDlg, ID_LISTBOX );

    if ( pd )
        d = *pd;

****************************************************/
    PTR odbcCURSOR::GetComboLookupTag(
                        HWND    hDlg,
                        UWORD   uComboBoxID
                        )
            {
            int nPos = (int)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_GETCURSEL,
                            0,
                            0
                            );
                            
            PTR pData = NULL;

            if ( nPos >= 0 )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uComboBoxID,
                            CB_GETITEMDATA,
                            nPos,
                            0
                            );
                }

            if ( (long)CB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                pData = NULL;

            return pData;
            }

/****************************************************

    GetLookupTag

    Get the lookup tag for the currently selected item in the
    list box. Only works for single-select list boxes.

    Uses LB_GETITEMDATA to retrieve the lookup tag. The type
    of data pointed to by the returned pointer can be determined
    using ColResultInfo( number-of-column-attached ). The fCType
    member of the struct pointed to by the ColResultInfo
    return is the type of the data pointed to by the return
    from GetLookupTag; e.g., if the type is SQL_C_DOUBLE,
    the returned pointer is of type double *; accessing the
    value would work like this:

    double d;

    double *pd = (double *)pCursor->GetLookupTag( hDlg, ID_LISTBOX );

    if ( pd )
        d = *pd;

****************************************************/
    PTR odbcCURSOR::GetLookupTag(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        )
            {
            int nPos = (int)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETCURSEL,
                            0,
                            0
                            );
                            
            PTR pData = NULL;

            if ( nPos >= 0 )
                {
                pData = (PTR)SendDlgItemMessage(
                            hDlg,
                            uListBoxID,
                            LB_GETITEMDATA,
                            nPos,
                            0
                            );
                }

            if ( (long)LB_ERR == (long)pData
                        || IsBadWritePtr( pData,
                            1 ) )
                pData = NULL;

            return pData;
            }

/*
    ScanColumnData

    Local function to scan a column in the list box browser.

*/

BOOL odbcCURSOR::ScanColumnData(
                            SWORD   fCType,
                            char *  buffer,
                            PTR     pData,
                            char *  fmt,
                            BOOL    fSigned
                            )
    {
    unsigned short uResult;
    short nResult;
    long lResult;
    unsigned long luResult;
    float fResult;
    double dResult;

    SetRC( SQL_SUCCESS );
    
    // append the value
    switch ( fCType )
        {
    case SQL_C_CHAR:
        if ( IsBadWritePtr( pData, strlen( buffer ) + 1 ) )
            {
            SetRC( SQL_ENTRY_RANGE_ERROR );
            }
        else
            {
            strcpy( (LPSTR)pData, buffer );
            }
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) || buffer[0] == '-')
            {
            nResult = (short)atoi( buffer);
            if ( nResult > SCHAR_MAX || nResult < SCHAR_MIN )
                {
                SetRC( SQL_ENTRY_RANGE_ERROR );
                }
            *((char *)pData) = (char)nResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;

    case SQL_C_UTINYINT:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) )
            {
            uResult = (unsigned short)atoi( buffer);
            if ( uResult > UCHAR_MAX )
                {
                SetRC( SQL_ENTRY_RANGE_ERROR );
                }
            else
                *((unsigned char *)pData) = (unsigned char)uResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_BIT:
    case SQL_C_TINYINT:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( fSigned )
            {
            if ( isdigit(buffer[0]) || buffer[0] == '-')
                {
                nResult = (short)atoi( buffer);
                if ( nResult > SCHAR_MAX || nResult < SCHAR_MIN )
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                *((char *)pData) = (char)nResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        else
            {
            if ( isdigit(buffer[0]) )
                {
                uResult = (unsigned short)atoi( buffer);
                if ( uResult > UCHAR_MAX )
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                else
                    *((unsigned char *)pData) = (unsigned char)uResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) || buffer[0] == '-')
            {
            lResult = (long)atol( buffer);
            if ( lResult > (long)SHRT_MAX || lResult < (long)SHRT_MIN )
                {
                SetRC( SQL_ENTRY_RANGE_ERROR );
                }
            else
                *((short *)pData) = (short)lResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;

    case SQL_C_USHORT:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) )
            {
            luResult = (unsigned long)atol( buffer);
            if ( luResult > (unsigned long)USHRT_MAX )
                {
                SetRC( SQL_ENTRY_RANGE_ERROR );
                }
            else
                *((unsigned short *)pData) = (unsigned short)luResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_SHORT:
        while ( isspace(*buffer) )
            buffer++;

        if ( fSigned )
            {
            if ( isdigit(buffer[0]) || buffer[0] == '-')
                {
                lResult = (long)atol( buffer);
                if ( lResult > (long)SHRT_MAX || lResult < (long)SHRT_MIN )
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                else
                    *((short *)pData) = (short)lResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        else
            {
            if ( isdigit(buffer[0]) )
                {
                luResult = (unsigned long)atol( buffer);
                if ( luResult > (unsigned long)USHRT_MAX )
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                else
                    *((unsigned short *)pData) = (unsigned short)luResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) || buffer[0] == '-')
            {
            lResult = (long)atol( buffer );
            if ( lResult > LONG_MAX || lResult < LONG_MIN )
                {
                SetRC( SQL_ENTRY_RANGE_ERROR );
                }
            else
                *((long *)pData) = lResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;

    case SQL_C_ULONG:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( isdigit(buffer[0]) )
            {
            luResult = (unsigned long)atof( buffer);
            *((unsigned long *)pData) = luResult;
            }
        else
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_LONG:
        while ( isspace(*buffer) )
            buffer++;
            
        if ( fSigned )
            {
            if ( isdigit(buffer[0]) || buffer[0] == '-')
                {
                lResult = (long)atol( buffer );
                if ( lResult > LONG_MAX || lResult < LONG_MIN )
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                else
                    *((long *)pData) = lResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        else
            {
            if ( isdigit(buffer[0]) )
                {
                luResult = (unsigned long)atof( buffer);
                *((unsigned long *)pData) = luResult;
                }
            else
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            }
        break;


    case SQL_C_FLOAT:
        fResult = (float)atof(buffer);
        *((float *)pData) = fResult;
        break;


    case SQL_C_DOUBLE:
        dResult = atof(buffer);
        *((double *)pData) = dResult;
        break;


    case SQL_C_DATE:
        if ( !ScanColumnDateData(
                    buffer,
                    pData,
                    fmt
                    ) )
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;


    case SQL_C_TIME:
        if ( !ScanColumnTimeData(
                buffer,
                pData,
                fmt
                ) )
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;


    case SQL_C_TIMESTAMP:
        if ( !ScanColumnDateTimeData(
                buffer,
                pData,
                fmt
                ) )
            {
            SetRC( SQL_ENTRY_FMT_ERROR );
            }
        break;
        } // end switch on fCType

    return sqlsuccess();
    }

/*
    ScanColumnDateData

    Local function to scan date data.

*/
BOOL odbcCURSOR::ScanColumnDateData(
                            char *  buffer,
                            PTR     pData,
                            char *  /* fmt = NULL */
                            )
    {
    DATE_STRUCT *pDate = (DATE_STRUCT *)pData;
    UWORD MaxDaysInMonth = 31;
    int i = 0;
    int nCnt = 0;
    
    // clear it
    memset( pDate, 0, sizeof(*pDate));

    nCnt = GetDateFromStrBuf( buffer, pDate, i );

    if ( nCnt == 3 )
        {
        // validate the date fields
        if ( pDate->year < 100 )
            pDate->year += (SWORD)1900;
        if ( pDate->month < 1 || pDate->month > 12 )
            return FALSE;
        else
            {
            // validate days against max number for the month
            if ( pDate->month == 4 ||
                  pDate->month == 6 ||
                  pDate->month == 9 ||
                  pDate->month == 11 )
                MaxDaysInMonth = 30;
            else if ( pDate->month == 2 )
                {
                // February is a special case. In leap years
                // it has twenty-nine days, except in years
                // that divide evenly by 400, e.g. 2000 A.D.
                if ( (pDate->year % 4) == 0
                       && (pDate->year % 400) != 0 )
                    MaxDaysInMonth = 29;
                else
                    MaxDaysInMonth = 28;
                }
            // we now have the max days in the month - see
            // if the day entered is valid
            if ( MaxDaysInMonth < pDate->day
                || pDate->day < (UWORD)1 )
                return FALSE;
            }
        }
        
    return nCnt == 3;
    }

/*
    ScanColumnDateTimeData

    Local function to scan timestamp data.

*/
BOOL odbcCURSOR::ScanColumnDateTimeData(
                            char *  buffer,
                            PTR     pData,
                            char *  /* fmt = NULL */
                            )
    {
    TIMESTAMP_STRUCT *pTs = (TIMESTAMP_STRUCT *)pData;
    char AmOrPm = 0;
    UWORD MaxDaysInMonth = 31;
    int nCnt = 0;
    int i = 0;

    // clear it
    memset( pTs, 0, sizeof(*pTs));

    nCnt = GetDateFromStrBuf( buffer, pTs, i );
    if ( nCnt == 3 )
        nCnt += GetTimeFromStrBuf( buffer, pTs, AmOrPm, i );

    if ( nCnt >= 3 )
        {
        // validate the date fields
        if ( pTs->year < 100 )
            pTs->year += (SWORD)1900;
        if ( pTs->month < 1 || pTs->month > 12 )
            return FALSE;
        else
            {
            // validate days against max number for the month
            if ( pTs->month == 4 ||
                  pTs->month == 6 ||
                  pTs->month == 9 ||
                  pTs->month == 11 )
                MaxDaysInMonth = 30;
            else if ( pTs->month == 2 )
                {
                // February is a special case. In leap years
                // it has twenty-nine days, except in years
                // that divide evenly by 400, e.g. 2000 A.D.
                if ( (pTs->year % 4) == 0
                       && (pTs->year % 400) != 0 )
                    MaxDaysInMonth = 29;
                else
                    MaxDaysInMonth = 28;
                }
            // we now have the max days in the month - see
            // if the day entered is valid
            if ( MaxDaysInMonth < pTs->day
                || pTs->day < (UWORD)1 )
                return FALSE;
            }
        }
    else
        return FALSE;
        
    // date is valid, now try time
    if ( nCnt >= 5 )
        {
        // validate minutes
        if ( pTs->minute > 59 )
            return FALSE;

        if ( nCnt < 6 )
            {
            // no am or pm, assume military time
            if ( pTs->hour > 23 )
                return FALSE;
            }
        else if ( AmOrPm == 'a' || AmOrPm == 'A' )
            {  // night - morning
            if ( pTs->hour == 12 )
                pTs->hour = 0;
            else if ( pTs->hour < 1 || pTs->hour > 11 )
                return FALSE;
            }
        else if ( AmOrPm == 'p' || AmOrPm == 'P' )
            {  // afternoon - evening
            if ( pTs->hour < 1 || pTs->hour > 12 )
                return FALSE;
            else if ( pTs->hour == 12 )
                ; // 12:53pm is 1253 hours
            else
                pTs->hour += (UWORD)12; // turn from 1..11 to 13..23
            }
        else
            return FALSE;
        }
        
    return nCnt == 3 || nCnt == 5 || nCnt == 6;
    }
/*
    ScanColumnTimeData

    Local function to scan time data.

*/
BOOL odbcCURSOR::ScanColumnTimeData(
                            char *  buffer,
                            PTR     pData,
                            char *  /* fmt = NULL */
                            )
    {
    TIME_STRUCT *pTime = (TIME_STRUCT *)pData;
    char AmOrPm = 0;
    int nCnt = 0;
    int i = 0;

    // clear it
    memset( pTime, 0, sizeof(*pTime));

    nCnt = GetTimeFromStrBuf( buffer, pTime, AmOrPm, i );

    if ( nCnt == 2 || nCnt == 3 )
        {
        // validate minutes
        if ( pTime->minute > 59 )
            return FALSE;

        if ( nCnt == 2 )
            {
            // no am or pm, assume military time
            if ( pTime->hour > 23 )
                return FALSE;
            }
        else if ( AmOrPm == 'a' || AmOrPm == 'A' )
            {  // night - morning
            if ( pTime->hour == 12 )
                pTime->hour = 0;
            else if ( pTime->hour < 1 || pTime->hour > 11 )
                return FALSE;
            }
        else if ( AmOrPm == 'p' || AmOrPm == 'P' )
            {  // afternoon - evening
            if ( pTime->hour < 1 || pTime->hour > 12 )
                return FALSE;
            else if ( pTime->hour == 12 )
                ; // 12:53pm is 1253 hours
            else
                pTime->hour += (UWORD)12; // turn from 1..11 to 13..23
            }
        else
            return FALSE;
        }
    else
        return FALSE;

    return TRUE;
    }

/****************************************************

    SetCheckBoxFromColResult

    Set the state of a check box control window
    based on the value for a given column or column/row in
    a rowset. Assumes if a numeric type, non-zero is
    checked and zero is unchecked; other data types cause
    an error.  Tri-states are correctly handled.  Values
    outside legal range (0..2) are treated as if they
    were 1.

****************************************************/
        RETCODE  odbcCURSOR::SetCheckBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData
                        )
            {
            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_CHAR : 
            case SQL_C_DATE :
            case SQL_C_TIME :
            case SQL_C_TIMESTAMP :
            case SQL_C_BINARY :
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            int nResult = ColValueAsInt(
                                pColBind->fCType,
                                pData
                                );

            // treat any non-zero value less than zero or
            // greater than 2 as if it were 1 (checked).
            // if in legal range 0..2, use value directly.
            SendDlgItemMessage( hDlg, uCtlID, BM_SETCHECK,
                            (WPARAM)
                            ((nResult < 3 && nResult >= 0) ?
                                nResult : 1), 0 );

            return SQL_SUCCESS;
            }

        RETCODE  odbcCURSOR::SetCheckBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow
                        )
            {
            return SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow )
                        );
            }

        RETCODE  odbcCURSOR::SetCheckBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow
                        )
            {
            return SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow )
                        );
            }



        RETCODE  odbcCURSOR::SetCheckBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName
                        )
            {
            return SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  )
                        );
            }


        RETCODE  odbcCURSOR::SetCheckBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol
                        )
            {
            return SetCheckBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol )
                        );
            }

/****************************************************

    SetColResultFromCheckBox

    Set the rowset value for a given column/row from the
    text in a control window of check box type.

****************************************************/
        RETCODE  odbcCURSOR::SetColResultFromCheckBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData
                        )
            {
            int nResult = 0;

            SetRC( SQL_SUCCESS );

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_BINARY:
            case SQL_C_CHAR:
            case SQL_C_DATE:
            case SQL_C_TIME:
            case SQL_C_TIMESTAMP:
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            // get user-entered text
            nResult = (int)SendDlgItemMessage(
                                    hDlg,
                                    uCtlID,
                                    BM_GETCHECK,
                                    0,
                                    0
                                    );
            if ( nResult < 0 || nResult > 2 )
                {
                SetRC( SQL_ENTRY_FMT_ERROR );
                }
            else
                SetColValueFromInt
                    (
                    pColBind->fCType,
                    pData,
                    nResult
                    );

            // if an error code was set, we'll return it.
            return lastRC();
            }

        RETCODE  odbcCURSOR::SetColResultFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow
                        )
            {
            return SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow )
                        );
            }

        RETCODE  odbcCURSOR::SetColResultFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow
                        )
            {
            return SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow )
                        );
            }



        RETCODE  odbcCURSOR::SetColResultFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName
                        )
            {
            return SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  )
                        );
            }


        RETCODE  odbcCURSOR::SetColResultFromCheckBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol
                        )
            {
            return SetColResultFromCheckBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol )
                        );
            }

/****************************************************

    SetColResultFromComboBox

    Set the rowset value for a given column/row from the
    lokup tag in a combo box control window. Assumes the combo
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

    Sets error to SQL_ENTRY_RANGE_ERROR if the list box
    has no selection.

****************************************************/
        RETCODE  odbcCURSOR::SetColResultFromComboBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos
                        )
            {
            PTR pSetting;
            int nPos;

            SetRC( SQL_SUCCESS );

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            if ( !bSetPos )
                {
                // we don't handle all types in dialogs
                switch ( pColBind->fSqlType )
                    {
                case SQL_LONGVARCHAR:
                case SQL_LONGVARBINARY:
                    SetRC( SQL_DATA_CONVERT_ERROR );
                    return lastRC();

                default:
                    break;
                    }
                }
            else
                {
                // we don't handle non-numeric types for position
                switch ( pColBind->fCType )
                    {
                case SQL_C_BINARY:
                case SQL_C_CHAR:
                case SQL_C_DATE:
                case SQL_C_TIME:
                case SQL_C_TIMESTAMP:
                    SetRC( SQL_DATA_CONVERT_ERROR );
                    return lastRC();

                default:
                    break;
                    }
                }

            if ( !bSetPos )
                {
                // get user-selected row's lookup tag
                pSetting = GetComboLookupTag(
                                        hDlg,
                                        uCtlID
                                        );
                if ( pSetting )
                    {
                    memcpy( pData, pSetting, (size_t)pColBind->cbValueMax );
                    }
                else
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                }
            else
                {
                // get position in box and use this value
                nPos = (int)SendDlgItemMessage(
                                        hDlg,
                                        uCtlID,
                                        CB_GETCURSEL,
                                        0,
                                        0
                                        );
                if ( nPos != CB_ERR )
                    {
                    SetColValueFromInt
                        (
                        pColBind->fCType,
                        pData,
                        nPos
                        );
                    }
                else
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                }

            // if an error code was set, we'll return it.
            return lastRC();
            }

        RETCODE  odbcCURSOR::SetColResultFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        bSetPos
                        );
            }

        RETCODE  odbcCURSOR::SetColResultFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        bSetPos
                        );
            }



        RETCODE  odbcCURSOR::SetColResultFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        bSetPos
                        );
            }


        RETCODE  odbcCURSOR::SetColResultFromComboBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromComboBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        bSetPos
                        );
            }


/****************************************************

    SetColResultFromListBox

    Set the rowset value for a given column/row from the
    lokup tag in a list box control window. Assumes the list
    box has been filled with the result of a query and
    lookup tags attached that are of exactly the same
    data type and size as the column given here.

    Sets error to SQL_ENTRY_RANGE_ERROR if the list box
    has no selection.

****************************************************/
        RETCODE  odbcCURSOR::SetColResultFromListBox(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos
                        )
            {
            PTR pSetting;
            int nPos;

            SetRC( SQL_SUCCESS );

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            if ( !bSetPos )
                {
                // we don't handle all types in dialogs
                switch ( pColBind->fSqlType )
                    {
                case SQL_LONGVARCHAR:
                case SQL_LONGVARBINARY:
                    SetRC( SQL_DATA_CONVERT_ERROR );
                    return lastRC();

                default:
                    break;
                    }
                }
            else
                {
                // we don't handle non-numeric types for position
                switch ( pColBind->fCType )
                    {
                case SQL_C_BINARY:
                case SQL_C_CHAR:
                case SQL_C_DATE:
                case SQL_C_TIME:
                case SQL_C_TIMESTAMP:
                    SetRC( SQL_DATA_CONVERT_ERROR );
                    return lastRC();

                default:
                    break;
                    }

                }

            if ( !bSetPos )
                {
                // get user-selected row's lookup tag
                pSetting = GetLookupTag(
                                        hDlg,
                                        uCtlID
                                        );
                if ( pSetting )
                    {
                    memcpy( pData, pSetting, (size_t)pColBind->cbValueMax );
                    }
                else
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                }
            else
                {
                // get position in box and use this value
                nPos = (int)SendDlgItemMessage(
                                        hDlg,
                                        uCtlID,
                                        LB_GETCURSEL,
                                        0,
                                        0
                                        );
                if ( nPos != LB_ERR )
                    {
                    SetColValueFromInt
                        (
                        pColBind->fCType,
                        pData,
                        nPos
                        );
                    }
                else
                    {
                    SetRC( SQL_ENTRY_RANGE_ERROR );
                    }
                }

            // if an error code was set, we'll return it.
            return lastRC();
            }

        RETCODE  odbcCURSOR::SetColResultFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        bSetPos
                        );
            }

        RETCODE  odbcCURSOR::SetColResultFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        bSetPos
                        );
            }



        RETCODE  odbcCURSOR::SetColResultFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        bSetPos
                        );
            }


        RETCODE  odbcCURSOR::SetColResultFromListBox(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        BOOL    bSetPos
                        )
            {
            return SetColResultFromListBox(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        bSetPos
                        );
            }

/****************************************************

    SetColResultFromRadioBtns

    Set value for a given column or column/row in
    a rowset based on the the state of a set of radio button
    control windows. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.

    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.

    The value stored in the database is assume to be the
    offset from the first radio button; i.e., if the stored value
    is zero the first radio button is highlighted. Hence, the valid
    range of the stored value is 0..(uCtlIDMax - uCtlIDMin).

****************************************************/
        RETCODE  odbcCURSOR::SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        psCOLBIND   pColBind,
                        PTR         pData
                        )
            {
            int nResult = 0;
            UWORD uCtlID;

            SetRC( SQL_SUCCESS );

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_BINARY:
            case SQL_C_CHAR:
            case SQL_C_DATE:
            case SQL_C_TIME:
            case SQL_C_TIMESTAMP:
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            for ( uCtlID = uCtlIDMin; uCtlID <= uCtlIDMax; uCtlID++ )
                {
                // get user-entered text
                nResult = (int)SendDlgItemMessage(
                                    hDlg,
                                    uCtlID,
                                    BM_GETCHECK,
                                    0,
                                    0
                                    );

                if ( nResult < 0 || nResult > 2 )
                    {
                    SetRC( SQL_ENTRY_FMT_ERROR );
                    }
                else if ( nResult == 1 )
                    {
                    SetColValueFromInt
                        (
                        pColBind->fCType,
                        pData,
                        (int)(uCtlID - uCtlIDMin)
                        );
                    break;
                    }
               } // end for loop

            // if an error code was set, we'll return it.
            return lastRC();
            }

        RETCODE  odbcCURSOR::SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        UWORD       irow
                        )
            {
            return SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow )
                        );
            }

        RETCODE  odbcCURSOR::SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        UWORD       irow
                        )
            {
            return SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow )
                        );
            }



        RETCODE  odbcCURSOR::SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName
                        )
            {
            return SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  )
                        );
            }


        RETCODE  odbcCURSOR::SetColResultFromRadioBtns(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol
                        )
            {
            return SetColResultFromRadioBtns(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColResultAddr( icol )
                        );
            }

/****************************************************

    SetColResultFromWndText

    Set the rowset value for a given column/row from the
    text in a control window of class EDIT.

****************************************************/
        RETCODE  odbcCURSOR::SetColResultFromWndText(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        char *      fmt,
                        BOOL        fSigned
                        )
            {
            char *buffer;
            unsigned uDisplayLen = 0;

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_BINARY:
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            if ( pColBind->fSqlType != SQL_LONGVARCHAR )
                {
                // how much buffer space do we need?
                uDisplayLen = (unsigned)SendDlgItemMessage( hDlg, uCtlID,
                                WM_GETTEXTLENGTH, 0, 0 ) + 1;

                // allocate temp buffer for the text
                buffer = new char[ uDisplayLen ];
                if ( !buffer )
                    {
                    SetRC( SQL_ALLOC_FAILED );
                    return lastRC();
                    }

                // get user-entered text
                GetDlgItemText( hDlg, uCtlID, buffer, uDisplayLen );

                // scan it into the rowset buffer
                ScanColumnData(
                    pColBind->fCType,
                    buffer,
                    pData,
                    fmt,
                    fSigned
                    );
                if ( !sqlsuccess())
                    {
                    // set focus and highlight text
                    SetFocus( GetDlgItem( hDlg, uCtlID ));

                    SendDlgItemMessage(
                            hDlg,
                            uCtlID,
                            EM_SETSEL,
                            (WPARAM)0,
                            (LPARAM)(int)strlen( buffer )
                            );
                    }

                // get rid of temp buffer
                delete[] buffer;
                }
            else
                {
                // get text from edit and put in BLOB
                podbcBLOB pBlob = *(podbcBLOB *)pData;
                char HUGE *pText = NULL;

                if ( !pBlob )
                    ;
                else
                    {
                    int nTextLen
                            = (int)SendDlgItemMessage( hDlg, uCtlID,
                                WM_GETTEXTLENGTH, 0, 0 );
                    if ( nTextLen > 0 )
                        {
                        nTextLen++; // to allow for null terminator byte
                        pText = (char HUGE *)pBlob->GetMem( (UDWORD)nTextLen ) ;

                        if ( pText )
                            {
                            // get user-entered text
                            GetDlgItemText( hDlg, uCtlID, (LPSTR)pText,
                                        nTextLen );

                            }
                        }
                    else
                        pBlob->SetLPSTRInBlob( "" );
                    }
                }

            // if an error code was set, we'll return it.
            return lastRC();
            }

        RETCODE  odbcCURSOR::SetColResultFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        fmt,
                        fSigned
                        );
            }

        RETCODE  odbcCURSOR::SetColResultFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        fmt,
                        fSigned
                        );
            }



        RETCODE  odbcCURSOR::SetColResultFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        fmt,
                        fSigned
                        );
            }


        RETCODE  odbcCURSOR::SetColResultFromWndText(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetColResultFromWndText(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        fmt,
                        fSigned
                        );
            }

/*
    SetColValueFromInt

    Set value of numeric column from integer.

*/

int odbcCURSOR::SetColValueFromInt(
                            SWORD   fCType,
                            PTR     pData,
                            int     nValue
                            )
    {
    int ret = TRUE;

    // append the value
    switch ( fCType )
        {
#if (ODBCVER >= 0x0200)
    case SQL_C_STINYINT:
        (*((char *)pData)) = (char)nValue;
        break;

    case SQL_C_UTINYINT:
        (*((unsigned char *)pData)) = (unsigned char)nValue;
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_BIT:
    case SQL_C_TINYINT:
        (*((char *)pData)) = (char)nValue;
        break;

#if (ODBCVER >= 0x0200)
    case SQL_C_SSHORT:
        (*((short *)pData)) = (short)nValue;
        break;

    case SQL_C_USHORT:
        (*((unsigned short *)pData)) = (unsigned short)nValue;
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_SHORT:
        (*((short *)pData)) = (short)nValue;
        break;


#if (ODBCVER >= 0x0200)
    case SQL_C_SLONG:
        (*((long *)pData)) = (long)nValue;
        break;

    case SQL_C_ULONG:
        (*((unsigned long *)pData)) = (unsigned long)nValue;
        break;
#endif  /* ODBCVER >= 0x0200 */

    case SQL_C_LONG:
        (*((long *)pData)) = (long)nValue;
        break;

    case SQL_C_FLOAT:
        (*((float *)pData)) = (float)nValue;
        break;

    case SQL_C_DOUBLE:
        (*((double *)pData)) = (double)nValue;
        break;

    default:
        ret = FALSE;
        }

    return ret;
    }

/****************************************************

    SetComboBoxFromColResult

    Set the state of a combo box control window
    based on the value for a given column or column/row in
    a rowset. Assumes the combo box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
        RETCODE  odbcCURSOR::SetComboBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos
                        )
            {
            RETCODE ret = SQL_SUCCESS;
            int nPos = CB_ERR;

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                ret = lastRC();
                }
            else
                {
                if ( !bSetPos )
                    {
                    switch ( pColBind->fSqlType )
                        {
                    // we don't handle all types
                    case SQL_LONGVARCHAR:
                    case SQL_LONGVARBINARY:
                        SetRC( SQL_DATA_CONVERT_ERROR );
                        ret = lastRC();
                        break;
                        }
                        
                    switch ( pColBind->fCType )
                        {
                    // find the lookup tag corresponding to this
                    // column.
                    // deal with string data
                    case SQL_C_CHAR:
                        nPos = FindComboLookupTag(
                            hDlg,
                            uCtlID,
                            pData
                            );
                        break;

                    default:
                        nPos = FindComboLookupTag(
                            hDlg,
                            uCtlID,
                            pData,
                            (SWORD)pColBind->cbValueMax
                            );
                        break;
                        } // end switch
                    }
                else
                    {
                    // we don't handle non-numeric types in set-pos ops
                    // we don't handle all types in dialogs
                    switch ( pColBind->fCType )
                        {
                    case SQL_C_CHAR : 
                    case SQL_C_DATE :
                    case SQL_C_TIME :
                    case SQL_C_TIMESTAMP :
                    case SQL_C_BINARY :
                        SetRC( SQL_DATA_CONVERT_ERROR );
                        return lastRC();

                    default:
                        nPos = ColValueAsInt(
                                pColBind->fCType,
                                pData
                                );
                        break;
                        }  // end switch
                    } // end if !bSetPos

                if ( nPos != CB_ERR )
                    SendDlgItemMessage(
                        hDlg,
                        uCtlID,
                        CB_SETCURSEL,
                        (WPARAM)nPos,
                        0
                        );
                } // end if

            return ret;
            }

        RETCODE  odbcCURSOR::SetComboBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        bSetPos
                        );
            }

        RETCODE  odbcCURSOR::SetComboBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        bSetPos
                        );
            }



        RETCODE  odbcCURSOR::SetComboBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        BOOL    bSetPos
                        )
            {
            return SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        bSetPos
                        );
            }


        RETCODE  odbcCURSOR::SetComboBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        BOOL    bSetPos
                        )
            {
            return SetComboBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        bSetPos
                        );
            }

/****************************************************

    SetListBoxFromColResult

    Set the state of a list box control window
    based on the value for a given column or column/row in
    a rowset. Assumes the list box has been filled with
    the result of a query and lookup tags attached that
    are of exactly the same data type and size as the
    column given here.

****************************************************/
        RETCODE  odbcCURSOR::SetListBoxFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        BOOL        bSetPos
                        )
            {
            RETCODE ret = SQL_SUCCESS;
            int nPos = LB_ERR;

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                ret = lastRC();
                }
            else
                {
                if ( !bSetPos )
                    {
                    switch ( pColBind->fSqlType )
                        {
                    // we don't handle all types
                    case SQL_LONGVARCHAR:
                    case SQL_LONGVARBINARY:
                        SetRC( SQL_DATA_CONVERT_ERROR );
                        ret = lastRC();
                        break;
                        }
                        
                    switch( pColBind->fCType )
                        {
                    // find the lookup tag corresponding to this
                    // column.
                    // deal with string data
                    case SQL_C_CHAR:
                        nPos = FindLookupTag(
                            hDlg,
                            uCtlID,
                            pData
                            );
                        break;

                    default:
                        nPos = FindLookupTag(
                            hDlg,
                            uCtlID,
                            pData,
                            (SWORD)pColBind->cbValueMax
                            );
                        break;
                        } // end switch
                    }
                else
                    {
                    // we don't handle non-numeric types in set-pos ops
                    switch ( pColBind->fCType )
                        {
                    case SQL_C_CHAR : 
                    case SQL_C_DATE :
                    case SQL_C_TIME :
                    case SQL_C_TIMESTAMP :
                    case SQL_C_BINARY :
                        SetRC( SQL_DATA_CONVERT_ERROR );
                        return lastRC();

                    default:
                        nPos = ColValueAsInt(
                                pColBind->fCType,
                                pData
                                );
                        break;
                        }  // end switch
                    } // end if !bSetPos

                if ( nPos != LB_ERR )
                    SendDlgItemMessage(
                        hDlg,
                        uCtlID,
                        LB_SETCURSEL,
                        (WPARAM)nPos,
                        0
                        );
                } // end if

            return ret;
            }

        RETCODE  odbcCURSOR::SetListBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        bSetPos
                        );
            }

        RETCODE  odbcCURSOR::SetListBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        BOOL    bSetPos
                        )
            {
            return SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        bSetPos
                        );
            }



        RETCODE  odbcCURSOR::SetListBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        BOOL    bSetPos
                        )
            {
            return SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        bSetPos
                        );
            }


        RETCODE  odbcCURSOR::SetListBoxFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        BOOL    bSetPos
                        )
            {
            return SetListBoxFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        bSetPos
                        );
            }

/****************************************************

    SetMaxTextLenFromCol

    Set the allowable text length a control window (of type EDIT)
    based on a given column.

****************************************************/
        void  odbcCURSOR::SetMaxTextLenFromCol(
                        HWND hDlg,
                        UWORD uCtlID,
                        LPCSTR ColName
                        )
            {
            psCOLBIND pColBind = ColResultInfo( ColName );

            if ( !pColBind )
                return;

            UWORD uDisplayLen = (UWORD)pColBind->cbValueMax;

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_BINARY:
                return;

            default:
                break;
                }

            // how much buffer space do we need?
            if ( pColBind->fSqlType == SQL_LONGVARCHAR )
                {
                uDisplayLen = 0;    // user must decide for longvarchars
                }
            else
                {
                DetermineColumnLen
                                    (
                                    pColBind->fCType,
                                    (LPSTR)pColBind->szColName,
                                    uDisplayLen
                                    );

                if ( uDisplayLen == 0 )
                    {
                    SendDlgItemMessage(
                                hDlg,
                                uCtlID,
                                EM_LIMITTEXT,
#if !defined(WIN32) && !defined(__WIN32__)
                                (WPARAM)30000, // 16-bit - limited
#else
                                (WPARAM)0,     // 32-bit - essentially no limit
#endif
                                0
                                );
                    }
                else
                    {

                    SendDlgItemMessage(
                                hDlg,
                                uCtlID,
                                EM_LIMITTEXT,
                                (WPARAM)(uDisplayLen + 1),
                                0
                                );
                    }
                }
            }

        void  odbcCURSOR::SetMaxTextLenFromCol(
                        HWND hDlg,
                        UWORD uCtlID,
                        UWORD icol
                        )
            {
            psCOLBIND pColBind = ColResultInfo( icol );
            if ( pColBind )
                {
                SetMaxTextLenFromCol(
                            hDlg,
                            uCtlID,
                            (LPCSTR)pColBind->szColName
                            );
                }
            }

/****************************************************

    SetRadioBtnsFromColResult

    Set the state of a set of radio button control windows
    based on the value for a given column or column/row in
    a rowset. Assumes column is numeric and value is in
    specified range; other data types or values out of range
    cause an error.
    uCtlIDMin is first radio button, uCtlIDMax is the
    last; radio buttons should exist for all cardinal integers
    between these values.

    The value stored in the database is assume to be the
    offset from the first radio button; i.e., if the stored value
    is zero the first radio button is highlighted. Hence, the valid
    range of the stored value is 0..(uCtlIDMax - uCtlIDMin).


****************************************************/
        RETCODE  odbcCURSOR::SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        psCOLBIND   pColBind,
                        PTR         pData
                        )
            {
            UWORD i;

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_CHAR : 
            case SQL_C_DATE :
            case SQL_C_TIME :
            case SQL_C_TIMESTAMP :
            case SQL_C_BINARY :
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            // get ID of radio button to turn on
            UWORD uCtlID = (UWORD)ColValueAsInt(
                                pColBind->fCType,
                                pData
                                );

            // add value of first radio button in set
            uCtlID += uCtlIDMin;

            // check range
            if ( uCtlID < uCtlIDMin || uCtlID > uCtlIDMax )
                {
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();
                }

            // turn 'em all off
            for ( i = uCtlIDMin; i <= uCtlIDMax; i++ )
                SendDlgItemMessage( hDlg, i, BM_SETCHECK,
                                (WPARAM)
                                0, 0 );

            // set turned-on radio button.
            SendDlgItemMessage( hDlg, uCtlID, BM_SETCHECK,
                            (WPARAM)
                            1, 0 );

            return SQL_SUCCESS;
            }

        RETCODE  odbcCURSOR::SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName,
                        UWORD       irow
                        )
            {
            return SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow )
                        );
            }

        RETCODE  odbcCURSOR::SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol,
                        UWORD       irow
                        )
            {
            return SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow )
                        );
            }



        RETCODE  odbcCURSOR::SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        LPCSTR      ColName
                        )
            {
            return SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  )
                        );
            }


        RETCODE  odbcCURSOR::SetRadioBtnsFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlIDMin,
                        UWORD       uCtlIDMax,
                        UWORD       icol
                        )
            {
            return SetRadioBtnsFromColResult(
                        hDlg,
                        uCtlIDMin,
                        uCtlIDMax,
                        ColResultInfo( icol ),
                        ColResultAddr( icol )
                        );
            }

/****************************************************

    SetTabsForBrowser

    Set tabs for a browser list box.  The style
    LBS_USETABSTOPS must have been applied to the list
    box resource definition for this to work.
****************************************************/
    void odbcCURSOR::SetTabsForBrowser(
                        HWND    hDlg,
                        UWORD   uListBoxID
                        )
        {
        int i = 0, j = 0;
        int nCount = 0;
        int *pTabs = NULL;
        int nAccumTab = 0;

        // get count of columns
        for ( nCount = 0, j = 0; j < (int)ColCount; j++ )
            {
            // get display length
            UWORD uDisplayLen =
                    (UWORD)max(
                        (UWORD)pColBindings[j].cbValueMax,
                        (UWORD)strlen((LPSTR)pColBindings[j].szColName));

            // we don't handle all types in the browser, just non-BLOBs that are
            // bound as char arrays.
            switch ( pColBindings[j].fCType )
                {
            case SQL_C_CHAR:
                if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                    continue;
                break;
            default:
                break;
                }

            DetermineBrowserColumnLen
                                (
                                pColBindings[j].fCType,
                                (LPSTR)pColBindings[j].szColName,
                                uDisplayLen
                                );

            // see if we are over the limit
            if ( nAccumTab + ((uDisplayLen + 3) * 4)
                     > 511)
                break;

            // if we get here, we're going to use this column
            nCount++;
            nAccumTab += ((uDisplayLen + 3) * 4);
            } // end inner for loop

        // allocate tab array
        if ( nCount < 2 )
            return;

        pTabs = new int[ nCount ];

        for ( i = 0; i < nCount; i++ )
            pTabs[i] = 0;

        if ( !pTabs )
            {
            SetRC( SQL_ALLOC_FAILED );
            return;
            }

        // get tab settings for each column

        // get count of columns
        for ( nAccumTab = 0, j = 0, i = 0; j < (int)ColCount; j++ )
            {
            // get display length
            UWORD uDisplayLen =
                    (UWORD)max(
                        (UWORD)pColBindings[j].cbValueMax,
                        (UWORD)strlen((LPSTR)pColBindings[j].szColName));

            // we don't handle all types in the browser, just non-BLOBs that are
            // bound as char arrays.
            switch ( pColBindings[j].fCType )
                {
            case SQL_C_CHAR:
                if ( pColBindings[ j ].fSqlType == SQL_LONGVARCHAR )
                    continue;
                break;
            default:
                break;
                }

            DetermineBrowserColumnLen
                                (
                                pColBindings[j].fCType,
                                (LPSTR)pColBindings[j].szColName,
                                uDisplayLen
                                );

            // see if we are over the limit
            if ( nAccumTab + ((uDisplayLen + 3) * 4)
                     > 511)
                break;

            // if we get here, we're going to use this column
            nAccumTab += ((uDisplayLen + 3) * 4);
            pTabs[i++] = nAccumTab;
            } // end inner for loop



        SendDlgItemMessage(
                    hDlg,
                    uListBoxID,
                    LB_SETTABSTOPS,
                    i,
                    (LPARAM)pTabs
                    );
        // free tab array
        delete[] pTabs;

        }

/****************************************************

    SetWndTextFromColResult

    Set the text a control window (of type EDIT or STATIC)
    based on the value for a given column or column/row in
    a rowset.

****************************************************/
        RETCODE  odbcCURSOR::SetWndTextFromColResult(
                        HWND        hDlg,
                        UWORD       uCtlID,
                        psCOLBIND   pColBind,
                        PTR         pData,
                        char *      fmt,
                        BOOL        fSigned
                        )
            {
            char *buffer;
            UWORD uDisplayLen = 0;

            // legal column name?
            if ( !pColBind || !pData )
                {
                SetRC( SQL_BAD_DISP_COLUMN );
                return lastRC();
                }

            // we don't handle all types in dialogs
            switch ( pColBind->fCType )
                {
            case SQL_C_BINARY:
                SetRC( SQL_DATA_CONVERT_ERROR );
                return lastRC();

            default:
                break;
                }

            if ( pColBind->fSqlType != SQL_LONGVARCHAR )
                {
                // how much buffer space do we need?
                DetermineColumnLen
                                    (
                                    pColBind->fCType,
                                    (LPSTR)pColBind->szColName,
                                    uDisplayLen
                                    );

                if ( uDisplayLen == 0 )
                    {
                    SetDlgItemText( hDlg, uCtlID, "" );
                    return SQL_SUCCESS;
                    }

                // allocate temp buffer for the text
                buffer = new char[ uDisplayLen + 1 ];
                if ( !buffer )
                    {
                    SetRC( SQL_ALLOC_FAILED );
                    return lastRC();
                    }

                // get formatted text
                buffer[0] = 0;
                FmtColumnData(
                                    pColBind->fCType,
                                    buffer,
                                    pData,
                                    fmt,
                                    fSigned
                                    );

                // set text
                SetDlgItemText( hDlg, uCtlID, buffer );
                // get rid of temp buffer
                delete[] buffer;
                }
            else
                {
                // get text from blob, if it exists, and display it
                podbcBLOB pBlob = *(podbcBLOB *)pData;
                if ( !pBlob || pBlob->IsEmpty() || pBlob->IsNull() )
                    SetDlgItemText( hDlg, uCtlID, "" );
                else
                    SetDlgItemText( hDlg,
                                    uCtlID,
                                    pBlob->GetLPSTRFromBlob()
                                  );
                }
            return SQL_SUCCESS;
            }

        RETCODE  odbcCURSOR::SetWndTextFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        UWORD   irow,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName, irow ),
                        fmt,
                        fSigned
                        );
            }

        RETCODE  odbcCURSOR::SetWndTextFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        UWORD   irow,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol, irow ),
                        fmt,
                        fSigned
                        );
            }



        RETCODE  odbcCURSOR::SetWndTextFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        LPCSTR  ColName,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( ColName ),
                        ColResultAddr( ColName  ),
                        fmt,
                        fSigned
                        );
            }


        RETCODE  odbcCURSOR::SetWndTextFromColResult(
                        HWND    hDlg,
                        UWORD   uCtlID,
                        UWORD   icol,
                        char *  fmt,
                        BOOL    fSigned
                        )
            {
            return SetWndTextFromColResult(
                        hDlg,
                        uCtlID,
                        ColResultInfo( icol ),
                        ColResultAddr( icol ),
                        fmt,
                        fSigned
                        );
            } 

