/* 
 * LTBOOT.CMD
 *
 * Copyright (c) 1995 Artisoft, Inc.  All rights reserved.
 * 
 * REXX program to create a 3-disk set of OS/2-LANtastic boot disks.
 *
 * Individual disks can be created using command line arguments:
 *
 *    -0   - create disk 0 ("Installation diskette")
 *    -1   - create disk 1 ("Diskette 1")
 *    -2   - create disk 2 (LANtastic and OS/2 utilities)
 *
 * The default is "-0 -1 -2"
 *
 * LTBOOT, like LANtastic for OS/2, requires OS/2 version 2.1
 * or higher.  LTBOOT has been tested with the following 
 * versions of OS/2:
 *
 *   version      disk/   install
 *                 cdrom  disk p/n
 *   ========     ======  ========
 *   2.1          Floppy  61G0727
 *   2.1          Floppy  71G4277
 *   2.1          Floppy  82G2733
 *   2.1          CD-ROM  71G1541
 *   2.1          CD-ROM  82G6304
 *   2.11         Floppy  
 *   Warp Beta 1  Floppy  
 *   Warp Beta 2  Floppy  
 *   Warp 3.0     CD-ROM  83G8438 
 *
 * If you have an Installation diskette of a different version
 * or part number, you can probably run LTBOOT successfully,
 * however, verify that the resulting floppy disks work correctly.
 *
 */

   Trace 'Off'
   Address CMD
   '@ECHO OFF'
   'CLS'
   
   /* process any command-line arguments */
   disk0 = 0
   disk1 = 0
   disk2 = 0
   Do i = 1 to 3           /* up to three command-line arguments */
      If Arg(i) = '' Then Leave
      If Substr(Arg(i),1,1) <> '-' Then Do
         Call usage
         Say ' '
         Say 'LTBOOT - unrecognized parameter '||Arg(i).
         Exit
      End
      Else Do
         option = Translate(Substr(Arg(i),2,1))
         Select
            When option = '0' Then disk0 = 1
            When option = '1' Then disk1 = 1
            When option = '2' Then disk2 = 1
         Otherwise
            Call usage
            Say ' '
            Say 'LTBOOT - unrecognized parameter '||Arg(i).
            Exit
         End   /* Select */
      End
   End
   
   /* if none were selected, default to all selected */
   If (disk0 = 0) & (disk1 = 0) & (disk2 = 0) Then Do
      disk0 = 1
      disk1 = 1
      disk2 = 1
   End
   
   Call show_banner
   
   Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
   Call sysloadfuncs
   
   /* 
    * Get the boot drive, the OS/2 directory path, and the LANtastic
    * installation directory 
    */
   bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)
   sysdir  = bootdrive||'\os2'
   instdir = SysIni(sysdir||'\LANTASTI.INI', 'LANtastic', 'ProgramDir')
   
   If instdir = 'ERROR:' Then Do
       Say 'LANtastic for OS/2 installation profile LANTASTI.INI not found '
       Say 'on this machine.  LTBOOT can''t continue.'
       Say ' '
       Exit 1
   End
   
   /* INI strings come back with a trailing NULL, truncate it */
   instdir = Strip(instdir, 'Trailing', D2C(0))
   
   /* make sure we can find PROTOCOL.INI */
   file.0 = 0
   RC = SysFileTree(instdir||'\PROTOCOL.INI', file, 'F')
   If (RC <> 0) | (file.0 = 0) Then Do
       Say 'LANtastic for OS/2 PROTOCOL.INI not found on this machine.'
       Say 'LTBOOT can''t continue.'
       Say ' '
       Exit 1
   End
   
   Say 'Reading '||instdir||'\PROTOCOL.INI...'
   
   /* get the driverlist from the system PROTOCOL.INI file */
   driverlist.0 = 0
   Call scan_drivers instdir||'\PROTOCOL.INI', 'NETBIOS$', 0, 0
   
   If disk0 = 0 Then SIGNAL skip_disk_0
   
   Say ' '
   Say 'You will need your original OS/2 Installation Diskette and Diskette 1.'
   Say 'Make sure that they are write-protected, with the write enable tab'
   Say 'window open.'
   Say ' '
   Say 'You will also need three blank or reusable 3-1/2" HD diskettes to use'
   Say 'as "Target" disks for copying.  Make sure that the write enable tab '
   Say 'window is closed.'
   Say ' '
   Say ' '
   
   Say 'Press Enter to continue...'
   Pull response
   
   Call show_banner
   Say ' '
   /* DISKCOPY the OS/2 Installation diskette */
   done = 0
   Do Until done = 1
       Say 'Copy your ORIGINAL OS/2 Installation Diskette...'
       'DISKCOPY A: A:'
       If RC == 2 Then Exit                 /* they hit CTRL-C */
       Else If RC = 0 then done = 1
   End
   
   Say 'Remove the Target disk, and label it "LANtastic OS/2 Boot, Disk 0".'
   Say ' '
   Say ' '
   Say 'Press Enter to continue...'
   Pull response
   
skip_disk_0:

   If disk1 = 0 Then SIGNAL skip_disk_1
   
   /* DISKCOPY the OS/2 disk 1 */
   Call show_banner
   Say ' '
   
   done = 0
   Do Until done = 1
       Say 'Copy your ORIGINAL OS/2 Disk 1...'
       'DISKCOPY A: A:'
       If RC == 2 Then Exit                 /* they hit CTRL-C */
       Else If RC = 0 then done = 1
   End
   
   /* Some Disk 1 versions have a BUNDLE file, delete it if present */
   rc = SysFileDelete('A:BUNDLE')
   
   /* Some Disk 1 versions have SYSINSTx.EXE files, delete them if present */
   rc = SysFileDelete('A:SYSINST1.EXE')
   rc = SysFileDelete('A:SYSINST2.EXE')
   
   /* Some CD-ROM kit Disk 1 versions have CDINST.EXE, delete it if present */
   rc = SysFileDelete('A:CDINST.EXE')
   
   /* 
    *  Make the required changes to the boot disk CONFIG.SYS, copying
    *  from the host computer's CONFIG.SYS, with information from the
    *  host's PROTOCOL.INI.  'driverlist.' goes as a global.
    */
    
   Call update_boot bootdrive, instdir 
   
   /* Get rid of Disk 2, have them load up disk 3 */
   Say 'Remove the Target disk, and label it "LANtastic OS/2 Boot, disk 2".'
   Say ' '
   Say 'Press Enter to continue...'
   Pull response
   
skip_disk_1:

   If disk2 = 0 Then SIGNAL skip_disk_2
   
   Call show_banner
   Say ' '
   
   /* Format Utility disk 3 */
   done = 0
   Do Until done = 1
   Say 'Insert the remaining Target disk in drive A:'
   Say 'Press Enter to continue, "Q" then Enter to quit...'
   response = Translate(response)
   Pull response
   If Substr(response,1,1) = 'Q' Then Call Endit

   'FORMAT A: /ONCE /V:LT4OS2'
   If RC == 2 Then Exit         /* they quit with CTRL-C */
   If RC == 0 Then done = 1     /* successful format */
End

  /* Copy the REDIR stuff and some OS/2 utilities to disk 3 */
   Say ' '
   Say 'Copying files...'
   'COPY '||instdir||'\NET.EXE A: 2>nul >nul'
   'COPY '||instdir||'\NET.MSG A: 2>nul >nul'
   'COPY '||instdir||'\OS2LPI.DLL A: 2>nul >nul'
   'COPY '||instdir||'\ACSNETB.DLL A: 2>nul >nul'
   'COPY '||instdir||'\NRSETUP.EXE A: 2>nul >nul'
   'COPY '||instdir||'\LANCHECK.EXE A: 2>nul >nul'
   
   /* Copy some utility stuff to disk 3 */
   'COPY '||sysdir||'\DLL\UHPFS.DLL A: 2>nul >nul'
   'COPY '||sysdir||'\CHKDSK.COM A: 2>nul >nul'
   'COPY '||sysdir||'\XCOPY.EXE A: 2>nul >nul'
   'COPY '||sysdir||'\FDISK.COM A: 2>nul >nul'
   'COPY '||sysdir||'\FORMAT.COM A: 2>nul >nul'
   'COPY '||sysdir||'\RESTORE.EXE A: 2>nul >nul'
   
   /* Copy the Tiny editor to disk 3, if it is there */
   'COPY '||sysdir||'\TEDIT.COM A: 2>nul >nul'
   'COPY '||sysdir||'\TEDIT.HLP A: 2>nul >nul'
   
   /* Create a startup.cmd file on disk 3 */
   Call show_banner
   Say ' '
   Call startup_cmd bootdrive, sysdir, instdir, 'A:'
   
   Say 'Remove the Target disk, and label it "LANtastic OS/2 Boot, disk 3".'
   Say ' '
   Say 'Press any key to continue...'
   Pull response
   
   skip_disk_1:
   
   Call show_banner
   Say ' '
   Say ' Your LANtastic OS/2 Boot disks are complete.'
   Say ' '
   Say ' To boot your system from these disks, reboot with Disk 0 in the A: drive.'
   Say ' When the system prompts you for Disk 1, place it in the A: drive.  When'
   Say ' you see the A:> prompt, place Disk 2 in the A: drive, and type:'
   Say ' '
   Say '    STARTUP '
   Say ' '
   Say ' and press the Enter key.  STARTUP.CMD will start the network driver, '
   Say ' log into your servers and restore your connections.'
   Say ' '
   Say ' You can use the NET LOGIN and NET USE commands to make additional '
   Say ' connections. '
   Say ' '
   
   /* Done. */
   Exit
   
/* 
 * Procedure:   update_boot
 *
 * Here we scan the Boot Floppy CONFIG.SYS, and change: 
 *
 *  - the PROTSHELL statement from SYSINST1.EXE to CMD.COM 
 *  - the OS2_SHELL statement from SYSINST2.EXE to CMD.COM 
 * 
 * and add a COMSPEC statement after the OS2_SHELL line. 
 *
 * Then, we scan the System CONFIG.SYS extracting the LANtastic
 * driver lines, transforming them for the A: drive root directory,
 * and appending them to the Boot Floppy config.sys.  Also, the
 * required drivers are copied to the boot disk 1.
 *
 *  Args:  (1)  Host system boot drive.
 *         (2)  LANtastic installation directory.
 *
 *  Globals:    driverlist. - list of drivers from PROTOCOL.INI
 *              driverlist.0 contains the number of unique entries
 *              only the filename portion is present, filetype is 
 *              not included.
 */

update_boot:    Procedure Expose driverlist.

   Say ' '
   Say 'Writing changes to Disk 1...'

   /* files to be moved unconditionally to the boot disk   */
   filelist.0  = 10                  /* entries in the list  */
   filelist.1  = 'PROTMAN.OS2'
   filelist.2  = 'IFS2NB.OS2'
   filelist.3  = 'LANMSGDD.OS2'
   filelist.4  = 'NETBIND.EXE'
   filelist.5  = 'LANTASTI.IFS'
   filelist.6  = 'LT0.MSG'
   filelist.7  = 'LT1.MSG'
   filelist.8  = 'NET.MSG'
   filelist.9  = 'PRO.MSG'
   filelist.10 = 'PROTOCOL.INI'
                                 
   bootdrive = Arg(1)            /* host boot drive */
   instdir   = Arg(2)            /* host LANtastic installation directory */
   oldconfig = 'A:\CONFIG.SYS'   /* the original boot disk CONFIG.SYS     */
   tmpconfig = 'A:\CONFIG.TM~'   /* our temp write file */
   bakconfig = 'A:\CONFIG.BAK'

   'DEL '||tmpconfig||' 2>nul >nul'  /* erase any old temp file */
   'DEL '||bakconfig||' 2>nul >nul'  /* erase any old bak file  */

   Linein(oldconfig, 1, 0)       /* open the boot drive CONFIG.SYS */

   first_shell = 1
   Do while lines(oldconfig)

      /* get the next line */
      inline=Linein(oldconfig)

      /* break up the line */
      Parse Upper Value inline With os2var '=' os2value
      Select
               
         /* Change the PROTSHELL statement to call CMD.EXE */
         When os2var='PROTSHELL' Then Do
             ret=Lineout(tmpconfig, 'PROTSHELL=A:\CMD.EXE')
             If ret=1 Then Do
                 writeerror()
                 return 1
             End
         End  /* PROTSHELL */

         /* Change the first SET OS2_SHELL statement to point to CMD.EXE */
         When os2var='SET OS2_SHELL' Then Do
            If first_shell = 1 Then Do
               first_shell = 0
               ret=Lineout(tmpconfig, 'SET OS2_SHELL=A:\CMD.EXE')
               If ret=1 Then Do
                  writeerror()
                  return 1
               End
               /* add a COMSPEC statement after the OS2_SHELL */
               ret=Lineout(tmpconfig, 'SET COMSPEC=A:\CMD.EXE')
               If ret=1 Then Do
                  writeerror()
                  return 1
               End
             End
             Else Do         
               /*  Second OS2_SHELL statement, must be CD-ROM disk. */
               Call process_cdrom oldconfig
               Leave
             End
         End  /* SET OS2_SHELL */
   
         Otherwise   /* everything else goes unchanged to the new file */

            ret = Lineout(tmpconfig, inline)
            If ret = 1 Then Do
               writeerror()
               return 1
            End

      End     /* select */
   End         /* oldconfig file processing */

   /*
    *  Finished with the original CONFIG.SYS, now scan through 
    *  the system CONFIG.SYS, looking for LANtastic files (in
    *  the driverlist. stem variable).
    */

   ret = Lineout( tmpconfig, ' ')
   ret = Lineout( tmpconfig, 'rem *** LANtastic network drivers *** ' )
   ret = Lineout( tmpconfig, ' ')

   sysconfig = bootdrive||'\CONFIG.SYS'        /* host CONFIG.SYS */
   Linein(sysconfig, 1, 0)

   Do While Lines(sysconfig)
      
      /* get a line */
      inline = Linein(sysconfig)

      /* break up the line */
      Parse Upper Value inline With os2var '=' os2value
      os2_name = Word( os2value, 1 )   /* just driver name, to speed search */
      found_offset = 0
      Select

          When os2var='DEVICE' Then Do
              Do i=1 to driverlist.0
                  /* see if this driverlist entry is part of drivername */
                  found_offset = search_string(driverlist.i, os2_name)
                  If found_offset > 0 Then Leave
              End     /* Do i */

              /* if not in the driverlist, see if it's in the filelist */
              If found_offset = 0 Then Do
                  Do i=1 to filelist.0
                      /* see if this filelist entry is part of drivername */
                      found_offset = search_string(filelist.i, os2_name)
                      If found_offset > 0 Then Leave
                  End /* Do i */
              End     /* found_offset = 0 */
          End         /* DEVICE=  */

          When os2var='IFS' Then Do
              Do i=1 to filelist.0
                  /* see if this driverlist entry is part of drivername */
                  found_offset = search_string(filelist.i, os2_name)
                  If found_offset > 0 Then Leave
              End
          End     /* IFS= */

          When os2var='RUN' Then Do
              Do i=1 to filelist.0
                  /* see if this driverlist entry is part of drivername */
                  found_offset = search_string(filelist.i, os2_name)
                  If found_offset > 0 Then Leave
              End
          End     /* RUN= */

      Otherwise

              /* nothing */

      End     /* Select                 */

      If found_offset > 0 Then Do

          /* line is part of the LANtastic set, translate and write */
          dline = Substr( os2value, found_offset )

          /* if there is a command line arg with a path, translate */
          found_offset = search_string( instdir, dline )
          If found_offset > 0 Then,
              dline = Substr(dline, 1, found_offset - 1)||'A:\'

          ret = Lineout( tmpconfig, os2var||'=A:\'||dline )
          If ret = 1 Then Do
              writeerror()
              return 1
          End

          /* ..and move the associated file to the boot disk */
          dline = Word(os2value,1)
          'COPY '||dline||' A: 2>nul >nul'
          If RC <> 0 Then Do
            Say 'LTBOOT: Disk full, can''t continue.'
            Exit
          End
          
      End     /* found_offset > 0 */

   End         /* While Lines(sysconfig) */

   /* move the unconditional files to the boot drive */
   Do i = 1 to filelist.0
       'COPY '||instdir||'\'||filelist.i||' A: 2>nul >nul'
       If RC <> 0 Then Do
         Say 'LTBOOT: Disk full, can''t continue.'
         Exit
       End
   End

   ret = Lineout( tmpconfig, ' ')
   ret = Lineout( tmpconfig, 'rem *** End of LANtastic drivers  *** ' )
   ret = Lineout( tmpconfig, ' ')

   /* close the files */
   ret = Stream( oldconfig, 'c', 'Close' )
   ret = Stream( tmpconfig, 'c', 'Close' )

   /* Copy original file to .BAK, temp file to .SYS */ 
   'COPY '||oldconfig||' '||bakconfig||' 2>nul >nul'
   If RC <> 0 Then Do
      Say 'LTBOOT: Disk full, can''t continue.'
      Exit
   End

   'COPY '||tmpconfig||' '||oldconfig||' 2>nul >nul'
   If RC <> 0 Then Do
      Say 'LTBOOT: Disk full, can''t continue.'
      Exit
   End

   'DEL '||tmpconfig||' 2>nul >nul'
   Return

/*
 * Procedure:   process_cdrom
 *
 * Process the CD-ROM section of the boot disk CONFIG.SYS, removing
 * CDROM-related drivers to make room for LANtastic.
 *
 * Args:    (1) - drive/path/name of boot disk CONFIG.SYS, current
 *                file position at the start of the CD-ROM section.
 */

process_cdrom:  procedure

   infile  = Arg(1)    /* input CONFIG.SYS */

   /* 
    *  There is a second SET OS2_SHELL statement, so this is a CD-ROM
    *  installation disk set, and we should warn them we are going to
    *  make a non-CDROM aware boot set.
    */
   Call show_banner

   Say 'This is a CD-ROM version of the installation disks.  The boot'
   Say 'disks you are making will not contain CD-ROM support, due to '
   Say 'insufficient disk space for both LANtastic and CD-ROM drivers.'
   Say ' '
   Say 'You may wish to manually add CD-ROM driver support to the disk'
   Say 'set after verifying that they work properly.  For information, '
   Say 'read the README file that came with LTBOOT.CMD.'
   Say ' '
   Say 'Press the Enter key to continue...'
   Pull response

   Say ' '
   Say 'Writing changes to Disk 1...'

   /*  
    *  CD-ROM disk set.  Process the remaining config.sys lines, finding the 
    *  file each refers to, deleting it from the new Disk 1, and then discarding
    *  the config.sys line.  It does NOT go into the new CONFIG.SYS file.
    */
   Do While Lines(infile)

      /* get a line */
      inline = Linein(infile)

      /* break up the line */
      Parse Upper Value inline With os2var '=' os2value

      /* 
       *  If it's a DEVICE=, BASEDEV= or IFS=, get the filename, and 
       *  delete the file on the boot disk.
       */

      If (os2var='DEVICE') | (os2var='BASEDEV') | (os2var='IFS') Then Do

         os2value = WORD(os2value,1)
         '@DEL A:\'||os2value||' 2>nul >nul'

      End

   End   /* Do While Lines(infile)  */

   return


/*
 * Procedure:   scan_drivers
 *
 * Recursively build our list of drivers, following
 * each driver chain to it's end, and taking the
 * section name of the terminal section as the
 * driver name.
 *
 * Args:    (1) - drive/path/name of system PROTOCOL.INI file.
 *          (2) - parent driver name.  Caller should use 'NETBIOS'
 *          (3) - key type.  Caller should use 0 ('AdapterN = driver')
 *          (4) - depth.  Caller should use 0
 *
 * Global:  'driverlist' - stem variable that gets driver list.
 *                         Caller should initialize  driverlist.0 to zero.
 */

scan_drivers: Procedure Expose driverlist.

  pini    = Arg(1)              /* drive:\path\PROTOCOL.INI */
  parent  = Arg(2)              /* parent driver name */
  keytype = Arg(3)              /* key type, 0=Adapter#, 1=Bindings */
  depth   = Arg(4)+1            /* recursion depth, max = 8 */

  If depth >= 8 Then Return;

  /* reset the file */
  Linein(pini, 1, 0)

  /* search for the parent driver section */
  scan_state = 0                /* initial state, look for NETBIOS$ */
  save_line  = 0                /* current working line number      */
  Do While lines(pini)

    inline=Linein(pini)         /* get a line */
    save_line = save_line + 1   /* keep track of the line number */

    driver.0 = 4                /* parse out up to four drivers per line */
    Parse Upper Value inline With keyn '=' driver.1 ',' driver.2 ',',
      driver.3 ',' driver.4

    keyn = Strip( keyn )                /* remove blanks */

    Select
      /* state 0, searching for the correct section.  */
      When scan_state = 0 Then Do

        /* keep track of which section we're in */
        If Substr( keyn, 1, 1 ) = '[' Then Do

          section = Substr( keyn, 2, Length(keyn)-2 )

          If keytype = 1 Then Do      /* looking for Bindings link? */

            /* Bindings link, see if this is the correct section */   
            If section = parent Then Do

              /*
               * This is our section, fix the drivername by removing
               * the '_NIFxx' from the end (if present).
               */
              Do i=2 to (Length(section)-3)
                If Substr(section, i, 4) = '_NIF' Then,
                  section = Left(section, i-1)
              End

              /* add this driver to the list, if it isn't there yet */
              Do i = 1 to driverlist.0
                If driverlist.i = section Then Leave
              End
       
              /* not in the list, add it */
              If i > driverlist.0 Then Do
                driverlist.i = section
                driverlist.0 = driverlist.0 + 1
              End

              /* move to the new state */
              scan_state = 1

            End  /* if section = parent */

          End  /* if keytype = 1 */

        End    /* if Substr(keyn,1,1)='[' */
        Else Do
          /* 
           * If we're here, must be keytype=0 (Adapter#), see if
           * we have the associated DriverName line in this section.
           */
          driver.1 = Strip( driver.1 )
          If (keyn='DRIVERNAME') & (driver.1=parent) Then Do

            /*
             * This is our section, fix the drivername by removing
             * the '_NIFxx' from the end (if present).
             */
            Do i=2 to (Length(section)-3)
              If Substr(section, i, 4) = '_NIF' Then,
                section = Left(section, i-1)
            End

            /* add this driver to the list, if it isn't there yet */
            Do i = 1 to driverlist.0
              If driverlist.i = section Then Leave
            End
    
            /* not in the list, add it */
            If i > driverlist.0 Then Do
              driverlist.i = section
              driverlist.0 = driverlist.0 + 1
            End

            /* move to the new state */
            scan_state = 1

          End   /* DriverName statement */
        End     /* Else Do clause */
      End       /* State 0, looking for NETBIOS$ driver section */

      /* state 1, correct section, searching for links. */
      When scan_state = 1 Then Do

        If (Substr(keyn,1,1)='['),
          Then scan_state = 2           /* end of section, new state */

        Else If (keyn = 'BINDINGS') | (Substr(keyn,1,7) = 'ADAPTER') Then Do
          /* 
           * if any of the driver names are single digits, they are not
           * valid driver names, ignore them.
           */
          Do i = 1 to driver.0
            driver.i = Strip( driver.i )
            If (Length( driver.i ) <= 1) & (driver.i >= '0') & (driver.i <= '9'),
              Then driver.i = ''
          End 

          If keyn = 'BINDINGS' Then,
            keytype = 1         /* Bindings key, look for [section] */
          Else,
            keytype = 0         /* Adapter key, look for DriverName */

          /* we have a link, get the driver name(s), and process it */
          Do i = 1 to driver.0
            If Length( driver.i ) > 0 Then Do

              Call scan_drivers pini, driver.i, keytype, depth

              /* return to the line number we were at before scan_drivers() */
              Linein(pini, 1, 0)
              Do i = 1 to save_line
                inline=Linein(pini)
              End

              /* return to file line N */
            End
          End
        End
      End       /* State 1, scanning Adapter # statements */

      /* state 2, done */
      Otherwise
        Leave   /* we're done. */

    End         /* switch on scan state */

    /* 
     * if we get here in state 0, no 'key' (Adapter# or Bindings) 
     * line was found for this 'parent' driver.  We reached the
     * end of this stack.
     */

  End   /* Do While lines(pini) */  

  /* close the file */
  ret = Stream( pini, 'c', 'Close' )
  Return


/*
 *  Function:   search_string
 *
 *  Find str1 in str2, return the offset.
 *
 *  Args:   (1) - string to search for.
 *          (2) - string to search in.
 *
 *  Returns:    offset of str1 in str2, 1..(Length(str2)-Length(str1)+1)
 */
search_string:  Procedure

    str1 = Arg(1)
    len1 = Length(str1)
    str2 = Arg(2)
    len2 = Length(str2)

    Do i = 1 to (len2 - len1 + 1)
        If Substr(str2, i, len1) = str1 Then,
            return i
    End

    return 0        /* not found */


/*
 *  Procedure:   startup_cmd
 *
 *  Create a STARTUP.CMD file on the requested path, using the host
 *  system profile and saved connections.
 *
 *  Args: (1) - bootdrive, like 'C:'
 *        (2) - system directory, like 'C:\OS2'
 *        (3) - program directory, like 'C:\LANTASTI\OS2'
 *        (4) - destination directory, like 'A:' (NO trailing backslashes)
 */

startup_cmd:    Procedure

   /* 
    * Get the boot drive, the OS/2 directory path, and the LANtastic
    * installation directory 
    */
   bootdrive   = Arg(1);
   sysdir      = Arg(2);
   program_dir = Arg(3);
   dest_dir    = Arg(4);

   control_dir = SysIni(sysdir||'\LANTASTI.INI', 'LANtastic', 'ControlDir')
   
   /* INI strings can come back with a trailing NULL, truncate it */
   control_dir = Strip(control_dir, 'Trailing', D2C(0))
   
   /* get the computer name */
   computer_name = SysIni(sysdir||'\LANTASTI.INI', 'LANtastic', 'ComputerName')
   computer_name = Strip(computer_name, 'Trailing', D2C(0))
   
   /* get the connection count 0..255 */
   connections    = SysIni(sysdir||'\LANTASTI.INI', 'PMNET', 'CONNECTCNT')
   connect_cnt    = C2D(Substr(connections,1,1))
   
   /* get the default username, if any */
   default_user   = SysIni(sysdir||'\LANTASTI.INI', 'PMNET', 'USERNAME' )
   If default_user = 'ERROR:' Then,
       default_user = ''
   Else,
       default_user = Strip(default_user, 'Trailing', D2C(0))

   /* get the connection data (can be very big */
   connections    = SysIni(sysdir||'\LANTASTI.INI', 'PMNET', 'CONNECTIONS')
   
   /*
    * Each connection is a block of data that looks like:
    *
    *    computer_name   - 64 bytes, null-terminated string like 
    *                         'LANtastic:\\SERVER'
    *    resource_name   - 64 bytes, null-terminated string like 'C-DRIVE'
    *    connection_name - 64 bytes, null-terminated string like 'C:' or 'LPT1'
    *    connection_type -  2 bytes, only first is significant:
    *                         16 = Disk connection
    *                         32 = Printer connection
    *    adapter_number  -  2 bytes, only first is significant:
    *                          0..254 = logical adapter number.
    *                          255 = try all adapters.
    *
    * Note that a connection often consists of ONLY a computer name, 
    * indicating that we were logged into the server (it is possible that
    * no connections to resources on that server were made).  If resources
    * were in use, there will be additional server-connection entries.
    */
   
   connection_size = 64 + 64 + 64 + 2 + 2    /* size of each connection entry */
   
   /* first pass, count servers */
   server.0 = 0            /* init a stem variable to hold server names */
   connection.0 = 0        /* ..and NET USE commands */
   
   Do i = 0 to (connect_cnt - 1)
   
      offset = 1 + (i * connection_size);  /* start offset for this entry */
   
      /* first is server name, as NETWORKNAME:\\SERVERNAME */
      this_server = Substr(connections, offset, 64)
   
      /* Remove network name, backslashes and nulls from server name */
      Parse Value this_server With network_name ':' this_server 
      this_server = Substr(this_server, 3)
      this_server = Strip(this_server, 'Trailing', D2C(0))
   
      /* see if we already have it */
      found_server = 0
      Do j = 1 to server.0
         If this_server = server.j Then Do
            found_server = 1
            Leave
         End
      End
   
      /* if we don't have it, add it */
      If found_server = 0 Then Do
         server.0 = server.0 + 1
         j = server.0
         server.j = this_server
      End
   
      /* Next is the resource name.  Remove trailing nulls */   
      this_resource = Substr(connections, offset+64, 64)
      this_resource = Strip(this_resource, 'Trailing', D2C(0))
   
      /* if there is a connection in this entry, save it */
      If Length(this_resource) > 0 Then Do
   
         /* Next is the connection name, remove trailing nulls */
         this_connection = Substr(connections, offset+128, 64)
         this_connection = Strip(this_connection, 'Trailing', D2C(0))
   
         this_adapter = C2D(Substr(connections, offset+194, 1))
   
         /* add this connection to our list */
         connection.0 = connection.0 + 1
         j = connection.0
   
         If this_resource = computer_name Then,
            connection.j =,
               'NET USE/DEFERRED '||this_connection||' \\'||this_server||'\'||,
               this_resource
         Else,
            connection.j =,
               'NET USE '||this_connection||' \\'||this_server||'\'||,
               this_resource
   
      End   /* If Length(this_resource) > 0 */
   End
   
   /* Tell them who we think we are */
   Say 'Computer name is: ' || computer_name
   default_user = Strip(default_user, 'Trailing', D2C(0))
   If Length(default_user) > 0 Then,
      Say 'Default Username is: '||default_user
   
   /* Pad the servernames for display */
   Do i=1 to server.0
      server.i = SubStr(server.i, 1, 16, ' ')
   End
   
   /* Tell the what servers we will connect to */
   Say ' '
   Say 'The following server(s) will be connected to:'
   Say ' '
   Do i = 0 to ((server.0 - 1) / 4)
      j1 = (i * 4) + 1; 
      j2 = j1+1;
      If j2 > server.0 Then server.j2 = ' '
      j3 = j1+2;
      If j3 > server.0 Then server.j3 = ' '
      j4 = j1+3
      If j4 > server.0 Then server.j4 = ' '
      Say '    ' || server.j1 || server.j2 ||server.j3 || server.j4
   End
   
   Say ' '
   
   /*
    *   If more than one server is in use, ask if they want to use
    *   the same username and password for all servers.  If so, we can
    *   put a 'NET USER' statement in the batch file to collect the
    *   username and password once for all servers.
    *
    */
   use_common = 1
   If server.0 > 1 Then Do
      If server.0 > 2 Then
         Say 'Can the same username and password be used for all servers (Y/N)?'
      Else
         Say 'Can the same username and password be used for both servers (Y/N)?'
   
      response = 'X'
      Do Forever                      /* or at least until we get a good answer */
   
         Pull response
         response = Translate(Substr(response, 1, 1))
         If response = 'Y' Then Leave
         If response = 'N' Then Leave
         Say ' '
         Say 'Press Y to enter a single username and password at login time, '
         Say 'N to enter names and passwords for each server at login time. '
         Say 'Then press the Enter key to continue.'
      End
   
      if response = 'N' Then use_common = 0
   End
   
   /* if we can use a default username/password, get them */
   use_default = 0
   If use_common = 1 Then Do
   
      /*   Ask if they want to use the default username, or enter one at boot? */
      If Length(default_user) > 0 Then Do
         Say 'Press Y to use '||default_user||' as your login username, or'
         Say 'press N to prompt for a username at boot-up (Y/N):'
      End
      Else Do
         Say 'Press Y to use '||computer_name||' as your login username, or'
         Say 'press N to prompt for a username at boot-up (Y/N):'
      End
   
      response = 'X'
      Do Forever                      /* or at least until we get a good answer */
   
         Pull response
         response = Translate(Substr(response, 1, 1))
         If response = 'Y' Then Leave
         If response = 'N' Then Leave
         Say ' '
         Say 'Press Y to use the default, N to specify the username at login time.'
         Say 'Then press the Enter key to continue.'
      End
   
      If response = 'Y' Then use_default = 1
   
   End   /* If use_common = 1 */
   Say ' '
   
   /* finally, we can write the new STARTUP.CMD */
   '@DEL '||dest_dir||'\STARTUP.BAK 2>nul >nul'
   '@RENAME '||dest_dir||'\STARTUP.CMD STARTUP.BAK 2>nul >nul'
   
   fout = dest_dir||'\STARTUP.CMD'
   rc = Lineout(fout, '@echo off')
   rc = Lineout(fout, 'rem *********************************************')
   rc = Lineout(fout, 'rem * STARTUP.CMD - Start the network           *')
   rc = Lineout(fout, 'rem *********************************************')
   rc = Lineout(fout, ' ')
   rc = Lineout(fout, 'rem Start the network.')
   
   nbr_logins = server.0 + 5       /* allow for a few extra manual logins */
   rc = Lineout(fout, 'NET START '||computer_name||' /logins='||nbr_logins||' /tasks=2')
   rc = Lineout(fout, ' ')
   
   If use_common = 1 Then Do
   
      rc = Lineout(fout, 'rem Get the default username/password ')
   
      If use_default = 1 Then Do
   
         /* we can use the default name as username */
            If Length(default_user) > 0 Then,
               rc = Lineout(fout, 'NET USER '||default_user||,
                  ' ^^"Enter default password for user '||default_user||': "')
            Else
               rc = Lineout(fout, 'NET USER '||computer_name||,
                  ' ^^"Enter default password for user '||computer_name||': "')
   
      End      /* if use_default = 1 */
   
      If use_default = 0 Then,
         /* we need to prompt for both username and password */
         rc = Lineout(fout, 'NET USER ?"Enter username: " ^^"Enter default password: "')
   
      /* spit out the NET LOGIN statements */
      rc = Lineout(fout, ' ')
      rc = Lineout(fout, 'echo Logging in servers... ')
      Do i = 1 to server.0
         /* 
          *  note:  I can't figure out how to use adapter number when no
          *         username or password is present.
          */
         rc = Lineout(fout, 'NET LOGIN \\'||server.i)
      End
   End
   Else Do
   /* If use_common = 0 Then DO */
      /* we have to prompt for username and password on each login */
      rc = Lineout(fout, ' ')
      rc = Lineout(fout, 'rem Login all servers. ')
      Do i = 1 to server.0
         rc = Lineout(fout, 'ECHO '||server.i)
         rc = Lineout(fout, 'NET LOGIN \\'||server.i||,
            '?"Enter username: " ^^"Enter default password: "')
      End
      
   End   /* if use_common = 0 */
   
   /* spit out the connections */
   rc = Lineout(fout, ' ')
   rc = Lineout(fout, 'echo Restoring connections... ')
   
   Do i = 1 to connection.0
      rc = Lineout(fout, connection.i)
   End
   
   rc = Lineout(fout, ' ' )
   rc = Lineout(fout, 'NET SHOW/CONNECTS' )

   /* we're done, close the file */
   rc = Lineout(fout, ' ')
   rc = Lineout(fout, 'rem End of STARTUP.CMD ')
   rc = Lineout(fout)
   
   return

show_banner:    procedure

   'CLS'
   Say ' '
   Say ' '
   Say 'LANtastic for OS/2 Boot Disk Utility, V1.00'
   Say 'Copyright (c) 1995, Artisoft.'
   Say ' '
   
   return;

usage:

   Call show_banner
   Say ' '
   Say 'usage:  LTBOOT [-0][-1][-2]'
   Say ' '
   Say 'where:  -0   means make a copy of OS/2 Installation diskette,'
   Say '        -1   means make a modified copy of OS/2 Disk 1, and'
   Say '        -2   means make a LANtastic and OS/2 utilities disk.'
   Say ' '
   Say 'The default is "-0 -1 -2".'
   Say
   return


