@echo off

REM FP.BAT, Copyright (c) 1994 Data Fellows Oy
REM This batch file simplifies automating the use of F-PROT.

REM If F-PROT is installed in a different directory than C:\F-PROT,
REM please modify this batch accordingly. Also the directory
REM to output the report into can be configured.

REM FP.BAT will scan all the hard disks in the machine. If only one
REM directory is ment to be checked, replace the switch /HARD
REM with the directory name. For example, C:\DOS.

REM Switch /REPORT will produce an ASCII file which will contain
REM a report of the results of the scanning. By including the
REM switch /APPEND, you can store all the reports in the same file.
REM This way every new report is appended to the end of the old ones.

REM Scan can be made uninterrupuble by including /NOBREAK to the
REM command line. Remember to change the note also, as ESC will
REM not abort the scan.

REM For a full list of command-line parameters supported by F-PROT,
REM type F-PROT /?

echo.
echo F-PROT is checking the system for viruses, please wait. Press ESC to abort.
echo.

C:\F-PROT\F-PROT.EXE /HARD /SILENT /BEEP /REPORT=C:\F-PROT.REP

REM Scan is over, now the errorlevels are checked

REM Suspicious files
if errorlevel 8 goto SUSPICIOUS

REM Out of memory
if errorlevel 7 goto OUT-OF-MEM

REM F-PROT was aborted early
if errorlevel 5 goto ABORT

REM A virus was found in the memory
if errorlevel 4 goto MEMORY

REM A virus was found in a file or in the boot sectors
if errorlevel 3 goto VIRUS

REM F-PROT.EXE is corrupted
if errorlevel 2 goto CORRUPTED

REM Abort with an error
if errorlevel 1 goto ERROR

REM Everythings OK
if errorlevel 0 goto OK

goto END

REM Additional functions can be added under the following labels.
REM For example, a sound can be included under label VIRUS or
REM a halt of the machine under the label MEMORY.

:SUSPICIOUS
REM F-PROT might warn you about suspicious files which usually are
REM not viruses. So you don't have to freeze the machine.
echo F-PROT has found something suspicious. Usually this does not 
echo mean that there is a virus present. You should report this to 
echo your support person.
echo.
echo More information will be found from the created report, C:\F-PROT.REP
echo.
pause
goto END

:OUT-OF-MEM
echo Virus check aborted - not enough memory.
goto END

:ABORT
echo F-PROT was aborted, scanning was not completed.
goto END

:MEMORY
REM  A large message screen can be added here or the
REM  command CTTY NUL, which will freeze the machine
echo F-PROT found an active virus from the computers memory!
echo Power down immediatly and contact PC support!
goto END

:VIRUS
REM  A large message screen can be added here or the
REM  command CTTY NUL, which will freeze the machine
echo F-PROT found a virus from a file or from the boot sector of
echo this machine!
echo Contact PC support immediatly.
echo More information will be found from the created report, C:\F-PROT.REP
goto END

:CORRUPTED
echo F-PROT.EXE has been corrupted! This may be caused by
echo a disk error or a virus.
echo Contact PC support immediatly.
goto END

:ERROR
echo System error, F-PROT cannot check the system for viruses.
echo Please check that all F-PROT's files are present.
goto END

:OK
echo The machine is checked, no viruses found.
goto END

:END
echo.
