// BCSAMPLE.CPP - Tutorial Program for BOUNDS-CHECKER
// See BCSAMPLE for information to re-build this program


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>


#define NullPointer1 (char far*) 0x14
#define NullPointer2 (char far*) 0x18
#define NullPointer3 (char far*) 0x0C

void MemoryAccess(char far*);
void CodeWrite();
void BadLibraryPtr(char far* p);
void UseFreedPtr();
char LegalAccess();
void GPfault();
void StrcpyTooFar();
void MemcpyOverStruct();
void MemsetPastStatic();
void MemsetPastMalloc();
void DirectWritePastMalloc();
void FreeBadPtr();
void StrcpyPastNew();
void DeleteBadPtr();

void DisplayInitScreen();
void DisplayMainScreen();
int CauseBug(int choice);
int DummyRoutine();

void screen1(), screen2(), screen3(), screen4(), screen5();
void screen6(), screen7(), screen8(), screen9(), screen10();
void screen11(), screen12(), screen13(), screen14(), screen15(), screen16();

char* x[5];
typedef void (*PF)();
PF screens[] = {(PF) 0, screen1, screen2, screen3, screen4, screen5,
			screen6, screen7, screen8, screen9, screen10,
			screen11, screen12, screen13, screen14, screen15,
			screen16};

char static_string[] = "0123456789";
char over_write_buf[10];

void main(int argc, char* argv[])
{
  if (argc > 1) {
     for (int i=1; i < argc; i++)
       CauseBug(atoi(argv[i]));
     return;
  }

  char buf[20];
  int choice;
  DisplayInitScreen();
  do {
    DisplayMainScreen();
    choice = atoi(gets(buf));
    if (choice>0 && choice<=16)
	    screens[choice]();
  } while (CauseBug(choice));
}

int CauseBug(int choice)
{
  switch (choice) {
  case 1: MemoryAccess(NullPointer1);
   break;
  case 2: CodeWrite(); //MemoryAccess((char far*) DummyRoutine);
   break;
  case 3: BadLibraryPtr(NullPointer2);
   break;
  case 4: LegalAccess();
   break;
  case 5: GPfault();
   break;
  case 6: StrcpyTooFar();
   break;
  case 7: MemcpyOverStruct();
   break;
  case 8: MemsetPastStatic();
   break;
  case 9: MemsetPastMalloc();
   break;
  case 10: DirectWritePastMalloc();
   break;
  case 11: UseFreedPtr();
   break;
  case 12: FreeBadPtr();
    break;
  case 13: StrcpyPastNew();
    break;
  case 14: DeleteBadPtr();
    break;
  case 15: new(char[10]);
    choice = 0;
    break;
  case 16: malloc(10);
    choice = 0;
    break;
  default: printf("\nNot A Valid Choice\n");
  	 choice = 0;
    break;
  }
  return choice;
}

void MemoryAccess(char far* p)
{
  *p = 'A';
}

void CodeWrite()
{
  char far* p;
  p = (char*) DummyRoutine;
  *p = 'B';
}

void BadLibraryPtr(char far* p)
{
  atol(p);
}

char LegalAccess()
{
  char *px, x;
  px = (char *) 0x410;	  // access the BIOS equipment flag at 40:10H
  x = *px;
  return x;
}

void GPfault()
{
  char *p;
  unsigned int i,x=1;
  p = (char*) malloc(0xfff1);
  p += 0xfff1;
  for (i=0; i <= 0x10; i++)
    (*(int*)p++) = x;
}

void StrcpyTooFar()
{
  char in_string[11] = "1234567890";
  char out_string[10];
  strcpy(out_string,in_string);
}

struct test_struct {
  char  element1;
  int   element2;
  long  element3;
};

void MemcpyOverStruct()
{
  char a[] = "1234567890AB";
  test_struct s, *p;
  p = &s;
  memcpy((void*)p, (void*)a, 9);
}

void MemsetPastStatic()
{
  memset(static_string,'A',13);
}

void MemsetPastMalloc()
{
  void *p;
  p = malloc(10);
  memset(p,'A',11);
  free(p);
}

void DirectWritePastMalloc()
{
  char *p, *p1;
  int i;
  p = (char*) malloc(10);
  for (i=0, p1=p; i<=10; i++)
      *p1++ = 'A';
  p1 = (char*) malloc(20);
  free(p);
  free(p1);
}

void UseFreedPtr()
{
  char *p;
  p = (char*) malloc(50);
  free(p);
  *p = 'A';
}

void FreeBadPtr()
{
  free(NullPointer3);
}

void StrcpyPastNew()
{
  char* p;
  char a[] = "1234567890";
  p = new(char[5]);
  strcpy(p, a);
  delete p;
}

void DeleteBadPtr()
{
  delete((char*) 10);
}

int DummyRoutine()
{
  return 1;
}

void DisplayInitScreen()
{
printf("\n                 BOUNDS-CHECKER Tutorial\n\n");
printf("BCSAMPLE (this program) is full of memory related defects(bugs).\n");
printf("When run with BOUNDS-CHECKER, it will show you how BOUNDS-CHECKER \n");
printf("responds to each type of problem.\n");
printf("\n");
printf("BCSAMPLE is used by the BOUNDS-CHECKER tutorial in the user guide.\n");
printf("BCSAMPLE can be used with this tutorial or you can experiment\n");
printf("on your own.\n");
printf("\n");
printf("Prior to running BOUNDS-CHECKER with BCSAMPLE you should\n");
printf("delete BCSAMPLE.LOG and BCSAMPLE.BC.\n");
printf("\n");
printf("To run BOUNDS-CHECKER on BCSAMPLE enter:  BCHK BCSAMPLE\n");
printf("\n\n\n\n\n\n\n\n\n");
printf("                   Press any key to continue");
getch();
}

void DisplayMainScreen()
{
printf("\n                 BOUNDS-CHECKER Tutorial\n\n");
printf("Type in a problem number and press enter. Enter 15 or 16 to exit.\n\n");
printf("Illegal out-of-bounds memory accesses and code over-writes\n");
printf("        1.   Illegally access memory outside this program\n");
printf("        2.   Illegally write over the code area of this program\n");
printf("        3.   Pass an out-of-bounds pointer to a library routine\n");
printf("        4.   Make a legal out-of-bounds access\n");
printf("        5.   General Protection Violation\n");
printf("Stack, Data Segment and Heap memory bugs\n");
printf("        6.   strcpy past the end of a local character array\n");
printf("        7.   memcpy past the end of a local structure\n");
printf("        8.   memset past the end of a static character array\n");
printf("        9.   memset past the end of a malloced block\n");
printf("        10   Direct program access past the end of a malloced block\n");
printf("        11.  Use of pointer to freed memory block\n");
printf("        12.  Call to free with bad pointer\n");
printf("C++ related problems\n");
printf("        13.  String copy past end of memory block allocated with new\n");
printf("        14.  delete called with bad pointer\n");
printf("        15.  Exit with memory blocks not deleted\n");
printf("Memory Leakage\n");
printf("        16.  Exit with malloced blocks not freed\n");
printf("Enter Choice:  ");
}

void screen1()
{
printf("\n          Illegally Accessing Memory Outside Your Program\n");
printf("\n");
printf("After you press a key, a null pointer will be used to write to a low\n");
printf("memory address. This access (into the interrupt vector table) will cause\n");
printf("BOUNDS-CHECKER to pop up immediately.  Select 'Mark' on the main menu.\n");
printf("Marking places information about this exception in the .LOG file and\n");
printf("also WRITE PROTECTS the memory location, so you do not actually corrupt memory.\n");
printf("Marking also prevents BOUNDS-CHECKER from popping up on subsequent accesses\n");
printf("to this address, so if you make this choice a 2nd time it will not pop up.\n");
printf("\n\n\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen2()
{
printf("\n           Write Over The Code Area Of This Program\n");
printf("\n");
printf("After you press a key, a this program will use a pointer to a routine in an\n");
printf("attempt to corrupt its own code area.  This illegal access will cause\n");
printf("BOUNDS-CHECKER to pop up immediately.\n");
printf("\n");
printf("To continue, select 'Mark' on the main menu.  Marking places \n");
printf("information about this exception in the .LOG file and also \n");
printf("WRITE PROTECTS the memory location, so you do not actually corrupt memory.\n");
printf("Marking also prevents BOUNDS-CHECKER from popping up on subsequent accesses.\n");
printf("to this address, so if you make this choice a 2nd time it will not pop up.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen3()
{

printf("\n      Pass A Library Routine An Out-Of-Bounds Pointer\n");
printf("\n");
printf("This example is to show what happens when an exception occurs in\n");
printf("a routine that has NOT been compiled with debug information.\n");
printf("\n");
printf("After you press a key, a bad pointer will be passed to a library routine.\n");
printf("BOUNDS-CHECKER will pop up immediately, stating that an out-of-bounds\n");
printf("access has occurred for a routine that does not have source available.\n");
printf("After pressing a key the call stack will be displayed.\n");
printf("Routines that have source available are preceded with '#'.\n");
printf("\n");
printf("You can select routines to display using the arrow keys followed by\n");
printf("enter.  To get back to the call stack select 'Stack' on the main menu.\n");
printf("After you have viewed the source, select 'Log' on the main menu.\n");
printf("Logging the access will cause relevant information  to be placed\n");
printf("in the log file.  The program will continue running and the\n");
printf("library routine will use the bad pointer.  Memory, however, will not be\n");
printf("corrupted by using 'Log' instead of 'Mark' because this is a memory\n");
printf("read instead of a memory write as shown in previous examples.\n");
printf("\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen4()
{
printf("\n               Make A Legal Out-Of-BOUNDS Access\n");
printf("\n");
printf("This example accesses a commonly used BIOS variable.  Many programs\n");
printf("access BIOS variables and other system memory locations intentionally\n");
printf("These memory accesses can be added to BOUNDS-CHECKER's exception list\n");
printf("so it does not pop up every time you run the program.\n");
printf("\n");
printf("Select 'Add' at BOUNDS-CHECKER's main menu.  Then select 'Read',\n");
printf("'Procedure' and 'Location' as you are prompted.  This tells\n");
printf("BOUNDS-CHECKER that any access to memory location 40:10H by the\n");
printf("procedure 'LegalAccess' is valid and should not be considered a bug.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}
void screen5()
{
printf("\n             Cause A General Protection Violation\n");
printf("\n");
printf("After you press a key, a routine will be called that causes a FATAL\n");
printf("general protection violation.  BOUNDS-CHECKER will pop up when this\n");
printf("occurs, but you can not continue to run this sample program.  You must\n");
printf("exit by selecting 'eXit' at the main menu.\n");
printf("\n");
printf("When a protection violation or invalid op-code exception occurs in a\n");
printf("program that you are debugging you typically want to display a call\n");
printf("stack by selecting 'Stack' at the main menu).  This gives you some \n");
printf("perspective on where the program was executing prior to the fault.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}


void screen6()
{
printf("\n        strcpy Past The End Of A Local Character Array\n");
printf("\n");
printf("After you press a key, a routine will be called that uses the strcpy library\n");
printf("routine to copy a string to a local array.  The array is not large\n");
printf("enough to hold the string so BOUNDS-CHECKER will pop up.\n");
printf("Select 'Data_info' to see more information about the array overflow.\n");
printf("\n");
printf("When this type of problem occurs, you would normally exit BOUNDS-CHECKER.\n");
printf("For this example select 'Log' at the main menu to continue running.\n");
printf("\n\n\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen7()
{
printf("\n           memcpy Past The End Of A Local Structure\n");
printf("\n");
printf("After you press a key, a routine will be called that uses the memcpy\n");
printf("library routine to copy memory past the end of a structure that was\n");
printf("defined locally (on the stack). BOUNDS-CHECKER pops up giving you\n");
printf("the opportunity to view source of calling routines on the call stack.\n");
printf("Select 'Data_info' to see more information about the structure overflow.\n");
printf("\n");
printf("Normally when this type of problem occurs, you would exit BOUNDS-\n");
printf("CHECKER with the 'eXit' option.  In this case select 'Log' at\n");
printf("BOUNDS-CHECKER's main menu so your program will continue to run.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen8()
{
printf("\n         strcpy Past The End Of A Static Character Array\n");
printf("\n");
printf("After you press a key, a routine will be called that uses the strcpy library\n");
printf("routine to copy a string to a statically allocated array that is not large\n");
printf("enough to hold the string.  BOUNDS-CHECKER will pop up.  The source\n");
printf("of the routine that called strcpy is displayed in the code window.\n");
printf("Select 'Data_info' to see more information about the array overflow.\n");
printf("\n");
printf("Normally when this type of problem occurs, you would exit BOUNDS-\n");
printf("CHECKER with the 'eXit' option.  In this case select 'Log' at\n");
printf("BOUNDS-CHECKER's main menu so your program will continue to run.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen9()
{
printf("\n                memset Past The End Of A malloced Block\n");
printf("\n");
printf("After you press a key, a routine will be called that uses the memcpy\n");
printf("library routine to copy data past the end of a memory block that was\n");
printf("allocated with malloc.  BOUNDS-CHECKER pops up stating that you are\n");
printf("about to over-run the block.  This type of bug typically corrupts\n");
printf("the internal heap data structures maintained by your run-time library.\n");
printf("Select 'Data_info' to see more information about the block overflow.\n");
printf("\n");
printf("This example pops up BOUNDS-CHECKER a second time when free is called.\n");
printf("This occurs because the memory block is corrupt when it is freed.\n");
printf("\n");
printf("Normally when this type of problem occurs, you would exit BOUNDS-\n");
printf("CHECKER with the 'eXit' option.  In this case select 'Log' at\n");
printf("BOUNDS-CHECKER's main menu both times it pops up.\n");
printf("\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen10()
{
printf("\n     Direct Program Access Past The End Of A malloced Block\n");
printf("\n");
printf("After you press a key, a memory block will be allocated and filled with\n");
printf("0's directly (not by using library routines).  Then another malloc will be\n");
printf("called to allocate additional memory.  In this case, BOUNDS-CHECKER\n");
printf("does not pop up the instant the write past the end of the block occurs.\n");
printf("It pops up on the next call to a memory or string related library routine. In\n");
printf("this example BOUNDS-CHECKER pops up when the next malloc occurs.\n");
printf("Select 'Data_info' to see more information about the block overflow.\n");
printf("\n");
printf("To continue, select 'Log' at BOUNDS-CHECKERs main menu.\n");
printf("\n\n\n\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen11()
{
printf("\n              Use Of Pointer To Freed Memory Block\n");
printf("\n");
printf("This example allocates a memory block, then immediately frees it. The\n");
printf("pointer returned by malloc will be used to write a character into memory.\n");
printf("BOUNDS-CHECKER will pop up immediately stating that an out-of-bounds\n");
printf("access at address 0:1.  The reason the access is at 0:1 is that\n");
printf("BOUNDS-CHECKER set the pointer to 0:1 when the block was freed.\n");
printf("This is done so the cause of the access will be easily identifiable if the\n");
printf("freed pointer is used.\n");
printf("\n");
printf("To continue, select 'Mark' on BOUNDS-CHECKER's main menu.\n");
printf("Marking places information about this exception in the .LOG file and\n");
printf("also WRITE PROTECTS the memory location, so you do not actually\n");
printf("corrupt memory.  Then your program continues to run.\n");
printf("\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen12()
{
printf("\n                Call To Free With A Bad Pointer\n");
printf("\n");
printf("After you press a key, free will be called with a pointer to memory that is\n");
printf("not the start of a malloced block.  This type of bug usually corrupts\n");
printf("memory, because free will assume that the pointer points at a data\n");
printf("structure that it can freely manipulate.\n");
printf("\n");
printf("In this case BOUNDS-CHECKER will pop up immediately stating that free\n");
printf("was called with a bad pointer.  To see the actual address that was passed\n");
printf("select 'Data_info' . Often, the address may give you a hint on what the problem is.\n");
printf("\n");
printf("To continue, select 'Log' on the main menu.  Logging places information\n");
printf("about this exception in the .LOG file for later perusal.\n");
printf("\n\n\n\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen13()
{
printf("\n        strcpy Past The End Of A Block Allocated With new\n");
printf("\n");
printf("After pressing a key, a routine will be called that uses the strcpy library\n");
printf("routine to copy a string to a memory block that is too small.  This block\n");
printf("was allocated with new.  BOUNDS-CHECKER pops up stating that you\n");
printf("are about to over-run the block.  In this case BOUNDS-CHECKER does\n");
printf("not show the source directly, but you can use the call stack to display\n");
printf("the routine that called new.  This type of bug typically corrupts internal\n");
printf("heap data structures. Select 'Data_info' to see more information\n");
printf("about the block overflow.\n");
printf("\n");
printf("This example pops up BOUNDS-CHECKER a second time when delete is called.\n");
printf("This occurs because the memory block is corrupt when it is freed.\n");
printf("\n");
printf("Normally when this type of problem occurs, you would exit BOUNDS-\n");
printf("CHECKER with the 'eXit' option.  In this case select 'Log' at BOUNDS-\n");
printf("CHECKER's main menu so the program will continue to run.\n");
printf("\n\n\n\n");
printf("          To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen14()
{
printf("\n                Call To delete With A Bad Pointer\n");
printf("\n");
printf("After you press a key, delete will be called with a pointer to memory that\n");
printf("is not the start of an allocated block.  This type of bug usually corrupts\n");
printf("memory, because delete will assume that the pointer points at a data\n");
printf("structure that it can freely manipulate.\n");
printf("\n");
printf("In this case BOUNDS-CHECKER will pop up immediately stating that\n");
printf("free was called with a bad pointer.  This is because delete actually\n");
printf("calls free to de-allocate memory. Select 'Data_info' to see the value of\n");
printf("the bad pointer.  Often, the address may give you a hint that will help\n");
printf("solve the problem.\n");
printf("\n");
printf("To continue, select 'Log' on the main menu. Logging places information\n");
printf("about this exception in the .LOG file for later perusal.\n");
printf("\n\n\n\n\n\n");
printf("       To see this screen in BOUNDS-CHECKER, press '/'\n");
printf("\n");
printf("            Press any key to cause this program defect");
getch();
}

void screen15()
{
printf("\n      Exit With Memory Blocks Not deleted\n");
printf("\n");
printf("This example shows memory leakage with C++'s delete.\n");
printf("\n");
printf("After you press a key, a memory block will be allocated with new then\n");
printf("the program will exit.  Since the memory block has not been removed\n");
printf("with delete, BOUNDS-CHECKER will display a message on exit.\n");
printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
printf("            Press any key to allocate blocks and exit");
getch();
}

void screen16()
{
printf("\n          Exit With malloced Blocks Not freed\n");
printf("\n");
printf("This example shows memory leakage of blocks allocated with malloc.\n");
printf("\n");
printf("After you press a key, a memory block will be allocated with malloc then\n");
printf("the program will exit.  Since the memory block has not been removed\n");
printf("with free, BOUNDS-CHECKER will display a message after your program\n");
printf("exits.\n");
printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
printf("            Press any key to allocate blocks and exit");
getch();
}
