/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* @(#) somc/smstd.h 2.6 9/1/94 20:03:13 [9/21/94 17:45:24] */

/*
 */

/*
 *         File:    smstd.h.
 *     Contents:    Standard header file with some useful #includes
 *                  and macros for all compiler/emitter development.
 */

#ifndef smstd_h
#define smstd_h

#ifdef __cplusplus      /* Turn off inlining of strcmp, etc for C++ */
#undef __STR__
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>

#ifndef __SCLITE__
    #if defined (__STDC__) || defined (__EXTENDED__)
	#ifdef __OS2__
	    #include <io.h>
	#else
	    #include <unistd.h>
	#endif
    #else
	#define _NO_PROTO
    #endif
#endif

#ifndef TRUE
    #define TRUE 1
#endif
#ifndef FALSE
    #define FALSE 0
#endif

/*
 *  Standard typedefs:
 */
typedef int bool;
#define global /* Maps onto nothing, used as a prefix to global variables */

/*
 *  Standard NULL casts:
 */
#ifndef NULL
#define NULL    ((void *)0)
#endif
#define CNULL       ((char *)0)
#define FNULL       ((FILE *)0)
#define VNULL       ((void *)0)
#define INULL       ((int  *)0)

#ifndef SOMLINK
  #ifdef __IBMCPP__
    #define SOMLINK _System
  #else
    #ifdef _CL386
      #define SOMLINK _syscall
    #else
      #define SOMLINK
    #endif
  #endif
#endif

#endif /* smstd_h */
