#ifndef __PUZZLE__
#define __PUZZLE__


#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif


#ifndef __Part__
#include <Part.xh>
#endif


#ifndef _PUZZDEF_
#include "PuzzDef.h"
#endif


//	consts

const ODType kXMPPuzzle	= kODKindPuzzle;


//	defines

#define	kPuzzleEmbeededPartBorder		3

#define	IDM_RE_SCRAMBLE		   			1501
#define	IDM_ED_IN_PLACE			   		1502
#define	IDM_CLICK_SOUND		   			1503

	enum
{
	kPuzzleEditInPlace,
	kPuzzleSolve
};

enum
{
	kPuzzleMenuReScramble = 1,
	kPuzzleMenuEditInPlaceToggle,
};


//==============================================================================
// Classes used by this interface
//==============================================================================

class	OrderedCollection;
class	OrderedCollectionIterator;
class	ODEmbeddedFramesIterator;
class	ODFacet;
class	ODFrame;
class	ODMenuBar;
class	ODFocusSet;
class	ODSemanticInterface;
class	DrawPartPropAccessor;
class	ODDragItemIterator;
class	ODWindow;
class	ODSession;
class	Proxy;


class myPartInfoRec 
{
public:
	myPartInfoRec()	{ fIsActive = kODFalse; fNeedsActivating = kODFalse; fFrameType = 0; }
	virtual 			~myPartInfoRec() { }
	ODTypeToken		fFrameType;		//	for drawing
	ODBoolean		fIsActive;			//	Does this frame have its focus set?
	ODBoolean		fNeedsActivating;	//	should this be activated when its window is activated?
};

struct  PuzzleFacetInfo
{
public:
	
	ODFacet		*fFacet;
	Point		fGridLocation;		//	value ranging from {0, 0} to {3, 3}
	Point		fOriginalGridLocation;
	short		fWidth, fHeight;
};


	//--------------------------------------------------------------------------
	// Class Types
	//--------------------------------------------------------------------------

class Proxy
{
public:

	ODRgnHandle region;
	ODFrame* frame;
	ODTransform* transform;
	Proxy(ODRgnHandle r, ODFrame* f, ODTransform* t) 
		{region = r; frame = f; transform = t; }
	
};


#endif	// __PUZZLE__
