/*
	File:		SIHelpMac.h

	Contains:	Definition of an abstract helper class used by
				ODSemanticInterface

	Owned by:	Nick Pilch

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <8>	10/21/94	NP		1193831: must compile standalone.
		 <7>	  9/8/94	NP		API additions/changes.
		 <6>	 8/19/94	NP		1181622: Ownership fix.
		 <5>	  7/8/94	NP		Added CallTokenInquiryProc.
		 <4>	  7/5/94	NP		Fixed parameter lists.
		 <3>	 6/28/94	NP		made methods pure virtual.
		 <2>	 6/24/94	NP		Fixed header comment.
		 <1>	 6/24/94	NP		first checked in
		<24>	  5/5/94	eeh		bug #1153053, nativity (only now it runs)
		<23>	  4/4/94	T		#1154941: Get OpenDoc source to actually
									compile for PowerPC.  Fixed
									CallODTokenInquiryProc.
		<22>	  4/1/94	T		#1154941: Get OpenDoc source to actually
									compile for PowerPC.  Moved typedefs of
									UPPs to PlfmType.h where Platform Specific
									black box types belong.
		<21>	 3/26/94	NP		1153509. Messaging not PowerPC ready.
		<20>	 3/26/94	NP		1137665. Predispatch proc.
		<19>	 3/25/94	eeh		bug #1153053: goofed last time.
		<18>	 3/24/94	eeh		bug #1153053: Changes for PPC nativity (or
									is it nativeness...?)
		<17>	 3/15/94	MB		Changes to support SCpp/ASLM builds,
									#1150864.
		<16>	  2/9/94	NP		Tiger Team cleanup.
		<15>	  2/7/94	NP		Tiger Team doings.
		<14>	 1/14/94	NP		Init changes.
		<13>	11/30/93	NP		Added token inquiry proc.
		<12>	 11/5/93	NP		Removed CallObjectAccessor to
									ODNameResolver.
		<11>	10/22/93	NP		Added new private types for implementation.
		<10>	10/18/93	NP		InstallErrDescProc -> InstallGetErrDescProc
									and removed code name.
		 <9>	10/11/93	NP		Mods to keep in sync with SemtIntf.h. Added
									new private instance variables.
		 <8>	 9/20/93	NP		Moved some members around.
		 <7>	 8/19/93	NP		Added context field. Some moving of things.
		 <6>	 8/18/93	NP		Added OSLSupportFlags getters and setters.
		 <5>	  8/9/93	NP		Added class id string.
		 <4>	 7/28/93	NP		Added some temporary code.
		 <3>	 7/27/93	CG		Replaced the hash table
									fSpecialHandlerTable with fields in
									SemtIntf for each of the possible special
									handler proc ptrs.
		 <2>	 7/23/93	CG		Added Coercion handler dispatching.
		 <1>	  7/2/93	CG		first checked in

	To Do:
*/

#ifndef _SIHLPABS_
#define _SIHLPABS_


#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class	SIHelperAbs;

//==============================================================================
// Classes used by this interface
//==============================================================================

class	ODAppleEvent;
class	ODDesc;
class	ODOSLToken;
class	ODPart;

//==============================================================================
// Constants
//==============================================================================

ODPart* const	kODAppShell = 0;

//==============================================================================
// SIHelperAbs
//==============================================================================

#define ODVMethod	virtual

class ODExport SIHelperAbs
{
  public:

	ODVMethod OSErr   CallEventHandler(
			ODPart* thePart,
			ODAppleEvent* theODAppleEvent,
			ODAppleEvent* reply) = 0;
	ODVMethod OSErr   CallPredispatchProc(
			ODPart* thePart,
			ODAppleEvent* theODAppleEvent,
			ODAppleEvent* reply) = 0;
	ODVMethod OSErr   CallCoercionHandler(
			ODPart* thePart,
			ODDesc* theODDesc,
			ODDescType toType,
			ODDesc* result) = 0;
	ODVMethod OSErr   CallObjectAccessor(
			ODPart* thePart,
			ODDescType desiredClass,
			ODOSLToken* container,
			ODDescType containerClass,
			ODDescType form,
			ODDesc* selectionData,
			ODOSLToken* value) = 0;
	ODVMethod OSErr   CallCompareProc(
		ODPart* thePart,
		ODDescType oper,
		ODOSLToken* obj1,
		ODOSLToken* obj2,
		ODBoolean* result) = 0;
	ODVMethod OSErr   CallCountProc(
		ODPart* thePart,
		ODDescType desiredType,
		ODDescType containerClass,
		ODOSLToken* container,
		ODSLong* result) = 0;
	ODVMethod OSErr   CallDisposeTokenProc(
		ODPart* thePart,
		ODOSLToken* unneededToken) = 0;
	ODVMethod OSErr   CallGetErrDescProc(
		ODPart* thePart,
		ODDesc** errDesc) = 0;
	ODVMethod OSErr   CallGetMarkTokenProc(
		ODPart* thePart,
		ODOSLToken* dContainerToken,
		ODDescType containerClass,
		ODOSLToken* result) = 0;
	ODVMethod OSErr   CallMarkProc(
		ODPart* thePart,
		ODOSLToken* dToken,
		ODOSLToken* markToken,
		ODSLong index) = 0;
	ODVMethod OSErr   CallAdjustMarksProc(
		ODPart* thePart,
		ODSLong newStart,
		ODSLong newStop,
		ODOSLToken* markToken) = 0;
	ODVMethod ODPart*   CallTokenInquiryProc(ODOSLToken* value) = 0;
};


#endif // _SIHLPABS_
